require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ASM_X86_KVM_PARA_H)) {
    eval 'sub _ASM_X86_KVM_PARA_H () {1;}' unless defined(&_ASM_X86_KVM_PARA_H);
    require 'linux/types.ph';
    require 'asm/hyperv.ph';
    eval 'sub KVM_CPUID_SIGNATURE () {0x40000000;}' unless defined(&KVM_CPUID_SIGNATURE);
    eval 'sub KVM_CPUID_FEATURES () {0x40000001;}' unless defined(&KVM_CPUID_FEATURES);
    eval 'sub KVM_FEATURE_CLOCKSOURCE () {0;}' unless defined(&KVM_FEATURE_CLOCKSOURCE);
    eval 'sub KVM_FEATURE_NOP_IO_DELAY () {1;}' unless defined(&KVM_FEATURE_NOP_IO_DELAY);
    eval 'sub KVM_FEATURE_MMU_OP () {2;}' unless defined(&KVM_FEATURE_MMU_OP);
    eval 'sub KVM_FEATURE_CLOCKSOURCE2 () {3;}' unless defined(&KVM_FEATURE_CLOCKSOURCE2);
    eval 'sub KVM_FEATURE_ASYNC_PF () {4;}' unless defined(&KVM_FEATURE_ASYNC_PF);
    eval 'sub KVM_FEATURE_STEAL_TIME () {5;}' unless defined(&KVM_FEATURE_STEAL_TIME);
    eval 'sub KVM_FEATURE_PV_EOI () {6;}' unless defined(&KVM_FEATURE_PV_EOI);
    eval 'sub KVM_FEATURE_PV_UNHALT () {7;}' unless defined(&KVM_FEATURE_PV_UNHALT);
    eval 'sub KVM_FEATURE_CLOCKSOURCE_STABLE_BIT () {24;}' unless defined(&KVM_FEATURE_CLOCKSOURCE_STABLE_BIT);
    eval 'sub MSR_KVM_WALL_CLOCK () {0x11;}' unless defined(&MSR_KVM_WALL_CLOCK);
    eval 'sub MSR_KVM_SYSTEM_TIME () {0x12;}' unless defined(&MSR_KVM_SYSTEM_TIME);
    eval 'sub KVM_MSR_ENABLED () {1;}' unless defined(&KVM_MSR_ENABLED);
    eval 'sub MSR_KVM_WALL_CLOCK_NEW () {0x4b564d00;}' unless defined(&MSR_KVM_WALL_CLOCK_NEW);
    eval 'sub MSR_KVM_SYSTEM_TIME_NEW () {0x4b564d01;}' unless defined(&MSR_KVM_SYSTEM_TIME_NEW);
    eval 'sub MSR_KVM_ASYNC_PF_EN () {0x4b564d02;}' unless defined(&MSR_KVM_ASYNC_PF_EN);
    eval 'sub MSR_KVM_STEAL_TIME () {0x4b564d03;}' unless defined(&MSR_KVM_STEAL_TIME);
    eval 'sub MSR_KVM_PV_EOI_EN () {0x4b564d04;}' unless defined(&MSR_KVM_PV_EOI_EN);
    eval 'sub KVM_STEAL_ALIGNMENT_BITS () {5;}' unless defined(&KVM_STEAL_ALIGNMENT_BITS);
    eval 'sub KVM_STEAL_VALID_BITS () {((-1 << ( &KVM_STEAL_ALIGNMENT_BITS + 1)));}' unless defined(&KVM_STEAL_VALID_BITS);
    eval 'sub KVM_STEAL_RESERVED_MASK () {(((1<<  &KVM_STEAL_ALIGNMENT_BITS) - 1) << 1);}' unless defined(&KVM_STEAL_RESERVED_MASK);
    eval 'sub KVM_MAX_MMU_OP_BATCH () {32;}' unless defined(&KVM_MAX_MMU_OP_BATCH);
    eval 'sub KVM_ASYNC_PF_ENABLED () {(1<< 0);}' unless defined(&KVM_ASYNC_PF_ENABLED);
    eval 'sub KVM_ASYNC_PF_SEND_ALWAYS () {(1<< 1);}' unless defined(&KVM_ASYNC_PF_SEND_ALWAYS);
    eval 'sub KVM_MMU_OP_WRITE_PTE () {1;}' unless defined(&KVM_MMU_OP_WRITE_PTE);
    eval 'sub KVM_MMU_OP_FLUSH_TLB () {2;}' unless defined(&KVM_MMU_OP_FLUSH_TLB);
    eval 'sub KVM_MMU_OP_RELEASE_PT () {3;}' unless defined(&KVM_MMU_OP_RELEASE_PT);
    eval 'sub KVM_PV_REASON_PAGE_NOT_PRESENT () {1;}' unless defined(&KVM_PV_REASON_PAGE_NOT_PRESENT);
    eval 'sub KVM_PV_REASON_PAGE_READY () {2;}' unless defined(&KVM_PV_REASON_PAGE_READY);
    eval 'sub KVM_PV_EOI_BIT () {0;}' unless defined(&KVM_PV_EOI_BIT);
    eval 'sub KVM_PV_EOI_MASK () {(0x1 <<  &KVM_PV_EOI_BIT);}' unless defined(&KVM_PV_EOI_MASK);
    eval 'sub KVM_PV_EOI_ENABLED () { &KVM_PV_EOI_MASK;}' unless defined(&KVM_PV_EOI_ENABLED);
    eval 'sub KVM_PV_EOI_DISABLED () {0x;}' unless defined(&KVM_PV_EOI_DISABLED);
}
1;
