# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.10
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.



from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_selinux', [dirname(__file__)])
        except ImportError:
            import _selinux
            return _selinux
        if fp is not None:
            try:
                _mod = imp.load_module('_selinux', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _selinux = swig_import_helper()
    del swig_import_helper
else:
    import _selinux
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


import shutil, os, errno, stat

DISABLED = -1
PERMISSIVE = 0
ENFORCING = 1

def restorecon(path, recursive=False):
    """ Restore SELinux context on a given path """

    try:
        mode = os.lstat(path)[stat.ST_MODE]
        status, context = matchpathcon(path, mode)
    except OSError:
        path = os.path.realpath(os.path.expanduser(path))
        mode = os.lstat(path)[stat.ST_MODE]
        try:
            status, context = matchpathcon(path, mode)
        except OSError as e:
            # matchpathcon returns ENOENT when <<none>> in file context
            if e.errno != errno.ENOENT:
                raise
            return

    if status == 0:
        try:
            status, oldcontext = lgetfilecon(path)
        except OSError as e:
            if e.errno != errno.ENODATA:
                raise
            oldcontext = None
        if context != oldcontext:
            lsetfilecon(path, context)

        if recursive:
            for root, dirs, files in os.walk(path):
                for name in files + dirs:
                   restorecon(os.path.join(root, name))

def chcon(path, context, recursive=False):
    """ Set the SELinux context on a given path """
    lsetfilecon(path, context)
    if recursive:
        for root, dirs, files in os.walk(path):
            for name in files + dirs:
               lsetfilecon(os.path.join(root,name), context)

def copytree(src, dest):
    """ An SELinux-friendly shutil.copytree method """
    shutil.copytree(src, dest)
    restorecon(dest, recursive=True)

def install(src, dest):
    """ An SELinux-friendly shutil.move method """
    shutil.move(src, dest)
    restorecon(dest, recursive=True)

class security_id(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, security_id, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, security_id, name)
    __repr__ = _swig_repr
    __swig_setmethods__["ctx"] = _selinux.security_id_ctx_set
    __swig_getmethods__["ctx"] = _selinux.security_id_ctx_get
    if _newclass:ctx = _swig_property(_selinux.security_id_ctx_get, _selinux.security_id_ctx_set)
    __swig_setmethods__["refcnt"] = _selinux.security_id_refcnt_set
    __swig_getmethods__["refcnt"] = _selinux.security_id_refcnt_get
    if _newclass:refcnt = _swig_property(_selinux.security_id_refcnt_get, _selinux.security_id_refcnt_set)
    def __init__(self): 
        this = _selinux.new_security_id()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_security_id
    __del__ = lambda self : None;
security_id_swigregister = _selinux.security_id_swigregister
security_id_swigregister(security_id)


def avc_sid_to_context(*args):
  return _selinux.avc_sid_to_context(*args)
avc_sid_to_context = _selinux.avc_sid_to_context

def avc_sid_to_context_raw(*args):
  return _selinux.avc_sid_to_context_raw(*args)
avc_sid_to_context_raw = _selinux.avc_sid_to_context_raw

def avc_context_to_sid(*args):
  return _selinux.avc_context_to_sid(*args)
avc_context_to_sid = _selinux.avc_context_to_sid

def avc_context_to_sid_raw(*args):
  return _selinux.avc_context_to_sid_raw(*args)
avc_context_to_sid_raw = _selinux.avc_context_to_sid_raw

def sidget(*args):
  return _selinux.sidget(*args)
sidget = _selinux.sidget

def sidput(*args):
  return _selinux.sidput(*args)
sidput = _selinux.sidput

def avc_get_initial_sid(*args):
  return _selinux.avc_get_initial_sid(*args)
avc_get_initial_sid = _selinux.avc_get_initial_sid
class avc_entry_ref(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_entry_ref, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_entry_ref, name)
    __repr__ = _swig_repr
    __swig_setmethods__["ae"] = _selinux.avc_entry_ref_ae_set
    __swig_getmethods__["ae"] = _selinux.avc_entry_ref_ae_get
    if _newclass:ae = _swig_property(_selinux.avc_entry_ref_ae_get, _selinux.avc_entry_ref_ae_set)
    def __init__(self): 
        this = _selinux.new_avc_entry_ref()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_avc_entry_ref
    __del__ = lambda self : None;
avc_entry_ref_swigregister = _selinux.avc_entry_ref_swigregister
avc_entry_ref_swigregister(avc_entry_ref)

class avc_memory_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_memory_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_memory_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_malloc"] = _selinux.avc_memory_callback_func_malloc_set
    __swig_getmethods__["func_malloc"] = _selinux.avc_memory_callback_func_malloc_get
    if _newclass:func_malloc = _swig_property(_selinux.avc_memory_callback_func_malloc_get, _selinux.avc_memory_callback_func_malloc_set)
    __swig_setmethods__["func_free"] = _selinux.avc_memory_callback_func_free_set
    __swig_getmethods__["func_free"] = _selinux.avc_memory_callback_func_free_get
    if _newclass:func_free = _swig_property(_selinux.avc_memory_callback_func_free_get, _selinux.avc_memory_callback_func_free_set)
    def __init__(self): 
        this = _selinux.new_avc_memory_callback()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_avc_memory_callback
    __del__ = lambda self : None;
avc_memory_callback_swigregister = _selinux.avc_memory_callback_swigregister
avc_memory_callback_swigregister(avc_memory_callback)

class avc_log_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_log_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_log_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_log"] = _selinux.avc_log_callback_func_log_set
    __swig_getmethods__["func_log"] = _selinux.avc_log_callback_func_log_get
    if _newclass:func_log = _swig_property(_selinux.avc_log_callback_func_log_get, _selinux.avc_log_callback_func_log_set)
    __swig_setmethods__["func_audit"] = _selinux.avc_log_callback_func_audit_set
    __swig_getmethods__["func_audit"] = _selinux.avc_log_callback_func_audit_get
    if _newclass:func_audit = _swig_property(_selinux.avc_log_callback_func_audit_get, _selinux.avc_log_callback_func_audit_set)
    def __init__(self): 
        this = _selinux.new_avc_log_callback()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_avc_log_callback
    __del__ = lambda self : None;
avc_log_callback_swigregister = _selinux.avc_log_callback_swigregister
avc_log_callback_swigregister(avc_log_callback)

class avc_thread_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_thread_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_thread_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_create_thread"] = _selinux.avc_thread_callback_func_create_thread_set
    __swig_getmethods__["func_create_thread"] = _selinux.avc_thread_callback_func_create_thread_get
    if _newclass:func_create_thread = _swig_property(_selinux.avc_thread_callback_func_create_thread_get, _selinux.avc_thread_callback_func_create_thread_set)
    __swig_setmethods__["func_stop_thread"] = _selinux.avc_thread_callback_func_stop_thread_set
    __swig_getmethods__["func_stop_thread"] = _selinux.avc_thread_callback_func_stop_thread_get
    if _newclass:func_stop_thread = _swig_property(_selinux.avc_thread_callback_func_stop_thread_get, _selinux.avc_thread_callback_func_stop_thread_set)
    def __init__(self): 
        this = _selinux.new_avc_thread_callback()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_avc_thread_callback
    __del__ = lambda self : None;
avc_thread_callback_swigregister = _selinux.avc_thread_callback_swigregister
avc_thread_callback_swigregister(avc_thread_callback)

class avc_lock_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_lock_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_lock_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_alloc_lock"] = _selinux.avc_lock_callback_func_alloc_lock_set
    __swig_getmethods__["func_alloc_lock"] = _selinux.avc_lock_callback_func_alloc_lock_get
    if _newclass:func_alloc_lock = _swig_property(_selinux.avc_lock_callback_func_alloc_lock_get, _selinux.avc_lock_callback_func_alloc_lock_set)
    __swig_setmethods__["func_get_lock"] = _selinux.avc_lock_callback_func_get_lock_set
    __swig_getmethods__["func_get_lock"] = _selinux.avc_lock_callback_func_get_lock_get
    if _newclass:func_get_lock = _swig_property(_selinux.avc_lock_callback_func_get_lock_get, _selinux.avc_lock_callback_func_get_lock_set)
    __swig_setmethods__["func_release_lock"] = _selinux.avc_lock_callback_func_release_lock_set
    __swig_getmethods__["func_release_lock"] = _selinux.avc_lock_callback_func_release_lock_get
    if _newclass:func_release_lock = _swig_property(_selinux.avc_lock_callback_func_release_lock_get, _selinux.avc_lock_callback_func_release_lock_set)
    __swig_setmethods__["func_free_lock"] = _selinux.avc_lock_callback_func_free_lock_set
    __swig_getmethods__["func_free_lock"] = _selinux.avc_lock_callback_func_free_lock_get
    if _newclass:func_free_lock = _swig_property(_selinux.avc_lock_callback_func_free_lock_get, _selinux.avc_lock_callback_func_free_lock_set)
    def __init__(self): 
        this = _selinux.new_avc_lock_callback()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_avc_lock_callback
    __del__ = lambda self : None;
avc_lock_callback_swigregister = _selinux.avc_lock_callback_swigregister
avc_lock_callback_swigregister(avc_lock_callback)

AVC_OPT_UNUSED = _selinux.AVC_OPT_UNUSED
AVC_OPT_SETENFORCE = _selinux.AVC_OPT_SETENFORCE

def avc_init(*args):
  return _selinux.avc_init(*args)
avc_init = _selinux.avc_init

def avc_open(*args):
  return _selinux.avc_open(*args)
avc_open = _selinux.avc_open

def avc_cleanup():
  return _selinux.avc_cleanup()
avc_cleanup = _selinux.avc_cleanup

def avc_reset():
  return _selinux.avc_reset()
avc_reset = _selinux.avc_reset

def avc_destroy():
  return _selinux.avc_destroy()
avc_destroy = _selinux.avc_destroy

def avc_has_perm_noaudit(*args):
  return _selinux.avc_has_perm_noaudit(*args)
avc_has_perm_noaudit = _selinux.avc_has_perm_noaudit

def avc_has_perm(*args):
  return _selinux.avc_has_perm(*args)
avc_has_perm = _selinux.avc_has_perm

def avc_audit(*args):
  return _selinux.avc_audit(*args)
avc_audit = _selinux.avc_audit

def avc_compute_create(*args):
  return _selinux.avc_compute_create(*args)
avc_compute_create = _selinux.avc_compute_create

def avc_compute_member(*args):
  return _selinux.avc_compute_member(*args)
avc_compute_member = _selinux.avc_compute_member
AVC_CALLBACK_GRANT = _selinux.AVC_CALLBACK_GRANT
AVC_CALLBACK_TRY_REVOKE = _selinux.AVC_CALLBACK_TRY_REVOKE
AVC_CALLBACK_REVOKE = _selinux.AVC_CALLBACK_REVOKE
AVC_CALLBACK_RESET = _selinux.AVC_CALLBACK_RESET
AVC_CALLBACK_AUDITALLOW_ENABLE = _selinux.AVC_CALLBACK_AUDITALLOW_ENABLE
AVC_CALLBACK_AUDITALLOW_DISABLE = _selinux.AVC_CALLBACK_AUDITALLOW_DISABLE
AVC_CALLBACK_AUDITDENY_ENABLE = _selinux.AVC_CALLBACK_AUDITDENY_ENABLE
AVC_CALLBACK_AUDITDENY_DISABLE = _selinux.AVC_CALLBACK_AUDITDENY_DISABLE
AVC_CACHE_STATS = _selinux.AVC_CACHE_STATS
class avc_cache_stats(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_cache_stats, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_cache_stats, name)
    __repr__ = _swig_repr
    __swig_setmethods__["entry_lookups"] = _selinux.avc_cache_stats_entry_lookups_set
    __swig_getmethods__["entry_lookups"] = _selinux.avc_cache_stats_entry_lookups_get
    if _newclass:entry_lookups = _swig_property(_selinux.avc_cache_stats_entry_lookups_get, _selinux.avc_cache_stats_entry_lookups_set)
    __swig_setmethods__["entry_hits"] = _selinux.avc_cache_stats_entry_hits_set
    __swig_getmethods__["entry_hits"] = _selinux.avc_cache_stats_entry_hits_get
    if _newclass:entry_hits = _swig_property(_selinux.avc_cache_stats_entry_hits_get, _selinux.avc_cache_stats_entry_hits_set)
    __swig_setmethods__["entry_misses"] = _selinux.avc_cache_stats_entry_misses_set
    __swig_getmethods__["entry_misses"] = _selinux.avc_cache_stats_entry_misses_get
    if _newclass:entry_misses = _swig_property(_selinux.avc_cache_stats_entry_misses_get, _selinux.avc_cache_stats_entry_misses_set)
    __swig_setmethods__["entry_discards"] = _selinux.avc_cache_stats_entry_discards_set
    __swig_getmethods__["entry_discards"] = _selinux.avc_cache_stats_entry_discards_get
    if _newclass:entry_discards = _swig_property(_selinux.avc_cache_stats_entry_discards_get, _selinux.avc_cache_stats_entry_discards_set)
    __swig_setmethods__["cav_lookups"] = _selinux.avc_cache_stats_cav_lookups_set
    __swig_getmethods__["cav_lookups"] = _selinux.avc_cache_stats_cav_lookups_get
    if _newclass:cav_lookups = _swig_property(_selinux.avc_cache_stats_cav_lookups_get, _selinux.avc_cache_stats_cav_lookups_set)
    __swig_setmethods__["cav_hits"] = _selinux.avc_cache_stats_cav_hits_set
    __swig_getmethods__["cav_hits"] = _selinux.avc_cache_stats_cav_hits_get
    if _newclass:cav_hits = _swig_property(_selinux.avc_cache_stats_cav_hits_get, _selinux.avc_cache_stats_cav_hits_set)
    __swig_setmethods__["cav_probes"] = _selinux.avc_cache_stats_cav_probes_set
    __swig_getmethods__["cav_probes"] = _selinux.avc_cache_stats_cav_probes_get
    if _newclass:cav_probes = _swig_property(_selinux.avc_cache_stats_cav_probes_get, _selinux.avc_cache_stats_cav_probes_set)
    __swig_setmethods__["cav_misses"] = _selinux.avc_cache_stats_cav_misses_set
    __swig_getmethods__["cav_misses"] = _selinux.avc_cache_stats_cav_misses_get
    if _newclass:cav_misses = _swig_property(_selinux.avc_cache_stats_cav_misses_get, _selinux.avc_cache_stats_cav_misses_set)
    def __init__(self): 
        this = _selinux.new_avc_cache_stats()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_avc_cache_stats
    __del__ = lambda self : None;
avc_cache_stats_swigregister = _selinux.avc_cache_stats_swigregister
avc_cache_stats_swigregister(avc_cache_stats)


def avc_av_stats():
  return _selinux.avc_av_stats()
avc_av_stats = _selinux.avc_av_stats

def avc_sid_stats():
  return _selinux.avc_sid_stats()
avc_sid_stats = _selinux.avc_sid_stats

def avc_netlink_open(*args):
  return _selinux.avc_netlink_open(*args)
avc_netlink_open = _selinux.avc_netlink_open

def avc_netlink_loop():
  return _selinux.avc_netlink_loop()
avc_netlink_loop = _selinux.avc_netlink_loop

def avc_netlink_close():
  return _selinux.avc_netlink_close()
avc_netlink_close = _selinux.avc_netlink_close

def selinux_status_open(*args):
  return _selinux.selinux_status_open(*args)
selinux_status_open = _selinux.selinux_status_open

def selinux_status_close():
  return _selinux.selinux_status_close()
selinux_status_close = _selinux.selinux_status_close

def selinux_status_updated():
  return _selinux.selinux_status_updated()
selinux_status_updated = _selinux.selinux_status_updated

def selinux_status_getenforce():
  return _selinux.selinux_status_getenforce()
selinux_status_getenforce = _selinux.selinux_status_getenforce

def selinux_status_policyload():
  return _selinux.selinux_status_policyload()
selinux_status_policyload = _selinux.selinux_status_policyload

def selinux_status_deny_unknown():
  return _selinux.selinux_status_deny_unknown()
selinux_status_deny_unknown = _selinux.selinux_status_deny_unknown
class context_s_t(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, context_s_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, context_s_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["ptr"] = _selinux.context_s_t_ptr_set
    __swig_getmethods__["ptr"] = _selinux.context_s_t_ptr_get
    if _newclass:ptr = _swig_property(_selinux.context_s_t_ptr_get, _selinux.context_s_t_ptr_set)
    def __init__(self): 
        this = _selinux.new_context_s_t()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_context_s_t
    __del__ = lambda self : None;
context_s_t_swigregister = _selinux.context_s_t_swigregister
context_s_t_swigregister(context_s_t)


def context_new(*args):
  return _selinux.context_new(*args)
context_new = _selinux.context_new

def context_str(*args):
  return _selinux.context_str(*args)
context_str = _selinux.context_str

def context_free(*args):
  return _selinux.context_free(*args)
context_free = _selinux.context_free

def context_type_get(*args):
  return _selinux.context_type_get(*args)
context_type_get = _selinux.context_type_get

def context_range_get(*args):
  return _selinux.context_range_get(*args)
context_range_get = _selinux.context_range_get

def context_role_get(*args):
  return _selinux.context_role_get(*args)
context_role_get = _selinux.context_role_get

def context_user_get(*args):
  return _selinux.context_user_get(*args)
context_user_get = _selinux.context_user_get

def context_type_set(*args):
  return _selinux.context_type_set(*args)
context_type_set = _selinux.context_type_set

def context_range_set(*args):
  return _selinux.context_range_set(*args)
context_range_set = _selinux.context_range_set

def context_role_set(*args):
  return _selinux.context_role_set(*args)
context_role_set = _selinux.context_role_set

def context_user_set(*args):
  return _selinux.context_user_set(*args)
context_user_set = _selinux.context_user_set
SELINUX_DEFAULTUSER = _selinux.SELINUX_DEFAULTUSER

def get_ordered_context_list(*args):
  return _selinux.get_ordered_context_list(*args)
get_ordered_context_list = _selinux.get_ordered_context_list

def get_ordered_context_list_with_level(*args):
  return _selinux.get_ordered_context_list_with_level(*args)
get_ordered_context_list_with_level = _selinux.get_ordered_context_list_with_level

def get_default_context(*args):
  return _selinux.get_default_context(*args)
get_default_context = _selinux.get_default_context

def get_default_context_with_level(*args):
  return _selinux.get_default_context_with_level(*args)
get_default_context_with_level = _selinux.get_default_context_with_level

def get_default_context_with_role(*args):
  return _selinux.get_default_context_with_role(*args)
get_default_context_with_role = _selinux.get_default_context_with_role

def get_default_context_with_rolelevel(*args):
  return _selinux.get_default_context_with_rolelevel(*args)
get_default_context_with_rolelevel = _selinux.get_default_context_with_rolelevel

def query_user_context():
  return _selinux.query_user_context()
query_user_context = _selinux.query_user_context

def manual_user_enter_context(*args):
  return _selinux.manual_user_enter_context(*args)
manual_user_enter_context = _selinux.manual_user_enter_context

def selinux_default_type_path():
  return _selinux.selinux_default_type_path()
selinux_default_type_path = _selinux.selinux_default_type_path

def get_default_type(*args):
  return _selinux.get_default_type(*args)
get_default_type = _selinux.get_default_type
SELABEL_CTX_FILE = _selinux.SELABEL_CTX_FILE
SELABEL_CTX_MEDIA = _selinux.SELABEL_CTX_MEDIA
SELABEL_CTX_X = _selinux.SELABEL_CTX_X
SELABEL_CTX_DB = _selinux.SELABEL_CTX_DB
SELABEL_CTX_ANDROID_PROP = _selinux.SELABEL_CTX_ANDROID_PROP
SELABEL_OPT_UNUSED = _selinux.SELABEL_OPT_UNUSED
SELABEL_OPT_VALIDATE = _selinux.SELABEL_OPT_VALIDATE
SELABEL_OPT_BASEONLY = _selinux.SELABEL_OPT_BASEONLY
SELABEL_OPT_PATH = _selinux.SELABEL_OPT_PATH
SELABEL_OPT_SUBSET = _selinux.SELABEL_OPT_SUBSET
SELABEL_OPT_DIGEST = _selinux.SELABEL_OPT_DIGEST
SELABEL_NOPT = _selinux.SELABEL_NOPT

def selabel_open(*args):
  return _selinux.selabel_open(*args)
selabel_open = _selinux.selabel_open

def selabel_close(*args):
  return _selinux.selabel_close(*args)
selabel_close = _selinux.selabel_close

def selabel_lookup(*args):
  return _selinux.selabel_lookup(*args)
selabel_lookup = _selinux.selabel_lookup

def selabel_lookup_raw(*args):
  return _selinux.selabel_lookup_raw(*args)
selabel_lookup_raw = _selinux.selabel_lookup_raw

def selabel_partial_match(*args):
  return _selinux.selabel_partial_match(*args)
selabel_partial_match = _selinux.selabel_partial_match

def selabel_lookup_best_match(*args):
  return _selinux.selabel_lookup_best_match(*args)
selabel_lookup_best_match = _selinux.selabel_lookup_best_match

def selabel_lookup_best_match_raw(*args):
  return _selinux.selabel_lookup_best_match_raw(*args)
selabel_lookup_best_match_raw = _selinux.selabel_lookup_best_match_raw

def selabel_digest(*args):
  return _selinux.selabel_digest(*args)
selabel_digest = _selinux.selabel_digest
SELABEL_SUBSET = _selinux.SELABEL_SUBSET
SELABEL_EQUAL = _selinux.SELABEL_EQUAL
SELABEL_SUPERSET = _selinux.SELABEL_SUPERSET
SELABEL_INCOMPARABLE = _selinux.SELABEL_INCOMPARABLE

def selabel_cmp(*args):
  return _selinux.selabel_cmp(*args)
selabel_cmp = _selinux.selabel_cmp

def selabel_stats(*args):
  return _selinux.selabel_stats(*args)
selabel_stats = _selinux.selabel_stats
SELABEL_X_PROP = _selinux.SELABEL_X_PROP
SELABEL_X_EXT = _selinux.SELABEL_X_EXT
SELABEL_X_CLIENT = _selinux.SELABEL_X_CLIENT
SELABEL_X_EVENT = _selinux.SELABEL_X_EVENT
SELABEL_X_SELN = _selinux.SELABEL_X_SELN
SELABEL_X_POLYPROP = _selinux.SELABEL_X_POLYPROP
SELABEL_X_POLYSELN = _selinux.SELABEL_X_POLYSELN
SELABEL_DB_DATABASE = _selinux.SELABEL_DB_DATABASE
SELABEL_DB_SCHEMA = _selinux.SELABEL_DB_SCHEMA
SELABEL_DB_TABLE = _selinux.SELABEL_DB_TABLE
SELABEL_DB_COLUMN = _selinux.SELABEL_DB_COLUMN
SELABEL_DB_SEQUENCE = _selinux.SELABEL_DB_SEQUENCE
SELABEL_DB_VIEW = _selinux.SELABEL_DB_VIEW
SELABEL_DB_PROCEDURE = _selinux.SELABEL_DB_PROCEDURE
SELABEL_DB_BLOB = _selinux.SELABEL_DB_BLOB
SELABEL_DB_TUPLE = _selinux.SELABEL_DB_TUPLE
SELABEL_DB_LANGUAGE = _selinux.SELABEL_DB_LANGUAGE
SELABEL_DB_EXCEPTION = _selinux.SELABEL_DB_EXCEPTION
SELABEL_DB_DATATYPE = _selinux.SELABEL_DB_DATATYPE

def is_selinux_enabled():
  return _selinux.is_selinux_enabled()
is_selinux_enabled = _selinux.is_selinux_enabled

def is_selinux_mls_enabled():
  return _selinux.is_selinux_mls_enabled()
is_selinux_mls_enabled = _selinux.is_selinux_mls_enabled

def getcon():
  return _selinux.getcon()
getcon = _selinux.getcon

def getcon_raw():
  return _selinux.getcon_raw()
getcon_raw = _selinux.getcon_raw

def setcon(*args):
  return _selinux.setcon(*args)
setcon = _selinux.setcon

def setcon_raw(*args):
  return _selinux.setcon_raw(*args)
setcon_raw = _selinux.setcon_raw

def getpidcon(*args):
  return _selinux.getpidcon(*args)
getpidcon = _selinux.getpidcon

def getpidcon_raw(*args):
  return _selinux.getpidcon_raw(*args)
getpidcon_raw = _selinux.getpidcon_raw

def getprevcon():
  return _selinux.getprevcon()
getprevcon = _selinux.getprevcon

def getprevcon_raw():
  return _selinux.getprevcon_raw()
getprevcon_raw = _selinux.getprevcon_raw

def getexeccon():
  return _selinux.getexeccon()
getexeccon = _selinux.getexeccon

def getexeccon_raw():
  return _selinux.getexeccon_raw()
getexeccon_raw = _selinux.getexeccon_raw

def setexeccon(*args):
  return _selinux.setexeccon(*args)
setexeccon = _selinux.setexeccon

def setexeccon_raw(*args):
  return _selinux.setexeccon_raw(*args)
setexeccon_raw = _selinux.setexeccon_raw

def getfscreatecon():
  return _selinux.getfscreatecon()
getfscreatecon = _selinux.getfscreatecon

def getfscreatecon_raw():
  return _selinux.getfscreatecon_raw()
getfscreatecon_raw = _selinux.getfscreatecon_raw

def setfscreatecon(*args):
  return _selinux.setfscreatecon(*args)
setfscreatecon = _selinux.setfscreatecon

def setfscreatecon_raw(*args):
  return _selinux.setfscreatecon_raw(*args)
setfscreatecon_raw = _selinux.setfscreatecon_raw

def getkeycreatecon():
  return _selinux.getkeycreatecon()
getkeycreatecon = _selinux.getkeycreatecon

def getkeycreatecon_raw():
  return _selinux.getkeycreatecon_raw()
getkeycreatecon_raw = _selinux.getkeycreatecon_raw

def setkeycreatecon(*args):
  return _selinux.setkeycreatecon(*args)
setkeycreatecon = _selinux.setkeycreatecon

def setkeycreatecon_raw(*args):
  return _selinux.setkeycreatecon_raw(*args)
setkeycreatecon_raw = _selinux.setkeycreatecon_raw

def getsockcreatecon():
  return _selinux.getsockcreatecon()
getsockcreatecon = _selinux.getsockcreatecon

def getsockcreatecon_raw():
  return _selinux.getsockcreatecon_raw()
getsockcreatecon_raw = _selinux.getsockcreatecon_raw

def setsockcreatecon(*args):
  return _selinux.setsockcreatecon(*args)
setsockcreatecon = _selinux.setsockcreatecon

def setsockcreatecon_raw(*args):
  return _selinux.setsockcreatecon_raw(*args)
setsockcreatecon_raw = _selinux.setsockcreatecon_raw

def getfilecon(*args):
  return _selinux.getfilecon(*args)
getfilecon = _selinux.getfilecon

def getfilecon_raw(*args):
  return _selinux.getfilecon_raw(*args)
getfilecon_raw = _selinux.getfilecon_raw

def lgetfilecon(*args):
  return _selinux.lgetfilecon(*args)
lgetfilecon = _selinux.lgetfilecon

def lgetfilecon_raw(*args):
  return _selinux.lgetfilecon_raw(*args)
lgetfilecon_raw = _selinux.lgetfilecon_raw

def fgetfilecon(*args):
  return _selinux.fgetfilecon(*args)
fgetfilecon = _selinux.fgetfilecon

def fgetfilecon_raw(*args):
  return _selinux.fgetfilecon_raw(*args)
fgetfilecon_raw = _selinux.fgetfilecon_raw

def setfilecon(*args):
  return _selinux.setfilecon(*args)
setfilecon = _selinux.setfilecon

def setfilecon_raw(*args):
  return _selinux.setfilecon_raw(*args)
setfilecon_raw = _selinux.setfilecon_raw

def lsetfilecon(*args):
  return _selinux.lsetfilecon(*args)
lsetfilecon = _selinux.lsetfilecon

def lsetfilecon_raw(*args):
  return _selinux.lsetfilecon_raw(*args)
lsetfilecon_raw = _selinux.lsetfilecon_raw

def fsetfilecon(*args):
  return _selinux.fsetfilecon(*args)
fsetfilecon = _selinux.fsetfilecon

def fsetfilecon_raw(*args):
  return _selinux.fsetfilecon_raw(*args)
fsetfilecon_raw = _selinux.fsetfilecon_raw

def getpeercon(*args):
  return _selinux.getpeercon(*args)
getpeercon = _selinux.getpeercon

def getpeercon_raw(*args):
  return _selinux.getpeercon_raw(*args)
getpeercon_raw = _selinux.getpeercon_raw
class av_decision(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, av_decision, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, av_decision, name)
    __repr__ = _swig_repr
    __swig_setmethods__["allowed"] = _selinux.av_decision_allowed_set
    __swig_getmethods__["allowed"] = _selinux.av_decision_allowed_get
    if _newclass:allowed = _swig_property(_selinux.av_decision_allowed_get, _selinux.av_decision_allowed_set)
    __swig_setmethods__["decided"] = _selinux.av_decision_decided_set
    __swig_getmethods__["decided"] = _selinux.av_decision_decided_get
    if _newclass:decided = _swig_property(_selinux.av_decision_decided_get, _selinux.av_decision_decided_set)
    __swig_setmethods__["auditallow"] = _selinux.av_decision_auditallow_set
    __swig_getmethods__["auditallow"] = _selinux.av_decision_auditallow_get
    if _newclass:auditallow = _swig_property(_selinux.av_decision_auditallow_get, _selinux.av_decision_auditallow_set)
    __swig_setmethods__["auditdeny"] = _selinux.av_decision_auditdeny_set
    __swig_getmethods__["auditdeny"] = _selinux.av_decision_auditdeny_get
    if _newclass:auditdeny = _swig_property(_selinux.av_decision_auditdeny_get, _selinux.av_decision_auditdeny_set)
    __swig_setmethods__["seqno"] = _selinux.av_decision_seqno_set
    __swig_getmethods__["seqno"] = _selinux.av_decision_seqno_get
    if _newclass:seqno = _swig_property(_selinux.av_decision_seqno_get, _selinux.av_decision_seqno_set)
    __swig_setmethods__["flags"] = _selinux.av_decision_flags_set
    __swig_getmethods__["flags"] = _selinux.av_decision_flags_get
    if _newclass:flags = _swig_property(_selinux.av_decision_flags_get, _selinux.av_decision_flags_set)
    def __init__(self): 
        this = _selinux.new_av_decision()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_av_decision
    __del__ = lambda self : None;
av_decision_swigregister = _selinux.av_decision_swigregister
av_decision_swigregister(av_decision)

SELINUX_AVD_FLAGS_PERMISSIVE = _selinux.SELINUX_AVD_FLAGS_PERMISSIVE
class selinux_opt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, selinux_opt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, selinux_opt, name)
    __repr__ = _swig_repr
    __swig_setmethods__["type"] = _selinux.selinux_opt_type_set
    __swig_getmethods__["type"] = _selinux.selinux_opt_type_get
    if _newclass:type = _swig_property(_selinux.selinux_opt_type_get, _selinux.selinux_opt_type_set)
    __swig_setmethods__["value"] = _selinux.selinux_opt_value_set
    __swig_getmethods__["value"] = _selinux.selinux_opt_value_get
    if _newclass:value = _swig_property(_selinux.selinux_opt_value_get, _selinux.selinux_opt_value_set)
    def __init__(self): 
        this = _selinux.new_selinux_opt()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_selinux_opt
    __del__ = lambda self : None;
selinux_opt_swigregister = _selinux.selinux_opt_swigregister
selinux_opt_swigregister(selinux_opt)

class selinux_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, selinux_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, selinux_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_log"] = _selinux.selinux_callback_func_log_set
    __swig_getmethods__["func_log"] = _selinux.selinux_callback_func_log_get
    if _newclass:func_log = _swig_property(_selinux.selinux_callback_func_log_get, _selinux.selinux_callback_func_log_set)
    __swig_setmethods__["func_audit"] = _selinux.selinux_callback_func_audit_set
    __swig_getmethods__["func_audit"] = _selinux.selinux_callback_func_audit_get
    if _newclass:func_audit = _swig_property(_selinux.selinux_callback_func_audit_get, _selinux.selinux_callback_func_audit_set)
    __swig_setmethods__["func_validate"] = _selinux.selinux_callback_func_validate_set
    __swig_getmethods__["func_validate"] = _selinux.selinux_callback_func_validate_get
    if _newclass:func_validate = _swig_property(_selinux.selinux_callback_func_validate_get, _selinux.selinux_callback_func_validate_set)
    __swig_setmethods__["func_setenforce"] = _selinux.selinux_callback_func_setenforce_set
    __swig_getmethods__["func_setenforce"] = _selinux.selinux_callback_func_setenforce_get
    if _newclass:func_setenforce = _swig_property(_selinux.selinux_callback_func_setenforce_get, _selinux.selinux_callback_func_setenforce_set)
    __swig_setmethods__["func_policyload"] = _selinux.selinux_callback_func_policyload_set
    __swig_getmethods__["func_policyload"] = _selinux.selinux_callback_func_policyload_get
    if _newclass:func_policyload = _swig_property(_selinux.selinux_callback_func_policyload_get, _selinux.selinux_callback_func_policyload_set)
    def __init__(self): 
        this = _selinux.new_selinux_callback()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_selinux_callback
    __del__ = lambda self : None;
selinux_callback_swigregister = _selinux.selinux_callback_swigregister
selinux_callback_swigregister(selinux_callback)

SELINUX_CB_LOG = _selinux.SELINUX_CB_LOG
SELINUX_CB_AUDIT = _selinux.SELINUX_CB_AUDIT
SELINUX_CB_VALIDATE = _selinux.SELINUX_CB_VALIDATE
SELINUX_CB_SETENFORCE = _selinux.SELINUX_CB_SETENFORCE
SELINUX_CB_POLICYLOAD = _selinux.SELINUX_CB_POLICYLOAD

def selinux_get_callback(*args):
  return _selinux.selinux_get_callback(*args)
selinux_get_callback = _selinux.selinux_get_callback

def selinux_set_callback(*args):
  return _selinux.selinux_set_callback(*args)
selinux_set_callback = _selinux.selinux_set_callback
SELINUX_ERROR = _selinux.SELINUX_ERROR
SELINUX_WARNING = _selinux.SELINUX_WARNING
SELINUX_INFO = _selinux.SELINUX_INFO
SELINUX_AVC = _selinux.SELINUX_AVC
SELINUX_TRANS_DIR = _selinux.SELINUX_TRANS_DIR

def security_compute_av(*args):
  return _selinux.security_compute_av(*args)
security_compute_av = _selinux.security_compute_av

def security_compute_av_raw(*args):
  return _selinux.security_compute_av_raw(*args)
security_compute_av_raw = _selinux.security_compute_av_raw

def security_compute_av_flags(*args):
  return _selinux.security_compute_av_flags(*args)
security_compute_av_flags = _selinux.security_compute_av_flags

def security_compute_av_flags_raw(*args):
  return _selinux.security_compute_av_flags_raw(*args)
security_compute_av_flags_raw = _selinux.security_compute_av_flags_raw

def security_compute_create(*args):
  return _selinux.security_compute_create(*args)
security_compute_create = _selinux.security_compute_create

def security_compute_create_raw(*args):
  return _selinux.security_compute_create_raw(*args)
security_compute_create_raw = _selinux.security_compute_create_raw

def security_compute_create_name(*args):
  return _selinux.security_compute_create_name(*args)
security_compute_create_name = _selinux.security_compute_create_name

def security_compute_create_name_raw(*args):
  return _selinux.security_compute_create_name_raw(*args)
security_compute_create_name_raw = _selinux.security_compute_create_name_raw

def security_compute_relabel(*args):
  return _selinux.security_compute_relabel(*args)
security_compute_relabel = _selinux.security_compute_relabel

def security_compute_relabel_raw(*args):
  return _selinux.security_compute_relabel_raw(*args)
security_compute_relabel_raw = _selinux.security_compute_relabel_raw

def security_compute_member(*args):
  return _selinux.security_compute_member(*args)
security_compute_member = _selinux.security_compute_member

def security_compute_member_raw(*args):
  return _selinux.security_compute_member_raw(*args)
security_compute_member_raw = _selinux.security_compute_member_raw

def security_compute_user(*args):
  return _selinux.security_compute_user(*args)
security_compute_user = _selinux.security_compute_user

def security_compute_user_raw(*args):
  return _selinux.security_compute_user_raw(*args)
security_compute_user_raw = _selinux.security_compute_user_raw

def security_load_policy(*args):
  return _selinux.security_load_policy(*args)
security_load_policy = _selinux.security_load_policy

def security_get_initial_context(*args):
  return _selinux.security_get_initial_context(*args)
security_get_initial_context = _selinux.security_get_initial_context

def security_get_initial_context_raw(*args):
  return _selinux.security_get_initial_context_raw(*args)
security_get_initial_context_raw = _selinux.security_get_initial_context_raw

def selinux_mkload_policy(*args):
  return _selinux.selinux_mkload_policy(*args)
selinux_mkload_policy = _selinux.selinux_mkload_policy

def selinux_init_load_policy():
  return _selinux.selinux_init_load_policy()
selinux_init_load_policy = _selinux.selinux_init_load_policy
class SELboolean(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SELboolean, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SELboolean, name)
    __repr__ = _swig_repr
    __swig_setmethods__["name"] = _selinux.SELboolean_name_set
    __swig_getmethods__["name"] = _selinux.SELboolean_name_get
    if _newclass:name = _swig_property(_selinux.SELboolean_name_get, _selinux.SELboolean_name_set)
    __swig_setmethods__["value"] = _selinux.SELboolean_value_set
    __swig_getmethods__["value"] = _selinux.SELboolean_value_get
    if _newclass:value = _swig_property(_selinux.SELboolean_value_get, _selinux.SELboolean_value_set)
    def __init__(self): 
        this = _selinux.new_SELboolean()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_SELboolean
    __del__ = lambda self : None;
SELboolean_swigregister = _selinux.SELboolean_swigregister
SELboolean_swigregister(SELboolean)


def security_set_boolean_list(*args):
  return _selinux.security_set_boolean_list(*args)
security_set_boolean_list = _selinux.security_set_boolean_list

def security_load_booleans(*args):
  return _selinux.security_load_booleans(*args)
security_load_booleans = _selinux.security_load_booleans

def security_check_context(*args):
  return _selinux.security_check_context(*args)
security_check_context = _selinux.security_check_context

def security_check_context_raw(*args):
  return _selinux.security_check_context_raw(*args)
security_check_context_raw = _selinux.security_check_context_raw

def security_canonicalize_context(*args):
  return _selinux.security_canonicalize_context(*args)
security_canonicalize_context = _selinux.security_canonicalize_context

def security_canonicalize_context_raw(*args):
  return _selinux.security_canonicalize_context_raw(*args)
security_canonicalize_context_raw = _selinux.security_canonicalize_context_raw

def security_getenforce():
  return _selinux.security_getenforce()
security_getenforce = _selinux.security_getenforce

def security_setenforce(*args):
  return _selinux.security_setenforce(*args)
security_setenforce = _selinux.security_setenforce

def security_deny_unknown():
  return _selinux.security_deny_unknown()
security_deny_unknown = _selinux.security_deny_unknown

def security_disable():
  return _selinux.security_disable()
security_disable = _selinux.security_disable

def security_policyvers():
  return _selinux.security_policyvers()
security_policyvers = _selinux.security_policyvers

def security_get_boolean_names():
  return _selinux.security_get_boolean_names()
security_get_boolean_names = _selinux.security_get_boolean_names

def security_get_boolean_pending(*args):
  return _selinux.security_get_boolean_pending(*args)
security_get_boolean_pending = _selinux.security_get_boolean_pending

def security_get_boolean_active(*args):
  return _selinux.security_get_boolean_active(*args)
security_get_boolean_active = _selinux.security_get_boolean_active

def security_set_boolean(*args):
  return _selinux.security_set_boolean(*args)
security_set_boolean = _selinux.security_set_boolean

def security_commit_booleans():
  return _selinux.security_commit_booleans()
security_commit_booleans = _selinux.security_commit_booleans
class security_class_mapping(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, security_class_mapping, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, security_class_mapping, name)
    __repr__ = _swig_repr
    __swig_setmethods__["name"] = _selinux.security_class_mapping_name_set
    __swig_getmethods__["name"] = _selinux.security_class_mapping_name_get
    if _newclass:name = _swig_property(_selinux.security_class_mapping_name_get, _selinux.security_class_mapping_name_set)
    __swig_setmethods__["perms"] = _selinux.security_class_mapping_perms_set
    __swig_getmethods__["perms"] = _selinux.security_class_mapping_perms_get
    if _newclass:perms = _swig_property(_selinux.security_class_mapping_perms_get, _selinux.security_class_mapping_perms_set)
    def __init__(self): 
        this = _selinux.new_security_class_mapping()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _selinux.delete_security_class_mapping
    __del__ = lambda self : None;
security_class_mapping_swigregister = _selinux.security_class_mapping_swigregister
security_class_mapping_swigregister(security_class_mapping)


def selinux_set_mapping(*args):
  return _selinux.selinux_set_mapping(*args)
selinux_set_mapping = _selinux.selinux_set_mapping

def mode_to_security_class(*args):
  return _selinux.mode_to_security_class(*args)
mode_to_security_class = _selinux.mode_to_security_class

def string_to_security_class(*args):
  return _selinux.string_to_security_class(*args)
string_to_security_class = _selinux.string_to_security_class

def security_class_to_string(*args):
  return _selinux.security_class_to_string(*args)
security_class_to_string = _selinux.security_class_to_string

def security_av_perm_to_string(*args):
  return _selinux.security_av_perm_to_string(*args)
security_av_perm_to_string = _selinux.security_av_perm_to_string

def string_to_av_perm(*args):
  return _selinux.string_to_av_perm(*args)
string_to_av_perm = _selinux.string_to_av_perm

def security_av_string(*args):
  return _selinux.security_av_string(*args)
security_av_string = _selinux.security_av_string

def print_access_vector(*args):
  return _selinux.print_access_vector(*args)
print_access_vector = _selinux.print_access_vector
MATCHPATHCON_BASEONLY = _selinux.MATCHPATHCON_BASEONLY
MATCHPATHCON_NOTRANS = _selinux.MATCHPATHCON_NOTRANS
MATCHPATHCON_VALIDATE = _selinux.MATCHPATHCON_VALIDATE

def set_matchpathcon_flags(*args):
  return _selinux.set_matchpathcon_flags(*args)
set_matchpathcon_flags = _selinux.set_matchpathcon_flags

def matchpathcon_init(*args):
  return _selinux.matchpathcon_init(*args)
matchpathcon_init = _selinux.matchpathcon_init

def matchpathcon_init_prefix(*args):
  return _selinux.matchpathcon_init_prefix(*args)
matchpathcon_init_prefix = _selinux.matchpathcon_init_prefix

def matchpathcon_fini():
  return _selinux.matchpathcon_fini()
matchpathcon_fini = _selinux.matchpathcon_fini

def realpath_not_final(*args):
  return _selinux.realpath_not_final(*args)
realpath_not_final = _selinux.realpath_not_final

def matchpathcon(*args):
  return _selinux.matchpathcon(*args)
matchpathcon = _selinux.matchpathcon

def matchpathcon_index(*args):
  return _selinux.matchpathcon_index(*args)
matchpathcon_index = _selinux.matchpathcon_index

def matchpathcon_filespec_add(*args):
  return _selinux.matchpathcon_filespec_add(*args)
matchpathcon_filespec_add = _selinux.matchpathcon_filespec_add

def matchpathcon_filespec_destroy():
  return _selinux.matchpathcon_filespec_destroy()
matchpathcon_filespec_destroy = _selinux.matchpathcon_filespec_destroy

def matchpathcon_filespec_eval():
  return _selinux.matchpathcon_filespec_eval()
matchpathcon_filespec_eval = _selinux.matchpathcon_filespec_eval

def matchpathcon_checkmatches(*args):
  return _selinux.matchpathcon_checkmatches(*args)
matchpathcon_checkmatches = _selinux.matchpathcon_checkmatches

def matchmediacon(*args):
  return _selinux.matchmediacon(*args)
matchmediacon = _selinux.matchmediacon

def selinux_getenforcemode():
  return _selinux.selinux_getenforcemode()
selinux_getenforcemode = _selinux.selinux_getenforcemode

def selinux_boolean_sub(*args):
  return _selinux.selinux_boolean_sub(*args)
selinux_boolean_sub = _selinux.selinux_boolean_sub

def selinux_getpolicytype():
  return _selinux.selinux_getpolicytype()
selinux_getpolicytype = _selinux.selinux_getpolicytype

def selinux_policy_root():
  return _selinux.selinux_policy_root()
selinux_policy_root = _selinux.selinux_policy_root

def selinux_set_policy_root(*args):
  return _selinux.selinux_set_policy_root(*args)
selinux_set_policy_root = _selinux.selinux_set_policy_root

def selinux_current_policy_path():
  return _selinux.selinux_current_policy_path()
selinux_current_policy_path = _selinux.selinux_current_policy_path

def selinux_binary_policy_path():
  return _selinux.selinux_binary_policy_path()
selinux_binary_policy_path = _selinux.selinux_binary_policy_path

def selinux_failsafe_context_path():
  return _selinux.selinux_failsafe_context_path()
selinux_failsafe_context_path = _selinux.selinux_failsafe_context_path

def selinux_removable_context_path():
  return _selinux.selinux_removable_context_path()
selinux_removable_context_path = _selinux.selinux_removable_context_path

def selinux_default_context_path():
  return _selinux.selinux_default_context_path()
selinux_default_context_path = _selinux.selinux_default_context_path

def selinux_user_contexts_path():
  return _selinux.selinux_user_contexts_path()
selinux_user_contexts_path = _selinux.selinux_user_contexts_path

def selinux_file_context_path():
  return _selinux.selinux_file_context_path()
selinux_file_context_path = _selinux.selinux_file_context_path

def selinux_file_context_homedir_path():
  return _selinux.selinux_file_context_homedir_path()
selinux_file_context_homedir_path = _selinux.selinux_file_context_homedir_path

def selinux_file_context_local_path():
  return _selinux.selinux_file_context_local_path()
selinux_file_context_local_path = _selinux.selinux_file_context_local_path

def selinux_file_context_subs_path():
  return _selinux.selinux_file_context_subs_path()
selinux_file_context_subs_path = _selinux.selinux_file_context_subs_path

def selinux_file_context_subs_dist_path():
  return _selinux.selinux_file_context_subs_dist_path()
selinux_file_context_subs_dist_path = _selinux.selinux_file_context_subs_dist_path

def selinux_homedir_context_path():
  return _selinux.selinux_homedir_context_path()
selinux_homedir_context_path = _selinux.selinux_homedir_context_path

def selinux_media_context_path():
  return _selinux.selinux_media_context_path()
selinux_media_context_path = _selinux.selinux_media_context_path

def selinux_virtual_domain_context_path():
  return _selinux.selinux_virtual_domain_context_path()
selinux_virtual_domain_context_path = _selinux.selinux_virtual_domain_context_path

def selinux_virtual_image_context_path():
  return _selinux.selinux_virtual_image_context_path()
selinux_virtual_image_context_path = _selinux.selinux_virtual_image_context_path

def selinux_lxc_contexts_path():
  return _selinux.selinux_lxc_contexts_path()
selinux_lxc_contexts_path = _selinux.selinux_lxc_contexts_path

def selinux_x_context_path():
  return _selinux.selinux_x_context_path()
selinux_x_context_path = _selinux.selinux_x_context_path

def selinux_sepgsql_context_path():
  return _selinux.selinux_sepgsql_context_path()
selinux_sepgsql_context_path = _selinux.selinux_sepgsql_context_path

def selinux_openssh_contexts_path():
  return _selinux.selinux_openssh_contexts_path()
selinux_openssh_contexts_path = _selinux.selinux_openssh_contexts_path

def selinux_snapperd_contexts_path():
  return _selinux.selinux_snapperd_contexts_path()
selinux_snapperd_contexts_path = _selinux.selinux_snapperd_contexts_path

def selinux_systemd_contexts_path():
  return _selinux.selinux_systemd_contexts_path()
selinux_systemd_contexts_path = _selinux.selinux_systemd_contexts_path

def selinux_contexts_path():
  return _selinux.selinux_contexts_path()
selinux_contexts_path = _selinux.selinux_contexts_path

def selinux_securetty_types_path():
  return _selinux.selinux_securetty_types_path()
selinux_securetty_types_path = _selinux.selinux_securetty_types_path

def selinux_booleans_subs_path():
  return _selinux.selinux_booleans_subs_path()
selinux_booleans_subs_path = _selinux.selinux_booleans_subs_path

def selinux_booleans_path():
  return _selinux.selinux_booleans_path()
selinux_booleans_path = _selinux.selinux_booleans_path

def selinux_customizable_types_path():
  return _selinux.selinux_customizable_types_path()
selinux_customizable_types_path = _selinux.selinux_customizable_types_path

def selinux_users_path():
  return _selinux.selinux_users_path()
selinux_users_path = _selinux.selinux_users_path

def selinux_usersconf_path():
  return _selinux.selinux_usersconf_path()
selinux_usersconf_path = _selinux.selinux_usersconf_path

def selinux_translations_path():
  return _selinux.selinux_translations_path()
selinux_translations_path = _selinux.selinux_translations_path

def selinux_colors_path():
  return _selinux.selinux_colors_path()
selinux_colors_path = _selinux.selinux_colors_path

def selinux_netfilter_context_path():
  return _selinux.selinux_netfilter_context_path()
selinux_netfilter_context_path = _selinux.selinux_netfilter_context_path

def selinux_path():
  return _selinux.selinux_path()
selinux_path = _selinux.selinux_path

def selinux_check_access(*args):
  return _selinux.selinux_check_access(*args)
selinux_check_access = _selinux.selinux_check_access

def selinux_check_passwd_access(*args):
  return _selinux.selinux_check_passwd_access(*args)
selinux_check_passwd_access = _selinux.selinux_check_passwd_access

def checkPasswdAccess(*args):
  return _selinux.checkPasswdAccess(*args)
checkPasswdAccess = _selinux.checkPasswdAccess

def selinux_check_securetty_context(*args):
  return _selinux.selinux_check_securetty_context(*args)
selinux_check_securetty_context = _selinux.selinux_check_securetty_context

def set_selinuxmnt(*args):
  return _selinux.set_selinuxmnt(*args)
set_selinuxmnt = _selinux.set_selinuxmnt

def selinuxfs_exists():
  return _selinux.selinuxfs_exists()
selinuxfs_exists = _selinux.selinuxfs_exists

def fini_selinuxmnt():
  return _selinux.fini_selinuxmnt()
fini_selinuxmnt = _selinux.fini_selinuxmnt

def setexecfilecon(*args):
  return _selinux.setexecfilecon(*args)
setexecfilecon = _selinux.setexecfilecon

def rpm_execcon(*args):
  return _selinux.rpm_execcon(*args)
rpm_execcon = _selinux.rpm_execcon

def is_context_customizable(*args):
  return _selinux.is_context_customizable(*args)
is_context_customizable = _selinux.is_context_customizable

def selinux_trans_to_raw_context(*args):
  return _selinux.selinux_trans_to_raw_context(*args)
selinux_trans_to_raw_context = _selinux.selinux_trans_to_raw_context

def selinux_raw_to_trans_context(*args):
  return _selinux.selinux_raw_to_trans_context(*args)
selinux_raw_to_trans_context = _selinux.selinux_raw_to_trans_context

def selinux_raw_context_to_color(*args):
  return _selinux.selinux_raw_context_to_color(*args)
selinux_raw_context_to_color = _selinux.selinux_raw_context_to_color

def getseuserbyname(*args):
  return _selinux.getseuserbyname(*args)
getseuserbyname = _selinux.getseuserbyname

def getseuser(*args):
  return _selinux.getseuser(*args)
getseuser = _selinux.getseuser

def selinux_file_context_cmp(*args):
  return _selinux.selinux_file_context_cmp(*args)
selinux_file_context_cmp = _selinux.selinux_file_context_cmp

def selinux_file_context_verify(*args):
  return _selinux.selinux_file_context_verify(*args)
selinux_file_context_verify = _selinux.selinux_file_context_verify

def selinux_lsetfilecon_default(*args):
  return _selinux.selinux_lsetfilecon_default(*args)
selinux_lsetfilecon_default = _selinux.selinux_lsetfilecon_default

def selinux_reset_config():
  return _selinux.selinux_reset_config()
selinux_reset_config = _selinux.selinux_reset_config
# This file is compatible with both classic and new-style classes.


