%define template_dir	/vz/template

Name: vztmpl2
Version: 1.0.0
Release: 1
Summary: OpenVZ metadata for templates 
License: GPL
Vendor: OpenVZ
URL:	http://openvz.org/
Group: Applications/System
Source: %{name}-%{version}.tar.bz2
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: createrepo, rpm-build, sed, gawk
Requires: vzpkg2 >= 0.9.0
Conflicts: vzpkg

%description
OpenVZ metadata for templates

%prep
%setup -q

%install
make VERSION=%{version} DESTDIR=${RPM_BUILD_ROOT} TEMPLATE=%{template_dir} install

%clean
test "$RPM_BUILD_ROOT" != "" && rm -rf $RPM_BUILD_ROOT

%post
# Remove yum-cache directory
rm -rf /vz/template/*/*/*/yum-cache
exit 0

%package all
Summary: OpenVZ template metadata for everything
Group: Applications/System
Requires: vzpkg2 >= 0.9.0
Requires: vztmpl2-centos
Requires: vztmpl2-fedora
Requires: vztmpl2-debian
Requires: vztmpl2-ubuntu

%description all
OpenVZ template metadata for everything

%files all

%package centos
Summary: OpenVZ template metadata for CentOS
Group: Applications/System

%description centos
OpenVZ template metadata for CentOS

%files centos
%defattr(-, root, root)
%dir /vz/template/centos/config
%dir /vz/template/centos/*/*/*
/vz/template/centos/config/*
/vz/template/centos/*/*/config/.rpmmacros

%package fedora
Summary: OpenVZ template metadata for Fedora
Group: Applications/System

%description fedora
OpenVZ template metadata for Fedora

%files fedora
%defattr(-, root, root)
%dir /vz/template/fedora/config
%dir /vz/template/fedora/*/config
%dir /vz/template/fedora/*/config/gpgkeys
%dir /vz/template/fedora/*/*/config
/vz/template/fedora/config/*
/vz/template/fedora/*/config/*
/vz/template/fedora/*/config/gpgkeys/*
/vz/template/fedora/*/*/config/.rpmmacros

%package debian
Summary: OpenVZ template metadata for Debian
Group: Applications/System

%description debian
OpenVZ template metadata for Debian

%files debian
%defattr(-, root, root)
%dir /vz/template/debian/config
%dir /vz/template/debian/*/*/*
/vz/template/debian/config/*
/vz/template/debian/*/*/*

%package ubuntu
Summary: OpenVZ template metadata for Ubuntu
Group: Applications/System

%description ubuntu
OpenVZ template metadata for Ubuntu

%files ubuntu
%defattr(-, root, root)
%dir /vz/template/ubuntu/config
%dir /vz/template/ubuntu/*/*/*
/vz/template/ubuntu/config/*
/vz/template/ubuntu/*/*/*

%changelog
* Mon Dec  1 2008 Robert Nelson <robertn@the-nelsons.org> - 1.0.0
  - Add support for creating templates that don't use pkg-cacher.

  - Add Fedora 10 templates

  - Cleanup RPM GPG Keys

* Thu Nov 16 2008 Robert Nelson <robertn@the-nelsons.org> - 0.9.4
  - create Berkeley style ptys statically

  - Add ubuntu intrepid template

  - Update debian sarge template to match move to the debian archive

  - Update fedora templates to use newkey version of the update repository

* Wed Sep 17 2008 Robert Nelson <robertn@the-nelsons.org> - 0.9.3
  - Change location of VZPKG_CACHE_HOST.

* Sun Sep  7 2008 Robert Nelson <robertn@the-nelsons.org> - 0.9.1
  - Initial version of new template structure.
