Name:		vzpkg2
Version:	1.0.0
Release:	1
Summary:	OpenVZ template management tools
Source:		%{name}-%{version}.tar.bz2
License:	GPL
URL:		http://openvz.org/
Group:		Applications/System
BuildRoot:	%{_tmppath}/%{name}-%{version}-root
BuildArch:	noarch

Requires:	sed, gawk, coreutils
Requires:	procmail
Requires:	vzctl >= 2.7.0-23

# New vzpkg does not work with old template metadata.
Conflicts:	vzpkg
Conflicts:	vztmpl-fedora-core-3
Conflicts:	vztmpl-fedora-core-4
Conflicts:	vztmpl-centos-4
# Since vzpkg-3.0 it requires newer vzrpms
# (the ones with dynamically linked python modules)

%define libdir %_datadir/%name

#avoid stripping
%define __strip /bin/true

%description
OpenVZ template management tools are used for software installation
inside Virtual Environments.


%prep
%setup -n %{name}-%{version}

%install
make DESTDIR=%buildroot install

%files
%defattr(755, root, root)
%_bindir/vzpkgcache
%_bindir/vzpkgadd
%_bindir/vzpkgrm
%_bindir/vzpkgupd
%_bindir/vzpkgquery
%_bindir/vzpkgls
%_bindir/vzosname
%dir %libdir
%defattr(755, root, root)
%attr(644,root,root) %libdir/functions
%libdir/cache-os
%attr(644,root,root) %libdir/apt-functions
%libdir/apt-checkupdate
%libdir/apt-cache-install
%libdir/apt-cache-update
%libdir/apt-add
%libdir/apt-query
%libdir/apt-rm
%libdir/apt-update
%attr(644,root,root) %libdir/yum-functions
%libdir/yum-cache-install
%libdir/yum-cache-update
%libdir/yum-checkupdate
%libdir/yum-add
%libdir/yum-query
%libdir/yum-rm
%libdir/yum-update
%libdir/myinit.*
%config %_sysconfdir/vz/vzpkg.conf
%_mandir/man5/vzpkg.conf.5.*
%_mandir/man8/vzpkgcache.8.*
%doc README NEWS TODO COPYING

%post
sed -i -e 's/@@hostname@@/'`hostname`'/' %_sysconfdir/vz/vzpkg.conf

%clean
test "x$RPM_BUILD_ROOT" != "x" && rm -rf $RPM_BUILD_ROOT


%changelog
* Mon Dec  1 2008 Robert Nelson <robertn@the-nelsons.org> 1.0.0
  - Updated copyrights.

  - Add support for generating templates without pkg-cacher.

  - Changed defaults to work with pkg-cacher running as a cgi script or 
    stand-alone.

* Tue Sep 17 2008 Robert Nelson <robertn@the-nelsons.org> 0.9.5
  - Fix read_vz_conf return code so it doesn't cause "set -e" scripts to fail.

* Tue Sep 16 2008 Robert Nelson <robertn@the-nelsons.org> 0.9.4
  - Use vzpkg.conf for global settings rather than vz.conf.
  - Use correct scripts directory on 64 bit systems
  - Change processing of vzpkg.conf files to allow more specific ones to override
    values from less specific ones.
  - Automatically set VZPKG_CACHE_HOST during install.
  - Add manual page for vzpkg.conf.
  - Update vzpkgcache manual page.

* Tue Sep 14 2008 Robert Nelson <robertn@the-nelsons.org> 0.9.3
  - Fix intermittent problem with tar failing due to building archive in current directory.

* Tue Sep  9 2008 Robert Nelson <robertn@the-nelsons.org> 0.9.2
  - Derived from OpenVZ vzpkg.

