Summary:  Caching proxy for Debian, Ubuntu, RedHat, Fedora, and CentOS repositories.
Name: pkg-cacher
Version: 0.9.6
Release: 1%{dist}
License: GPL
Group: Applications/System
Source: %{name}-%{version}.tar.bz2
Packager: Robert Nelson (robertn at the-nelsons dot org)
Buildroot: %{_tmppath}/%{name}-%{version}-root
BuildArch: noarch
Provides: perl(pkg-cacher-lib.pl)
Provides: perl(pkg-cacher-request.pl)
Provides: perl(pkg-cacher-fetch.pl)

%description
Pkg-cacher performs caching of packages and metadata which have been downloaded by 
local users. It is most useful for local area networks with slow internet uplink or 
many machines running the same distribution and version.

When a package is requested, the cache checks whether it already has the
requested version, in which case it sends the package to the user immediately.
If not, it downloads the package while streaming it to the user at the same
time. A local copy is then kept for use by other users.

Pkg-cacher has been optimized for best utilization of network bandwidth and
efficiency even on slow low-memory servers. Multiple ways of installation are
possible: as a stand-alone HTTP proxy, as a daemon executed by inetd or as a
CGI program. Client machines are configured by changing APT's proxy
configuration or modification of access URLs in sources.list.

The package includes utilities to clean the cache (removing obsolete package
files), generate usage reports.  Experimental features include optional IPv6 
support.

Pkg-cacher can be used as a replacement for apt-cacher or apt-proxy, with no 
need to modify client's /etc/pkg/sources.list files or as an alternative to 
approx.

%package sa
Summary:  Caching proxy for Debian, Ubuntu, RedHat, Fedora, and CentOS repositories.
Group: Applications/System
Requires: pkg-cacher = %{version}
Conflicts: pkg-cacher-cgi
%description sa
This package installs and configures pkg-cacher as a cgi script under Apache.

Install pkg-cacher-sa instead if a standalone server is desired.

%package cgi
Summary:  Caching proxy for Debian, Ubuntu, RedHat, Fedora, and CentOS repositories.
Group: Applications/System
Requires: pkg-cacher = %{version}
Conflicts: pkg-cacher-sa
%description cgi
This package installs and configures pkg-cacher as a standalone server.

Install pkg-cacher-cgi instead if a cgi script under Apache is desired.

%prep
%setup -q

%install
make DESTDIR=$RPM_BUILD_ROOT install-clean
make DESTDIR=$RPM_BUILD_ROOT install-dirs
make DESTDIR=$RPM_BUILD_ROOT install-files
perl -pe 's/^my \$version=.*/my \$version="'%{version}-%{release}'";/' -i $RPM_BUILD_ROOT/usr/share/pkg-cacher/*
make DESTDIR=$RPM_BUILD_ROOT install-config
make DESTDIR=$RPM_BUILD_ROOT install-docs
make DESTDIR=$RPM_BUILD_ROOT install-logrotate
make DESTDIR=$RPM_BUILD_ROOT install-init
make DESTDIR=$RPM_BUILD_ROOT install-cron
make DESTDIR=$RPM_BUILD_ROOT install-man
make DESTDIR=$RPM_BUILD_ROOT install-link

%files
%defattr(-,root,root)
/usr/sbin/pkg-cacher
%attr(-,pkg-cacher,pkg-cacher) %dir /usr/share/pkg-cacher
/usr/share/pkg-cacher/*
%attr(-,pkg-cacher,pkg-cacher) %dir /var/cache/pkg-cacher
%attr(-,pkg-cacher,pkg-cacher) %dir /var/log/pkg-cacher
%config /etc/pkg-cacher/pkg-cacher.conf
%config /etc/pkg-cacher/apache.conf
%config /etc/cron.daily/pkg-cacher
%config /etc/logrotate.d/pkg-cacher
%doc /usr/share/doc/pkg-cacher/*
%doc /usr/share/man/man1/pkg-cacher.*

%files sa
%defattr(-,root,root)
%config /etc/init.d/pkg-cacher
%config /etc/sysconfig/pkg-cacher

%files cgi
%defattr(-,root,root)

%pre sa
getent group pkg-cacher > /dev/null || groupadd -r pkg-cacher
getent passwd pkg-cacher > /dev/null || \
	useradd -r -d /var/cache/pkg-cacher -g pkg-cacher -s /sbin/nologin \
	-c "pkg-cacher user" pkg-cacher > /dev/null 2>&1

%post sa
test -d /var/cache/pkg-cacher || {
	mkdir /var/cache/pkg-cacher{,/cache,/headers,/import,/packages,/private,/temp}
}
chown -R pkg-cacher:pkg-cacher /var/cache/pkg-cacher
test -d /var/log/pkg-cacher || {
	mkdir /var/log/pkg-cacher
	touch /var/log/pkg-cacher/{access.log,error.log}
}
chown -R pkg-cacher:pkg-cacher /var/log/pkg-cacher
sed -i -e '/^\(user\|group\)=/s/=.*$/=pkg-cacher/' /etc/pkg-cacher/pkg-cacher.conf
chkconfig pkg-cacher on
service pkg-cacher restart

%post cgi
ln -sf /etc/pkg-cacher/apache.conf /etc/httpd/conf.d/pkg-cacher.conf
test -d /var/cache/pkg-cacher || {
	mkdir /var/cache/pkg-cacher{,/cache,/headers,/import,/packages,/private,/temp}
}
chown -R apache:apache /var/cache/pkg-cacher
test -d /var/log/pkg-cacher || {
	mkdir /var/log/pkg-cacher
	touch /var/log/pkg-cacher/{access.log,error.log}
}
chown -R apache:apache /var/log/pkg-cacher
sed -i -e '/^\(user\|group\)=/s/=.*$/=apache/' /etc/pkg-cacher/pkg-cacher.conf
service httpd restart

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Sun Nov 11 2008 Robert Nelson ( robertn@the-nelsons.org ) - 0.9.6
  - Add support for RedHat .img files as static files.

  - Since we handle the Range header but not the If-Range header we need 
    to ignore the former if the latter is specified.

  - Remove import and precache scripts since they aren't applicable to the 
    new cache structure.

  - Remove proxy support for arbitrary host.

  - Remove allowed_location configuration since path_map controls remote
    server access.

  - fix cgi-mode handling.

  - Add separate packages for standalone vs cgi installs.

  - Allow override of configuration values in cgi-mode.

  - Cleanup documentation.

* Wed Sep 17 2008 Robert Nelson ( robertn@the-nelsons.org ) - 0.9.5
  - Fix owner, perms on /var/cache/pkg-cacher on Debian

* Sun Sep 14 2008 Robert Nelson ( robertn@the-nelsons.org ) - 0.9.4
  - Split into 3 files to ease maintenance prior to changing to multithreaded.
  - Disable curl debugging, not supported on Debian Etch.
  - Fix path for reading patterns.

* Fri Sep 12 2008 Robert Nelson ( robertn@the-nelsons.org ) - 0.9.3
  - Add support for HTTP Redirect
  - Made file patterns easily configurable.
  - Added OpenSUSE patterns.

* Mon Sep  9 2008 Robert Nelson ( robertn@the-nelsons.org ) - 0.9.2
  - Updated path_map to add repo.opensource-sw.net
  - Add support for Range header

* Sat Sep  6 2008 Robert Nelson ( robertn@the-nelsons.org ) - 0.9.1
  - Fixed Debian packaging

* Mon Sep  2 2008 Robert Nelson ( robertn@the-nelsons.org ) - 0.9.0
  - Created from version 1.6.4 of apt-cacher.
  - Renamed to pkg-cacher.
  - Modified to support RedHat.
  - Modified to handle files with the same name but different content.
  - Removed Debian specific checksum code.
