# To get a package list without version numbers from a target system
# rpm -qa --qf "%{n} " > packages.txt
# Put contents of packages.txt after "-y install \" line below

rm -rf /ostemplate ; mkdir /ostemplate
mkdir -p /ostemplate/var/lib
touch /ostemplate/var/lib/random-seed

yum \
--installroot=/ostemplate \
--nogpg \
--releasever=20 \
--disablerepo=* --enablerepo="fedora" --enablerepo="updates" \
-y install \
openssh-clients openssh-server yum yum-utils man wget sudo tar passwd vim-minimal net-tools fedora-release net-tools initscripts

# Fix up /etc/fstab
echo "none /dev/pts devpts rw,gid=5,mode=620 0 0" > /ostemplate/etc/fstab
echo "none /dev/shm tmpfs defaults 0 0" >> /ostemplate/etc/fstab
ln -sf /proc/mounts /ostemplate/etc/mtab

# Get rid of gettys
# sed -i -e 's/ACTIVE_CONSOLES=\/dev\/tty\[1\-6\]/ACTIVE_CONSOLES=/g' /ostemplate/etc/sysconfig/init

# Clean up yum, etc
# yum --installroot=/ostemplate clean all
rm -rf /ostemplate/var/cache/yum/*
rm -rf /ostemplate/var/lib/yum/yumdb/*
rm -f /ostemplate/dev/null
mknod -m 600 /ostemplate/dev/console c 5 1

# Fix networking
cd /ostemplate/etc/rc.d/rc3.d ; ln -sf ../init.d/network S10network

# Copy the scripts into the new container
cp /root/create-fedora20* /ostemplate/root/

# Create .tar.xz file
cd /ostemplate ; tar -cvJf /root/fedora-20-x86-minimal-$(date +%Y%m%d).tar.xz . 
ls -lh /root/fedora-20-x86-minimal-$(date +%Y%m%d).tar.xz 
echo "Done building OS Template.  Now test it."
