#version=DEVEL
# X Window System configuration information
xconfig  --startxonboot
# Keyboard layouts
keyboard 'us'
# Root password
rootpw --plaintext rootme
# System language
lang en_US.UTF-8
# Shutdown after installation
shutdown
# System timezone
timezone US/Mountain
# Network information
network  --bootproto=dhcp --device=link --activate

url --url=http://192.168.1.4/fedora/development/43/Everything/x86_64/os/
repo --name="rpmfusionfree" --baseurl=http://192.168.1.4/rpmfusion/development/43/free/x86_64/os/
repo --name="rpmfusionnonfree" --baseurl=http://192.168.1.4/rpmfusion/development/43/nonfree/x86_64/os/
repo --name="local" --baseurl=http://192.168.1.4/local/43/x86_64/

# Firewall configuration
firewall --enabled --service=mdns
# SELinux configuration
selinux --enforcing

# System services
services --disabled="sshd" --enabled="NetworkManager,ModemManager"
# System bootloader configuration
bootloader --location=none
# Clear the Master Boot Record
zerombr
# Partition clearing information
clearpart --all --initlabel
# Disk partitioning information
part / --size=10238

%post

# Enable livesys services
systemctl enable livesys.service
systemctl enable livesys-late.service

# Enable sddm since EPEL packages it disabled by default
systemctl enable sddm.service

# enable tmpfs for /tmp
systemctl enable tmp.mount

# make it so that we don't do writing to the overlay for things which
# are just tmpdirs/caches
# note https://bugzilla.redhat.com/show_bug.cgi?id=1135475
cat >> /etc/fstab << EOF
vartmp   /var/tmp    tmpfs   defaults   0  0
EOF

# work around for poor key import UI in PackageKit
rm -f /var/lib/rpm/__db*
# import AlmaLinux PGP key
rpm --import /etc/pki/rpm-gpg/RPM-GPG-KEY-AlmaLinux
echo "Packages within this LiveCD"
rpm -qa
# Note that running rpm recreates the rpm db files which aren't needed or wanted
rm -f /var/lib/rpm/__db*

# go ahead and pre-make the man -k cache (#455968)
/usr/bin/mandb

# make sure there aren't core files lying around
rm -f /core*

# remove random seed, the newly installed instance should make it's own
rm -f /var/lib/systemd/random-seed

# convince readahead not to collect
# FIXME: for systemd

echo 'File created by kickstart. See systemd-update-done.service(8).' \
    | tee /etc/.updated >/var/.updated

# Drop the rescue kernel and initramfs, we don't need them on the live media itself.
# See bug 1317709
rm -f /boot/*-rescue*

# Theme wallpapers
rm -f /usr/share/wallpapers/Fedora
ln -s Alma-default /usr/share/wallpapers/Fedora

# Login screen theme and wallpapers
cat <<'EOF'>/etc/sddm.conf.d/kde_settings.conf
[Theme]
Current=breeze
EOF
sed -i 's#background=.*$#background=/usr/share/backgrounds/almalinux-day.jpg#g' \
  /usr/share/sddm/themes/breeze/theme.conf

# TODO: revise I and II once installer icon is on the separate package
# like Fedora does at https://src.fedoraproject.org/rpms/kf6-breeze-icons/c/728493c525b4e4e7be5caccba41f66e8d816ee38

# I. Fix org.fedoraproject.AnacondaInstaller.svg broken symlinks
cp -a /usr/share/icons/hicolor/scalable/apps/org.fedoraproject.AnacondaInstaller.svg \
  /usr/share/icons/hicolor/48x48/apps/
# II. Replace live installer icon for the application and welcome center
cp -a /usr/share/icons/hicolor/scalable/apps/org.fedoraproject.AnacondaInstaller.svg \
  /usr/share/icons/hicolor/48x48/apps/org.almalinux.AnacondaInstaller.svg
sed -i 's#Icon=.*$#Icon=org.almalinux.AnacondaInstaller#g' \
  /usr/share/applications/liveinst.desktop

# Show liveinst.desktop on desktop and in menu
sed -i 's/NoDisplay=true/NoDisplay=false/' /usr/share/applications/liveinst.desktop
mkdir /home/liveuser/Desktop
cp -a /usr/share/applications/liveinst.desktop /home/liveuser/Desktop/liveinst.desktop
chmod +x /home/liveuser/Desktop/liveinst.desktop

# Disable network service here, as doing it in the services line
# fails due to RHBZ #1369794
systemctl disable network

# Remove machine-id on pre generated images
rm -f /etc/machine-id
touch /etc/machine-id

# set livesys session type
sed -i 's/^livesys_session=.*/livesys_session="kde"/' /etc/sysconfig/livesys

# enable CRB repo
dnf config-manager --enable crb

# Workaround to add openvpn user and group in case they didn't added during
# openvpn package installation
getent group openvpn &>/dev/null || groupadd -r openvpn
getent passwd openvpn &>/dev/null || \
    /usr/sbin/useradd -r -g openvpn -s /sbin/nologin -c OpenVPN \
        -d /etc/openvpn openvpn

%end

%packages

7zip
aajohan-comfortaa-fonts
aalib-libs
abattis-cantarell-fonts
abattis-cantarell-vf-fonts
abseil-cpp
accountsservice
accountsservice-libs
acl
adobe-mappings-cmap
adobe-mappings-cmap-deprecated
adobe-mappings-pdf
adwaita-cursor-theme
adwaita-gtk2-theme
adwaita-icon-theme
adwaita-icon-theme-legacy
adwaita-mono-fonts
adwaita-sans-fonts
alsa-lib
alsa-sof-firmware
alsa-ucm
alsa-utils
alternatives
amd-gpu-firmware
amd-ucode-firmware
anaconda
anaconda-core
anaconda-gui
anaconda-install-env-deps
anaconda-live
anaconda-tui
anaconda-webui
anaconda-widgets
anthy-unicode
antiword
appstream
appstream-data
aribb24
asunder
at
atheros-firmware
atk
atkmm
atril
atril-libs
at-spi2-atk
at-spi2-core
attr
audit
audit-libs
audit-rules
augeas-libs
authselect
authselect-libs
autocorr-en
avahi
avahi-glib
avahi-gobject
avahi-libs
avahi-tools
avahi-ui-gtk3
b43-fwcutter
b43-openfwwf
babl
bash
bash-color-prompt
bash-completion
bc
bind-libs
bind-utils
binutils
blivet-data
blivet-gui-runtime
blueman
bluez
bluez-cups
bluez-libs
bluez-obexd
boost-atomic
boost-chrono
boost-date-time
boost-filesystem
boost-iostreams
boost-locale
boost-regex
boost-system
boost-thread
borgbackup
Box2D
braille-printer-app
brcmfmac-firmware
brlapi
brltty
btrfs-progs
bubblewrap
bzip2
bzip2-libs
ca-certificates
cairo
cairo-gobject
cairomm
cairomm1.16
c-ares
catfish
cdparanoia
cdparanoia-libs
cfitsio
checkpolicy
chrony
cifs-utils
cifs-utils-info
cirrus-audio-firmware
cldr-emoji-annotation
cldr-emoji-annotation-dtd
clevis
clevis-luks
clevis-pin-tpm2
clucene-contribs-lib
clucene-core
clutter
cockpit-bridge
cockpit-storaged
cockpit-system
cockpit-ws
cockpit-ws-selinux
codec2
cogl
colord
colord-libs
color-filesystem
compat-lua-libs
composefs-libs
comps-extras
compsize
coreutils
coreutils-common
cpio
cpp
cpuinfo
cracklib
cracklib-dicts
cronie
cronie-anacron
crontabs
crypto-policies
crypto-policies-scripts
cryptsetup
cryptsetup-libs
ctags
cups
cups-browsed
cups-client
cups-filesystem
cups-filters
cups-filters-driverless
cups-ipptool
cups-libs
cups-pk-helper
curl
cxl-libs
cyrus-sasl-gssapi
cyrus-sasl-lib
cyrus-sasl-plain
daxctl-libs
dbus
dbus-broker
dbus-common
dbus-daemon
dbus-glib
dbus-libs
dbus-tools
dbus-x11
dconf
ddrescue
default-editor
default-fonts-am
default-fonts-ar
default-fonts-as
default-fonts-ast
default-fonts-be
default-fonts-bg
default-fonts-bn
default-fonts-bo
default-fonts-br
default-fonts-chr
default-fonts-cjk-mono
default-fonts-cjk-sans
default-fonts-cjk-serif
default-fonts-core-emoji
default-fonts-core-math
default-fonts-core-mono
default-fonts-core-sans
default-fonts-core-serif
default-fonts-dv
default-fonts-dz
default-fonts-el
default-fonts-eo
default-fonts-eu
default-fonts-fa
default-fonts-got
default-fonts-gu
default-fonts-he
default-fonts-hi
default-fonts-hy
default-fonts-ia
default-fonts-iu
default-fonts-ka
default-fonts-kab
default-fonts-km
default-fonts-kn
default-fonts-ku
default-fonts-lo
default-fonts-mai
default-fonts-ml
default-fonts-mni
default-fonts-mr
default-fonts-my
default-fonts-nb
default-fonts-ne
default-fonts-nn
default-fonts-nqo
default-fonts-nr
default-fonts-nso
default-fonts-or
default-fonts-other-mono
default-fonts-other-sans
default-fonts-other-serif
default-fonts-pa
default-fonts-ru
default-fonts-sat
default-fonts-si
default-fonts-ss
default-fonts-syr
default-fonts-ta
default-fonts-te
default-fonts-th
default-fonts-tn
default-fonts-ts
default-fonts-uk
default-fonts-ur
default-fonts-ve
default-fonts-vi
default-fonts-xh
default-fonts-yi
default-fonts-zu
dejavu-sans-mono-fonts
deltarpm
desktop-backgrounds-compat
desktop-file-utils
device-mapper
device-mapper-event
device-mapper-event-libs
device-mapper-libs
device-mapper-persistent-data
dhcp-client
dhcp-common
diffutils
djvulibre-libs
dmidecode
dnf4-plugin-notify-PackageKit
dnf5
dnf5daemon-server
dnf5-plugins
dnf-data
dnfdragora
dnfdragora-updater
dnf-plugins-core
dnsmasq
dos2unix
dosfstools
dotconf
double-conversion
dracut
dracut-config-rescue
dracut-live
dracut-network
dracut-squash
duktape
e2fsprogs
e2fsprogs-libs
ed
efibootmgr
efi-filesystem
efivar-libs
elfutils-debuginfod-client
elfutils-default-yama-scope
elfutils-libelf
elfutils-libs
emacs-filesystem
enchant
enchant2
erofs-utils
espeak-ng
ethtool
exfatprogs
exiv2
exiv2-libs
exo
expat
f2fs-tools
f42-backgrounds-base
f43-backgrounds-base
faad2-libs
fdk-aac-free
fedora-gpg-keys
fedora-logos
fedora-release-common
fedora-release-identity-xfce
fedora-release-xfce
fedora-repos
ffmpeg
ffmpeg-libs
fftw-libs-double
fftw-libs-single
file
file-libs
filesystem
findutils
firefox
firefox-langpacks
firewall-config
firewalld
firewalld-filesystem
flac
flac-libs
flashrom
flatpak
flatpak-libs
flatpak-selinux
flatpak-session-helper
flexiblas
flexiblas-netlib
flexiblas-openblas-openmp
flite
fmt
fontconfig
fonts-filesystem
fpaste
fprintd
fprintd-pam
freeglut
freerdp-libs
freetype
fribidi
fstrm
fuse
fuse3
fuse3-libs
fuse-common
fuse-libs
fuse-sshfs
fwupd
fwupd-efi
fwupd-plugin-flashrom
fwupd-plugin-modem-manager
fwupd-plugin-uefi-capsule-data
galculator
game-music-emu
garcon
gawk
gawk-all-langpacks
gc
gcr3
gcr3-base
gcr-libs
gd
gdb
gdb-headless
gdbm
gdbm-libs
gdk-pixbuf2
gdk-pixbuf2-modules-extra
gdouros-symbola-fonts
geany
geany-libgeany
gegl04
gegl04-matting-levin
geoclue2
geolite2-city
geolite2-country
gettext-envsubst
gettext-libs
gettext-runtime
ghostscript
ghostscript-tools-fontutils
ghostscript-tools-printing
giflib
gimp
gimp-libs
gjs
glib2
glibc
glibc-all-langpacks
glibc-common
glibc-gconv-extra
glibmm2.4
glibmm2.68
glib-networking
glx-utils
glycin-libs
glycin-loaders
gmp
gnome-disk-utility
gnome-icon-theme
gnome-keyring
gnome-keyring-pam
gnome-themes-extra
gnulib-l10n
gnupg2
gnupg2-dirmngr
gnupg2-g13
gnupg2-gpg-agent
gnupg2-gpgconf
gnupg2-keyboxd
gnupg2-scdaemon
gnupg2-smime
gnupg2-utils
gnupg2-verify
gnupg2-wks
gnutls
gnutls-dane
gobject-introspection
golang-github-katalix-l2tp
google-carlito-fonts
google-crosextra-caladea-fonts
google-droid-sans-fonts
google-noto-color-emoji-fonts
google-noto-emoji-fonts
google-noto-fonts-common
google-noto-naskh-arabic-vf-fonts
google-noto-sans-arabic-vf-fonts
google-noto-sans-armenian-vf-fonts
google-noto-sans-bengali-vf-fonts
google-noto-sans-canadian-aboriginal-vf-fonts
google-noto-sans-cherokee-vf-fonts
google-noto-sans-cjk-vf-fonts
google-noto-sans-devanagari-vf-fonts
google-noto-sans-ethiopic-vf-fonts
google-noto-sans-georgian-vf-fonts
google-noto-sans-gothic-fonts
google-noto-sans-gujarati-vf-fonts
google-noto-sans-gurmukhi-vf-fonts
google-noto-sans-hebrew-vf-fonts
google-noto-sans-kannada-vf-fonts
google-noto-sans-khmer-vf-fonts
google-noto-sans-lao-vf-fonts
google-noto-sans-math-fonts
google-noto-sans-meetei-mayek-vf-fonts
google-noto-sans-mono-cjk-vf-fonts
google-noto-sans-mono-vf-fonts
google-noto-sans-nko-fonts
google-noto-sans-ol-chiki-vf-fonts
google-noto-sans-oriya-vf-fonts
google-noto-sans-sinhala-vf-fonts
google-noto-sans-symbols-2-fonts
google-noto-sans-symbols-vf-fonts
google-noto-sans-syriac-vf-fonts
google-noto-sans-tamil-vf-fonts
google-noto-sans-telugu-vf-fonts
google-noto-sans-thaana-vf-fonts
google-noto-sans-thai-vf-fonts
google-noto-sans-vf-fonts
google-noto-serif-armenian-vf-fonts
google-noto-serif-bengali-vf-fonts
google-noto-serif-cjk-vf-fonts
google-noto-serif-devanagari-vf-fonts
google-noto-serif-ethiopic-vf-fonts
google-noto-serif-georgian-vf-fonts
google-noto-serif-gujarati-vf-fonts
google-noto-serif-gurmukhi-vf-fonts
google-noto-serif-hebrew-vf-fonts
google-noto-serif-kannada-vf-fonts
google-noto-serif-khmer-vf-fonts
google-noto-serif-lao-vf-fonts
google-noto-serif-oriya-vf-fonts
google-noto-serif-sinhala-vf-fonts
google-noto-serif-tamil-vf-fonts
google-noto-serif-telugu-vf-fonts
google-noto-serif-thai-vf-fonts
google-noto-serif-vf-fonts
gparted
gpgme
gpgmepp
gpm-libs
graphene
GraphicsMagick
GraphicsMagick-c++
graphite2
graphviz-libs
grep
greybird-dark-theme
greybird-light-theme
greybird-xfce4-notifyd-theme
greybird-xfwm4-theme
groff-base
grub2-common
grub2-efi-ia32
grub2-efi-ia32-cdboot
grub2-efi-x64
grub2-efi-x64-cdboot
grub2-efi-x64-modules
grub2-pc
grub2-pc-modules
grub2-tools
grub2-tools-efi
grub2-tools-extra
grub2-tools-minimal
grubby
gsettings-desktop-schemas
gsl
gsm
gspell
gssdp
gssproxy
gstreamer1
gstreamer1-plugin-dav1d
gstreamer1-plugin-openh264
gstreamer1-plugins-bad-free
gstreamer1-plugins-bad-free-libs
gstreamer1-plugins-bad-freeworld
gstreamer1-plugins-base
gstreamer1-plugins-good
gstreamer1-plugins-good-gtk
gstreamer1-plugins-good-qt6
gstreamer1-plugins-ugly
gstreamer1-plugins-ugly-free
gtk2
gtk2-immodule-xim
gtk3
gtk3-immodule-xim
gtk4
gtk-layer-shell
gtkmm3.0
gtkmm4.0
gtk-murrine-engine
gtksourceview4
gtk-update-icon-cache
gtk-vnc2
gtk-xfce-engine
gupnp
gupnp-igd
gutenprint
gutenprint-cups
gutenprint-libs
gvfs
gvfs-archive
gvfs-client
gvfs-mtp
gvnc
gzip
harfbuzz
harfbuzz-icu
hfsplus-tools
hicolor-icon-theme
hidapi
highcontrast-icon-theme
highway
hiredis
hostname
hplip
hplip-common
hplip-libs
hunspell
hunspell-en
hunspell-en-GB
hunspell-en-US
hunspell-filesystem
hwdata
hyperv-daemons
hyperv-daemons-license
hypervfcopyd
hypervkvpd
hypervvssd
hyphen
hyphen-en
ibus
ibus-anthy
ibus-anthy-python
ibus-chewing
ibus-gtk2
ibus-gtk3
ibus-gtk4
ibus-hangul
ibus-libpinyin
ibus-libs
ibus-m17n
ibus-panel
ibus-setup
ibus-table
ibus-table-chinese
ibus-table-chinese-cangjie
ibus-typing-booster
ibus-xinit
iceauth
ilbc
ima-evm-utils-libs
ImageMagick
ImageMagick-libs
imath
im-chooser
im-chooser-common
im-chooser-xfce
imsettings
imsettings-gsettings
imsettings-libs
inih
inih-cpp
iniparser
initscripts-service
inkscape
inkscape-libs
intel-audio-firmware
intel-gmmlib
intel-gpu-firmware
intel-media-driver
intel-mediasdk
intel-qpl
intel-vpl-gpu-rt
intel-vsc-firmware
iodine-client
ipcalc
ipp-usb
iproute
ipset
ipset-libs
iptables-libs
iptables-nft
iptstate
iputils
irqbalance
iscsi-initiator-utils
iscsi-initiator-utils-iscsiuio
isns-utils-libs
iso-codes
isomd5sum
iw
iwlegacy-firmware
iwlwifi-dvm-firmware
iwlwifi-mld-firmware
iwlwifi-mvm-firmware
jansson
jasper-libs
java-21-openjdk-headless
javapackages-filesystem
javascriptcoregtk4.1
jbig2dec-libs
jbigkit-libs
jomolhari-fonts
jose
jq
json-c
json-glib
jxl-pixbuf-loader
jxrlib
kasumi-common
kasumi-unicode
kbd
kbd-legacy
kbd-misc
kde-filesystem
kdump-anaconda-addon
kdump-utils
kernel
kernel
kernel-core
kernel-core
kernel-modules
kernel-modules
kernel-modules-core
kernel-modules-core
kernel-modules-extra
kernel-modules-extra
kexec-tools
keybinder3
keyutils
keyutils-libs
kf5-filesystem
kf6-filesystem
kf6-karchive
kf6-kimageformats
kmod
kmod-libs
kpartx
krb5-libs
kyotocabinet-libs
lame
lame-libs
langpacks-core-en
langpacks-en
langpacks-fonts-en
langtable
lcms2
ldns
leptonica
less
lib2geom
liba52
libabw
libacl
libadwaita
libaio
libao
libaom
libappindicator-gtk3
libappstream-glib
libarchive
libargon2
libaribcaption
libass
libassuan
libasyncns
libatasmart
libatomic
libattr
libavdevice
libavif
libb2
libbabeltrace
libbasicobjects
libblkid
libblockdev
libblockdev-btrfs
libblockdev-crypto
libblockdev-dm
libblockdev-fs
libblockdev-loop
libblockdev-lvm
libblockdev-lvm-dbus
libblockdev-mdraid
libblockdev-mpath
libblockdev-nvdimm
libblockdev-nvme
libblockdev-part
libblockdev-plugins-all
libblockdev-smart
libblockdev-smartmontools
libblockdev-swap
libblockdev-tools
libblockdev-utils
libbluray
libbpf
libbrotli
libbs2b
libburn
libbytesize
libcaca
libcacard
libcamera
libcamera-ipa
libcanberra
libcanberra-gtk2
libcanberra-gtk3
libcap
libcap-ng
libcap-ng-python3
libcbor
libcddb
libcdio
libcdio-paranoia
libcdr
libchewing
libchromaprint
libcloudproviders
libcmis
libcollection
libcom_err
libcomps
libcupsfilters
libcurl
libdaemon
libdatrie
libdav1d
libdbusmenu
libdbusmenu-gtk3
libde265
libdecor
libdeflate
libdhash
libdisplay-info
libdnf
libdnf5
libdnf5-cli
libdnf5-plugin-expired-pgp-keys
libdnf5-plugin-notify-PackageKit
libdovi
libdrm
libdvdnav
libdvdread
libe-book
libebur128
libeconf
libedit
libeot
libepoxy
libepubgen
liberation-mono-fonts
liberation-sans-fonts
liberation-serif-fonts
libertas-firmware
libestr
libetonyek
libev
libevdev
libevent
libexif
libexttextcat
libfastjson
libfdisk
libffi
libfido2
libfontenc
libfprint
libfreeaptx
libfreehand
libfsverity
libftdi
libfyaml
libgcc
libgcrypt
libgexiv2
libgfortran
libglvnd
libglvnd-egl
libglvnd-gles
libglvnd-glx
libglvnd-opengl
libgomp
libgpg-error
libgphoto2
libgs
libgsf
libgtop2
libgudev
libgusb
libgxps
libhandy
libhangul
libheif
libheif-freeworld
libibverbs
libical
libICE
libicu
libicu76
libidn2
libieee1284
libijs
libimagequant
libimobiledevice
libimobiledevice-glue
libini_config
libinput
libipt
libisoburn
libisofs
libjaylink
libjcat
libjose
libjpeg-turbo
libjxl
libkcapi
libkcapi-hasher
libkcapi-hmaccalc
libksba
liblangtag
liblangtag-data
liblastlog2
liblc3
libldac
libldb
liblerc
liblouis
liblouis-tables
liblouisutdml
liblouisutdml-utils
liblqr-1
libluksmeta
libmanette
libmaxminddb
libmbim
libmbim-utils
libmng
libmnl
libmodplug
libmodulemd
libmount
libmousepad0
libmpc
libmpeg2
libmspack
libmspub
libmtp
libmwaw
libmypaint
libmysofa
libndp
libnetfilter_conntrack
libnfnetlink
libnfsidmap
libnftnl
libnghttp2
libnice
libnl3
libnl3-cli
libnma
libnma-gtk4
libnotify
libnsl2
libnumbertext
libnvme
libodfgen
libogg
libopenjph
libopenmpt
libopusenc
liborcus
libpagemaker
libpaper
libpasswdqc
libpath_utils
libpcap
libpciaccess
libphodav
libpinyin
libpinyin-data
libpipeline
libpkgconf
libplacebo
libplist
libpng
libppd
libproxy
libpskc
libpsl
libpwquality
libqmi
libqmi-utils
libqrtr-glib
libquadmath
libqxp
libraqm
LibRaw
libref_array
libreoffice-calc
libreoffice-core
libreoffice-data
libreoffice-graphicfilter
libreoffice-gtk3
libreoffice-gtk4
libreoffice-help-en
libreoffice-impress
libreoffice-langpack-en
libreoffice-ogltrans
libreoffice-opensymbol-fonts
libreoffice-pdfimport
libreoffice-pyuno
libreoffice-ure
libreoffice-ure-common
libreoffice-writer
libreoffice-x11
librepo
libreport
libreport-anaconda
libreport-cli
libreport-filesystem
libreport-gtk
libreport-plugin-bugzilla
libreport-plugin-reportuploader
libreport-web
libreswan
libreswan-minimal
librevenge
librsvg2
librtmp
libsamplerate
libsane-airscan
libsane-hpaio
libsbc
libseccomp
libsecret
libselinux
libselinux-utils
libsemanage
libsepol
libshaderc
libshout
libsigc++20
libsigc++30
libSM
libsmartcols
libsmbclient
libsndfile
libsodium
libsolv
libsoup
libsoup3
libspectre
libsrtp
libss
libssh
libssh2
libssh-config
libsss_certmap
libsss_idmap
libsss_nss_idmap
libsss_sudo
libstaroffice
libstdc++
libstemmer
libtalloc
libtasn1
libtdb
libteam
libtevent
libtextstyle
libthai
libtheora
libtiff
libtinysparql
libtirpc
libtomcrypt
libtommath
libtool-ltdl
libtsan
libudfread
libudisks2
libunibreak
libunistring
libunwind
liburing
libusb1
libusbmuxd
libuser
libutempter
libuuid
libuv
libv4l
libva
libva-intel-driver
libva-intel-media-driver
libvdpau
libverto
libverto-libev
libvirt-client
libvirt-glib
libvirt-libs
libvisio
libvisual
libvmaf
libvncserver
libvorbis
libvpl
libvpx
libwacom
libwacom-data
libwayland-client
libwayland-cursor
libwayland-egl
libwayland-server
libwbclient
libwebp
libwinpr
libwmf
libwmf-lite
libwnck3
libwpd
libwpg
libwps
libwsman1
libX11
libX11-common
libX11-xcb
libXau
libXaw
libxcb
libXcomposite
libxcrypt
libXcursor
libxcvt
libXdamage
libXdmcp
libXext
libxfce4ui
libxfce4util
libxfce4windowing
libXfixes
libXfont2
libXft
libXi
libXinerama
libxkbcommon
libxkbcommon-x11
libxkbfile
libxklavier
libxml2
libxmlb
libXmu
libXpm
libXpresent
libXrandr
libXrender
libXres
libXScrnSaver
libxshmfence
libxslt
libXt
libXtst
libXv
libXvMC
libXxf86vm
libyaml
libyui
libyui-gtk
libyui-mga
libyui-mga-gtk
libyui-mga-ncurses
libyui-ncurses
libyuv
libzip
libzmf
libzstd
lightdm
lightdm-gobject
lightdm-gtk
lilv-libs
linux-atm-libs
linux-firmware
linux-firmware-whence
livesys-scripts
lksctp-tools
llvm-filesystem
llvm-libs
lmdb-libs
lm_sensors-libs
lockdev
logrotate
lorax
lorax-templates-generic
low-memory-monitor
lpcnetfreedv
lpsolve
lrzsz
lsof
lttng-ust
luajit
lua-lgi-compat
lua-libs
luksmeta
lvm2
lvm2-dbusd
lvm2-libs
lz4-libs
lzo
m17n-db
m17n-lib
mactel-boot
madan-fonts
mailcap
makedumpfile
malcontent-libs
man-db
man-pages
mariadb-connector-c
mariadb-connector-c-config
mate-desktop-libs
mathjax
mathjax-ams-fonts
mathjax-caligraphic-fonts
mathjax-fraktur-fonts
mathjax-main-fonts
mathjax-math-fonts
mathjax-sansserif-fonts
mathjax-script-fonts
mathjax-size1-fonts
mathjax-size2-fonts
mathjax-size3-fonts
mathjax-size4-fonts
mathjax-stixweb-fonts
mathjax-typewriter-fonts
mathjax-vector-fonts
mathjax-winchrome-fonts
mathjax-winie6-fonts
mc
mcelog
mdadm
mediawriter
memstrack
mesa-compat-libxatracker
mesa-dri-drivers
mesa-filesystem
mesa-libEGL
mesa-libgbm
mesa-libGL
mesa-libGLU
mesa-va-drivers
mesa-vulkan-drivers
microcode_ctl
minicom
minizip-ng-compat
mint-x-icons
mint-y-icons
mint-y-theme
mkfontscale
mkpasswd
mobile-broadband-provider-info
ModemManager
ModemManager-glib
mokutil
mousepad
mozilla-filesystem
mozilla-openh264
mozjs128
mozjs140
mpage
mpdecimal
mpfr
mpg123-libs
mpv
mt7xxx-firmware
mtdev
mtools
mtr
mujs
mypaint-brushes
mythes
mythes-en
nano
nano-default-editor
ncurses
ncurses-base
ncurses-libs
ndctl
ndctl-libs
net-snmp-libs
nettle
net-tools
NetworkManager
NetworkManager-adsl
network-manager-applet
NetworkManager-bluetooth
NetworkManager-fortisslvpn
NetworkManager-fortisslvpn-gnome
NetworkManager-iodine
NetworkManager-iodine-gnome
NetworkManager-l2tp
NetworkManager-l2tp-gnome
NetworkManager-libnm
NetworkManager-libreswan
NetworkManager-libreswan-gnome
NetworkManager-openconnect
NetworkManager-openconnect-gnome
NetworkManager-openvpn
NetworkManager-openvpn-gnome
NetworkManager-ppp
NetworkManager-pptp
NetworkManager-pptp-gnome
NetworkManager-ssh
NetworkManager-ssh-gnome
NetworkManager-ssh-selinux
NetworkManager-sstp
NetworkManager-sstp-gnome
NetworkManager-strongswan
NetworkManager-strongswan-gnome
NetworkManager-team
NetworkManager-vpnc
NetworkManager-vpnc-gnome
NetworkManager-wifi
NetworkManager-wwan
newt
nfs-utils
nftables
nftables-services
ngtcp2
nilfs-utils
nmap-ncat
nm-connection-editor
npth
nspr
nss
nss-mdns
nss-softokn
nss-softokn-freebl
nss-sysinit
nss-tools
nss-util
ntfs-3g
ntfs-3g-libs
ntfs-3g-system-compression
ntfsprogs
numactl-libs
nvidia-gpu-firmware
nvme-cli
nxpwireless-firmware
oniguruma
openal-soft
openblas
openblas-openmp
OpenCL-ICD-Loader
openconnect
opencore-amr
openexr-libs
openfortivpn
openh264
openjpeg
openldap
openpace
openpgm
open-sans-fonts
opensc
opensc-libs
openssh
openssh-askpass
openssh-clients
openssh-server
openssl
openssl-libs
open-vm-tools
open-vm-tools-desktop
openvpn
opus
opusfile
opus-tools
orc
orca
os-prober
ostree-libs
p11-kit
p11-kit-server
p11-kit-trust
PackageKit
PackageKit-glib
PackageKit-gstreamer-plugin
paktype-naskh-basic-fonts
pam
pam-libs
pam_passwdqc
pango
pangomm
pangomm2.48
paps
parted
passim
passim-libs
passwdqc
passwdqc-utils
pavucontrol
pbzip2
pcaudiolib
pciutils
pciutils-libs
pcre2
pcre2-syntax
pcre2-utf16
pcre2-utf32
pcsc-lite
pcsc-lite-ccid
pcsc-lite-libs
perl-AutoLoader
perl-B
perl-base
perl-Carp
perl-Class-Struct
perl-constant
perl-Data-Dumper
perl-Digest
perl-Digest-MD5
perl-DynaLoader
perl-Encode
perl-Errno
perl-Exporter
perl-Fcntl
perl-File-Basename
perl-FileHandle
perl-File-Path
perl-File-stat
perl-File-Temp
perl-Getopt-Long
perl-Getopt-Std
perl-HTTP-Tiny
perl-if
perl-interpreter
perl-IO
perl-IO-Socket-IP
perl-IO-Socket-SSL
perl-IPC-Open3
perl-libnet
perl-libs
perl-locale
perl-MIME-Base32
perl-MIME-Base64
perl-mro
perl-NDBM_File
perl-Net-SSLeay
perl-overload
perl-overloading
perl-parent
perl-PathTools
perl-Pod-Escapes
perl-podlators
perl-Pod-Perldoc
perl-Pod-Simple
perl-Pod-Usage
perl-POSIX
perl-Scalar-List-Utils
perl-SelectSaver
perl-Socket
perl-Storable
perl-Symbol
perl-Term-ANSIColor
perl-Term-Cap
perl-Text-ParseWords
perl-Text-Tabs+Wrap
perl-Time-Local
perl-URI
perl-vars
pigz
pinentry
pinentry-gnome3
pinfo
pipewire
pipewire-alsa
pipewire-codec-aptx
pipewire-config-raop
pipewire-gstreamer
pipewire-jack-audio-connection-kit
pipewire-jack-audio-connection-kit-libs
pipewire-libs
pipewire-plugin-libcamera
pipewire-pulseaudio
pipewire-utils
pixman
pkcs11-helper
pkcs11-provider
pkgconf
pkgconf-m4
pkgconf-pkg-config
plocate
plymouth
plymouth-core-libs
plymouth-graphics-libs
plymouth-plugin-label
plymouth-plugin-two-step
plymouth-scripts
plymouth-system-theme
plymouth-theme-spinner
policycoreutils
policycoreutils-python-utils
polkit
polkit-libs
polkit-pkla-compat
poppler
poppler-cpp
poppler-data
poppler-glib
poppler-utils
popt
portaudio
potrace
ppp
pptp
prefixdevname
procps-ng
protobuf-c
psacct
psmisc
publicsuffix-list-dafsa
pulseaudio-libs
pulseaudio-libs-glib2
pulseaudio-utils
python3
python3-anyio
python3-appdirs
python3-audit
python3-beaker
python3-blivet
python3-blockdev
python3-boto3
python3-botocore
python3-brlapi
python3-brotli
python3-bytesize
python3-cairo
python3-cairocffi
python3-cairosvg
python3-certifi
python3-cffi
python3-charset-normalizer
python3-crypto
python3-cryptography
python3-crypt-r
python3-cssselect
python3-cssselect2
python3-cups
python3-dasbus
python3-dateutil
python3-dbus
python3-dbus-next
python3-defusedxml
python3-distro
python3-dnf
python3-dnf-plugins-core
python3-enchant
python3-file-magic
python3-firewall
python3-gettext
python3-gobject
python3-gobject-base
python3-h11
python3-hawkey
python3-httpcore
python3-httpx
python3-idna
python3-inkex
python3-iso639
python3-jmespath
python3-kickstart
python3-langtable
python3-libcomps
python3-libdnf
python3-libdnf5
python3-libmount
python3-librepo
python3-libreport
python3-libs
python3-libselinux
python3-libsemanage
python3-libxml2
python3-llfuse
python3-louis
python3-lxml
python3-mako
python3-manatools
python3-markupsafe
python3-meh
python3-meh-gui
python3-msgpack
python3-mutagen
python3-newt
python3-nftables
python3-numpy
python3-numpy-f2py
python3-olefile
python3-packaging
python3-paste
python3-pexpect
python3-pid
python3-pillow
python3-ply
python3-policycoreutils
python3-productmd
python3-psutil
python3-ptyprocess
python3-pwquality
python3-pyatspi
python3-pyaudio
python3-pycdio
python3-pycparser
python3-pycryptodomex
python3-pyOpenSSL
python3-pyparsing
python3-pyparted
python3-pyserial
python3-pysocks
python3-pystray
python3-pyudev
python3-pyxdg
python3-pyyaml
python3-rapidfuzz
python3-regex
python3-requests
python3-requests-file
python3-requests-ftp
python3-rpm
python3-s3transfer
python3-satyr
python3-scour
python3-setools
python3-setuptools
python3-simpleaudio
python3-simpleline
python3-six
python3-sniffio
python3-speechd
python3-systemd
python3-tinycss2
python3-unbound
python3-urllib3
python3-urllib3+socks
python3-webencodings
python3-websockets
python3-xkbregistry
python3-xlib
python3-yui
python-pip-wheel
python-unversioned-command
qcom-wwan-firmware
qemu-guest-agent
qpdf-libs
qrencode-libs
qt6-filesystem
qt6-qtbase
qt6-qtbase-common
qt6-qtbase-gui
qt6-qtdeclarative
qt6-qtpdf
qt6-qtpositioning
qt6-qtserialport
qt6-qtsvg
qt6-qttranslations
qt6-qtwayland
qt6-qtwebchannel
qt6-qtwebengine
qt6-qtwebview
quota
quota-nls
raptor2
rasqal
rav1e-libs
re2
readline
realmd
realtek-firmware
redhat-menus
redland
remmina
remmina-plugins-exec
remmina-plugins-rdp
remmina-plugins-secret
remmina-plugins-spice
remmina-plugins-vnc
ristretto
rit-meera-new-fonts
rit-rachana-fonts
rootfiles
rpcbind
rpm
rpm-build-libs
rpmfusion-free-appstream-data
rpmfusion-free-release
rpmfusion-nonfree-appstream-data
rpmfusion-nonfree-release
rpm-libs
rpm-plugin-audit
rpm-plugin-selinux
rpm-plugin-systemd-inhibit
rpm-sequoia
rpm-sign-libs
rsync
rsyslog
rtkit
rubberband-libs
samba-client
samba-client-libs
samba-common
samba-common-libs
sane-airscan
sane-backends
sane-backends-drivers-cameras
sane-backends-drivers-scanners
sane-backends-libs
satyr
sdbus-cpp
sdl12-compat
sdl2-compat
SDL3
seahorse
sed
selinux-policy
selinux-policy-targeted
serd
setroubleshoot
setroubleshoot-plugins
setroubleshoot-server
setup
setxkbmap
shadow-utils
shared-mime-info
shim-ia32
shim-x64
sil-padauk-fonts
simdutf
slang
slitherer
smartmontools
smartmontools-selinux
snappy
sord
sos
sound-theme-freedesktop
soundtouch
source-highlight
soxr
speech-dispatcher
speech-dispatcher-espeak-ng
speech-dispatcher-libs
speech-dispatcher-utils
speex
spice-glib
spice-gtk3
spice-vdagent
spice-webdavd
spirv-tools-libs
sqlite-libs
squashfs-tools
sratom
srt-libs
sscg
sshpass
sssd-client
sssd-common
sssd-kcm
sssd-krb5-common
sssd-nfs-idmap
sssd-proxy
sstp-client
startup-notification
stix-fonts
stoken-libs
strongswan
strongswan-charon-nm
sudo
sudo-python-plugin
suitesparse
svt-av1-libs
svt-hevc-libs
symlinks
system-config-language
system-config-printer
system-config-printer-libs
system-config-printer-udev
systemd
systemd-libs
systemd-networkd
systemd-oomd-defaults
systemd-pam
systemd-resolved
systemd-shared
systemd-sysusers
systemd-udev
taglib
tar
tcl
tcpdump
teamd
tecla
tesseract-common
tesseract-langpack-eng
tesseract-libs
tesseract-tessdata-doc
texlive-lib
Thunar
thunar-archive-plugin
thunar-media-tags-plugin
thunar-volman
time
tinysparql
tiwilink-firmware
tmux
tpm2-tools
tpm2-tss
tpm2-tss-fapi
traceroute
tree
tslib
tumbler
twolame-libs
tzdata
tzdata-java
uchardet
udftools
udisks2
udisks2-btrfs
udisks2-iscsi
udisks2-lvm2
unbound-anchor
unbound-libs
unicode-ucd
unzip
upower
upower-libs
uriparser
urw-base35-bookman-fonts
urw-base35-c059-fonts
urw-base35-d050000l-fonts
urw-base35-fonts
urw-base35-fonts-common
urw-base35-fonts-legacy
urw-base35-gothic-fonts
urw-base35-nimbus-mono-ps-fonts
urw-base35-nimbus-roman-fonts
urw-base35-nimbus-sans-fonts
urw-base35-p052-fonts
urw-base35-standard-symbols-ps-fonts
urw-base35-z003-fonts
usb_modeswitch
usb_modeswitch-data
usbmuxd
usbredir
usbutils
usermode
userspace-rcu
util-linux
util-linux-core
vapoursynth-libs
vazirmatn-vf-fonts
vid.stab
vim-common
vim-data
vim-enhanced
vim-filesystem
vim-minimal
virtualbox-guest-additions
virt-viewer
vmaf-models
vo-amrwbenc
volume_key-libs
vorbis-tools
vpnc
vpnc-script
vte291
vte-profile
vulkan-loader
vvenc-libs
wavpack
web-assets-filesystem
webkit2gtk4.1
webrtc-audio-processing
wget2
wget2-libs
wget2-wget
which
whois
whois-nls
wireless-regdb
wireplumber
wireplumber-libs
wl-clipboard
woff2
words
wpa_supplicant
wsdd
x264-libs
x265-libs
xarchiver
xcb-util
xcb-util-cursor
xcb-util-image
xcb-util-keysyms
xcb-util-renderutil
xcb-util-wm
xdg-dbus-proxy
xdg-desktop-portal
xdg-desktop-portal-gtk
xdg-user-dirs
xdg-user-dirs-gtk
xdg-utils
xdriinfo
xfburn
xfce4-about
xfce4-appfinder
xfce4-battery-plugin
xfce4-clipman-plugin
xfce4-cpugraph-plugin
xfce4-datetime-plugin
xfce4-dict
xfce4-dict-plugin
xfce4-diskperf-plugin
xfce4-fsguard-plugin
xfce4-genmon-plugin
xfce4-mailwatch-plugin
xfce4-mount-plugin
xfce4-netload-plugin
xfce4-notifyd
xfce4-panel
xfce4-panel-profiles
xfce4-places-plugin
xfce4-power-manager
xfce4-pulseaudio-plugin
xfce4-screensaver
xfce4-screenshooter
xfce4-screenshooter-plugin
xfce4-session
xfce4-settings
xfce4-systemload-plugin
xfce4-taskmanager
xfce4-terminal
xfce4-time-out-plugin
xfce4-verve-plugin
xfce4-weather-plugin
xfce4-whiskermenu-plugin
xfce4-xkb-plugin
xfce-polkit
xfconf
xfdashboard
xfdashboard-themes
xfdesktop
xfsprogs
xfwm4
xfwm4-themes
xhost
xkbcomp
xkeyboard-config
xl2tpd
xml-common
xmlrpc-c
xmlrpc-c-client
xmlsec1
xmlsec1-nss
xmlsec1-openssl
xmodmap
xorg-x11-drv-amdgpu
xorg-x11-drv-ati
xorg-x11-drv-evdev
xorg-x11-drv-intel
xorg-x11-drv-libinput
xorg-x11-drv-nouveau
xorg-x11-drv-openchrome
xorg-x11-drv-qxl
xorg-x11-drv-vmware
xorg-x11-drv-wacom
xorg-x11-drv-wacom-serial-support
xorg-x11-fonts-misc
xorg-x11-server-common
xorg-x11-server-Xorg
xorg-x11-xauth
xorg-x11-xinit
xorriso
xprop
xrdb
xset
xterm
xvidcore
xxd
xxhash-libs
xz
xz-libs
xz-lzma-compat
yajl
yt-dlp
yt-dlp-bash-completion
yt-dlp+default
zchunk-libs
zenity
zeromq
zimg
zip
zix
zlib-ng-compat
zram-generator
zram-generator-defaults
zstd
zvbi
zxcvbn-c
zxing-cpp

%end
