/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.CaptureContentPane;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import movieMaker.FrameSequencer;
import movieMaker.Picture;

public class StartMovieCapture
implements Runnable {
    private FrameSequencer frameSequencer = null;
    private int framesPerSecond = 16;
    private Rectangle region = null;
    private Thread active = null;
    private Rectangle reg = null;
    private CaptureContentPane renderContent = null;
    private AuthoringTool author = null;

    public StartMovieCapture(AuthoringTool a, CaptureContentPane pane, FrameSequencer sequencer, int framesPerSec) {
        this.frameSequencer = sequencer;
        this.framesPerSecond = framesPerSec;
        this.author = a;
        this.renderContent = pane;
    }

    public void upDateRectangle() {
        this.reg = new Rectangle(1, 1, 1, 1);
        if (this.renderContent.getRenderPanel() != null) {
            this.reg.setSize(this.renderContent.getRenderPanel().getSize());
        }
        Rectangle r = new Rectangle(1, 1, 1, 1);
        r = this.renderContent.getRenderPanelLocation();
        this.reg.y = r.y + 3;
        int buttonPanelWidth = this.renderContent.getButtonPanel().getWidth();
        this.reg.x = r.x + (buttonPanelWidth - this.reg.width) / 2;
        this.reg.height -= 2;
    }

    public void captureMovie() {
        long startTime = 0L;
        long endTime = 0L;
        int timeToSleep = 1000 / this.framesPerSecond;
        Thread current = Thread.currentThread();
        this.upDateRectangle();
        while (current == this.active && this.renderContent.getEnd()) {
            if (!this.author.getWorld().isRunning() || !this.renderContent.getRunning()) continue;
            startTime = System.currentTimeMillis();
            try {
                this.upDateRectangle();
                BufferedImage bi = new Robot().createScreenCapture(this.reg);
                this.author.getSoundStorage().frameList.add(new Long(startTime));
                this.frameSequencer.addFrame(new Picture(bi));
                endTime = System.currentTimeMillis();
                if (endTime - startTime >= (long)timeToSleep) continue;
                Thread.sleep((long)timeToSleep - (endTime - startTime));
            }
            catch (Exception ex) {
                System.err.println(Messages.getString("Caught_exception_in_StartMovieCapture"));
            }
        }
    }

    @Override
    public void run() {
        this.active = Thread.currentThread();
        this.captureMovie();
    }

    public void stop() {
        this.active = null;
    }
}

