/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.media.jmfmedia.DataSource;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.MediaLocator;
import movieMaker.Concat;
import movieMaker.Cut;
import movieMaker.Merge;
import movieMaker.SimpleSound;
import movieMaker.SoundException;

public class SoundStorage {
    private ArrayList soundList = new ArrayList();
    public ArrayList frameList = new ArrayList();
    private boolean listening = false;
    private double totalLength = 0.0;
    private Vector startCaptureTimes = new Vector();
    private Vector stopCaptureTimes = new Vector();
    Object stateLock = new Object();
    boolean stateFailed = false;

    public void add(Long start, Double len, DataSource ds, Object to, Object from, Object rate, Object volume) {
        this.soundList.add(new SoundData(start, len, ds, to, from, rate, volume));
    }

    public ArrayList getList() {
        return this.soundList;
    }

    public void setListening(boolean isListening, double time) {
        this.listening = isListening;
        if (this.listening) {
            this.startCaptureTimes.add(new Double(time));
        } else {
            this.stopCaptureTimes.add(new Double(time));
            this.totalLength += time - (Double)this.startCaptureTimes.get(this.startCaptureTimes.size() - 1);
        }
    }

    public void convertTimes() {
        long startNum = (Long)this.frameList.get(0);
        int x = 0;
        while (x < this.frameList.size()) {
            this.frameList.set(x, new Long((Long)this.frameList.get(x) - startNum));
            ++x;
        }
        x = 0;
        while (x < this.soundList.size()) {
            ((SoundData)this.soundList.get((int)x)).worldTime -= (double)startNum;
            ++x;
        }
        x = 0;
        while (x < this.soundList.size()) {
            int index = 0;
            while (index < this.frameList.size() && (double)((Long)this.frameList.get(index)).longValue() < ((SoundData)this.soundList.get((int)x)).worldTime) {
                ++index;
            }
            if (index != this.frameList.size()) {
                long time2 = (Long)this.frameList.get(index);
                long time1 = (Long)this.frameList.get(index == 0 ? 0 : index - 1);
                if (time1 == time2) {
                    ((SoundData)this.soundList.get((int)x)).worldTime /= 1000.0;
                } else {
                    double percentage = (((SoundData)this.soundList.get((int)x)).worldTime - (double)time1) / (double)(time2 - time1);
                    ((SoundData)this.soundList.get((int)x)).worldTime = ((double)(index - 1) + percentage) / 16.0;
                }
            }
            ++x;
        }
    }

    public void convertCaptureTimes() {
        double start = (Double)this.startCaptureTimes.get(0);
        int x = 0;
        while (x < this.startCaptureTimes.size()) {
            this.startCaptureTimes.set(x, new Double((Double)this.startCaptureTimes.get(x) - start));
            this.stopCaptureTimes.set(x, new Double((Double)this.stopCaptureTimes.get(x) - start));
            ++x;
        }
    }

    public void convertNumbers(double length) {
        int x = 0;
        while (x < this.soundList.size()) {
            SoundData sd = (SoundData)this.soundList.get(x);
            sd.worldTime *= length / this.totalLength;
            sd.duration *= length / this.totalLength;
            sd.clippedDuration *= length / this.totalLength;
            ++x;
        }
        x = 0;
        while (x < this.startCaptureTimes.size()) {
            double d = (Double)this.startCaptureTimes.get(x);
            this.startCaptureTimes.set(x, new Double(d * length / this.totalLength));
            d = (Double)this.stopCaptureTimes.get(x);
            this.stopCaptureTimes.set(x, new Double(d * length / this.totalLength));
            ++x;
        }
    }

    public Vector encodeFiles(double length, String exportDirectory) {
        Vector<String> newDS = new Vector<String>();
        String orig_file = "";
        String final_sound = "";
        String sound_slice = "";
        String sound_cut = "";
        String track_file = "";
        String silence = String.valueOf(exportDirectory) + "silence.wav";
        int currentChunk = 0;
        int currentLength = 0;
        this.convertTimes();
        this.convertCaptureTimes();
        int y = 0;
        while (y < this.soundList.size()) {
            double blankLength = 0.0;
            SoundData sd = (SoundData)this.soundList.get(y);
            if (sd.duration < sd.clippedDuration || sd.clippedDuration == 0.0) {
                sd.clippedDuration = sd.duration;
            }
            sd.stopTime = sd.duration;
            while (sd.worldTime > (Double)this.stopCaptureTimes.get(currentChunk)) {
                currentLength = (int)((double)currentLength + (Double)this.stopCaptureTimes.get(currentChunk));
                if (++currentChunk >= this.stopCaptureTimes.size()) break;
            }
            if (currentChunk >= this.stopCaptureTimes.size()) break;
            if (!((Double)this.startCaptureTimes.get(currentChunk) > sd.worldTime + sd.clippedDuration)) {
                blankLength = sd.worldTime > (Double)this.startCaptureTimes.get(currentChunk) ? sd.worldTime - (Double)this.startCaptureTimes.get(currentChunk) + (double)currentLength : (double)currentLength;
                orig_file = String.valueOf(exportDirectory) + "sound" + y + "." + sd.data.getExtension();
                sound_slice = String.valueOf(exportDirectory) + "sound" + y + ".wav";
                sound_cut = String.valueOf(exportDirectory) + "soundCut" + y + ".wav";
                track_file = String.valueOf(exportDirectory) + "track" + y + ".wav";
                this.writeToFile(sd.data.getJMFDataSource(), this.createURL(orig_file));
                if (sd.data.getExtension().equals("MP3")) {
                    SimpleSound.convert(orig_file, sound_slice);
                }
                double beginning = 0.0;
                double ending = 0.0;
                beginning = this.cropBeginning(sd, length, currentChunk);
                ending = this.cropEnding(sd, length, currentChunk);
                if (beginning != 0.0 || ending != 0.0) {
                    sound_slice = this.tryToCut(length, sd, sound_slice, sound_cut, beginning, ending, blankLength);
                }
                try {
                    SimpleSound s = new SimpleSound();
                    s.loadFromFile(sound_slice);
                    SimpleSound blank = new SimpleSound(blankLength, s);
                    blank.writeToFile(silence);
                }
                catch (SoundException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_encoding_sound_file__"), e);
                    return null;
                }
                if (blankLength > 0.0) {
                    Vector<String> v = new Vector<String>();
                    v.add(this.createURL(silence));
                    v.add(this.createURL(sound_slice));
                    final_sound = this.createURL(track_file);
                    if (!this.concat(v, final_sound)) {
                        return null;
                    }
                } else {
                    final_sound = this.createURL(sound_slice);
                }
                newDS.add(final_sound);
            }
            ++y;
        }
        return newDS;
    }

    public double cropBeginning(SoundData sd, double length, int current) {
        if ((Double)this.startCaptureTimes.get(current) < sd.worldTime) {
            return 0.0;
        }
        if ((Double)this.startCaptureTimes.get(current) > sd.worldTime) {
            return (Double)this.startCaptureTimes.get(current) - sd.worldTime;
        }
        return 0.0;
    }

    public double cropEnding(SoundData sd, double length, int current) {
        if ((Double)this.stopCaptureTimes.get(current) < sd.duration + sd.worldTime) {
            return sd.worldTime + sd.duration - (Double)this.stopCaptureTimes.get(current);
        }
        if ((Double)this.stopCaptureTimes.get(current) > sd.duration + sd.worldTime) {
            return 0.0;
        }
        return 0.0;
    }

    public String tryToCut(double length, SoundData sd, String file3, String file4, double cropFromBeginning, double cropFromEnding, double blankLength) {
        Vector<Long> start = new Vector<Long>();
        Vector<Long> stop = new Vector<Long>();
        if (cropFromBeginning != 0.0 || cropFromEnding != 0.0 || sd.clippedDuration + sd.worldTime > length) {
            if (sd.duration - sd.clippedDuration > cropFromEnding) {
                cropFromEnding = sd.duration - sd.clippedDuration;
            }
            sd.startTime += cropFromBeginning;
            sd.stopTime -= cropFromEnding;
            if (blankLength + (sd.stopTime - sd.startTime) > length) {
                sd.stopTime = length - blankLength + sd.startTime - 0.02;
            }
            if (sd.stopTime < sd.startTime) {
                return file3;
            }
            start.add(new Long((int)(sd.startTime * 1000.0)));
            stop.add(new Long((int)(sd.stopTime * 1000.0)));
            Cut cut = new Cut();
            if ((double)((Long)start.get(0)).longValue() != 0.0 || (double)((Long)stop.get(0)).longValue() != sd.clippedDuration) {
                cut.doCut(this.createURL(file3), this.createURL(file4), start, stop);
            }
            cut = null;
            return file4;
        }
        return file3;
    }

    public String createURL(String s) {
        String url;
        try {
            url = new File(s).toURL().toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "";
        }
        String mod = url.replaceFirst("file:/", "file:///");
        return mod;
    }

    public void writeToFile(javax.media.protocol.DataSource ds, String fileName) {
        Merge m = new Merge(fileName);
        if (m != null) {
            m.doSingle(ds);
        }
        m = null;
    }

    public boolean concat(Vector inputURL, String outputURL) {
        MediaLocator[] iml = new MediaLocator[2];
        int i = 0;
        i = 0;
        while (i < inputURL.size()) {
            iml[i] = Concat.createMediaLocator((String)inputURL.elementAt(i));
            if (iml[i] == null) {
                return false;
            }
            ++i;
        }
        MediaLocator oml = Concat.createMediaLocator(outputURL);
        if (oml == null) {
            return false;
        }
        Concat concat = new Concat();
        return concat.doIt(iml, oml);
    }

    class SoundData {
        double startTime = 0.0;
        double worldTime = 0.0;
        double duration = 0.0;
        double volume = 1.0;
        double clippedDuration = 11000.0;
        double stopTime = 0.0;
        DataSource data = null;

        public SoundData(Long start, Double len, DataSource ds, Object to, Object from, Object rate, Object vol) {
            this.worldTime = start.longValue();
            this.duration = len;
            this.data = ds;
            if (rate != null) {
                this.clippedDuration = (Double)rate;
            }
            if (to != null) {
                this.startTime = (Double)to;
            }
            if (from != null) {
                this.stopTime = (Double)from;
            }
            if (vol != null) {
                this.volume = (Double)vol;
            }
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                SoundStorage.this.stateFailed = true;
            }
            if (ce instanceof ControllerEvent) {
                Object object = SoundStorage.this.stateLock;
                synchronized (object) {
                    SoundStorage.this.stateLock.notifyAll();
                }
            }
        }
    }
}

