/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import movieMaker.Playback;
import movieMaker.SimpleSound;

public class SoundExplorer
implements MouseMotionListener,
ActionListener,
MouseListener,
LineListener {
    private static final String zoomInHint = Messages.getString("Click_to_see_all_the_samples__the_number_of_samples_between_pixels_is_1_");
    private boolean DEBUG = false;
    private JFrame soundFrame;
    private JPanel playPanel;
    private JScrollPane scrollSound;
    private JPanel soundPanel;
    private SimpleSound sound;
    private boolean inStereo;
    private JLabel startIndexLabel;
    private JLabel stopIndexLabel;
    private JPanel buttonPanel;
    private JButton playEntireButton;
    private JButton playSelectionButton;
    private JButton playBeforeButton;
    private JButton playAfterButton;
    private JButton clearSelectionButton;
    private JButton stopButton;
    private boolean selectionPrevState;
    private JPanel leftSoundPanel;
    private JPanel rightSoundPanel;
    private JPanel leftSampleWrapper;
    private JPanel rightSampleWrapper;
    private SamplingPanel leftSamplePanel;
    private SamplingPanel rightSamplePanel;
    private JPanel infoPanel;
    private JLabel indexLabel;
    private JTextField numSamplesPerPixelField;
    private JTextField indexValue;
    private JLabel leftSampleLabel;
    private JTextField leftSampleValue;
    private JLabel rightSampleLabel;
    private JTextField rightSampleValue;
    private JPanel zoomButtonPanel;
    private JButton zoomButton;
    private JButton prevButton;
    private JButton nextButton;
    private JButton lastButton;
    private JButton firstButton;
    private int zoomOutWidth;
    private int zoomInWidth;
    private int sampleWidth;
    private int sampleHeight;
    private int soundPanelHeight;
    private float framesPerPixel;
    private int currentPixelPosition;
    private int base = 0;
    private int mousePressed;
    private int mouseReleased;
    private int mousePressedX;
    private int mouseReleasedX;
    private boolean mouseDragged;
    private int startFrame;
    private int stopFrame;
    private int selectionStart;
    private int selectionStop;
    private static final String currentIndexText = Messages.getString("Current_Index__");
    private static final String startIndexText = Messages.getString("Start_Index__");
    private static final String stopIndexText = Messages.getString("Stop_Index__");
    private static final Color selectionColor = Color.gray;
    private static final Color backgroundColor = Color.black;
    private static final Color waveColor = Color.white;
    private static final Color barColor = Color.cyan;
    private static String leftSampleText = Messages.getString("Sample_Value__");
    private static String rightSampleText = Messages.getString("Right__Bottom__Sample_Value__");

    public SoundExplorer(SimpleSound sound, boolean inStereo) {
        this.sound = sound;
        this.inStereo = inStereo;
        if (inStereo) {
            leftSampleText = Messages.getString("Left__Top__Sample_Value__");
        }
        sound.setSoundExplorer(this);
        this.mouseDragged = false;
        this.selectionStart = -1;
        this.selectionStop = -1;
        this.zoomOutWidth = 640;
        this.zoomInWidth = sound.getLengthInFrames();
        this.sampleWidth = this.zoomOutWidth;
        this.framesPerPixel = sound.getLengthInFrames() / this.sampleWidth;
        this.sampleHeight = 201;
        this.currentPixelPosition = 0;
        this.createWindow();
    }

    private void catchException(Exception ex) {
        System.err.println(ex.getMessage());
    }

    public void setTitle(String s) {
        this.soundFrame.setTitle(s);
    }

    private void createWindow() {
        String fileName = this.sound.getFileName();
        if (fileName == null) {
            fileName = Messages.getString("no_file_name");
        }
        this.soundFrame = new JFrame(fileName);
        Container frameContainer = this.soundFrame.getContentPane();
        frameContainer.setLayout(new BorderLayout());
        this.soundFrame.setDefaultCloseOperation(2);
        this.createPlayPanel();
        frameContainer.add((Component)this.playPanel, "North");
        this.createSoundPanel();
        this.scrollSound = new JScrollPane();
        this.scrollSound.setViewportView(this.soundPanel);
        frameContainer.add((Component)this.scrollSound, "Center");
        this.createInfoPanel();
        frameContainer.add((Component)this.infoPanel, "South");
        this.soundFrame.pack();
        this.soundFrame.setResizable(false);
        this.soundFrame.setVisible(true);
    }

    private JButton makeButton(String name, boolean enabled, JPanel panel) {
        JButton j = new JButton(name);
        j.addActionListener(this);
        j.setEnabled(enabled);
        panel.add(j);
        return j;
    }

    private void clearSelection() {
        this.selectionStart = -1;
        this.selectionStop = -1;
        this.startIndexLabel.setText(String.valueOf(startIndexText) + "N/A");
        this.stopIndexLabel.setText(String.valueOf(stopIndexText) + "N/A");
        this.soundFrame.getContentPane().repaint();
        this.playSelectionButton.setEnabled(false);
        this.clearSelectionButton.setEnabled(false);
    }

    private void createPlayPanel() {
        this.playPanel = new JPanel();
        this.playPanel.setLayout(new BorderLayout());
        JPanel selectionPanel = new JPanel();
        this.startIndexLabel = new JLabel(String.valueOf(startIndexText) + "N/A");
        this.stopIndexLabel = new JLabel(String.valueOf(stopIndexText) + "N/A");
        this.playSelectionButton = this.makeButton(Messages.getString("Play_Selection"), false, selectionPanel);
        this.clearSelectionButton = this.makeButton(Messages.getString("Clear_Selection"), false, selectionPanel);
        this.clearSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundExplorer.this.clearSelection();
            }
        });
        selectionPanel.add(this.startIndexLabel);
        selectionPanel.add(this.stopIndexLabel);
        this.buttonPanel = new JPanel();
        this.playEntireButton = this.makeButton(Messages.getString("Play_Entire_Sound"), true, this.buttonPanel);
        this.selectionPrevState = false;
        this.playBeforeButton = this.makeButton(Messages.getString("Play_Before"), false, this.buttonPanel);
        this.playAfterButton = this.makeButton(Messages.getString("Play_After"), true, this.buttonPanel);
        this.stopButton = this.makeButton(Messages.getString("Stop"), false, this.buttonPanel);
        this.playBeforeButton.setToolTipText(Messages.getString("Play_sound_up_to_the_current_index"));
        this.playAfterButton.setToolTipText(Messages.getString("Play_sound_starting_at_the_current_index"));
        this.playEntireButton.setToolTipText(Messages.getString("Play_the_entire_sound"));
        this.playSelectionButton.setToolTipText(Messages.getString("Play_sound_between_start_and_stop_index"));
        this.stopButton.setToolTipText(Messages.getString("Stop_playing_the_sound"));
        this.clearSelectionButton.setToolTipText(Messages.getString("Click_to_clear__remove__the_selection"));
        this.playPanel.add((Component)this.buttonPanel, "North");
        this.playPanel.add((Component)selectionPanel, "South");
    }

    private void createSoundPanel() {
        this.soundPanel = new JPanel();
        if (this.inStereo) {
            this.soundPanel.setLayout(new GridLayout(2, 1));
        } else {
            this.soundPanel.setLayout(new GridLayout(1, 1));
        }
        this.leftSoundPanel = new JPanel();
        this.leftSoundPanel.setLayout(new BorderLayout());
        this.leftSoundPanel.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
        this.leftSampleWrapper = new JPanel();
        this.leftSamplePanel = new SamplingPanel(true);
        this.leftSamplePanel.addMouseMotionListener(this);
        this.leftSamplePanel.addMouseListener(this);
        this.leftSampleWrapper.add(this.leftSamplePanel);
        this.leftSampleWrapper.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
        this.leftSoundPanel.add((Component)this.leftSampleWrapper, "North");
        this.soundPanel.add(this.leftSoundPanel);
        this.soundPanelHeight = this.sampleHeight;
        if (this.inStereo) {
            this.rightSoundPanel = new JPanel();
            this.rightSoundPanel.setLayout(new BorderLayout());
            this.rightSoundPanel.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
            this.rightSampleWrapper = new JPanel();
            this.rightSamplePanel = new SamplingPanel(false);
            this.rightSamplePanel.addMouseMotionListener(this);
            this.rightSamplePanel.addMouseListener(this);
            this.rightSampleWrapper.add(this.rightSamplePanel);
            this.rightSampleWrapper.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
            this.rightSoundPanel.add((Component)this.rightSampleWrapper, "North");
            this.soundPanel.add(this.rightSoundPanel);
            this.soundPanelHeight = 2 * this.sampleHeight;
        }
        this.soundPanel.setPreferredSize(new Dimension(this.zoomOutWidth, this.soundPanelHeight));
        this.soundPanel.setSize(this.soundPanel.getPreferredSize());
    }

    private void updateIndexValues() {
        int curFrame = (int)((float)this.currentPixelPosition * this.framesPerPixel);
        this.indexValue.setText(Integer.toString(curFrame + this.base));
        if (this.numSamplesPerPixelField != null) {
            this.numSamplesPerPixelField.setText(Integer.toString((int)this.framesPerPixel));
        }
        try {
            this.leftSampleValue.setText(Integer.toString(this.sound.getLeftSample(curFrame)));
            if (this.inStereo) {
                this.rightSampleValue.setText(Integer.toString(this.sound.getRightSample(curFrame)));
            }
        }
        catch (Exception ex) {
            this.catchException(ex);
        }
    }

    private void setUpIndexPanel(JPanel indexPanel) {
        JPanel topPanel = new JPanel();
        Box vertBox = Box.createVerticalBox();
        ImageIcon prevIcon = new ImageIcon(SoundExplorer.class.getResource("leftArrow.gif"), Messages.getString("previous_index"));
        ImageIcon nextIcon = new ImageIcon(SoundExplorer.class.getResource("rightArrow.gif"), Messages.getString("next_index"));
        ImageIcon firstIcon = new ImageIcon(SoundExplorer.class.getResource("endLeft.gif"), Messages.getString("first_index"));
        ImageIcon lastIcon = new ImageIcon(SoundExplorer.class.getResource("endRight.gif"), Messages.getString("last_index"));
        this.prevButton = new JButton(prevIcon);
        this.firstButton = new JButton(firstIcon);
        this.nextButton = new JButton(nextIcon);
        this.lastButton = new JButton(lastIcon);
        this.prevButton.setToolTipText(Messages.getString("Click_to_view_previous_index__sample_at_previous_pixel_"));
        this.firstButton.setToolTipText(Messages.getString("Click_to_view_first_index__sample_at_first_pixel_"));
        this.nextButton.setToolTipText(Messages.getString("Click_to_view_next_index__sample_at_next_pixel_"));
        this.lastButton.setToolTipText(Messages.getString("Click_to_view_last_index__sample_at_last_pixel_"));
        this.prevButton.setPreferredSize(new Dimension(prevIcon.getIconWidth() + 2, prevIcon.getIconHeight() + 2));
        this.firstButton.setPreferredSize(new Dimension(firstIcon.getIconWidth() + 2, firstIcon.getIconHeight() + 2));
        this.nextButton.setPreferredSize(new Dimension(nextIcon.getIconWidth() + 2, nextIcon.getIconHeight() + 2));
        this.lastButton.setPreferredSize(new Dimension(lastIcon.getIconWidth() + 2, lastIcon.getIconHeight() + 2));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundExplorer soundExplorer = SoundExplorer.this;
                soundExplorer.currentPixelPosition = soundExplorer.currentPixelPosition - 1;
                if (SoundExplorer.this.currentPixelPosition < 0) {
                    SoundExplorer.this.currentPixelPosition = 0;
                }
                SoundExplorer.this.updateIndexValues();
                SoundExplorer.this.checkScroll();
                SoundExplorer.this.soundFrame.getContentPane().repaint();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundExplorer soundExplorer = SoundExplorer.this;
                soundExplorer.currentPixelPosition = soundExplorer.currentPixelPosition + 1;
                if ((float)SoundExplorer.this.currentPixelPosition * SoundExplorer.this.framesPerPixel >= (float)SoundExplorer.this.sound.getNumSamples()) {
                    SoundExplorer.this.currentPixelPosition = (int)((float)(SoundExplorer.this.sound.getNumSamples() - 1) / SoundExplorer.this.framesPerPixel);
                }
                SoundExplorer.this.updateIndexValues();
                SoundExplorer.this.checkScroll();
                SoundExplorer.this.soundFrame.getContentPane().repaint();
            }
        });
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundExplorer.this.currentPixelPosition = 0;
                SoundExplorer.this.updateIndexValues();
                SoundExplorer.this.checkScroll();
                SoundExplorer.this.soundFrame.getContentPane().repaint();
            }
        });
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundExplorer.this.currentPixelPosition = (int)((float)(SoundExplorer.this.sound.getNumSamples() - 1) / SoundExplorer.this.framesPerPixel);
                SoundExplorer.this.updateIndexValues();
                SoundExplorer.this.checkScroll();
                SoundExplorer.this.soundFrame.getContentPane().repaint();
            }
        });
        this.indexValue = new JTextField(Integer.toString(0), 8);
        this.indexValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundExplorer.this.handleZoomIn(Integer.parseInt(SoundExplorer.this.indexValue.getText()));
                SoundExplorer.this.updateIndexValues();
            }
        });
        this.leftSampleValue = new JTextField(8);
        this.leftSampleValue.setEditable(false);
        this.rightSampleValue = new JTextField(8);
        this.rightSampleValue.setEditable(false);
        this.indexLabel = new JLabel(currentIndexText);
        this.leftSampleLabel = new JLabel(leftSampleText);
        this.rightSampleLabel = new JLabel(rightSampleText);
        this.updateIndexValues();
        topPanel.add(this.firstButton);
        topPanel.add(this.prevButton);
        topPanel.add(this.indexLabel);
        topPanel.add(this.indexValue);
        topPanel.add(this.leftSampleLabel);
        topPanel.add(this.leftSampleValue);
        if (this.inStereo) {
            topPanel.add(this.rightSampleLabel);
            topPanel.add(this.rightSampleValue);
        }
        topPanel.add(this.nextButton);
        topPanel.add(this.lastButton);
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JLabel(Messages.getString("The_number_of_samples_between_pixels__")));
        this.numSamplesPerPixelField = new JTextField(Integer.toString((int)this.framesPerPixel), 8);
        this.numSamplesPerPixelField.setToolTipText(Messages.getString("Click_here_to_zoom_in__decrease__or_out__increase__"));
        this.numSamplesPerPixelField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundExplorer.this.handleFramesPerPixel(Integer.parseInt(SoundExplorer.this.numSamplesPerPixelField.getText()));
                SoundExplorer.this.updateIndexValues();
            }
        });
        bottomPanel.add(this.numSamplesPerPixelField);
        vertBox.add(topPanel);
        vertBox.add(bottomPanel);
        indexPanel.add(vertBox);
    }

    private void createInfoPanel() {
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new BorderLayout());
        JPanel indexPanel = new JPanel();
        indexPanel.setLayout(new FlowLayout());
        this.setUpIndexPanel(indexPanel);
        this.zoomButtonPanel = new JPanel();
        this.zoomButton = this.makeButton(Messages.getString("Zoom_In"), true, this.zoomButtonPanel);
        this.zoomButton.setToolTipText(zoomInHint);
        this.infoPanel.add("North", indexPanel);
        this.infoPanel.add("South", this.zoomButtonPanel);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.currentPixelPosition = e.getX();
        if (this.currentPixelPosition == 0) {
            this.playBeforeButton.setEnabled(false);
            this.playAfterButton.setEnabled(true);
        } else if (this.currentPixelPosition < this.sampleWidth) {
            this.playBeforeButton.setEnabled(true);
            this.playAfterButton.setEnabled(true);
        } else if (this.currentPixelPosition == this.sampleWidth) {
            this.playBeforeButton.setEnabled(true);
            this.playAfterButton.setEnabled(false);
        }
        this.updateIndexValues();
        this.soundPanel.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressedX = e.getX();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseReleasedX = e.getX();
        if (this.mouseDragged) {
            this.mousePressed = this.mousePressedX;
            this.mouseReleased = this.mouseReleasedX;
            if (this.mousePressed > this.mouseReleased) {
                int temp = this.mousePressed;
                this.mousePressed = this.mouseReleased;
                this.mouseReleased = temp;
            }
            this.startFrame = (int)((float)this.mousePressed * this.framesPerPixel);
            this.stopFrame = (int)((float)this.mouseReleased * this.framesPerPixel);
            if (this.stopFrame >= this.sound.getLengthInFrames()) {
                this.stopFrame = this.sound.getLengthInFrames();
            }
            if (this.startFrame < 0) {
                this.startFrame = 0;
            }
            this.startIndexLabel.setText(String.valueOf(startIndexText) + this.startFrame);
            this.stopIndexLabel.setText(String.valueOf(stopIndexText) + this.stopFrame);
            this.selectionStart = this.mousePressed;
            this.selectionStop = this.mouseReleased;
            this.soundPanel.repaint();
            this.playSelectionButton.setEnabled(true);
            this.clearSelectionButton.setEnabled(true);
            this.mouseDragged = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragged = true;
        this.mouseReleased(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void update(LineEvent e) {
        if (e.getType().equals(LineEvent.Type.OPEN)) {
            this.playEntireButton.setEnabled(false);
            this.playBeforeButton.setEnabled(false);
            this.playAfterButton.setEnabled(false);
            this.selectionPrevState = this.playSelectionButton.isEnabled();
            this.playSelectionButton.setEnabled(false);
            this.clearSelectionButton.setEnabled(false);
            this.stopButton.setEnabled(true);
        }
        if (e.getType().equals(LineEvent.Type.CLOSE)) {
            this.playEntireButton.setEnabled(true);
            this.playSelectionButton.setEnabled(this.selectionPrevState);
            this.clearSelectionButton.setEnabled(this.selectionPrevState);
            this.stopButton.setEnabled(false);
            if (this.currentPixelPosition == 0) {
                this.playBeforeButton.setEnabled(false);
                this.playAfterButton.setEnabled(true);
            } else if (this.currentPixelPosition < this.sampleWidth) {
                this.playBeforeButton.setEnabled(true);
                this.playAfterButton.setEnabled(true);
            } else if (this.currentPixelPosition == this.sampleWidth) {
                this.playBeforeButton.setEnabled(true);
                this.playAfterButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block10: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block9: {
                                    if (e.getActionCommand() != Messages.getString("Play_Entire_Sound")) break block9;
                                    try {
                                        this.sound.play();
                                    }
                                    catch (Exception ex) {
                                        this.catchException(ex);
                                    }
                                    break block10;
                                }
                                if (e.getActionCommand() != Messages.getString("Play_Selection")) break block11;
                                try {
                                    this.sound.playAtRateInRange(1.0f, this.startFrame, this.stopFrame);
                                }
                                catch (Exception ex) {
                                    this.catchException(ex);
                                }
                                break block10;
                            }
                            if (!e.getActionCommand().equals(Messages.getString("Stop"))) break block12;
                            int i = 0;
                            while (i < this.sound.getPlaybacks().size()) {
                                ((Playback)this.sound.getPlaybacks().elementAt(i)).stopPlaying();
                                ++i;
                            }
                            break block10;
                        }
                        if (!e.getActionCommand().equals(Messages.getString("Zoom_In"))) break block13;
                        this.handleZoomIn(true);
                        break block10;
                    }
                    if (!e.getActionCommand().equals(Messages.getString("Zoom_Out"))) break block14;
                    this.handleZoomOut();
                    break block10;
                }
                if (!e.getActionCommand().equals(Messages.getString("Play_Before"))) break block15;
                try {
                    this.sound.playAtRateInRange(1.0f, 0, (int)((float)this.currentPixelPosition * this.framesPerPixel));
                }
                catch (Exception ex) {
                    this.catchException(ex);
                }
                break block10;
            }
            if (!e.getActionCommand().equals(Messages.getString("Play_After"))) break block10;
            try {
                this.sound.playAtRateInRange(1.0f, (int)((float)this.currentPixelPosition * this.framesPerPixel), this.sound.getLengthInFrames() - 1);
            }
            catch (Exception ex) {
                this.catchException(ex);
            }
        }
    }

    public void checkScroll() {
        if (this.sampleWidth != this.zoomOutWidth) {
            JViewport viewport = this.scrollSound.getViewport();
            Rectangle rect = viewport.getViewRect();
            int rectMinX = (int)rect.getX();
            int rectWidth = (int)rect.getWidth();
            int rectMaxX = rectMinX + rectWidth - 1;
            int maxIndex = this.sound.getLength() - rectWidth - 1;
            if (this.currentPixelPosition < rectMinX || this.currentPixelPosition > rectMaxX) {
                int barXPos = this.currentPixelPosition - rectWidth / 2;
                int barYPos = (int)((double)this.sampleHeight - rect.getHeight()) / 2;
                if (barXPos < 0) {
                    barXPos = 0;
                } else if (barXPos > maxIndex) {
                    barXPos = maxIndex;
                }
                viewport.setViewPosition(new Point(barXPos, barYPos));
            }
        }
    }

    private void handleZoomIn(boolean checkScrollFlag) {
        this.zoomButton.setText(Messages.getString("Zoom_Out"));
        this.zoomButton.setToolTipText(Messages.getString("Click_to_zoom_out__see_the_whole_sound_"));
        this.currentPixelPosition = (int)((float)this.currentPixelPosition * this.framesPerPixel);
        this.selectionStart = (int)((float)this.selectionStart * this.framesPerPixel);
        this.selectionStop = (int)((float)this.selectionStop * this.framesPerPixel);
        this.sampleWidth = this.zoomInWidth;
        this.framesPerPixel = this.sound.getLengthInFrames() / this.sampleWidth;
        this.soundPanel.setPreferredSize(new Dimension(this.zoomInWidth, this.soundPanel.getHeight()));
        this.soundPanel.setSize(this.soundPanel.getPreferredSize());
        this.leftSoundPanel.setPreferredSize(new Dimension(this.zoomInWidth, this.leftSoundPanel.getHeight()));
        this.leftSoundPanel.setSize(this.leftSoundPanel.getPreferredSize());
        this.leftSampleWrapper.setPreferredSize(new Dimension(this.zoomInWidth, this.leftSampleWrapper.getHeight()));
        this.leftSampleWrapper.setSize(this.leftSampleWrapper.getPreferredSize());
        this.leftSamplePanel.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
        this.leftSamplePanel.setSize(this.leftSamplePanel.getPreferredSize());
        this.leftSamplePanel.createWaveForm(true);
        if (this.inStereo) {
            this.rightSoundPanel.setPreferredSize(new Dimension(this.zoomInWidth, this.rightSoundPanel.getHeight()));
            this.rightSoundPanel.setSize(this.rightSoundPanel.getPreferredSize());
            this.rightSampleWrapper.setPreferredSize(new Dimension(this.zoomInWidth, this.rightSampleWrapper.getHeight()));
            this.rightSampleWrapper.setSize(this.rightSampleWrapper.getPreferredSize());
            this.rightSamplePanel.setPreferredSize(new Dimension(this.zoomInWidth, this.rightSamplePanel.getHeight()));
            this.rightSamplePanel.setSize(this.rightSamplePanel.getPreferredSize());
            this.rightSamplePanel.createWaveForm(false);
        }
        this.scrollSound.revalidate();
        this.updateIndexValues();
        if (checkScrollFlag) {
            this.checkScroll();
        }
    }

    private void handleZoomIn(int index) {
        if ((float)index % this.framesPerPixel != 0.0f) {
            this.handleZoomIn(false);
        }
        this.currentPixelPosition = (int)((float)index / this.framesPerPixel);
        this.checkScroll();
        this.soundPanel.repaint();
    }

    private void handleZoomOut() {
        this.zoomButton.setText(Messages.getString("Zoom_In"));
        this.zoomButton.setToolTipText(zoomInHint);
        this.sampleWidth = this.zoomOutWidth;
        this.framesPerPixel = this.sound.getLengthInFrames() / this.sampleWidth;
        int divisor = this.sound.getLengthInFrames() / this.sampleWidth;
        this.currentPixelPosition /= divisor;
        this.selectionStart /= divisor;
        this.selectionStop /= divisor;
        this.soundPanel.setPreferredSize(new Dimension(this.zoomOutWidth, this.soundPanel.getHeight()));
        this.soundPanel.setSize(this.soundPanel.getPreferredSize());
        this.leftSoundPanel.setPreferredSize(new Dimension(this.zoomOutWidth, this.leftSoundPanel.getHeight()));
        this.leftSoundPanel.setSize(this.leftSoundPanel.getPreferredSize());
        this.leftSampleWrapper.setPreferredSize(new Dimension(this.zoomOutWidth, this.leftSampleWrapper.getHeight()));
        this.leftSampleWrapper.setSize(this.leftSampleWrapper.getPreferredSize());
        this.leftSamplePanel.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
        this.leftSamplePanel.setSize(this.leftSamplePanel.getPreferredSize());
        this.leftSamplePanel.createWaveForm(true);
        if (this.inStereo) {
            this.rightSoundPanel.setPreferredSize(new Dimension(this.zoomOutWidth, this.rightSoundPanel.getHeight()));
            this.rightSoundPanel.setSize(this.rightSoundPanel.getPreferredSize());
            this.rightSampleWrapper.setPreferredSize(new Dimension(this.zoomOutWidth, this.rightSampleWrapper.getHeight()));
            this.rightSampleWrapper.setSize(this.rightSampleWrapper.getPreferredSize());
            this.rightSamplePanel.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
            this.rightSamplePanel.setSize(this.rightSamplePanel.getPreferredSize());
            this.rightSamplePanel.createWaveForm(false);
        }
        this.updateIndexValues();
        this.soundPanel.repaint();
    }

    private void handleFramesPerPixel(int numFrames) {
        int currIndex = (int)((float)this.currentPixelPosition * this.framesPerPixel);
        this.sampleWidth = this.sound.getLengthInFrames() / numFrames;
        this.framesPerPixel = numFrames;
        int divisor = this.sound.getLengthInFrames() / this.sampleWidth;
        this.currentPixelPosition = currIndex / divisor;
        this.selectionStart /= divisor;
        this.selectionStop /= divisor;
        this.soundPanel.setPreferredSize(new Dimension(this.sampleWidth, this.soundPanel.getHeight()));
        this.soundPanel.setSize(this.soundPanel.getPreferredSize());
        this.leftSoundPanel.setPreferredSize(new Dimension(this.sampleWidth, this.leftSoundPanel.getHeight()));
        this.leftSoundPanel.setSize(this.leftSoundPanel.getPreferredSize());
        this.leftSampleWrapper.setPreferredSize(new Dimension(this.sampleWidth, this.leftSampleWrapper.getHeight()));
        this.leftSampleWrapper.setSize(this.leftSampleWrapper.getPreferredSize());
        this.leftSamplePanel.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
        this.leftSamplePanel.setSize(this.leftSamplePanel.getPreferredSize());
        this.leftSamplePanel.createWaveForm(true);
        if (this.inStereo) {
            this.rightSoundPanel.setPreferredSize(new Dimension(this.sampleWidth, this.rightSoundPanel.getHeight()));
            this.rightSoundPanel.setSize(this.rightSoundPanel.getPreferredSize());
            this.rightSampleWrapper.setPreferredSize(new Dimension(this.sampleWidth, this.rightSampleWrapper.getHeight()));
            this.rightSampleWrapper.setSize(this.rightSampleWrapper.getPreferredSize());
            this.rightSamplePanel.setPreferredSize(new Dimension(this.sampleWidth, this.sampleHeight));
            this.rightSamplePanel.setSize(this.rightSamplePanel.getPreferredSize());
            this.rightSamplePanel.createWaveForm(false);
        }
        this.scrollSound.revalidate();
        this.updateIndexValues();
        this.checkScroll();
        this.soundPanel.repaint();
    }

    public void setBase(int base) {
        this.base = base;
    }

    private class SamplingPanel
    extends JPanel {
        private boolean forLeftSample;
        private Vector points;

        public SamplingPanel(boolean inputForLeftSample) {
            this.forLeftSample = inputForLeftSample;
            if (SoundExplorer.this.DEBUG) {
                System.out.println("creating_new_sampling_panel___n_tfor_left_sample__" + this.forLeftSample + "_n_tsampleWidth__" + SoundExplorer.this.sampleWidth + "_n_tsampleHeight__" + SoundExplorer.this.sampleHeight);
            }
            this.setBackground(backgroundColor);
            this.setPreferredSize(new Dimension(SoundExplorer.this.sampleWidth, SoundExplorer.this.sampleHeight));
            this.setSize(this.getPreferredSize());
            if (SoundExplorer.this.DEBUG) {
                System.out.println("_tSample_panel_preferred_size__" + this.getPreferredSize() + "_n_tSample_panel_size__" + this.getSize());
            }
            this.points = new Vector();
            this.createWaveForm(this.forLeftSample);
        }

        public void createWaveForm(boolean forLeftSample) {
            float maxValue;
            AudioFormat format = SoundExplorer.this.sound.getAudioFileFormat().getFormat();
            if (format.getSampleSizeInBits() == 8) {
                maxValue = (float)Math.pow(2.0, 7.0);
            } else if (format.getSampleSizeInBits() == 16) {
                maxValue = (float)Math.pow(2.0, 15.0);
            } else if (format.getSampleSizeInBits() == 24) {
                maxValue = (float)Math.pow(2.0, 23.0);
            } else if (format.getSampleSizeInBits() == 32) {
                maxValue = (float)Math.pow(2.0, 31.0);
            } else {
                try {
                    SoundExplorer.this.sound.printError(Messages.getString("InvalidSampleSize"));
                }
                catch (Exception ex) {
                    SoundExplorer.this.catchException(ex);
                }
                return;
            }
            this.points.clear();
            int pixel = 0;
            while (pixel < SoundExplorer.this.sampleWidth) {
                float sampleValue;
                if (forLeftSample) {
                    try {
                        sampleValue = SoundExplorer.this.sound.getLeftSample((int)((float)pixel * SoundExplorer.this.framesPerPixel));
                    }
                    catch (Exception ex) {
                        SoundExplorer.this.catchException(ex);
                        return;
                    }
                }
                try {
                    sampleValue = SoundExplorer.this.sound.getRightSample((int)((float)pixel * SoundExplorer.this.framesPerPixel));
                }
                catch (Exception ex) {
                    SoundExplorer.this.catchException(ex);
                    return;
                }
                float y = (float)Math.floor(SoundExplorer.this.sampleHeight / 2) - sampleValue * ((float)Math.floor(SoundExplorer.this.sampleHeight / 2) / maxValue);
                this.points.add(new Point2D.Float(pixel, y));
                ++pixel;
            }
            if (SoundExplorer.this.DEBUG) {
                System.out.println("number of points: " + this.points.size());
            }
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle rectToPaint = g.getClipBounds();
            if (SoundExplorer.this.DEBUG) {
                System.out.println("Repainting: " + rectToPaint);
                System.out.println("SampleWidth: " + SoundExplorer.this.sampleWidth);
                System.out.println("framesPerPixel: " + SoundExplorer.this.framesPerPixel);
                System.out.println("Sample_panel_size: " + this.getSize());
                System.out.println("SamplePanel_Width: " + this.getWidth());
                System.out.println("SamplePanel_Height: " + this.getHeight());
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setBackground(backgroundColor);
            g2.clearRect((int)rectToPaint.getX(), (int)rectToPaint.getY(), (int)rectToPaint.getWidth(), (int)rectToPaint.getHeight());
            if (SoundExplorer.this.selectionStart != -1 && SoundExplorer.this.selectionStop != -1) {
                g2.setBackground(selectionColor);
                g2.clearRect(SoundExplorer.this.selectionStart, 0, SoundExplorer.this.selectionStop - SoundExplorer.this.selectionStart + 1, SoundExplorer.this.sampleHeight);
            }
            g2.setColor(waveColor);
            int i = (int)rectToPaint.getX();
            while ((double)i < rectToPaint.getX() + rectToPaint.getWidth() - 1.0) {
                g2.draw(new Line2D.Float((Point2D.Float)this.points.elementAt(i), (Point2D.Float)this.points.elementAt(i + 1)));
                ++i;
            }
            g2.setColor(barColor);
            g2.setStroke(new BasicStroke(1.0f));
            g2.draw(new Line2D.Double(rectToPaint.getX(), Math.floor(SoundExplorer.this.sampleHeight / 2), rectToPaint.getX() + rectToPaint.getWidth() - 1.0, Math.floor(SoundExplorer.this.sampleHeight / 2)));
            if (rectToPaint.getX() < (double)SoundExplorer.this.currentPixelPosition && (double)SoundExplorer.this.currentPixelPosition < rectToPaint.getX() + rectToPaint.getWidth() - 1.0) {
                g2.setColor(barColor);
                g2.setStroke(new BasicStroke(1.0f));
                g2.draw(new Line2D.Double(SoundExplorer.this.currentPixelPosition, 0.0, SoundExplorer.this.currentPixelPosition, SoundExplorer.this.sampleHeight));
            }
        }
    }
}

