/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import movieMaker.DigitalPicture;
import movieMaker.FileChooser;
import movieMaker.Picture;
import movieMaker.PictureExplorer;
import movieMaker.PictureFrame;
import movieMaker.Pixel;

public class SimplePicture
implements DigitalPicture {
    private String fileName;
    private String title;
    private BufferedImage bufferedImage;
    private PictureFrame pictureFrame;
    private String extension;

    public SimplePicture() {
        this(200, 100);
    }

    public SimplePicture(String fileName) {
        this.load(fileName);
    }

    public SimplePicture(int width, int height) {
        this.bufferedImage = new BufferedImage(width, height, 1);
        this.title = "None";
        this.fileName = "None";
        this.extension = "jpg";
        this.setAllPixelsToAColor(Color.white);
    }

    public SimplePicture(int width, int height, Color theColor) {
        this(width, height);
        this.setAllPixelsToAColor(theColor);
    }

    public SimplePicture(SimplePicture copyPicture) {
        if (copyPicture.fileName != null) {
            this.fileName = new String(copyPicture.fileName);
            this.extension = copyPicture.extension;
        }
        if (copyPicture.title != null) {
            this.title = new String(copyPicture.title);
        }
        if (copyPicture.bufferedImage != null) {
            this.bufferedImage = new BufferedImage(copyPicture.getWidth(), copyPicture.getHeight(), 1);
            this.copyPicture(copyPicture);
        }
    }

    public SimplePicture(BufferedImage image) {
        this.bufferedImage = image;
        this.title = "None";
        this.fileName = "None";
        this.extension = "jpg";
    }

    public String getExtension() {
        return this.extension;
    }

    public void copyPicture(SimplePicture sourcePicture) {
        Pixel sourcePixel = null;
        Pixel targetPixel = null;
        int sourceX = 0;
        int targetX = 0;
        while (sourceX < sourcePicture.getWidth() && targetX < this.getWidth()) {
            int sourceY = 0;
            int targetY = 0;
            while (sourceY < sourcePicture.getHeight() && targetY < this.getHeight()) {
                sourcePixel = sourcePicture.getPixel(sourceX, sourceY);
                targetPixel = this.getPixel(targetX, targetY);
                targetPixel.setColor(sourcePixel.getColor());
                ++sourceY;
                ++targetY;
            }
            ++sourceX;
            ++targetX;
        }
    }

    public void setAllPixelsToAColor(Color color) {
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                this.getPixel(x, y).setColor(color);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public Graphics getGraphics() {
        return this.bufferedImage.getGraphics();
    }

    public Graphics2D createGraphics() {
        return this.bufferedImage.createGraphics();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        if (this.pictureFrame != null) {
            this.pictureFrame.setTitle(title);
        }
    }

    @Override
    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public PictureFrame getPictureFrame() {
        return this.pictureFrame;
    }

    public void setPictureFrame(PictureFrame pictureFrame) {
        this.pictureFrame = pictureFrame;
    }

    @Override
    public Image getImage() {
        return this.bufferedImage;
    }

    @Override
    public int getBasicPixel(int x, int y) {
        return this.bufferedImage.getRGB(x, y);
    }

    @Override
    public void setBasicPixel(int x, int y, int rgb) {
        this.bufferedImage.setRGB(x, y, rgb);
    }

    @Override
    public Pixel getPixel(int x, int y) {
        Pixel pixel = new Pixel(this, x, y);
        return pixel;
    }

    public Pixel[] getPixels() {
        int width = this.getWidth();
        int height = this.getHeight();
        Pixel[] pixelArray = new Pixel[width * height];
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                pixelArray[row * width + col] = new Pixel(this, col, row);
                ++col;
            }
            ++row;
        }
        return pixelArray;
    }

    @Override
    public void load(Image image) {
        Graphics2D graphics2d = this.bufferedImage.createGraphics();
        graphics2d.drawImage(image, 0, 0, null);
        this.show();
    }

    @Override
    public void show() {
        if (this.pictureFrame != null) {
            this.pictureFrame.updateImageAndShowIt();
        } else {
            this.pictureFrame = new PictureFrame(this);
        }
    }

    public void hide() {
        if (this.pictureFrame != null) {
            this.pictureFrame.setVisible(false);
        }
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void explore() {
        new PictureExplorer(new SimplePicture(this));
    }

    public void repaint() {
        if (this.pictureFrame != null) {
            this.pictureFrame.repaint();
        } else {
            this.pictureFrame = new PictureFrame(this);
        }
    }

    public void loadOrFail(String fileName) throws IOException {
        File file;
        this.fileName = fileName;
        int posDot = fileName.lastIndexOf(46);
        if (posDot >= 0) {
            this.extension = fileName.substring(posDot + 1);
        }
        if (this.title == null) {
            this.title = fileName;
        }
        if (!(file = new File(this.fileName)).canRead() && !(file = new File(FileChooser.getMediaPath(this.fileName))).canRead()) {
            throw new IOException(String.valueOf(this.fileName) + " " + Messages.getString("could_not_be_opened__Check_that_you_specified_the_path"));
        }
        this.bufferedImage = ImageIO.read(file);
    }

    @Override
    public boolean load(String fileName) {
        try {
            this.loadOrFail(fileName);
            return true;
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(Messages.getString("There_was_an_error_trying_to_open_")) + fileName);
            this.bufferedImage = new BufferedImage(600, 200, 1);
            this.addMessage(String.valueOf(Messages.getString("Couldn_t_load_")) + fileName, 5, 100);
            return false;
        }
    }

    public boolean loadImage(String fileName) {
        return this.load(fileName);
    }

    public void addMessage(String message, int xPos, int yPos) {
        Graphics2D graphics2d = this.bufferedImage.createGraphics();
        graphics2d.setPaint(Color.white);
        graphics2d.setFont(new Font("Helvetica", 1, 16));
        graphics2d.drawString(message, xPos, yPos);
    }

    public void drawString(String text, int xPos, int yPos) {
        this.addMessage(text, xPos, yPos);
    }

    public Picture scale(double xFactor, double yFactor) {
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.scale(xFactor, yFactor);
        Picture result = new Picture((int)((double)this.getWidth() * xFactor), (int)((double)this.getHeight() * yFactor));
        Graphics graphics = result.getGraphics();
        Graphics2D g2 = (Graphics2D)graphics;
        g2.drawImage(this.getImage(), scaleTransform, null);
        return result;
    }

    public Picture getPictureWithWidth(int width) {
        double xFactor = (double)width / (double)this.getWidth();
        Picture result = this.scale(xFactor, xFactor);
        return result;
    }

    public Picture getPictureWithHeight(int height) {
        double yFactor = (double)height / (double)this.getHeight();
        Picture result = this.scale(yFactor, yFactor);
        return result;
    }

    public boolean loadPictureAndShowIt(String fileName) {
        boolean result = true;
        result = this.load(fileName);
        this.show();
        return result;
    }

    public void writeOrFail(String fileName) throws IOException {
        String extension = this.extension;
        File file = new File(fileName);
        File fileLoc = file.getParentFile();
        if (!fileLoc.canWrite()) {
            throw new IOException(String.valueOf(fileName) + " " + Messages.getString("could_not_be_opened__Check_to_see_if_you_can_write_to_the_directory_"));
        }
        int posDot = fileName.lastIndexOf(46);
        if (posDot >= 0) {
            extension = fileName.substring(posDot + 1);
        }
        ImageIO.write((RenderedImage)this.bufferedImage, extension, file);
    }

    public boolean write(String fileName) {
        try {
            this.writeOrFail(fileName);
            return true;
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(Messages.getString("There_was_an_error_trying_to_write_")) + fileName);
            return false;
        }
    }

    public static void setMediaPath(String directory) {
        FileChooser.setMediaPath(directory);
    }

    public static String getMediaPath(String fileName) {
        return FileChooser.getMediaPath(fileName);
    }

    public Rectangle2D getTransformEnclosingRect(AffineTransform trans) {
        int width = this.getWidth();
        int height = this.getHeight();
        double maxX = width - 1;
        double maxY = height - 1;
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(maxX, 0.0);
        Point2D.Double p3 = new Point2D.Double(maxX, maxY);
        Point2D.Double p4 = new Point2D.Double(0.0, maxY);
        Point2D.Double result = new Point2D.Double(0.0, 0.0);
        Rectangle2D.Double rect = null;
        trans.deltaTransform(p1, result);
        double minX = result.getX();
        maxX = result.getX();
        double minY = result.getY();
        maxY = result.getY();
        trans.deltaTransform(p2, result);
        minX = Math.min(minX, result.getX());
        maxX = Math.max(maxX, result.getX());
        minY = Math.min(minY, result.getY());
        maxY = Math.max(maxY, result.getY());
        trans.deltaTransform(p3, result);
        minX = Math.min(minX, result.getX());
        maxX = Math.max(maxX, result.getX());
        minY = Math.min(minY, result.getY());
        maxY = Math.max(maxY, result.getY());
        trans.deltaTransform(p4, result);
        minX = Math.min(minX, result.getX());
        maxX = Math.max(maxX, result.getX());
        minY = Math.min(minY, result.getY());
        maxY = Math.max(maxY, result.getY());
        rect = new Rectangle2D.Double(minX, minY, maxX - minX + 1.0, maxY - minY + 1.0);
        return rect;
    }

    public String toString() {
        String output = String.valueOf(Messages.getString("Simple_Picture__filename_")) + this.fileName + " " + Messages.getString("height_") + this.getHeight() + " " + Messages.getString("width_") + this.getWidth();
        return output;
    }
}

