/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import com.sun.media.ui.TabControl;
import com.sun.media.util.JMFI18N;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.MonitorControl;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import jmapps.ui.ImageArea;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.ProgressDialog;
import jmapps.ui.ProgressThread;
import jmapps.util.JMAppsCfg;
import movieMaker.TrackPanelAudio;

public class SaveAsDialog
extends JMDialog
implements ControllerListener,
DataSinkListener,
ItemListener {
    private JMAppsCfg cfgJMApps;
    private String inputURL;
    private DataSource dataSource = null;
    private Processor processor = null;
    private DataSink dataSink = null;
    private TrackControl[] arrTrackControls;
    private int nAudioTrackCount = 0;
    private String strContentType = null;
    private boolean boolSaving = false;
    private ProgressDialog dlgProgress = null;
    private ProgressThread threadProgress = null;
    private TabControl tabControl;
    private Hashtable hashtablePanelsAudio = new Hashtable();
    private Choice comboContentType;
    private Image imageAudioEn = null;
    private Image imageAudioDis = null;
    private String strFailMessage = null;
    Object stateLock = new Object();
    boolean stateFailed = false;

    public SaveAsDialog(Frame frame, String inputURL, Format format, JMAppsCfg cfgJMApps) {
        super(frame, JMFI18N.getResource((String)"jmstudio.saveas.title"), false);
        this.cfgJMApps = cfgJMApps;
        this.inputURL = inputURL;
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SaveAsDialog(Frame frame, DataSource dataSource, JMAppsCfg cfgJMApps) {
        super(frame, JMFI18N.getResource((String)"jmstudio.saveas.title"), false);
        this.cfgJMApps = cfgJMApps;
        this.dataSource = dataSource;
        this.inputURL = "Capture";
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.imageAudioEn = ImageArea.loadImage((String)"audio.gif", (Component)((Object)this), (boolean)true);
        this.imageAudioDis = ImageArea.loadImage((String)"audio-disabled.gif", (Component)((Object)this), (boolean)true);
        this.frameOwner.setCursor(new Cursor(3));
        if (this.dataSource == null) {
            try {
                MediaLocator mediaSource = new MediaLocator(this.inputURL);
                this.dataSource = Manager.createDataSource((MediaLocator)mediaSource);
            }
            catch (Exception exception) {
                AuthoringTool.showErrorDialog(Messages.getString("Alice_has_encountered_an_error"), exception);
                this.frameOwner.setCursor(Cursor.getDefaultCursor());
                throw exception;
            }
        }
        this.strContentType = this.dataSource.getContentType();
        try {
            this.processor = Manager.createProcessor((DataSource)this.dataSource);
        }
        catch (NoPlayerException exception) {
            AuthoringTool.showErrorDialog(Messages.getString("Alice_has_encountered_an_error"), (Object)exception);
            this.frameOwner.setCursor(Cursor.getDefaultCursor());
            throw exception;
        }
        this.processor.addControllerListener((ControllerListener)this);
        boolean boolResult = this.waitForState(this.processor, 180);
        if (!boolResult) {
            this.frameOwner.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.arrTrackControls = this.processor.getTrackControls();
        int i = 0;
        while (i < this.arrTrackControls.length) {
            Format format = this.arrTrackControls[i].getFormat();
            if (format instanceof AudioFormat) {
                ++this.nAudioTrackCount;
            }
            ++i;
        }
        this.setLayout(new BorderLayout());
        JMPanel panelBorder = new JMPanel((LayoutManager)new BorderLayout(6, 6));
        panelBorder.setEmptyBorder(6, 6, 6, 6);
        panelBorder.setBackground(Color.lightGray);
        this.add((Component)panelBorder, "Center");
        Panel panel = this.createPanelGeneral();
        panelBorder.add((Component)panel, (Object)"North");
        panel = this.createPanelProperties();
        panelBorder.add((Component)panel, (Object)"Center");
        this.changeContentType();
        this.pack();
        Dimension dim = this.getSize();
        dim.width += 64;
        this.setSize(dim);
        this.addWindowListener((WindowListener)((Object)this));
        this.setResizable(false);
        this.doSave();
        this.frameOwner.setCursor(Cursor.getDefaultCursor());
    }

    private Panel createPanelProperties() throws Exception {
        String strAudio = "Audio";
        this.tabControl = new TabControl(0);
        int nCount = this.arrTrackControls.length;
        int i = 0;
        while (i < nCount) {
            Format format = this.arrTrackControls[i].getFormat();
            if (format instanceof AudioFormat) {
                JMAppsCfg.TrackData dataTrack;
                TrackPanelAudio panelAudio = new TrackPanelAudio(this.arrTrackControls[i], (ActionListener)((Object)this));
                this.tabControl.addPage((Panel)((Object)panelAudio), strAudio, this.imageAudioEn);
                this.hashtablePanelsAudio.put(strAudio, panelAudio);
                if (this.cfgJMApps != null && (dataTrack = this.cfgJMApps.getLastSaveFileTrackData(strAudio)) != null) {
                    panelAudio.setDefaults(dataTrack.boolEnable, dataTrack.format);
                }
            }
            ++i;
        }
        return this.tabControl;
    }

    private Panel createPanelGeneral() throws Exception {
        Panel panelGeneral = new Panel(new GridLayout(0, 1, 4, 4));
        Panel panelFormat = new Panel(new BorderLayout());
        panelGeneral.add(panelFormat);
        Label label = new Label(Messages.getString("Format_"));
        panelFormat.add((Component)label, "West");
        label = new Label("Wave(wav)");
        panelFormat.add((Component)label, "Center");
        return panelGeneral;
    }

    private void doSave() {
        Object strFileContentType = null;
        Object strDirName = null;
        Object strFileName = null;
        Component monitor = null;
        this.setCursor(new Cursor(3));
        try {
            this.processor.setContentDescriptor((ContentDescriptor)new FileTypeDescriptor(this.strContentType));
            Enumeration enumKeys = this.hashtablePanelsAudio.keys();
            while (enumKeys.hasMoreElements()) {
                String strPanel = (String)enumKeys.nextElement();
                TrackPanelAudio panelAudio = (TrackPanelAudio)this.hashtablePanelsAudio.get(strPanel);
                panelAudio.updateTrack();
                if (this.cfgJMApps == null) continue;
                JMAppsCfg.TrackData dataTrack = this.cfgJMApps.createTrackDataObject();
                TrackControl trackControl = panelAudio.getTrackControl();
                dataTrack.boolEnable = trackControl.isEnabled();
                dataTrack.format = trackControl.getFormat();
                this.cfgJMApps.setLastSaveFileTrackData(dataTrack, strPanel);
            }
            boolean boolResult = this.waitForState(this.processor, 300);
            if (!boolResult) {
                this.setCursor(Cursor.getDefaultCursor());
                this.processor.close();
                this.dispose();
                return;
            }
            DataSource dataSource = this.processor.getDataOutput();
            this.inputURL = String.valueOf(this.inputURL.substring(0, this.inputURL.lastIndexOf("."))) + "a.wav";
            MediaLocator mediaDest = new MediaLocator(this.inputURL);
            this.dataSink = Manager.createDataSink((DataSource)dataSource, (MediaLocator)mediaDest);
            this.boolSaving = true;
            MonitorControl monitorControl = (MonitorControl)this.processor.getControl("javax.media.control.MonitorControl");
            if (monitorControl != null) {
                monitor = monitorControl.getControlComponent();
            }
            Time duration = this.processor.getDuration();
            int nMediaDuration = (int)duration.getSeconds();
            this.dataSink.addDataSinkListener((DataSinkListener)this);
            try {
                this.dataSink.open();
            }
            catch (Exception e) {
                this.processor.close();
                throw e;
            }
            this.dataSink.start();
            this.processor.start();
            this.dlgProgress = nMediaDuration > 0 && duration != Duration.DURATION_UNBOUNDED && duration != Duration.DURATION_UNKNOWN ? new ProgressDialog(this.frameOwner, JMFI18N.getResource((String)"jmstudio.saveprogress.title"), 0, nMediaDuration, (ActionListener)((Object)this)) : new ProgressDialog(this.frameOwner, JMFI18N.getResource((String)"jmstudio.saveprogress.title"), JMFI18N.getResource((String)"jmstudio.saveprogress.label"), monitor, (ActionListener)((Object)this));
            this.threadProgress = new ProgressThread(this.processor, this.dlgProgress);
            this.threadProgress.start();
        }
        catch (Exception exception) {
            this.boolSaving = false;
            AuthoringTool.showErrorDialog(Messages.getString("Alice_has_encountered_an_error__"), exception);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        Object objectSource;
        String strCmd = event.getActionCommand();
        if (strCmd.equals(ACTION_CANCEL)) {
            this.stopSaving();
            this.dispose();
        } else if (strCmd.equals(ACTION_SAVE)) {
            this.doSave();
        } else if ((strCmd.equals(ProgressDialog.ACTION_ABORT) || strCmd.equals(ProgressDialog.ACTION_STOP)) && this.boolSaving) {
            this.stopSaving();
        } else if (strCmd.equals(ProgressDialog.ACTION_PAUSE) && this.boolSaving) {
            this.processor.stop();
            this.dlgProgress.setPauseButtonText(ProgressDialog.ACTION_RESUME);
            this.threadProgress.pauseThread();
        } else if (strCmd.equals(ProgressDialog.ACTION_RESUME) && this.boolSaving) {
            this.processor.start();
            this.dlgProgress.setPauseButtonText(ProgressDialog.ACTION_PAUSE);
            this.threadProgress.resumeThread();
        } else if (strCmd.equals("ACTION_AUDIO_TRACK_ENABLED")) {
            Object objectSource2 = event.getSource();
            if (objectSource2 instanceof TrackPanelAudio) {
                this.tabControl.setPageImage((Panel)objectSource2, this.imageAudioEn);
            }
        } else if (strCmd.equals("ACTION_AUDIO_TRACK_DISABLED") && (objectSource = event.getSource()) instanceof TrackPanelAudio) {
            this.tabControl.setPageImage((Panel)objectSource, this.imageAudioDis);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.comboContentType) {
            this.changeContentType();
        }
    }

    public void windowClosing(WindowEvent event) {
        this.stopSaving();
        this.dispose();
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof ControllerErrorEvent) {
            this.strFailMessage = ((ControllerErrorEvent)event).getMessage();
            if (this.boolSaving) {
                this.stopSaving();
                MessageDialog.createErrorDialogModeless((Frame)this.frameOwner, (String)(String.valueOf(JMFI18N.getResource((String)"jmstudio.error.processor.savefile")) + "\n" + JMFI18N.getResource((String)"jmstudio.error.controller") + "\n" + this.strFailMessage));
            } else {
                MessageDialog.createErrorDialogModeless((Frame)this.frameOwner, (String)(String.valueOf(JMFI18N.getResource((String)"jmstudio.error.controller")) + "\n" + this.strFailMessage));
            }
        } else if (event instanceof EndOfMediaEvent && this.boolSaving) {
            this.stopSaving();
        }
    }

    public void dataSinkUpdate(DataSinkEvent event) {
        if (event instanceof EndOfStreamEvent) {
            this.closeDataSink();
        } else if (event instanceof DataSinkErrorEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialogModeless((Frame)this.frameOwner, (String)JMFI18N.getResource((String)"jmstudio.error.processor.writefile"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataSink() {
        SaveAsDialog saveAsDialog = this;
        synchronized (saveAsDialog) {
            if (this.dataSink != null) {
                this.dataSink.close();
            }
            this.dataSink = null;
        }
    }

    private void stopSaving() {
        this.boolSaving = false;
        if (this.threadProgress != null) {
            this.threadProgress.terminateNormaly();
            this.threadProgress = null;
        }
        if (this.processor != null) {
            this.processor.stop();
            this.processor.close();
        }
        if (this.dlgProgress != null) {
            this.dlgProgress.dispose();
            this.dlgProgress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForState(Processor p, int state) {
        p.addControllerListener((ControllerListener)new StateListener());
        this.stateFailed = false;
        if (state == 180) {
            p.configure();
        } else if (state == 300) {
            p.realize();
        }
        while (p.getState() < state && !this.stateFailed) {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException ie) {
                    return false;
                }
            }
        }
        return !this.stateFailed;
    }

    private void changeContentType() {
        this.strContentType = "audio.x_wav";
        if (this.processor.setContentDescriptor((ContentDescriptor)new FileTypeDescriptor(this.strContentType)) == null) {
            System.err.println(Messages.getString("Error_setting_content_descriptor_on_processor"));
        }
        Enumeration enumPanels = this.hashtablePanelsAudio.elements();
        while (enumPanels.hasMoreElements()) {
            TrackPanelAudio panelAudio = (TrackPanelAudio)enumPanels.nextElement();
            panelAudio.setContentType(this.strContentType);
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                SaveAsDialog.this.stateFailed = true;
            }
            if (ce instanceof ControllerEvent) {
                Object object = SaveAsDialog.this.stateLock;
                synchronized (object) {
                    SaveAsDialog.this.stateLock.notifyAll();
                }
            }
        }
    }
}

