/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import movieMaker.SimpleSound;
import movieMaker.SoundExplorer;

public class Playback
extends Thread {
    private static final int BUFFER_SIZE = 16384;
    private SourceDataLine line;
    private boolean playing = false;
    private SimpleSound sound;

    public Playback(SimpleSound sound) {
        this.sound = sound;
    }

    private void shutDown(String message, Exception e) {
        if (message != null) {
            System.err.println(message);
            e.printStackTrace();
        }
        this.playing = false;
    }

    public void stopPlaying() {
        this.playing = false;
    }

    public boolean getPlaying() {
        return this.playing;
    }

    @Override
    public void run() {
        AudioFileFormat audioFileFormat = this.sound.getAudioFileFormat();
        SoundExplorer soundExplorer = this.sound.getSoundExplorer();
        AudioInputStream audioInputStream = this.sound.makeAIS();
        if (audioInputStream == null) {
            this.shutDown(Messages.getString("There_is_no_input_stream_to_play"), null);
            return;
        }
        try {
            audioInputStream.reset();
        }
        catch (Exception e) {
            this.shutDown(Messages.getString("Problems_resetting_the_stream_n"), e);
            return;
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFileFormat.getFormat());
        if (!AudioSystem.isLineSupported(info)) {
            this.shutDown(String.valueOf(Messages.getString("Line_matching_")) + info + Messages.getString("not_supported_"), null);
            return;
        }
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            if (this.sound.getSoundExplorer() != null) {
                this.line.addLineListener(soundExplorer);
            }
            this.line.open(audioFileFormat.getFormat(), 16384);
        }
        catch (LineUnavailableException e) {
            this.shutDown(Messages.getString("Unable_to_open_the_line__"), e);
            return;
        }
        int frameSizeInBytes = audioFileFormat.getFormat().getFrameSize();
        int bufferLengthInBytes = this.line.getBufferSize();
        int bufferLengthInFrames = bufferLengthInBytes / frameSizeInBytes;
        byte[] data = new byte[bufferLengthInBytes];
        int numBytesRead = 0;
        this.line.start();
        this.playing = true;
        while (this.playing) {
            try {
                numBytesRead = audioInputStream.read(data);
                if (numBytesRead == -1) break;
                int numBytesRemaining = numBytesRead;
                while (numBytesRemaining > 0) {
                    numBytesRemaining -= this.line.write(data, 0, numBytesRemaining);
                }
            }
            catch (Exception e) {
                this.shutDown(Messages.getString("Error_during_playback__"), e);
                break;
            }
        }
        if (this.playing) {
            this.line.drain();
        }
        this.line.stop();
        this.line.close();
        this.line = null;
        this.shutDown(null, null);
        if (this.sound.getDEBUG()) {
            System.out.println(Messages.getString("exiting_run_method"));
        }
        this.sound.removePlayback(this);
    }
}

