/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import movieMaker.DigitalPicture;

public class Pixel {
    private DigitalPicture picture;
    private int x;
    private int y;

    public Pixel(DigitalPicture picture, int x, int y) {
        this.picture = picture;
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getAlpha() {
        int value = this.picture.getBasicPixel(this.x, this.y);
        int alpha = value >> 24 & 0xFF;
        return alpha;
    }

    public int getRed() {
        int value = this.picture.getBasicPixel(this.x, this.y);
        int red = value >> 16 & 0xFF;
        return red;
    }

    public static int getRed(int value) {
        int red = value >> 16 & 0xFF;
        return red;
    }

    public int getGreen() {
        int value = this.picture.getBasicPixel(this.x, this.y);
        int green = value >> 8 & 0xFF;
        return green;
    }

    public static int getGreen(int value) {
        int green = value >> 8 & 0xFF;
        return green;
    }

    public int getBlue() {
        int value = this.picture.getBasicPixel(this.x, this.y);
        int blue = value & 0xFF;
        return blue;
    }

    public static int getBlue(int value) {
        int blue = value & 0xFF;
        return blue;
    }

    public Color getColor() {
        int value = this.picture.getBasicPixel(this.x, this.y);
        int red = value >> 16 & 0xFF;
        int green = value >> 8 & 0xFF;
        int blue = value & 0xFF;
        return new Color(red, green, blue);
    }

    public void setColor(Color newColor) {
        int red = newColor.getRed();
        int green = newColor.getGreen();
        int blue = newColor.getBlue();
        this.updatePicture(this.getAlpha(), red, green, blue);
    }

    public void updatePicture(int alpha, int red, int green, int blue) {
        int value = (alpha << 24) + (red << 16) + (green << 8) + blue;
        this.picture.setBasicPixel(this.x, this.y, value);
    }

    private static int correctValue(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 255) {
            value = 255;
        }
        return value;
    }

    public void setRed(int value) {
        int red = Pixel.correctValue(value);
        this.updatePicture(this.getAlpha(), red, this.getGreen(), this.getBlue());
    }

    public void setGreen(int value) {
        int green = Pixel.correctValue(value);
        this.updatePicture(this.getAlpha(), this.getRed(), green, this.getBlue());
    }

    public void setBlue(int value) {
        int blue = Pixel.correctValue(value);
        this.updatePicture(this.getAlpha(), this.getRed(), this.getGreen(), blue);
    }

    public void setAlpha(int value) {
        int alpha = Pixel.correctValue(value);
        this.updatePicture(alpha, this.getRed(), this.getGreen(), this.getBlue());
    }

    public double colorDistance(Color testColor) {
        double redDistance = this.getRed() - testColor.getRed();
        double greenDistance = this.getGreen() - testColor.getGreen();
        double blueDistance = this.getBlue() - testColor.getBlue();
        double distance = Math.sqrt(redDistance * redDistance + greenDistance * greenDistance + blueDistance * blueDistance);
        return distance;
    }

    public static double colorDistance(Color color1, Color color2) {
        double redDistance = color1.getRed() - color2.getRed();
        double greenDistance = color1.getGreen() - color2.getGreen();
        double blueDistance = color1.getBlue() - color2.getBlue();
        double distance = Math.sqrt(redDistance * redDistance + greenDistance * greenDistance + blueDistance * blueDistance);
        return distance;
    }

    public double getAverage() {
        double average = (double)(this.getRed() + this.getGreen() + this.getBlue()) / 3.0;
        return average;
    }

    public String toString() {
        return String.valueOf(Messages.getString("Pixel_red_")) + this.getRed() + " " + Messages.getString("green_") + this.getGreen() + " " + Messages.getString("blue_") + this.getBlue();
    }
}

