/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import movieMaker.DigitalPicture;
import movieMaker.ImageDisplay;
import movieMaker.Pixel;
import movieMaker.SoundExplorer;

public class PictureExplorer
implements MouseMotionListener,
ActionListener,
MouseListener {
    private int xIndex = 0;
    private int yIndex = 0;
    private JFrame pictureFrame;
    private JScrollPane scrollPane;
    private JLabel xLabel;
    private JButton xPrevButton;
    private JButton yPrevButton;
    private JButton xNextButton;
    private JButton yNextButton;
    private JLabel yLabel;
    private JTextField xValue;
    private JTextField yValue;
    private JLabel rValue;
    private JLabel gValue;
    private JLabel bValue;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JMenuBar menuBar;
    private JMenu zoomMenu;
    private JMenuItem twentyFive;
    private JMenuItem fifty;
    private JMenuItem seventyFive;
    private JMenuItem hundred;
    private JMenuItem hundredFifty;
    private JMenuItem twoHundred;
    private JMenuItem fiveHundred;
    private DigitalPicture picture;
    private ImageIcon scrollImageIcon;
    private ImageDisplay imageDisplay;
    private double zoomFactor;
    private int numberBase = 0;

    public PictureExplorer(DigitalPicture picture) {
        this.picture = picture;
        this.zoomFactor = 1.0;
        this.createWindow();
    }

    public void changeToBaseOne() {
        this.numberBase = 1;
    }

    public void setTitle(String title) {
        this.pictureFrame.setTitle(title);
    }

    private void createAndInitPictureFrame() {
        this.pictureFrame = new JFrame();
        this.pictureFrame.setResizable(true);
        this.pictureFrame.getContentPane().setLayout(new BorderLayout());
        this.pictureFrame.setDefaultCloseOperation(2);
        this.pictureFrame.setTitle(this.picture.getTitle());
        PictureExplorerFocusTraversalPolicy newPolicy = new PictureExplorerFocusTraversalPolicy();
        this.pictureFrame.setFocusTraversalPolicy(newPolicy);
    }

    private void setUpMenuBar() {
        this.menuBar = new JMenuBar();
        this.zoomMenu = new JMenu(Messages.getString("Zoom"));
        this.twentyFive = new JMenuItem("25%");
        this.fifty = new JMenuItem("50%");
        this.seventyFive = new JMenuItem("75%");
        this.hundred = new JMenuItem("100%");
        this.hundred.setEnabled(false);
        this.hundredFifty = new JMenuItem("150%");
        this.twoHundred = new JMenuItem("200%");
        this.fiveHundred = new JMenuItem("500%");
        this.twentyFive.addActionListener(this);
        this.fifty.addActionListener(this);
        this.seventyFive.addActionListener(this);
        this.hundred.addActionListener(this);
        this.hundredFifty.addActionListener(this);
        this.twoHundred.addActionListener(this);
        this.fiveHundred.addActionListener(this);
        this.zoomMenu.add(this.twentyFive);
        this.zoomMenu.add(this.fifty);
        this.zoomMenu.add(this.seventyFive);
        this.zoomMenu.add(this.hundred);
        this.zoomMenu.add(this.hundredFifty);
        this.zoomMenu.add(this.twoHundred);
        this.zoomMenu.add(this.fiveHundred);
        this.menuBar.add(this.zoomMenu);
        this.pictureFrame.setJMenuBar(this.menuBar);
    }

    private void createAndInitScrollingImage() {
        this.scrollPane = new JScrollPane();
        BufferedImage bimg = this.picture.getBufferedImage();
        this.imageDisplay = new ImageDisplay(bimg);
        this.imageDisplay.addMouseMotionListener(this);
        this.imageDisplay.addMouseListener(this);
        this.imageDisplay.setToolTipText(Messages.getString("Click_a_mouse_button_on_a_pixel_to_see_the_pixel_information"));
        this.scrollPane.setViewportView(this.imageDisplay);
        this.pictureFrame.getContentPane().add((Component)this.scrollPane, "Center");
    }

    private void createWindow() {
        this.createAndInitPictureFrame();
        this.setUpMenuBar();
        this.createInfoPanel();
        this.createAndInitScrollingImage();
        this.pictureFrame.pack();
        this.pictureFrame.setVisible(true);
    }

    private void setUpNextAndPreviousButtons() {
        ImageIcon prevIcon = new ImageIcon(SoundExplorer.class.getResource("leftArrow.gif"), Messages.getString("previous_index"));
        ImageIcon nextIcon = new ImageIcon(SoundExplorer.class.getResource("rightArrow.gif"), Messages.getString("next_index"));
        this.xPrevButton = new JButton(prevIcon);
        this.xNextButton = new JButton(nextIcon);
        this.yPrevButton = new JButton(prevIcon);
        this.yNextButton = new JButton(nextIcon);
        this.xNextButton.setToolTipText(Messages.getString("Click_to_go_to_the_next_x_value"));
        this.xPrevButton.setToolTipText(Messages.getString("Click_to_go_to_the_previous_x_value"));
        this.yNextButton.setToolTipText(Messages.getString("Click_to_go_to_the_next_y_value"));
        this.yPrevButton.setToolTipText(Messages.getString("Click_to_go_to_the_previous_y_value"));
        int prevWidth = prevIcon.getIconWidth() + 2;
        int nextWidth = nextIcon.getIconWidth() + 2;
        int prevHeight = prevIcon.getIconHeight() + 2;
        int nextHeight = nextIcon.getIconHeight() + 2;
        Dimension prevDimension = new Dimension(prevWidth, prevHeight);
        Dimension nextDimension = new Dimension(nextWidth, nextHeight);
        this.xPrevButton.setPreferredSize(prevDimension);
        this.yPrevButton.setPreferredSize(prevDimension);
        this.xNextButton.setPreferredSize(nextDimension);
        this.yNextButton.setPreferredSize(nextDimension);
        this.xPrevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PictureExplorer pictureExplorer = PictureExplorer.this;
                pictureExplorer.xIndex = pictureExplorer.xIndex - 1;
                if (PictureExplorer.this.xIndex < 0) {
                    PictureExplorer.this.xIndex = 0;
                }
                PictureExplorer.this.displayPixelInformation(PictureExplorer.this.xIndex, PictureExplorer.this.yIndex);
            }
        });
        this.yPrevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PictureExplorer pictureExplorer = PictureExplorer.this;
                pictureExplorer.yIndex = pictureExplorer.yIndex - 1;
                if (PictureExplorer.this.yIndex < 0) {
                    PictureExplorer.this.yIndex = 0;
                }
                PictureExplorer.this.displayPixelInformation(PictureExplorer.this.xIndex, PictureExplorer.this.yIndex);
            }
        });
        this.xNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PictureExplorer pictureExplorer = PictureExplorer.this;
                pictureExplorer.xIndex = pictureExplorer.xIndex + 1;
                if (PictureExplorer.this.xIndex >= PictureExplorer.this.picture.getWidth()) {
                    PictureExplorer.this.xIndex = PictureExplorer.this.picture.getWidth() - 1;
                }
                PictureExplorer.this.displayPixelInformation(PictureExplorer.this.xIndex, PictureExplorer.this.yIndex);
            }
        });
        this.yNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PictureExplorer pictureExplorer = PictureExplorer.this;
                pictureExplorer.yIndex = pictureExplorer.yIndex + 1;
                if (PictureExplorer.this.yIndex >= PictureExplorer.this.picture.getHeight()) {
                    PictureExplorer.this.yIndex = PictureExplorer.this.picture.getHeight() - 1;
                }
                PictureExplorer.this.displayPixelInformation(PictureExplorer.this.xIndex, PictureExplorer.this.yIndex);
            }
        });
    }

    public JPanel createLocationPanel(Font labelFont) {
        JPanel locationPanel = new JPanel();
        locationPanel.setLayout(new FlowLayout());
        Box hBox = Box.createHorizontalBox();
        this.xLabel = new JLabel("X:");
        this.yLabel = new JLabel("Y:");
        this.xValue = new JTextField(Integer.toString(this.xIndex + this.numberBase), 6);
        this.xValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PictureExplorer.this.displayPixelInformation(PictureExplorer.this.xValue.getText(), PictureExplorer.this.yValue.getText());
            }
        });
        this.yValue = new JTextField(Integer.toString(this.yIndex + this.numberBase), 6);
        this.yValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PictureExplorer.this.displayPixelInformation(PictureExplorer.this.xValue.getText(), PictureExplorer.this.yValue.getText());
            }
        });
        this.setUpNextAndPreviousButtons();
        this.xLabel.setFont(labelFont);
        this.yLabel.setFont(labelFont);
        this.xValue.setFont(labelFont);
        this.yValue.setFont(labelFont);
        hBox.add(Box.createHorizontalGlue());
        hBox.add(this.xLabel);
        hBox.add(this.xPrevButton);
        hBox.add(this.xValue);
        hBox.add(this.xNextButton);
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(this.yLabel);
        hBox.add(this.yPrevButton);
        hBox.add(this.yValue);
        hBox.add(this.yNextButton);
        locationPanel.add(hBox);
        hBox.add(Box.createHorizontalGlue());
        return locationPanel;
    }

    private JPanel createColorInfoPanel(Font labelFont) {
        JPanel colorInfoPanel = new JPanel();
        colorInfoPanel.setLayout(new FlowLayout());
        Pixel pixel = new Pixel(this.picture, this.xIndex, this.yIndex);
        this.rValue = new JLabel("R: " + pixel.getRed());
        this.gValue = new JLabel("G: " + pixel.getGreen());
        this.bValue = new JLabel("B: " + pixel.getBlue());
        this.colorLabel = new JLabel(Messages.getString("Color_at_location__"));
        this.colorPanel = new JPanel();
        this.colorPanel.setBorder(new LineBorder(Color.black, 1));
        this.colorPanel.setBackground(pixel.getColor());
        this.rValue.setFont(labelFont);
        this.gValue.setFont(labelFont);
        this.bValue.setFont(labelFont);
        this.colorLabel.setFont(labelFont);
        this.colorPanel.setPreferredSize(new Dimension(25, 25));
        colorInfoPanel.add(this.rValue);
        colorInfoPanel.add(this.gValue);
        colorInfoPanel.add(this.bValue);
        colorInfoPanel.add(this.colorLabel);
        colorInfoPanel.add(this.colorPanel);
        return colorInfoPanel;
    }

    private void createInfoPanel() {
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        Font largerFont = new Font(infoPanel.getFont().getName(), infoPanel.getFont().getStyle(), 14);
        JPanel locationPanel = this.createLocationPanel(largerFont);
        JPanel colorInfoPanel = this.createColorInfoPanel(largerFont);
        infoPanel.add("North", locationPanel);
        infoPanel.add("South", colorInfoPanel);
        this.pictureFrame.getContentPane().add("North", infoPanel);
    }

    public void checkScroll() {
        int xPos = (int)((double)this.xIndex * this.zoomFactor);
        int yPos = (int)((double)this.yIndex * this.zoomFactor);
        if (this.zoomFactor > 1.0) {
            JViewport viewport = this.scrollPane.getViewport();
            Rectangle rect = viewport.getViewRect();
            int rectMinX = (int)rect.getX();
            int rectWidth = (int)rect.getWidth();
            int rectMaxX = rectMinX + rectWidth - 1;
            int rectMinY = (int)rect.getY();
            int rectHeight = (int)rect.getHeight();
            int rectMaxY = rectMinY + rectHeight - 1;
            int maxIndexX = (int)((double)this.picture.getWidth() * this.zoomFactor) - rectWidth - 1;
            int maxIndexY = (int)((double)this.picture.getHeight() * this.zoomFactor) - rectHeight - 1;
            int viewX = xPos - rectWidth / 2;
            int viewY = yPos - rectHeight / 2;
            if (viewX < 0) {
                viewX = 0;
            } else if (viewX > maxIndexX) {
                viewX = maxIndexX;
            }
            if (viewY < 0) {
                viewY = 0;
            } else if (viewY > maxIndexY) {
                viewY = maxIndexY;
            }
            viewport.scrollRectToVisible(new Rectangle(viewX, viewY, rectWidth, rectHeight));
        }
    }

    public void zoom(double factor) {
        this.zoomFactor = factor;
        int width = (int)((double)this.picture.getWidth() * this.zoomFactor);
        int height = (int)((double)this.picture.getHeight() * this.zoomFactor);
        BufferedImage bimg = this.picture.getBufferedImage();
        this.imageDisplay.setImage(bimg.getScaledInstance(width, height, 1));
        this.imageDisplay.setCurrentX((int)((double)this.xIndex * this.zoomFactor));
        this.imageDisplay.setCurrentY((int)((double)this.yIndex * this.zoomFactor));
        this.imageDisplay.revalidate();
        this.checkScroll();
    }

    public void repaint() {
        this.pictureFrame.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.displayPixelInformation(e);
    }

    private boolean isLocationInPicture(int x, int y) {
        boolean result = false;
        if (x >= 0 && x < this.picture.getWidth() && y >= 0 && y < this.picture.getHeight()) {
            result = true;
        }
        return result;
    }

    public void displayPixelInformation(String xString, String yString) {
        int x = -1;
        int y = -1;
        try {
            x = Integer.parseInt(xString);
            x -= this.numberBase;
            y = Integer.parseInt(yString);
            y -= this.numberBase;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (x >= 0 && y >= 0) {
            this.displayPixelInformation(x, y);
        }
    }

    private void displayPixelInformation(int pictureX, int pictureY) {
        if (this.isLocationInPicture(pictureX, pictureY)) {
            this.xIndex = pictureX;
            this.yIndex = pictureY;
            Pixel pixel = new Pixel(this.picture, this.xIndex, this.yIndex);
            this.xValue.setText(Integer.toString(this.xIndex + this.numberBase));
            this.yValue.setText(Integer.toString(this.yIndex + this.numberBase));
            this.rValue.setText("R: " + pixel.getRed());
            this.gValue.setText("G: " + pixel.getGreen());
            this.bValue.setText("B: " + pixel.getBlue());
            this.colorPanel.setBackground(new Color(pixel.getRed(), pixel.getGreen(), pixel.getBlue()));
        } else {
            this.clearInformation();
        }
        this.imageDisplay.setCurrentX((int)((double)this.xIndex * this.zoomFactor));
        this.imageDisplay.setCurrentY((int)((double)this.yIndex * this.zoomFactor));
    }

    private void displayPixelInformation(MouseEvent e) {
        int cursorX = e.getX();
        int cursorY = e.getY();
        int pictureX = (int)((double)cursorX / this.zoomFactor + (double)this.numberBase);
        int pictureY = (int)((double)cursorY / this.zoomFactor + (double)this.numberBase);
        this.displayPixelInformation(pictureX, pictureY);
    }

    private void clearInformation() {
        this.xValue.setText("N/A");
        this.yValue.setText("N/A");
        this.rValue.setText("R: N/A");
        this.gValue.setText("G: N/A");
        this.bValue.setText("B: N/A");
        this.colorPanel.setBackground(Color.black);
        this.xIndex = -1;
        this.yIndex = -1;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.displayPixelInformation(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.displayPixelInformation(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void enableZoomItems() {
        this.twentyFive.setEnabled(true);
        this.fifty.setEnabled(true);
        this.seventyFive.setEnabled(true);
        this.hundred.setEnabled(true);
        this.hundredFifty.setEnabled(true);
        this.twoHundred.setEnabled(true);
        this.fiveHundred.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        if (a.getActionCommand().equals(Messages.getString("Update"))) {
            this.repaint();
        }
        if (a.getActionCommand().equals("25%")) {
            this.zoom(0.25);
            this.enableZoomItems();
            this.twentyFive.setEnabled(false);
        }
        if (a.getActionCommand().equals("50%")) {
            this.zoom(0.5);
            this.enableZoomItems();
            this.fifty.setEnabled(false);
        }
        if (a.getActionCommand().equals("75%")) {
            this.zoom(0.75);
            this.enableZoomItems();
            this.seventyFive.setEnabled(false);
        }
        if (a.getActionCommand().equals("100%")) {
            this.zoom(1.0);
            this.enableZoomItems();
            this.hundred.setEnabled(false);
        }
        if (a.getActionCommand().equals("150%")) {
            this.zoom(1.5);
            this.enableZoomItems();
            this.hundredFifty.setEnabled(false);
        }
        if (a.getActionCommand().equals("200%")) {
            this.zoom(2.0);
            this.enableZoomItems();
            this.twoHundred.setEnabled(false);
        }
        if (a.getActionCommand().equals("500%")) {
            this.zoom(5.0);
            this.enableZoomItems();
            this.fiveHundred.setEnabled(false);
        }
    }

    private class PictureExplorerFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private PictureExplorerFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PictureExplorer.this.xValue)) {
                return PictureExplorer.this.yValue;
            }
            return PictureExplorer.this.xValue;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PictureExplorer.this.xValue)) {
                return PictureExplorer.this.yValue;
            }
            return PictureExplorer.this.xValue;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return PictureExplorer.this.xValue;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return PictureExplorer.this.yValue;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return PictureExplorer.this.xValue;
        }
    }
}

