/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import movieMaker.FileChooser;
import movieMaker.JpegImagesToMovie;
import movieMaker.Picture;

public class MovieWriter {
    private String framesDir = null;
    private int frameRate = 16;
    private String movieName = null;
    private String movieDir = null;
    private String outputURL = null;

    public MovieWriter() {
        this.movieDir = this.framesDir = FileChooser.pickADirectory();
        this.movieName = this.getMovieName();
        this.outputURL = this.getOutputURL();
    }

    public MovieWriter(String dirPath) {
        this.framesDir = dirPath;
        this.movieName = this.getMovieName();
        this.movieDir = this.framesDir;
        this.outputURL = this.getOutputURL();
    }

    public MovieWriter(int theFrameRate) {
        this.framesDir = FileChooser.pickADirectory();
        this.frameRate = theFrameRate;
        this.movieDir = this.framesDir;
        this.movieName = this.getMovieName();
        this.outputURL = this.getOutputURL();
    }

    public MovieWriter(int theFrameRate, String theFramesDir) {
        this.framesDir = theFramesDir;
        this.frameRate = theFrameRate;
        this.movieDir = this.framesDir;
        this.movieName = this.getMovieName();
        this.outputURL = this.getOutputURL();
    }

    public MovieWriter(int theFrameRate, String theFramesDir, String theMovieName) {
        this.framesDir = theFramesDir;
        this.frameRate = theFrameRate;
        this.movieDir = this.framesDir;
        this.movieName = theMovieName;
        this.outputURL = this.getOutputURL();
    }

    public MovieWriter(int theFrameRate, String theFramesDir, String theMovieName, String theMovieDir) {
        this.framesDir = theFramesDir;
        this.frameRate = theFrameRate;
        this.movieDir = theMovieDir;
        this.movieName = theMovieName;
        this.outputURL = this.getOutputURL();
    }

    public MovieWriter(String theFramesDir, int theFrameRate, String theOutputURL) {
        this.framesDir = theFramesDir;
        this.frameRate = theFrameRate;
        this.outputURL = theOutputURL;
        this.movieDir = theFramesDir;
    }

    private String getMovieName() {
        File dir = new File(this.framesDir);
        return dir.getName();
    }

    private String getOutputURL() {
        File dir = null;
        URL myURL = null;
        if (this.framesDir != null) {
            try {
                dir = new File(String.valueOf(this.movieDir) + this.movieName);
                myURL = dir.toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myURL.toString();
    }

    public List getFrameNames() {
        File dir = new File(this.framesDir);
        String[] filesArray = dir.list();
        ArrayList<String> files = new ArrayList<String>();
        long lenFirst = 0L;
        int x = 0;
        while (x < filesArray.length) {
            String fileName = filesArray[x];
            if (fileName.indexOf(".jpg") >= 0) {
                File f = new File(String.valueOf(this.framesDir) + fileName);
                if (lenFirst == 0L || f.length() > lenFirst / 2L) {
                    try {
                        BufferedImage i = ImageIO.read(f);
                        files.add(String.valueOf(this.framesDir) + fileName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (lenFirst == 0L) {
                    lenFirst = f.length();
                }
            }
            ++x;
        }
        return files;
    }

    public boolean writeAVI() {
        JpegImagesToMovie imageToMovie = new JpegImagesToMovie();
        List frameNames = this.getFrameNames();
        Picture p = new Picture((String)frameNames.get(0));
        return imageToMovie.doItAVI(p.getWidth(), p.getHeight(), this.frameRate, frameNames, String.valueOf(this.outputURL) + ".avi");
    }

    public boolean writeQuicktime() {
        JpegImagesToMovie imageToMovie = new JpegImagesToMovie();
        List frameNames = this.getFrameNames();
        Picture p = new Picture((String)frameNames.get(0));
        return imageToMovie.doItQuicktime(p.getWidth(), p.getHeight(), this.frameRate, frameNames, String.valueOf(this.outputURL) + ".mov");
    }
}

