/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.io.IOException;
import java.util.Vector;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;

public class Merge
implements ControllerListener,
DataSinkListener {
    Processor[] processors = null;
    String outputFile = null;
    String videoEncoding = "JPEG";
    String audioEncoding = "LINEAR";
    String outputType = "video.quicktime";
    DataSource[] dataOutputs = null;
    DataSource merger = null;
    DataSource outputDataSource;
    Processor outputProcessor;
    ProcessorModel outputPM;
    DataSink outputDataSink;
    MediaLocator outputLocator;
    boolean done = false;
    VideoFormat videoFormat = null;
    AudioFormat audioFormat = null;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public Merge(String output) {
        this.outputFile = output;
    }

    public Merge(String output, String outputTy) {
        this.outputFile = output;
        this.outputType = outputTy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge(Vector sourcesURLs) {
        this.processors = new Processor[sourcesURLs.size()];
        this.dataOutputs = new DataSource[sourcesURLs.size()];
        int i = 0;
        while (i < sourcesURLs.size()) {
            String source = (String)sourcesURLs.elementAt(i);
            MediaLocator ml = new MediaLocator(source);
            MyPM pm = new MyPM(ml);
            try {
                this.processors[i] = Manager.createRealizedProcessor((ProcessorModel)pm);
                this.dataOutputs[i] = this.processors[i].getDataOutput();
                this.processors[i].start();
            }
            catch (Exception e) {
                System.err.println(String.valueOf(Messages.getString("Failed_to_create_a_processor__")) + e);
            }
            ++i;
        }
        try {
            this.merger = Manager.createMergingDataSource((DataSource[])this.dataOutputs);
            this.merger.connect();
            this.merger.start();
        }
        catch (Exception ex) {
            System.err.println(String.valueOf(Messages.getString("Failed_to_merge_data_sources_")) + ex);
        }
        if (this.merger == null) {
            System.err.println(Messages.getString("Failed_to_merge_data_sources_"));
        }
        MyPMOut outputPM = new MyPMOut(this.merger);
        try {
            this.outputProcessor = Manager.createRealizedProcessor((ProcessorModel)outputPM);
            this.outputDataSource = this.outputProcessor.getDataOutput();
        }
        catch (Exception exc) {
            System.err.println(String.valueOf(Messages.getString("Failed_to_create_output_processor__")) + exc);
        }
        while (this.outputDataSink == null) {
            try {
                this.outputLocator = new MediaLocator(this.outputFile);
                this.outputDataSink = Manager.createDataSink((DataSource)this.outputDataSource, (MediaLocator)this.outputLocator);
                this.outputDataSink.open();
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        this.outputProcessor.addControllerListener((ControllerListener)this);
        this.outputDataSink.addDataSinkListener((DataSinkListener)this);
        try {
            this.outputDataSink.start();
            this.outputProcessor.start();
        }
        catch (Exception excep) {
            System.err.println(String.valueOf(Messages.getString("Failed_to_start_file_writing__")) + excep);
        }
        this.waitForFileDone();
        if (this.outputDataSink != null) {
            this.outputDataSink.close();
            this.outputDataSink.removeDataSinkListener((DataSinkListener)this);
        }
        Merge excep = this;
        synchronized (excep) {
            if (this.outputProcessor != null) {
                this.outputProcessor.close();
                this.outputProcessor.removeControllerListener((ControllerListener)this);
            }
        }
        try {
            this.merger.stop();
            this.merger.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int ii = 0;
        while (ii < this.processors.length) {
            this.processors[ii].stop();
            this.processors[ii].close();
            this.processors[ii].deallocate();
            ++ii;
        }
    }

    private void showUsage() {
        System.err.println(Messages.getString("Usage__Merge__url1___url2____url3__________o__out_URL_____v__video_encoding_____a__audio_encoding_____t__content_type__"));
    }

    public void doSingle(DataSource ds) {
        DataSink dsink;
        Processor p = null;
        MediaLocator outML = new MediaLocator(this.outputFile);
        try {
            p = Manager.createProcessor((DataSource)ds);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("Cannot_create_a_processor_from_the_data_source_"));
        }
        p.addControllerListener((ControllerListener)this);
        p.configure();
        if (!this.waitForState(p, 180)) {
            System.err.println(Messages.getString("Failed_to_configure_the_processor_"));
        }
        p.setContentDescriptor(new ContentDescriptor("audio.x_wav"));
        TrackControl[] tcs = p.getTrackControls();
        Format[] f = tcs[0].getSupportedFormats();
        if (f == null || f.length <= 0) {
            System.err.println(String.valueOf(Messages.getString("The_mux_does_not_support_the_input_format__")) + tcs[0].getFormat());
        }
        tcs[0].setFormat(f[0]);
        p.realize();
        if (!this.waitForState(p, 300)) {
            System.err.println(Messages.getString("Failed_to_realize_the_processor_"));
        }
        while ((dsink = this.createDataSink(p, outML)) == null) {
        }
        dsink.addDataSinkListener((DataSinkListener)this);
        this.fileDone = false;
        try {
            p.start();
            dsink.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.waitForFileDone();
        try {
            dsink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.removeControllerListener((ControllerListener)this);
        dsink.removeDataSinkListener((DataSinkListener)this);
        p.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            System.err.println(Messages.getString("Something_is_really_wrong__the_processor_does_not_have_an_output_DataSource"));
            return null;
        }
        try {
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
            dsink.open();
        }
        catch (Exception e) {
            return null;
        }
        return dsink;
    }

    class MyPM
    extends ProcessorModel {
        MediaLocator inputLocator;

        public MyPM(MediaLocator inputLocator) {
            this.inputLocator = inputLocator;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public DataSource getInputDataSource() {
            return null;
        }

        public MediaLocator getInputLocator() {
            return this.inputLocator;
        }

        public Format getOutputTrackFormat(int index) {
            return null;
        }

        public int getTrackCount(int n) {
            return n;
        }

        public boolean isFormatAcceptable(int index, Format format) {
            if (Merge.this.videoFormat == null) {
                Merge.this.videoFormat = new VideoFormat(Merge.this.videoEncoding);
            }
            if (Merge.this.audioFormat == null) {
                Merge.this.audioFormat = new AudioFormat(Merge.this.audioEncoding);
            }
            return format.matches((Format)Merge.this.videoFormat) || format.matches((Format)Merge.this.audioFormat);
        }
    }

    class MyPMOut
    extends ProcessorModel {
        DataSource inputDataSource;

        public MyPMOut(DataSource inputDataSource) {
            this.inputDataSource = inputDataSource;
        }

        public ContentDescriptor getContentDescriptor() {
            return new FileTypeDescriptor(Merge.this.outputType);
        }

        public DataSource getInputDataSource() {
            return this.inputDataSource;
        }

        public MediaLocator getInputLocator() {
            return null;
        }

        public Format getOutputTrackFormat(int index) {
            return null;
        }

        public int getTrackCount(int n) {
            return n;
        }

        public boolean isFormatAcceptable(int index, Format format) {
            if (Merge.this.videoFormat == null) {
                Merge.this.videoFormat = new VideoFormat(Merge.this.videoEncoding);
            }
            if (Merge.this.audioFormat == null) {
                Merge.this.audioFormat = new AudioFormat(Merge.this.audioEncoding);
            }
            return format.matches((Format)Merge.this.videoFormat) || format.matches((Format)Merge.this.audioFormat);
        }
    }
}

