/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;

public class JpegImagesToMovie
implements ControllerListener,
DataSinkListener {
    private int fRate = 16;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public boolean doItQuicktime(int width, int height, int frameRate, List inFiles, MediaLocator outML) {
        this.fRate = frameRate;
        return this.doIt(width, height, frameRate, inFiles, outML, "video.quicktime");
    }

    public boolean doItQuicktime(int width, int height, int frameRate, List inFiles, String outputURL) {
        this.fRate = frameRate;
        MediaLocator oml = JpegImagesToMovie.createMediaLocator(outputURL);
        return this.doItQuicktime(width, height, frameRate, inFiles, oml);
    }

    public boolean doItAVI(int width, int height, int frameRate, List inFiles, String outputURL) {
        this.fRate = frameRate;
        MediaLocator oml = JpegImagesToMovie.createMediaLocator(outputURL);
        return this.doItAVI(width, height, frameRate, inFiles, oml);
    }

    public boolean doItAVI(int width, int height, int frameRate, List inFiles, MediaLocator outML) {
        this.fRate = frameRate;
        return this.doItAVI(width, height, frameRate, inFiles, outML, "video.x_msvideo");
    }

    public boolean doIt(int width, int height, int frameRate, List inFiles, MediaLocator outML, String type) {
        DataSink dsink;
        Processor p;
        this.fRate = frameRate;
        ImageDataSource ids = new ImageDataSource(width, height, frameRate, inFiles);
        try {
            p = Manager.createProcessor((DataSource)ids);
        }
        catch (Exception e) {
            return false;
        }
        p.addControllerListener((ControllerListener)this);
        p.configure();
        if (!this.waitForState(p, 180)) {
            return false;
        }
        p.setContentDescriptor(new ContentDescriptor(type));
        TrackControl[] tcs = p.getTrackControls();
        Format[] f = tcs[0].getSupportedFormats();
        if (f == null || f.length <= 0) {
            return false;
        }
        tcs[0].setFormat(f[0]);
        p.realize();
        if (!this.waitForState(p, 300)) {
            return false;
        }
        while ((dsink = this.createDataSink(p, outML)) == null) {
        }
        dsink.addDataSinkListener((DataSinkListener)this);
        this.fileDone = false;
        try {
            p.start();
            dsink.start();
        }
        catch (IOException e) {
            return false;
        }
        this.waitForFileDone();
        try {
            dsink.removeDataSinkListener((DataSinkListener)this);
            dsink.stop();
            dsink.close();
        }
        catch (Exception e) {
            System.err.println(Messages.getString("DataSink_did_not_close"));
        }
        p.removeControllerListener((ControllerListener)this);
        p.close();
        p.deallocate();
        return true;
    }

    public boolean doItAVI(int width, int height, int frameRate, List inFiles, MediaLocator outML, String type) {
        Processor p;
        ImageDataSource ids = new ImageDataSource(width, height, frameRate, inFiles);
        try {
            System.err.println(Messages.getString("__create_processor_for_the_image_datasource____"));
            p = Manager.createProcessor((DataSource)ids);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("Yikes____Cannot_create_a_processor_from_the_data_source_"));
            return false;
        }
        p.addControllerListener((ControllerListener)this);
        p.configure();
        if (!this.waitForState(p, 180)) {
            System.err.println(Messages.getString("Failed_to_configure_the_processor_"));
            return false;
        }
        p.setContentDescriptor(new ContentDescriptor(type));
        TrackControl[] tcs = p.getTrackControls();
        TrackControl[] arrTrackControls = p.getTrackControls();
        int i = 0;
        while (i < arrTrackControls.length) {
            Format format = arrTrackControls[i].getFormat();
            if (format instanceof VideoFormat) {
                arrTrackControls[i].setFormat((Format)new VideoFormat("rgb"));
            }
            ++i;
        }
        p.realize();
        if (!this.waitForState(p, 300)) {
            System.err.println(Messages.getString("Failed_to_realize_the_processor_"));
            return false;
        }
        DataSink dsink = this.createDataSink(p, outML);
        if (dsink == null) {
            System.err.println(String.valueOf(Messages.getString("Failed_to_create_a_DataSink_for_the_given_output_MediaLocator__")) + outML);
            return false;
        }
        dsink.addDataSinkListener((DataSinkListener)this);
        this.fileDone = false;
        System.err.println(Messages.getString("start_processing___"));
        try {
            p.start();
            dsink.start();
        }
        catch (IOException e) {
            System.err.println(Messages.getString("IO_error_during_processing"));
            return false;
        }
        this.waitForFileDone();
        try {
            dsink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.removeControllerListener((ControllerListener)this);
        p.close();
        p.deallocate();
        return true;
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            return null;
        }
        try {
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
        }
        catch (Exception e) {
            return null;
        }
        if (dsink == null) {
            return null;
        }
        try {
            dsink.open();
        }
        catch (SecurityException e) {
            try {
                dsink.stop();
            }
            catch (IOException e1) {
                return null;
            }
            dsink.close();
            return null;
        }
        catch (IOException e) {
            try {
                dsink.stop();
            }
            catch (IOException e1) {
                dsink.close();
                return null;
            }
            dsink.close();
            return null;
        }
        return dsink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    public static void main(String[] args) {
        MediaLocator oml;
        if (args.length == 0) {
            JpegImagesToMovie.prUsage();
        }
        int i = 0;
        int width = -1;
        int height = -1;
        int frameRate = 1;
        ArrayList<String> inputFiles = new ArrayList<String>();
        String outputURL = null;
        while (i < args.length) {
            if (args[i].equals("-w")) {
                if (++i >= args.length) {
                    JpegImagesToMovie.prUsage();
                }
                width = new Integer(args[i]);
            } else if (args[i].equals("-h")) {
                if (++i >= args.length) {
                    JpegImagesToMovie.prUsage();
                }
                height = new Integer(args[i]);
            } else if (args[i].equals("-f")) {
                if (++i >= args.length) {
                    JpegImagesToMovie.prUsage();
                }
                frameRate = new Integer(args[i]);
            } else if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    JpegImagesToMovie.prUsage();
                }
                outputURL = args[i];
            } else {
                inputFiles.add(args[i]);
            }
            ++i;
        }
        if (outputURL == null || inputFiles.size() == 0) {
            JpegImagesToMovie.prUsage();
        }
        if (!outputURL.endsWith(".mov") && !outputURL.endsWith(".MOV")) {
            System.err.println(Messages.getString("The_output_file_extension_should_end_with_a__mov_extension"));
            JpegImagesToMovie.prUsage();
        }
        if (width < 0 || height < 0) {
            System.err.println(Messages.getString("Please_specify_the_correct_image_size_"));
            JpegImagesToMovie.prUsage();
        }
        if (frameRate < 1) {
            frameRate = 1;
        }
        if ((oml = JpegImagesToMovie.createMediaLocator(outputURL)) == null) {
            System.err.println(String.valueOf(Messages.getString("Cannot_build_media_locator_from__")) + outputURL);
            System.exit(0);
        }
        JpegImagesToMovie imageToMovie = new JpegImagesToMovie();
        imageToMovie.doItQuicktime(width, height, frameRate, inputFiles, oml);
        System.exit(0);
    }

    static void prUsage() {
        System.err.println(Messages.getString("Usage__java_JpegImagesToMovie__w__width___h__height___f__frame_rate___o__output_URL___input_JPEG_file_1___input_JPEG_file_2_____"));
        System.exit(-1);
    }

    static MediaLocator createMediaLocator(String url) {
        String file;
        MediaLocator ml;
        if (url.indexOf(":") > 0 && (ml = new MediaLocator(url)) != null) {
            return ml;
        }
        if (url.startsWith(File.separator) ? (ml = new MediaLocator("file:" + url)) != null : (ml = new MediaLocator(file = "file:" + System.getProperty("user.dir") + File.separator + url)) != null) {
            return ml;
        }
        return null;
    }

    class ImageDataSource
    extends PullBufferDataSource {
        ImageSourceStream[] streams = new ImageSourceStream[1];

        ImageDataSource(int width, int height, int frameRate, List images) {
            this.streams[0] = new ImageSourceStream(width, height, frameRate, images);
        }

        public void setLocator(MediaLocator source) {
        }

        public MediaLocator getLocator() {
            return null;
        }

        public String getContentType() {
            return "raw";
        }

        public void connect() {
        }

        public void disconnect() {
        }

        public void start() {
        }

        public void stop() {
        }

        public PullBufferStream[] getStreams() {
            return this.streams;
        }

        public Time getDuration() {
            return DURATION_UNKNOWN;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }

    class ImageSourceStream
    implements PullBufferStream {
        List images;
        int width;
        int height;
        VideoFormat format;
        long frame = 0L;
        int nextImage = 0;
        boolean ended = false;

        public ImageSourceStream(int width, int height, int frameRate, List images) {
            this.width = width;
            this.height = height;
            this.images = images;
            this.format = new VideoFormat("jpeg", new Dimension(width, height), -1, Format.byteArray, (float)frameRate);
        }

        public boolean willReadBlock() {
            return false;
        }

        public void read(Buffer buf) throws IOException {
            if (this.nextImage >= this.images.size()) {
                buf.setEOM(true);
                buf.setOffset(0);
                buf.setLength(0);
                this.ended = true;
                return;
            }
            String imageFile = (String)this.images.get(this.nextImage);
            ++this.nextImage;
            RandomAccessFile raFile = new RandomAccessFile(imageFile, "r");
            byte[] data = null;
            if (buf.getData() instanceof byte[]) {
                data = (byte[])buf.getData();
            }
            if (data == null || (long)data.length < raFile.length()) {
                data = new byte[(int)raFile.length()];
                buf.setData((Object)data);
            }
            raFile.readFully(data, 0, (int)raFile.length());
            buf.setOffset(0);
            buf.setLength((int)raFile.length());
            buf.setFormat((Format)this.format);
            buf.setFlags(buf.getFlags() | 0x10);
            raFile.close();
        }

        public Format getFormat() {
            return this.format;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public long getContentLength() {
            return 0L;
        }

        public boolean endOfStream() {
            return this.ended;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }
}

