/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class ImageDisplay
extends JPanel
implements Scrollable {
    private Image image;
    private Dimension prefSize;
    private int currentX = 0;
    private int currentY = 0;

    public ImageDisplay(Image theImage) {
        this.image = theImage;
        this.prefSize = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        this.setPreferredSize(this.prefSize);
        this.revalidate();
    }

    public ImageDisplay(Image theImage, int x, int y) {
        this(theImage);
        this.currentX = x;
        this.currentY = y;
    }

    public Image getImage() {
        return this.image;
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public void setCurrentX(int x) {
        this.currentX = x;
        this.repaint();
    }

    public void setCurrentY(int y) {
        this.currentY = y;
        this.repaint();
    }

    public void setImage(Image theImage) {
        this.image = theImage;
        this.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.prefSize;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int num = 3;
        int xStart = this.currentX - num;
        int xEnd = this.currentX + num;
        int yStart = this.currentY - num;
        int yEnd = this.currentY + num;
        int width = this.image.getWidth(this);
        int maxX = width - 1;
        int height = this.image.getHeight(this);
        int maxY = height - 1;
        g.drawImage(this.image, 0, 0, this);
        if (this.currentX >= 0 && this.currentX < width && this.currentY >= 0 && this.currentY < height) {
            if (xStart < 0) {
                xStart = 0;
            }
            if (xEnd > maxX) {
                xEnd = maxX;
            }
            if (yStart < 0) {
                yStart = 0;
            }
            if (yEnd > maxY) {
                yEnd = maxY;
            }
            g.setColor(Color.yellow);
            g.drawLine(xStart, this.currentY, xEnd, this.currentY);
            g.drawLine(this.currentX, yStart, this.currentX, yEnd);
            g.setColor(Color.black);
            int leftX = this.currentX - 1;
            int rightX = this.currentX + 1;
            int upY = this.currentY - 1;
            int downY = this.currentY + 1;
            if (xStart <= leftX && upY >= 0) {
                g.drawLine(xStart, upY, leftX, upY);
            }
            if (yStart <= upY && leftX >= 0) {
                g.drawLine(leftX, yStart, leftX, upY);
            }
            if (yStart <= upY && rightX <= maxX) {
                g.drawLine(rightX, yStart, rightX, upY);
            }
            if (upY >= 0 && rightX <= xEnd) {
                g.drawLine(rightX, upY, xEnd, upY);
            }
            if (downY < height && rightX <= xEnd) {
                g.drawLine(rightX, downY, xEnd, downY);
            }
            if (downY <= yEnd && rightX < width) {
                g.drawLine(rightX, downY, rightX, yEnd);
            }
            if (xStart <= leftX && downY < height) {
                g.drawLine(xStart, downY, leftX, downY);
            }
            if (leftX >= 0 && downY <= yEnd) {
                g.drawLine(leftX, downY, leftX, yEnd);
            }
        }
    }
}

