/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import com.sun.media.MimeManager;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Control;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.FramePositioningControl;
import javax.media.control.QualityControl;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;

public class Cut
implements ControllerListener,
DataSinkListener {
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public static void main(String[] args) {
        Cut cut;
        MediaLocator oml;
        String inputURL = null;
        String outputURL = null;
        Vector<Long> startV = new Vector<Long>();
        Vector<Long> endV = new Vector<Long>();
        boolean frameMode = false;
        if (args.length == 0) {
            Cut.prUsage();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    Cut.prUsage();
                }
                outputURL = args[i];
            } else if (args[i].equals("-f")) {
                frameMode = true;
            } else if (args[i].equals("-s")) {
                if (++i >= args.length) {
                    Cut.prUsage();
                }
                startV.addElement(new Long(args[i]));
            } else if (args[i].equals("-e")) {
                if (++i >= args.length) {
                    Cut.prUsage();
                }
                endV.addElement(new Long(args[i]));
                if (startV.size() != endV.size()) {
                    if (startV.size() == 0) {
                        startV.addElement(new Long(0L));
                    } else {
                        Cut.prUsage();
                    }
                }
            } else {
                inputURL = args[i];
            }
            ++i;
        }
        if (inputURL == null) {
            System.err.println(Messages.getString("No_input_url_specified_"));
            Cut.prUsage();
        }
        if (outputURL == null) {
            System.err.println(Messages.getString("No_output_url_specified_"));
            Cut.prUsage();
        }
        if (startV.size() == 0 && endV.size() == 0) {
            System.err.println(Messages.getString("No_start_and_end_point_specified_"));
            Cut.prUsage();
        }
        if (startV.size() > endV.size()) {
            if (startV.size() == endV.size() + 1) {
                endV.addElement(new Long(Long.MAX_VALUE));
            } else {
                Cut.prUsage();
            }
        }
        long[] start = new long[startV.size()];
        long[] end = new long[startV.size()];
        long prevEnd = 0L;
        int j = 0;
        while (j < start.length) {
            start[j] = (Long)startV.elementAt(j);
            end[j] = (Long)endV.elementAt(j);
            if (prevEnd > start[j]) {
                System.err.println(Messages.getString("Previous_end_point_cannot_be___the_next_start_point_"));
                Cut.prUsage();
            } else if (start[j] >= end[j]) {
                System.err.println(Messages.getString("Start_point_cannot_be____end_point_"));
                Cut.prUsage();
            }
            prevEnd = end[j];
            ++j;
        }
        if (frameMode) {
            System.err.println(Messages.getString("Start_and_end_points_are_specified_in_frames_"));
        } else {
            j = 0;
            while (j < start.length) {
                int n = j;
                start[n] = start[n] * 1000000L;
                if (end[j] != Long.MAX_VALUE) {
                    int n2 = j;
                    end[n2] = end[n2] * 1000000L;
                }
                System.err.println(String.valueOf(Messages.getString("Start__")) + start[j] + " " + Messages.getString("End__") + end[j]);
                ++j;
            }
        }
        MediaLocator iml = Cut.createMediaLocator(inputURL);
        if (iml == null) {
            System.err.println(String.valueOf(Messages.getString("Cannot_build_media_locator_from__")) + inputURL);
            System.exit(0);
        }
        if ((oml = Cut.createMediaLocator(outputURL)) == null) {
            System.err.println(String.valueOf(Messages.getString("Cannot_build_media_locator_from__")) + outputURL);
            System.exit(0);
        }
        if (!(cut = new Cut()).doIt(iml, oml, start, end, frameMode)) {
            System.err.println(Messages.getString("Failed_to_cut_the_input"));
        }
        System.exit(0);
    }

    public boolean doCut(String input, String output, Vector startV, Vector endV) {
        String inputURL = input;
        String outputURL = output;
        long[] start = new long[startV.size()];
        long[] end = new long[startV.size()];
        long prevEnd = 0L;
        int j = 0;
        while (j < start.length) {
            start[j] = (Long)startV.elementAt(j);
            end[j] = (Long)endV.elementAt(j);
            if (prevEnd > start[j]) {
                Cut.prUsage();
            } else if (start[j] >= end[j]) {
                Cut.prUsage();
            }
            prevEnd = end[j];
            ++j;
        }
        j = 0;
        while (j < start.length) {
            int n = j;
            start[n] = start[n] * 1000000L;
            if (end[j] != Long.MAX_VALUE) {
                int n2 = j;
                end[n2] = end[n2] * 1000000L;
            }
            ++j;
        }
        MediaLocator iml = Cut.createMediaLocator(inputURL);
        if (iml == null) {
            return false;
        }
        MediaLocator oml = Cut.createMediaLocator(outputURL);
        if (oml == null) {
            return false;
        }
        return this.doIt(iml, oml, start, end, false);
    }

    public boolean doIt(MediaLocator inML, MediaLocator outML, long[] start, long[] end, boolean frameMode) {
        DataSink dsink;
        Processor p;
        ContentDescriptor cd = this.fileExtToCD(outML.getRemainder());
        if (cd == null) {
            System.err.println(Messages.getString("Couldn_t_figure_out_from_the_file_extension_the_type_of_output_needed"));
            return false;
        }
        try {
            p = Manager.createProcessor((MediaLocator)inML);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(Messages.getString("Cannot_create_a_processor_from_the_given_url__")) + e);
            return false;
        }
        if (!this.waitForState(p, 180)) {
            System.err.println(Messages.getString("Failed_to_configure_the_processor_"));
            return false;
        }
        this.checkTrackFormats(p);
        if (!this.waitForState(p, 300)) {
            System.err.println(Messages.getString("Failed_to_realize_the_processor_"));
            return false;
        }
        this.setJPEGQuality((Player)p, 0.5f);
        if (frameMode) {
            FramePositioningControl fpc = (FramePositioningControl)p.getControl("javax.media.control.FramePositioningControl");
            if (fpc != null) {
                int i = 0;
                while (i < start.length) {
                    Time t = fpc.mapFrameToTime((int)start[i]);
                    if (t == FramePositioningControl.TIME_UNKNOWN) {
                        fpc = null;
                        break;
                    }
                    start[i] = t.getNanoseconds();
                    if (end[i] != Long.MAX_VALUE) {
                        t = fpc.mapFrameToTime((int)end[i]);
                        if (t == FramePositioningControl.TIME_UNKNOWN) {
                            fpc = null;
                            break;
                        }
                        end[i] = t.getNanoseconds();
                    }
                    ++i;
                }
            }
            if (fpc == null) {
                return false;
            }
        }
        SuperCutDataSource ds = new SuperCutDataSource(p, inML, start, end);
        try {
            p = Manager.createProcessor((DataSource)ds);
        }
        catch (Exception e) {
            return false;
        }
        p.addControllerListener((ControllerListener)this);
        if (!this.waitForState(p, 180)) {
            System.err.println(Messages.getString("Failed_to_configure_the_processor_"));
            return false;
        }
        if (p.setContentDescriptor(cd) == null) {
            System.err.println(Messages.getString("Failed_to_set_the_output_content_descriptor_on_the_processor_"));
            return false;
        }
        if (!this.waitForState(p, 500)) {
            System.err.println(Messages.getString("Failed_to_realize_the_processor_"));
            return false;
        }
        while ((dsink = this.createDataSink(p, outML)) == null) {
        }
        dsink.addDataSinkListener((DataSinkListener)this);
        this.fileDone = false;
        try {
            p.start();
            dsink.start();
        }
        catch (IOException e) {
            System.err.println(Messages.getString("IO_error_during_concatenation"));
            return false;
        }
        this.waitForFileDone();
        try {
            if (dsink != null) {
                dsink.close();
                dsink.removeDataSinkListener((DataSinkListener)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.removeControllerListener((ControllerListener)this);
        p.close();
        p.deallocate();
        return true;
    }

    void checkTrackFormats(Processor p) {
        TrackControl[] tc = p.getTrackControls();
        VideoFormat mpgVideo = new VideoFormat("mpeg");
        AudioFormat rawAudio = new AudioFormat("LINEAR");
        int i = 0;
        while (i < tc.length) {
            VideoFormat preferred = null;
            if (tc[i].getFormat().matches((Format)mpgVideo)) {
                preferred = new VideoFormat("jpeg");
            } else if (tc[i].getFormat() instanceof AudioFormat && !tc[i].getFormat().matches((Format)rawAudio)) {
                preferred = rawAudio;
            }
            if (preferred != null) {
                Format[] supported = tc[i].getSupportedFormats();
                Format selected = null;
                int j = 0;
                while (j < supported.length) {
                    if (supported[j].matches((Format)preferred)) {
                        selected = supported[j];
                        break;
                    }
                    ++j;
                }
                if (selected != null) {
                    System.err.println("  " + Messages.getString("Transcode_"));
                    System.err.println(String.valueOf(Messages.getString("from__")) + tc[i].getFormat());
                    System.err.println(String.valueOf(Messages.getString("to__")) + selected);
                    tc[i].setFormat(selected);
                }
            }
            ++i;
        }
    }

    void setJPEGQuality(Player p, float val) {
        Control[] cs = p.getControls();
        QualityControl qc = null;
        VideoFormat jpegFmt = new VideoFormat("jpeg");
        int i = 0;
        while (i < cs.length) {
            if (cs[i] instanceof QualityControl && cs[i] instanceof Owned) {
                Object owner = ((Owned)cs[i]).getOwner();
                if (owner instanceof Codec) {
                    Format[] fmts = ((Codec)owner).getSupportedOutputFormats(null);
                    int j = 0;
                    while (j < fmts.length) {
                        if (fmts[j].matches((Format)jpegFmt)) {
                            qc = (QualityControl)cs[i];
                            qc.setQuality(val);
                            System.err.println(String.valueOf(Messages.getString("__Set_quality_to_")) + val + " " + Messages.getString("on_") + qc);
                            break;
                        }
                        ++j;
                    }
                }
                if (qc != null) break;
            }
            ++i;
        }
    }

    boolean isRawAudio(Format fmt) {
        return fmt instanceof AudioFormat && fmt.getEncoding().equalsIgnoreCase("LINEAR");
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            System.err.println(Messages.getString("Something_is_really_wrong__the_processor_does_not_have_an_output_DataSource"));
            return null;
        }
        try {
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
            dsink.open();
        }
        catch (Exception e) {
            return null;
        }
        return dsink;
    }

    boolean waitForState(Processor p, int state) {
        return new StateWaiter(p).waitForState(state);
    }

    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ControllerErrorEvent) {
            System.err.println(Messages.getString("Failed_to_cut_the_file_"));
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait(1000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    ContentDescriptor fileExtToCD(String name) {
        String type;
        int p = name.lastIndexOf(46);
        if (p < 0) {
            return null;
        }
        String ext = name.substring(p + 1).toLowerCase();
        if (ext.equals("mp3")) {
            type = "audio.mpeg";
        } else if (ext.equals("wav")) {
            type = "audio.x_wav";
        } else {
            type = MimeManager.getMimeType((String)ext);
            if (type == null) {
                return null;
            }
            type = ContentDescriptor.mimeTypeToPackageName((String)type);
        }
        return new FileTypeDescriptor(type);
    }

    static MediaLocator createMediaLocator(String url) {
        String file;
        MediaLocator ml;
        if (url.indexOf(":") > 0 && (ml = new MediaLocator(url)) != null) {
            return ml;
        }
        if (url.startsWith(File.separator) ? (ml = new MediaLocator("file:" + url)) != null : (ml = new MediaLocator(file = "file:" + System.getProperty("user.dir") + File.separator + url)) != null) {
            return ml;
        }
        return null;
    }

    static void prUsage() {
    }

    public class StateWaiter
    implements ControllerListener {
        Processor p;
        boolean error = false;

        StateWaiter(Processor p) {
            this.p = p;
            p.addControllerListener((ControllerListener)this);
        }

        public synchronized boolean waitForState(int state) {
            switch (state) {
                case 180: {
                    this.p.configure();
                    break;
                }
                case 300: {
                    this.p.realize();
                    break;
                }
                case 500: {
                    this.p.prefetch();
                    break;
                }
                case 600: {
                    this.p.start();
                }
            }
            while (this.p.getState() < state && !this.error) {
                try {
                    this.wait(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return !this.error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerErrorEvent) {
                this.error = true;
            }
            StateWaiter stateWaiter = this;
            synchronized (stateWaiter) {
                this.notifyAll();
            }
        }
    }

    class SuperCutDataSource
    extends PushBufferDataSource {
        Processor p;
        MediaLocator ml;
        PushBufferDataSource ds;
        SuperCutStream[] streams;

        public SuperCutDataSource(Processor p, MediaLocator ml, long[] start, long[] end) {
            this.p = p;
            this.ml = ml;
            this.ds = (PushBufferDataSource)p.getDataOutput();
            TrackControl[] tcs = p.getTrackControls();
            PushBufferStream[] pbs = this.ds.getStreams();
            this.streams = new SuperCutStream[pbs.length];
            int i = 0;
            while (i < pbs.length) {
                this.streams[i] = new SuperCutStream(tcs[i], pbs[i], start, end);
                ++i;
            }
        }

        public void connect() throws IOException {
        }

        public PushBufferStream[] getStreams() {
            return this.streams;
        }

        public void start() throws IOException {
            this.p.start();
            this.ds.start();
        }

        public void stop() throws IOException {
        }

        public Object getControl(String name) {
            return null;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public Time getDuration() {
            return this.ds.getDuration();
        }

        public void disconnect() {
        }

        public String getContentType() {
            return "raw";
        }

        public MediaLocator getLocator() {
            return this.ml;
        }

        public void setLocator(MediaLocator ml) {
            System.err.println(Messages.getString("Not_interested_in_a_media_locator"));
        }
    }

    class SuperCutStream
    implements PushBufferStream,
    BufferTransferHandler {
        TrackControl tc;
        PushBufferStream pbs;
        long[] start;
        long[] end;
        boolean[] startReached;
        boolean[] endReached;
        int idx = 0;
        BufferTransferHandler bth;
        long timeStamp = 0L;
        long lastTS = 0L;
        int audioLen = 0;
        int audioElapsed = 0;
        boolean eos = false;
        Format format;
        Buffer buffer;
        int bufferFilled = 0;

        public SuperCutStream(TrackControl tc, PushBufferStream pbs, long[] start, long[] end) {
            this.tc = tc;
            this.pbs = pbs;
            this.start = start;
            this.end = end;
            this.startReached = new boolean[start.length];
            this.endReached = new boolean[end.length];
            int i = 0;
            while (i < start.length) {
                this.endReached[i] = false;
                this.startReached[i] = false;
                ++i;
            }
            this.buffer = new Buffer();
            pbs.setTransferHandler((BufferTransferHandler)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void processData() {
            Buffer buffer = this.buffer;
            synchronized (buffer) {
                while (this.bufferFilled == 1) {
                    try {
                        this.buffer.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                this.pbs.read(this.buffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.format = this.buffer.getFormat();
            if (this.idx >= this.end.length) {
                this.buffer.setOffset(0);
                this.buffer.setLength(0);
                this.buffer.setEOM(true);
            }
            if (this.buffer.isEOM()) {
                this.eos = true;
            }
            int len = this.buffer.getLength();
            if (this.checkTimeToSkip(this.buffer)) {
                if (Cut.this.isRawAudio(this.buffer.getFormat())) {
                    this.audioLen += len;
                }
                return;
            }
            if (Cut.this.isRawAudio(this.buffer.getFormat())) {
                this.audioLen += len;
            }
            Buffer buffer2 = this.buffer;
            synchronized (buffer2) {
                this.bufferFilled = 1;
                this.buffer.notifyAll();
            }
            if (this.bth != null) {
                this.bth.transferData((PushBufferStream)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void read(Buffer rdBuf) throws IOException {
            Buffer buffer = this.buffer;
            synchronized (buffer) {
                while (this.bufferFilled == 0) {
                    try {
                        this.buffer.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Object oldData = rdBuf.getData();
            rdBuf.copy(this.buffer);
            this.buffer.setData(oldData);
            if (Cut.this.isRawAudio(rdBuf.getFormat())) {
                rdBuf.setTimeStamp(this.computeDuration(this.audioElapsed, rdBuf.getFormat()));
                this.audioElapsed += this.buffer.getLength();
            } else if (rdBuf.getTimeStamp() != -1L) {
                long diff = rdBuf.getTimeStamp() - this.lastTS;
                this.lastTS = rdBuf.getTimeStamp();
                if (diff > 0L) {
                    this.timeStamp += diff;
                }
                rdBuf.setTimeStamp(this.timeStamp);
            }
            Buffer buffer2 = this.buffer;
            synchronized (buffer2) {
                this.bufferFilled = 0;
                this.buffer.notifyAll();
                return;
            }
        }

        boolean checkTimeToSkip(Buffer buf) {
            if (this.idx >= this.startReached.length) {
                return false;
            }
            if (!(this.eos || this.startReached[this.idx] || (this.startReached[this.idx] = this.checkStartTime(buf, this.start[this.idx])))) {
                return true;
            }
            if (!this.eos && !this.endReached[this.idx]) {
                this.endReached[this.idx] = this.checkEndTime(buf, this.end[this.idx]);
                if (this.endReached[this.idx]) {
                    ++this.idx;
                    return true;
                }
            } else if (this.endReached[this.idx]) {
                if (!this.eos) {
                    return true;
                }
                buf.setOffset(0);
                buf.setLength(0);
            }
            return false;
        }

        boolean checkStartTime(Buffer buf, long startTS) {
            if (Cut.this.isRawAudio(buf.getFormat())) {
                long ts = this.computeDuration(this.audioLen + buf.getLength(), buf.getFormat());
                if (ts > startTS) {
                    int len = this.computeLength(ts - startTS, buf.getFormat());
                    buf.setOffset(buf.getOffset() + buf.getLength() - len);
                    buf.setLength(len);
                    this.lastTS = buf.getTimeStamp();
                    return true;
                }
            } else if (buf.getTimeStamp() >= startTS) {
                if (buf.getFormat() instanceof VideoFormat) {
                    if ((buf.getFlags() & 0x10) != 0) {
                        this.lastTS = buf.getTimeStamp();
                        return true;
                    }
                } else {
                    this.lastTS = buf.getTimeStamp();
                    return true;
                }
            }
            return false;
        }

        boolean checkEndTime(Buffer buf, long endTS) {
            if (Cut.this.isRawAudio(buf.getFormat())) {
                if (this.computeDuration(this.audioLen, buf.getFormat()) >= endTS) {
                    return true;
                }
                long ts = this.computeDuration(this.audioLen + buf.getLength(), buf.getFormat());
                if (ts >= endTS) {
                    int len = this.computeLength(ts - endTS, buf.getFormat());
                    buf.setLength(buf.getLength() - len);
                }
            } else if (buf.getTimeStamp() > endTS) {
                return true;
            }
            return false;
        }

        public long computeDuration(int len, Format fmt) {
            if (!(fmt instanceof AudioFormat)) {
                return -1L;
            }
            return ((AudioFormat)fmt).computeDuration((long)len);
        }

        public int computeLength(long duration, Format fmt) {
            if (!(fmt instanceof AudioFormat)) {
                return -1;
            }
            AudioFormat af = (AudioFormat)fmt;
            return (int)((double)(duration / 1000L * (long)(af.getChannels() * af.getSampleSizeInBits()) / 1000L) * af.getSampleRate() / 8000.0);
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public boolean endOfStream() {
            return this.eos;
        }

        public long getContentLength() {
            return -1L;
        }

        public Format getFormat() {
            return this.tc.getFormat();
        }

        public void setTransferHandler(BufferTransferHandler bth) {
            this.bth = bth;
        }

        public Object getControl(String name) {
            return null;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public synchronized void transferData(PushBufferStream pbs) {
            this.processData();
        }
    }
}

