/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import com.sun.media.MimeManager;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Control;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.QualityControl;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;

public class Concat
implements ControllerListener,
DataSinkListener {
    static int AUDIO = 0;
    static int VIDEO = AUDIO + 1;
    static int MEDIA_TYPES = VIDEO + 1;
    int totalTracks;
    boolean transcodeMsg = false;
    String TRANSCODE_MSG = Messages.getString("The_given_inputs_require_transcoding_to_have_a_common_format_for_concatenation_");
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;
    boolean masterFound = false;
    long masterTime = 0L;
    long masterAudioLen = 0L;

    public static void main(String[] args) {
        Concat concat;
        Vector<String> inputURL = new Vector<String>();
        String outputURL = null;
        if (args.length == 0) {
            Concat.prUsage();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    Concat.prUsage();
                }
                outputURL = args[i];
            } else {
                inputURL.addElement(args[i]);
            }
            ++i;
        }
        if (inputURL.size() == 0) {
            System.err.println(Messages.getString("No_input_url_is_specified"));
            Concat.prUsage();
        }
        if (outputURL == null) {
            System.err.println(Messages.getString("No_output_url_is_specified"));
            Concat.prUsage();
        }
        MediaLocator[] iml = new MediaLocator[inputURL.size()];
        i = 0;
        while (i < inputURL.size()) {
            iml[i] = Concat.createMediaLocator((String)inputURL.elementAt(i));
            if (iml[i] == null) {
                System.err.println(String.valueOf(Messages.getString("Cannot_build_media_locator_from__")) + inputURL);
                System.exit(0);
            }
            ++i;
        }
        MediaLocator oml = Concat.createMediaLocator(outputURL);
        if (oml == null) {
            System.err.println(String.valueOf(Messages.getString("Cannot_build_media_locator_from__")) + outputURL);
            System.exit(0);
        }
        if (!(concat = new Concat()).doIt(iml, oml)) {
            System.err.println(Messages.getString("Failed_to_concatenate_the_inputs"));
        }
        System.exit(0);
    }

    public boolean doIt(MediaLocator[] inML, MediaLocator outML) {
        DataSink dsink;
        Processor p;
        ContentDescriptor cd = this.fileExtToCD(outML.getRemainder());
        if (cd == null) {
            System.err.println(Messages.getString("Couldn_t_figure_out_from_the_file_extension_the_type_of_output_needed"));
            return false;
        }
        ProcInfo[] pInfo = new ProcInfo[inML.length];
        int i = 0;
        while (i < inML.length) {
            pInfo[i] = new ProcInfo();
            pInfo[i].ml = inML[i];
            try {
                pInfo[i].p = Manager.createProcessor((MediaLocator)inML[i]);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(Messages.getString("Cannot_create_a_processor_from_the_given_url__")) + e);
                return false;
            }
            ++i;
        }
        if (!this.matchTracks(pInfo, cd)) {
            System.err.println(Messages.getString("Failed_to_match_the_tracks_"));
            return false;
        }
        if (!this.buildTracks(pInfo)) {
            System.err.println(Messages.getString("Failed_to_build_processors_for_the_inputs_"));
            return false;
        }
        SuperGlueDataSource ds = new SuperGlueDataSource(pInfo);
        try {
            p = Manager.createProcessor((DataSource)ds);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("Failed_to_create_a_processor_to_concatenate_the_inputs_"));
            return false;
        }
        p.addControllerListener((ControllerListener)this);
        if (!this.waitForState(p, 180)) {
            System.err.println(Messages.getString("Failed_to_configure_the_processor_"));
            return false;
        }
        if (p.setContentDescriptor(cd) == null) {
            System.err.println(Messages.getString("Failed_to_set_the_output_content_descriptor_on_the_processor_"));
            return false;
        }
        if (!this.waitForState(p, 300)) {
            System.err.println(Messages.getString("Failed_to_realize_the_processor_"));
            return false;
        }
        while ((dsink = this.createDataSink(p, outML)) == null) {
        }
        dsink.addDataSinkListener((DataSinkListener)this);
        this.fileDone = false;
        try {
            p.start();
            dsink.start();
        }
        catch (IOException e) {
            System.err.println(Messages.getString("IO_error_during_concatenation"));
            return false;
        }
        this.waitForFileDone();
        try {
            dsink.removeDataSinkListener((DataSinkListener)this);
            dsink.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        p.removeControllerListener((ControllerListener)this);
        int ii = 0;
        while (ii < inML.length) {
            pInfo[ii].p.close();
            pInfo[ii].p.deallocate();
            ++ii;
        }
        p.close();
        p.deallocate();
        return true;
    }

    public boolean matchTracks(ProcInfo[] pInfo, ContentDescriptor cd) {
        TrackInfo tInfo;
        int j;
        int type;
        int i = 0;
        while (i < pInfo.length) {
            if (!this.waitForState(pInfo[i].p, 180)) {
                System.err.println(Messages.getString("__Failed_to_configure_the_processor_"));
                return false;
            }
            TrackControl[] tcs = pInfo[i].p.getTrackControls();
            pInfo[i].tracksByType = new TrackInfo[MEDIA_TYPES][];
            type = AUDIO;
            while (type < MEDIA_TYPES) {
                pInfo[i].tracksByType[type] = new TrackInfo[tcs.length];
                ++type;
            }
            pInfo[i].numTracksByType = new int[MEDIA_TYPES];
            int vIdx = 0;
            int aIdx = 0;
            j = 0;
            while (j < tcs.length) {
                if (tcs[j].getFormat() instanceof AudioFormat) {
                    tInfo = new TrackInfo();
                    tInfo.idx = j;
                    tInfo.tc = tcs[j];
                    pInfo[i].tracksByType[Concat.AUDIO][aIdx++] = tInfo;
                } else if (tcs[j].getFormat() instanceof VideoFormat) {
                    tInfo = new TrackInfo();
                    tInfo.idx = j;
                    tInfo.tc = tcs[j];
                    pInfo[i].tracksByType[Concat.VIDEO][vIdx++] = tInfo;
                }
                ++j;
            }
            pInfo[i].numTracksByType[Concat.AUDIO] = aIdx;
            pInfo[i].numTracksByType[Concat.VIDEO] = vIdx;
            pInfo[i].p.setContentDescriptor(cd);
            ++i;
        }
        int[] total = new int[MEDIA_TYPES];
        type = AUDIO;
        while (type < MEDIA_TYPES) {
            total[type] = pInfo[0].numTracksByType[type];
            ++type;
        }
        i = 1;
        while (i < pInfo.length) {
            type = AUDIO;
            while (type < MEDIA_TYPES) {
                if (pInfo[i].numTracksByType[type] < total[type]) {
                    total[type] = pInfo[i].numTracksByType[type];
                }
                ++type;
            }
            ++i;
        }
        if (total[AUDIO] < 1 && total[VIDEO] < 1) {
            System.err.println(Messages.getString("There_is_no_audio_or_video_tracks_to_concatenate_"));
            return false;
        }
        this.totalTracks = 0;
        type = AUDIO;
        while (type < MEDIA_TYPES) {
            this.totalTracks += total[type];
            ++type;
        }
        i = 0;
        while (i < pInfo.length) {
            type = AUDIO;
            while (type < MEDIA_TYPES) {
                j = total[type];
                while (j < pInfo[i].numTracksByType[type]) {
                    tInfo = pInfo[i].tracksByType[type][j];
                    this.disableTrack(pInfo[i], tInfo);
                    System.err.println(Messages.getString("__Disable_the_following_track_since_the_other_input_media_do_not_have_a_matching_type_"));
                    System.err.println("  " + tInfo.tc.getFormat());
                    ++j;
                }
                pInfo[i].numTracksByType[type] = total[type];
                ++type;
            }
            ++i;
        }
        type = AUDIO;
        while (type < MEDIA_TYPES) {
            i = 0;
            while (i < total[type]) {
                if (!this.tryMatch(pInfo, type, i)) {
                    System.err.println(Messages.getString("__Cannot_transcode_the_tracks_to_a_common_format_for_concatenation_"));
                    return false;
                }
                ++i;
            }
            ++type;
        }
        return true;
    }

    void disableTrack(ProcInfo pInfo, TrackInfo remove) {
        remove.tc.setEnabled(false);
        remove.disabled = true;
        int type = AUDIO;
        while (type < MEDIA_TYPES) {
            int j = 0;
            while (j < pInfo.numTracksByType[type]) {
                TrackInfo ti = pInfo.tracksByType[type][j];
                if (ti.idx >= remove.idx) {
                    --ti.idx;
                }
                ++j;
            }
            ++type;
        }
    }

    public boolean buildTracks(ProcInfo[] pInfo) {
        ContentDescriptor cd = new ContentDescriptor("raw");
        int i = 0;
        while (i < pInfo.length) {
            Processor p = pInfo[i].p;
            p.setContentDescriptor(cd);
            if (!this.waitForState(p, 300)) {
                System.err.println(Messages.getString("__Failed_to_realize_the_processor_"));
                return false;
            }
            this.setJPEGQuality((Player)p, 0.5f);
            pInfo[i].ds = (PushBufferDataSource)p.getDataOutput();
            PushBufferStream[] pbs = pInfo[i].ds.getStreams();
            int type = AUDIO;
            while (type < MEDIA_TYPES) {
                int trackID = 0;
                while (trackID < pInfo[i].numTracksByType[type]) {
                    TrackInfo tInfo = pInfo[i].tracksByType[type][trackID];
                    tInfo.pbs = pbs[tInfo.idx];
                    ++trackID;
                }
                ++type;
            }
            ++i;
        }
        return true;
    }

    public boolean tryMatch(ProcInfo[] pInfo, int type, int trackID) {
        TrackControl tc = pInfo[0].tracksByType[type][trackID].tc;
        Format origFmt = tc.getFormat();
        Format[] supported = tc.getSupportedFormats();
        int i = 0;
        while (i < supported.length) {
            if ((!(supported[i] instanceof AudioFormat) || supported[i].matches(tc.getFormat()) || supported[i].getEncoding().equalsIgnoreCase("LINEAR")) && this.tryTranscode(pInfo, 1, type, trackID, supported[i])) {
                int j = 0;
                while (j < pInfo.length) {
                    Format newFmt;
                    tc = pInfo[j].tracksByType[type][trackID].tc;
                    Format oldFmt = tc.getFormat();
                    if (!oldFmt.matches(newFmt = supported[i])) {
                        if (!this.transcodeMsg) {
                            this.transcodeMsg = true;
                            System.err.println(this.TRANSCODE_MSG);
                        }
                        System.err.println(String.valueOf(Messages.getString("__Transcoding__")) + pInfo[j].ml);
                        System.err.println("  " + oldFmt);
                        System.err.println(Messages.getString("to__"));
                        System.err.println("  " + newFmt);
                    }
                    if (oldFmt instanceof VideoFormat) {
                        Dimension newSize = ((VideoFormat)origFmt).getSize();
                        Dimension oldSize = ((VideoFormat)oldFmt).getSize();
                        if (oldSize != null && !oldSize.equals(newSize)) {
                            if (!this.transcodeMsg) {
                                this.transcodeMsg = true;
                                System.err.println(this.TRANSCODE_MSG);
                            }
                            System.err.println(String.valueOf(Messages.getString("__Scaling__")) + pInfo[j].ml);
                            System.err.println("  " + Messages.getString("from__") + oldSize.width + " x " + oldSize.height);
                            System.err.println("  " + Messages.getString("to__") + newSize.width + " x " + newSize.height);
                            newFmt = new VideoFormat(null, newSize, -1, null, -1.0f).intersects(newFmt);
                        }
                    }
                    tc.setFormat(newFmt);
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean tryTranscode(ProcInfo[] pInfo, int procID, int type, int trackID, Format candidate) {
        if (procID >= pInfo.length) {
            return true;
        }
        boolean matched = false;
        TrackControl tc = pInfo[procID].tracksByType[type][trackID].tc;
        Format[] supported = tc.getSupportedFormats();
        int i = 0;
        while (i < supported.length) {
            if (candidate.matches(supported[i]) && this.tryTranscode(pInfo, procID + 1, type, trackID, candidate)) {
                matched = true;
                break;
            }
            ++i;
        }
        return matched;
    }

    boolean isRawAudio(TrackInfo tInfo) {
        Format fmt = tInfo.tc.getFormat();
        return fmt instanceof AudioFormat && fmt.getEncoding().equalsIgnoreCase("LINEAR");
    }

    void setJPEGQuality(Player p, float val) {
        Control[] cs = p.getControls();
        QualityControl qc = null;
        VideoFormat jpegFmt = new VideoFormat("jpeg");
        int i = 0;
        while (i < cs.length) {
            if (cs[i] instanceof QualityControl && cs[i] instanceof Owned) {
                Object owner = ((Owned)cs[i]).getOwner();
                if (owner instanceof Codec) {
                    Format[] fmts = ((Codec)owner).getSupportedOutputFormats(null);
                    int j = 0;
                    while (j < fmts.length) {
                        if (fmts[j].matches((Format)jpegFmt)) {
                            qc = (QualityControl)cs[i];
                            qc.setQuality(val);
                            System.err.println(String.valueOf(Messages.getString("__Set_quality_to_")) + val + " " + Messages.getString("on_") + qc);
                            break;
                        }
                        ++j;
                    }
                }
                if (qc != null) break;
            }
            ++i;
        }
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            System.err.println(Messages.getString("Something_is_really_wrong__the_processor_does_not_have_an_output_DataSource"));
            return null;
        }
        try {
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
        }
        catch (Exception e) {
            return null;
        }
        if (dsink == null) {
            return null;
        }
        try {
            dsink.open();
        }
        catch (SecurityException e) {
            dsink.close();
            return null;
        }
        catch (IOException e) {
            dsink.close();
            return null;
        }
        return dsink;
    }

    boolean waitForState(Processor p, int state) {
        return new StateWaiter(p).waitForState(state);
    }

    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ControllerErrorEvent) {
            System.err.println(Messages.getString("Failed_to_concatenate_the_files_"));
            System.exit(-1);
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait(1000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    ContentDescriptor fileExtToCD(String name) {
        String type;
        int p = name.lastIndexOf(46);
        if (p < 0) {
            return null;
        }
        String ext = name.substring(p + 1).toLowerCase();
        if (ext.equals("mp3")) {
            type = "audio.mpeg";
        } else if (ext.equals("wav")) {
            type = "audio.x_wav";
        } else {
            type = MimeManager.getMimeType((String)ext);
            if (type == null) {
                return null;
            }
            type = ContentDescriptor.mimeTypeToPackageName((String)type);
        }
        return new FileTypeDescriptor(type);
    }

    static MediaLocator createMediaLocator(String url) {
        String file;
        MediaLocator ml;
        if (url.indexOf(":") > 0 && (ml = new MediaLocator(url)) != null) {
            return ml;
        }
        if (url.startsWith(File.separator) ? (ml = new MediaLocator("file:" + url)) != null : (ml = new MediaLocator(file = "file:" + System.getProperty("user.dir") + File.separator + url)) != null) {
            return ml;
        }
        return null;
    }

    static void prUsage() {
        System.err.println("Usage: java Concat -o <output> <input> ...");
        System.err.println("     <output>: input URL or file name");
        System.err.println("     <input>: output URL or file name");
        System.exit(0);
    }

    public class ProcInfo {
        public MediaLocator ml;
        public Processor p;
        public PushBufferDataSource ds;
        public TrackInfo[][] tracksByType;
        public int[] numTracksByType;
        public int numTracks;
    }

    public class StateWaiter
    implements ControllerListener {
        Processor p;
        boolean error = false;

        StateWaiter(Processor p) {
            this.p = p;
            p.addControllerListener((ControllerListener)this);
        }

        public synchronized boolean waitForState(int state) {
            switch (state) {
                case 180: {
                    this.p.configure();
                    break;
                }
                case 300: {
                    this.p.realize();
                    break;
                }
                case 500: {
                    this.p.prefetch();
                    break;
                }
                case 600: {
                    this.p.start();
                }
            }
            while (this.p.getState() < state && !this.error) {
                try {
                    this.wait(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return !this.error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerErrorEvent) {
                this.error = true;
            }
            StateWaiter stateWaiter = this;
            synchronized (stateWaiter) {
                this.notifyAll();
            }
        }
    }

    class SuperGlueDataSource
    extends PushBufferDataSource {
        ProcInfo[] pInfo;
        int current;
        SuperGlueStream[] streams;

        public SuperGlueDataSource(ProcInfo[] pInfo) {
            this.pInfo = pInfo;
            this.streams = new SuperGlueStream[Concat.this.totalTracks];
            int i = 0;
            while (i < Concat.this.totalTracks) {
                this.streams[i] = new SuperGlueStream(this);
                ++i;
            }
            this.current = 0;
            this.setStreams(pInfo[this.current]);
        }

        void setStreams(ProcInfo pInfo) {
            int j = 0;
            Concat.this.masterFound = false;
            int type = AUDIO;
            while (type < MEDIA_TYPES) {
                int i = 0;
                while (i < pInfo.numTracksByType[type]) {
                    if (!Concat.this.masterFound && Concat.this.isRawAudio(pInfo.tracksByType[type][i])) {
                        this.streams[j].setStream(pInfo.tracksByType[type][i], true);
                        Concat.this.masterFound = true;
                    } else {
                        this.streams[j].setStream(pInfo.tracksByType[type][i], false);
                    }
                    ++j;
                    ++i;
                }
                ++type;
            }
        }

        public void connect() throws IOException {
        }

        public PushBufferStream[] getStreams() {
            return this.streams;
        }

        public void start() throws IOException {
            this.pInfo[this.current].p.start();
            this.pInfo[this.current].ds.start();
        }

        public void stop() throws IOException {
        }

        synchronized boolean handleEOM(TrackInfo tInfo) {
            boolean lastProcessor = this.current >= this.pInfo.length - 1;
            int type = AUDIO;
            while (type < MEDIA_TYPES) {
                int i = 0;
                while (i < this.pInfo[this.current].numTracksByType[type]) {
                    if (!this.pInfo[this.current].tracksByType[type][i].done) {
                        return lastProcessor;
                    }
                    ++i;
                }
                ++type;
            }
            try {
                this.pInfo[this.current].p.stop();
                this.pInfo[this.current].ds.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lastProcessor) {
                return lastProcessor;
            }
            if (!Concat.this.masterFound && this.pInfo[this.current].p.getDuration() != Duration.DURATION_UNKNOWN) {
                Concat.this.masterTime += this.pInfo[this.current].p.getDuration().getNanoseconds();
            }
            ++this.current;
            this.setStreams(this.pInfo[this.current]);
            try {
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return lastProcessor;
        }

        public Object getControl(String name) {
            return null;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public void disconnect() {
        }

        public String getContentType() {
            return "raw";
        }

        public MediaLocator getLocator() {
            return this.pInfo[this.current].ml;
        }

        public void setLocator(MediaLocator ml) {
            System.err.println(Messages.getString("Not_interested_in_a_media_locator"));
        }
    }

    class SuperGlueStream
    implements PushBufferStream,
    BufferTransferHandler {
        SuperGlueDataSource ds;
        TrackInfo tInfo;
        PushBufferStream pbs;
        BufferTransferHandler bth;
        boolean useAsMaster = false;
        long timeStamp = 0L;
        long lastTS = 0L;

        public SuperGlueStream(SuperGlueDataSource ds) {
            this.ds = ds;
        }

        public void setStream(TrackInfo tInfo, boolean useAsMaster) {
            this.tInfo = tInfo;
            this.useAsMaster = useAsMaster;
            if (this.pbs != null) {
                this.pbs.setTransferHandler(null);
            }
            this.pbs = tInfo.pbs;
            if (Concat.this.masterTime > 0L) {
                this.timeStamp = Concat.this.masterTime;
            }
            this.lastTS = 0L;
            this.pbs.setTransferHandler((BufferTransferHandler)this);
        }

        public void read(Buffer buffer) throws IOException {
            this.pbs.read(buffer);
            if (buffer.getTimeStamp() != -1L) {
                long diff = buffer.getTimeStamp() - this.lastTS;
                this.lastTS = buffer.getTimeStamp();
                if (diff > 0L) {
                    this.timeStamp += diff;
                }
                buffer.setTimeStamp(this.timeStamp);
            }
            if (this.useAsMaster) {
                if (buffer.getFormat() instanceof AudioFormat) {
                    AudioFormat af = (AudioFormat)buffer.getFormat();
                    Concat.this.masterAudioLen += (long)buffer.getLength();
                    long t = af.computeDuration(Concat.this.masterAudioLen);
                    Concat.this.masterTime = t > 0L ? t : buffer.getTimeStamp();
                } else {
                    Concat.this.masterTime = buffer.getTimeStamp();
                }
            }
            if (buffer.isEOM()) {
                this.tInfo.done = true;
                if (!this.ds.handleEOM(this.tInfo)) {
                    buffer.setEOM(false);
                    buffer.setDiscard(true);
                }
            }
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public boolean endOfStream() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public Format getFormat() {
            return this.tInfo.tc.getFormat();
        }

        public void setTransferHandler(BufferTransferHandler bth) {
            this.bth = bth;
        }

        public Object getControl(String name) {
            return null;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public synchronized void transferData(PushBufferStream pbs) {
            if (this.bth != null) {
                this.bth.transferData((PushBufferStream)this);
            }
        }
    }

    public class TrackInfo {
        public TrackControl tc;
        public PushBufferStream pbs;
        public int idx;
        public boolean done;
        public boolean disabled;
    }
}

