/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import movieMaker.Picture;

public class AnimationPanel
extends JComponent {
    private List imageList = new ArrayList();
    private List nameList = new ArrayList();
    private int currIndex = 0;
    private int framesPerSec = 16;

    public AnimationPanel() {
        this.setSize(new Dimension(100, 100));
    }

    public AnimationPanel(List pictList) {
        Image image = null;
        Picture picture = null;
        int i = 0;
        while (i < pictList.size()) {
            picture = (Picture)pictList.get(i);
            this.nameList.add(picture.getFileName());
            image = picture.getImage();
            this.imageList.add(image);
            ++i;
        }
        BufferedImage bi = (BufferedImage)image;
        int width = bi.getWidth();
        int height = bi.getHeight();
        this.setSize(new Dimension(width, height));
        this.setMinimumSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
    }

    public AnimationPanel(String directory) {
        File dirObj = new File(directory);
        String[] fileArray = dirObj.list();
        ImageIcon imageIcon = null;
        Image image = null;
        int i = 0;
        while (i < fileArray.length) {
            if (fileArray[i].indexOf(".jpg") >= 0) {
                imageIcon = new ImageIcon(String.valueOf(directory) + fileArray[i]);
                this.nameList.add(String.valueOf(directory) + fileArray[i]);
                this.imageList.add(imageIcon.getImage());
            }
            ++i;
        }
        if (imageIcon != null) {
            image = (Image)this.imageList.get(0);
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            this.setSize(new Dimension(width, height));
            this.setMinimumSize(new Dimension(width, height));
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    public AnimationPanel(String directory, int theFramesPerSec) {
        this(directory);
        this.framesPerSec = theFramesPerSec;
    }

    public int getCurrIndex() {
        return this.currIndex;
    }

    public void setFramesPerSec(int numFramesPerSec) {
        this.framesPerSec = numFramesPerSec;
    }

    public int getFramesPerSec() {
        return this.framesPerSec;
    }

    public void add(Picture picture) {
        Image image = picture.getImage();
        this.imageList.add(image);
        this.nameList.add(picture.getFileName());
    }

    public void showNext() {
        ++this.currIndex;
        if (this.currIndex == this.imageList.size()) {
            this.currIndex = 0;
        }
        this.draw(this.getGraphics());
    }

    public void showPrev() {
        --this.currIndex;
        if (this.currIndex < 0) {
            this.currIndex = this.imageList.size() - 1;
        }
        this.draw(this.getGraphics());
    }

    public void showAll() {
        Graphics g = null;
        long startTime = 0L;
        long endTime = 0L;
        int timeToSleep = 1000 / this.framesPerSec;
        int i = 0;
        while (i < this.imageList.size()) {
            startTime = System.currentTimeMillis();
            this.currIndex = i;
            g = this.getGraphics();
            this.draw(g);
            g.dispose();
            endTime = System.currentTimeMillis();
            try {
                if (endTime - startTime < (long)timeToSleep) {
                    Thread.sleep((long)timeToSleep - (endTime - startTime));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.currIndex = this.imageList.size() - 1;
            ++i;
        }
    }

    public void showAllFromCurrent() {
        Graphics g = null;
        int timeToSleep = 1000 / this.framesPerSec;
        while (this.currIndex < this.imageList.size()) {
            g = this.getGraphics();
            this.draw(g);
            g.dispose();
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++this.currIndex;
        }
        this.currIndex = this.imageList.size() - 1;
    }

    public void removeAllBefore() {
        File f = null;
        boolean result = false;
        int i = 0;
        while (i <= this.currIndex) {
            f = new File((String)this.nameList.get(i));
            result = f.delete();
            if (!result) {
                System.out.println(String.valueOf(Messages.getString("trouble_deleting_")) + this.nameList.get(i));
            }
            this.imageList.remove(0);
            ++i;
        }
    }

    public void removeAllAfter() {
        int i;
        int index = i = this.currIndex + 1;
        File f = null;
        boolean result = false;
        while (i < this.imageList.size()) {
            if (!(result = (f = new File((String)this.nameList.get(index++))).delete())) {
                System.out.println(String.valueOf(Messages.getString("trouble_deleting_")) + this.nameList.get(index - 1));
            }
            this.imageList.remove(i);
        }
    }

    public void draw(Graphics g) {
        Image image = (Image)this.imageList.get(this.currIndex);
        g.drawImage(image, 0, 0, this);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.imageList.size() == 0) {
            g.drawString(Messages.getString("No_images_yet__"), 20, 20);
        } else {
            this.draw(g);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        AnimationPanel panel = new AnimationPanel("c:/intro-prog-java/mediasources/fish/");
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
        panel.showAll();
    }
}

