/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.swing.numpad;

import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class NumPad
extends ContentPane {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel mainPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextField numberTextField = new JTextField();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton okayButton = new JButton();
    JButton cancelButton = new JButton();
    JPanel keyWell = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JButton sevenButton = new JButton();
    JButton eightButton = new JButton();
    JButton nineButton = new JButton();
    JButton backspaceButton = new JButton();
    JButton fourButton = new JButton();
    JButton fiveButton = new JButton();
    JButton sixButton = new JButton();
    JButton clearButton = new JButton();
    JButton oneButton = new JButton();
    JButton twoButton = new JButton();
    JButton threeButton = new JButton();
    JButton plusMinusButton = new JButton();
    JButton zeroButton = new JButton();
    JButton decimalButton = new JButton();
    JButton slashButton = new JButton();

    public NumPad() {
        this.init();
    }

    @Override
    public String getTitle() {
        return Messages.getString("Custom_Number");
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.okayButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.okayButton.removeActionListener(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    private void doKey(JButton button, String imageString, ActionListener onClick) {
        button.addActionListener(onClick);
        Image image = null;
        URL resource = NumPad.class.getResource(String.valueOf(imageString) + ".gif");
        if (resource != null) {
            image = Toolkit.getDefaultToolkit().getImage(resource);
        }
        ImageIcon icon = new ImageIcon(image);
        ImageIcon rolloverIcon = null;
        ImageIcon pressedIcon = null;
        if (image != null) {
            rolloverIcon = new ImageIcon(this.createLightenedOrDarkenedImage(image, 30));
            pressedIcon = new ImageIcon(this.createLightenedOrDarkenedImage(image, -30));
        }
        if (icon != null) {
            button.setText(null);
            button.setBorder(null);
            button.setIcon(icon);
            Dimension iconSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            button.setMinimumSize(iconSize);
            button.setMaximumSize(iconSize);
            button.setPreferredSize(iconSize);
            if (rolloverIcon != null) {
                button.setRolloverIcon(rolloverIcon);
            }
            if (pressedIcon != null) {
                button.setPressedIcon(pressedIcon);
            }
        }
    }

    private void keyInit() {
        this.doKey(this.oneButton, "one", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '1'));
            }
        });
        this.doKey(this.twoButton, "two", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '2'));
            }
        });
        this.doKey(this.threeButton, "three", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '3'));
            }
        });
        this.doKey(this.fourButton, "four", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '4'));
            }
        });
        this.doKey(this.fiveButton, "five", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '5'));
            }
        });
        this.doKey(this.sixButton, "six", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '6'));
            }
        });
        this.doKey(this.sevenButton, "seven", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '7'));
            }
        });
        this.doKey(this.eightButton, "eight", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '8'));
            }
        });
        this.doKey(this.nineButton, "nine", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '9'));
            }
        });
        this.doKey(this.zeroButton, "zero", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '0'));
            }
        });
        this.doKey(this.decimalButton, "decimal", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '.'));
            }
        });
        this.doKey(this.slashButton, "slash", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.dispatchEvent(new KeyEvent(NumPad.this.numberTextField, 400, System.currentTimeMillis(), 0, 0, '/'));
            }
        });
        this.doKey(this.backspaceButton, "backspace", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    NumPad.this.numberTextField.setText(NumPad.this.numberTextField.getText(0, NumPad.this.numberTextField.getText().length() - 1).toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.doKey(this.clearButton, "clear", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NumPad.this.numberTextField.setText("");
            }
        });
        this.doKey(this.plusMinusButton, "plusminus", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    if ("-".equals(NumPad.this.numberTextField.getDocument().getText(0, 1))) {
                        NumPad.this.numberTextField.getDocument().remove(0, 1);
                    } else {
                        NumPad.this.numberTextField.getDocument().insertString(0, "-", null);
                    }
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
    }

    private void init() {
        this.jbInit();
        this.keyInit();
        this.numberTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NumPad.this.refresh();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NumPad.this.refresh();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NumPad.this.refresh();
            }
        });
        this.numberTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (NumPad.this.okayButton.isEnabled()) {
                    NumPad.this.okayButton.doClick();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.refresh();
    }

    public String getNumberString() {
        return this.numberTextField.getText();
    }

    public void setNumberString(String value) {
        if (value != null) {
            this.numberTextField.setText(value);
        } else {
            this.numberTextField.setText("");
        }
    }

    public void selectAll() {
        this.numberTextField.selectAll();
    }

    protected void refresh() {
        Double number = NumPad.parseDouble(this.numberTextField.getText());
        if (number != null) {
            this.okayButton.setEnabled(true);
            this.numberTextField.setForeground(Color.black);
        } else {
            this.okayButton.setEnabled(false);
            this.numberTextField.setForeground(Color.red);
        }
    }

    public static Double parseDouble(String doubleString) {
        Double number = null;
        if (doubleString.trim().equalsIgnoreCase("infinity")) {
            number = new Double(Double.POSITIVE_INFINITY);
        } else if (doubleString.trim().equalsIgnoreCase("-infinity")) {
            number = new Double(Double.NEGATIVE_INFINITY);
        } else if (doubleString.indexOf(47) > -1) {
            if (doubleString.lastIndexOf(47) == doubleString.indexOf(47)) {
                String numeratorString = doubleString.substring(0, doubleString.indexOf(47));
                String denominatorString = doubleString.substring(doubleString.indexOf(47) + 1);
                try {
                    number = new Double(Double.parseDouble(numeratorString) / Double.parseDouble(denominatorString));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            try {
                number = Double.valueOf(doubleString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }

    public Image createLightenedOrDarkenedImage(Image i, int percent) {
        LightenDarkenFilter filter = new LightenDarkenFilter(percent);
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        Image filteredImage = Toolkit.getDefaultToolkit().createImage(prod);
        return filteredImage;
    }

    private void jbInit() {
        this.setLayout(this.borderLayout1);
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.okayButton.setText(Messages.getString("Okay"));
        this.cancelButton.setText(Messages.getString("Cancel"));
        this.numberTextField.setFont(new Font("Dialog", 0, 24));
        this.keyWell.setLayout(this.gridBagLayout3);
        this.keyWell.setBackground(new Color(17, 17, 17));
        this.sevenButton.setText("7");
        this.eightButton.setText("8");
        this.nineButton.setText("9");
        this.backspaceButton.setText("<");
        this.fourButton.setText("4");
        this.fiveButton.setText("5");
        this.sixButton.setText("6");
        this.clearButton.setText("C");
        this.oneButton.setText("1");
        this.twoButton.setText("2");
        this.threeButton.setText("3");
        this.plusMinusButton.setText("-");
        this.zeroButton.setText("0");
        this.decimalButton.setText(".");
        this.slashButton.setText("/");
        this.add((Component)this.mainPanel, "North");
        this.mainPanel.add((Component)this.numberTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.add((Component)this.buttonPanel, "Center");
        this.buttonPanel.add((Component)this.okayButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 12, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.keyWell, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 8, 8), 0, 0));
        this.keyWell.add((Component)this.sevenButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.eightButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.nineButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.backspaceButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 4), 0, 0));
        this.keyWell.add((Component)this.fourButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.fiveButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.sixButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.clearButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 4), 0, 0));
        this.keyWell.add((Component)this.oneButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.twoButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.threeButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 0), 0, 0));
        this.keyWell.add((Component)this.plusMinusButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 0, 4), 0, 0));
        this.keyWell.add((Component)this.zeroButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 4, 0), 0, 0));
        this.keyWell.add((Component)this.decimalButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 4, 0), 0, 0));
        this.keyWell.add((Component)this.slashButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    public class LightenDarkenFilter
    extends RGBImageFilter {
        private int percent;

        public LightenDarkenFilter(int p) {
            this.percent = p;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb >> 0 & 0xFF;
            if (this.percent > 0) {
                r = 255 - (255 - r) * (100 - this.percent) / 100;
                g = 255 - (255 - g) * (100 - this.percent) / 100;
                b = 255 - (255 - b) * (100 - this.percent) / 100;
            } else {
                r = r * (100 + this.percent) / 100;
                g = g * (100 + this.percent) / 100;
                b = b * (100 + this.percent) / 100;
            }
            if (r < 0) {
                r = 0;
            }
            if (g < 0) {
                g = 0;
            }
            if (b < 0) {
                b = 0;
            }
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            return rgb & 0xFF000000 | r << 16 | g << 8 | b << 0;
        }
    }
}

