/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.pratt.maxkeyframing;

import edu.cmu.cs.stage3.math.BezierCubic;
import edu.cmu.cs.stage3.pratt.maxkeyframing.BezierKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Key;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Spline;

public class BezierSpline
extends Spline {
    public boolean addKey(BezierKey key) {
        return super.addKey(key);
    }

    public boolean removeKey(BezierKey key) {
        return super.removeKey(key);
    }

    @Override
    public Object getSample(double t) {
        if (t <= 0.0) {
            Key key = this.getFirstKey();
            if (key != null) {
                return key.createSample(key.getValueComponents());
            }
        } else if (t >= this.getDuration()) {
            Key key = this.getLastKey();
            if (key != null) {
                return key.createSample(key.getValueComponents());
            }
        } else {
            Key[] boundingKeys = this.getBoundingKeys(t);
            if (boundingKeys != null) {
                double timeSpan = boundingKeys[1].getTime() - boundingKeys[0].getTime();
                double portion = (t - boundingKeys[0].getTime()) / timeSpan;
                int numComponents = boundingKeys[0].getValueComponents().length;
                BezierCubic[] curves = new BezierCubic[numComponents];
                int j = 0;
                while (j < numComponents) {
                    double p0 = ((BezierKey)boundingKeys[0]).getValueComponents()[j];
                    double p1 = ((BezierKey)boundingKeys[0]).getOutgoingControlComponents()[j];
                    double p2 = ((BezierKey)boundingKeys[1]).getIncomingControlComponents()[j];
                    double p3 = ((BezierKey)boundingKeys[1]).getValueComponents()[j];
                    curves[j] = new BezierCubic(p0, p1, p2, p3);
                    ++j;
                }
                double[] components = new double[numComponents];
                int j2 = 0;
                while (j2 < numComponents) {
                    components[j2] = curves[j2].evaluate(portion);
                    ++j2;
                }
                return boundingKeys[0].createSample(components);
            }
        }
        return null;
    }

    public void convertMAXTangentsToBezierTangents(double timeFactor) {
        BezierKey[] keys = (BezierKey[])this.getKeyArray(new BezierKey[0]);
        int i = 0;
        while (i < keys.length) {
            BezierKey prevKey = keys[Math.max(i - 1, 0)];
            BezierKey thisKey = keys[i];
            BezierKey nextKey = keys[Math.min(i + 1, keys.length - 1)];
            double[] in = thisKey.getIncomingControlComponents();
            double[] out = thisKey.getOutgoingControlComponents();
            int j = 0;
            while (j < thisKey.getValueComponents().length) {
                double value = thisKey.getValueComponents()[j];
                double dt = (thisKey.getTime() - prevKey.getTime()) / timeFactor / 3.0;
                in[j] = value + in[j] * dt;
                dt = (nextKey.getTime() - thisKey.getTime()) / timeFactor / 3.0;
                out[j] = value + out[j] * dt;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void scaleKeyValueComponents(double scaleFactor) {
        super.scaleKeyValueComponents(scaleFactor);
        BezierKey[] keys = (BezierKey[])this.getKeyArray(new BezierKey[0]);
        int i = 0;
        while (i < keys.length) {
            BezierKey key = keys[i];
            double[] incomingControlComponents = key.getIncomingControlComponents();
            int j = 0;
            while (j < incomingControlComponents.length) {
                int n = j++;
                incomingControlComponents[n] = incomingControlComponents[n] * scaleFactor;
            }
            double[] outgoingControlComponents = key.getOutgoingControlComponents();
            int j2 = 0;
            while (j2 < outgoingControlComponents.length) {
                int n = j2++;
                outgoingControlComponents[n] = outgoingControlComponents[n] * scaleFactor;
            }
            ++i;
        }
    }
}

