/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.pratt.maxkeyframing;

import edu.cmu.cs.stage3.pratt.maxkeyframing.Key;

public abstract class BezierKey
extends Key {
    private double[] incomingControlComponents;
    private double[] outgoingControlComponents;

    protected BezierKey(double time, double[] components, double[] incomingControlComponents, double[] outgoingControlComponents) {
        this.setTime(time);
        this.setValueComponents(components);
        this.incomingControlComponents = incomingControlComponents;
        this.outgoingControlComponents = outgoingControlComponents;
    }

    public double[] getIncomingControlComponents() {
        return this.incomingControlComponents;
    }

    public double[] getOutgoingControlComponents() {
        return this.outgoingControlComponents;
    }

    public String toString() {
        String className = this.getClass().getName();
        double[] components = this.getValueComponents();
        int numComponents = components.length;
        StringBuffer repr = new StringBuffer();
        repr.append(className);
        repr.append("[");
        repr.append(this.getTime());
        repr.append(",");
        int i = 0;
        while (i < numComponents) {
            repr.append(components[i]);
            repr.append(",");
            ++i;
        }
        i = 0;
        while (i < numComponents) {
            repr.append(this.incomingControlComponents[i]);
            repr.append(",");
            ++i;
        }
        i = 0;
        while (i < numComponents - 1) {
            repr.append(this.outgoingControlComponents[i]);
            repr.append(",");
            ++i;
        }
        repr.append(this.outgoingControlComponents[numComponents - 1]);
        repr.append("]");
        return repr.toString();
    }
}

