/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.media.jmfmedia;

import edu.cmu.cs.stage3.media.AbstractPlayer;
import edu.cmu.cs.stage3.media.jmfmedia.DataSource;
import edu.cmu.cs.stage3.media.jmfmedia.FixedJavaSoundRenderer;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.Manager;
import javax.media.Time;
import javax.media.TransitionEvent;

public class Player
extends AbstractPlayer {
    private javax.media.Player m_jmfPlayer;
    private Time m_pendingMediaTime;
    private Float m_pendingVolumeLevel;
    private Float m_pendingRate;

    public Player(DataSource dataSource) {
        super(dataSource);
        try {
            FixedJavaSoundRenderer.usurpControlFromJavaSoundRenderer();
            this.m_jmfPlayer = Manager.createPlayer((javax.media.protocol.DataSource)dataSource.getJMFDataSource());
            this.m_jmfPlayer.addControllerListener(new ControllerListener(){

                public void controllerUpdate(ControllerEvent e) {
                    if (e instanceof TransitionEvent) {
                        TransitionEvent te = (TransitionEvent)e;
                        switch (te.getCurrentState()) {
                            case 300: {
                                if (Player.this.m_pendingMediaTime != null) {
                                    Player.this.m_jmfPlayer.setMediaTime(Player.this.m_pendingMediaTime);
                                    Player.this.m_pendingMediaTime = null;
                                }
                                if (Player.this.m_pendingVolumeLevel != null) {
                                    Player.this.updateVolumeLevel(Player.this.m_pendingVolumeLevel.floatValue());
                                    Player.this.m_pendingVolumeLevel = null;
                                }
                                if (Player.this.m_pendingRate == null) break;
                                Player.this.updateRate(Player.this.m_pendingRate.floatValue());
                                Player.this.m_pendingRate = null;
                            }
                        }
                        Player.this.fireStateChanged();
                    }
                    if (e instanceof EndOfMediaEvent) {
                        Player.this.fireEndReached();
                    }
                    if (e instanceof DurationUpdateEvent) {
                        Player.this.fireDurationUpdated();
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public int getState() {
        return this.m_jmfPlayer.getState();
    }

    @Override
    public double getDuration() {
        Time t = this.m_jmfPlayer.getDuration();
        if (t != null) {
            long nsec = t.getNanoseconds();
            if (nsec == 0x7FFFFFFFFFFFFFFEL) {
                return Double.NaN;
            }
            if (nsec == 0x7FFFFFFFFFFFFFFEL) {
                return Double.POSITIVE_INFINITY;
            }
            return (double)nsec * 1.0E-9;
        }
        return Double.NaN;
    }

    @Override
    public double getCurrentTime() {
        Time t = this.m_pendingMediaTime != null ? this.m_pendingMediaTime : this.m_jmfPlayer.getMediaTime();
        if (t != null) {
            long nsec = t.getNanoseconds();
            if (nsec == 0x7FFFFFFFFFFFFFFEL) {
                return Double.NaN;
            }
            if (nsec == 0x7FFFFFFFFFFFFFFEL) {
                return Double.POSITIVE_INFINITY;
            }
            return (double)nsec * 1.0E-9;
        }
        return Double.NaN;
    }

    private boolean isAtLeastRealized() {
        int state = this.getState();
        return state != 100 && state != 200;
    }

    @Override
    public void setCurrentTime(double currentTime) {
        Time t = new Time(currentTime);
        if (this.isAtLeastRealized()) {
            this.m_jmfPlayer.setMediaTime(t);
        } else {
            this.m_pendingMediaTime = t;
        }
    }

    private void updateVolumeLevel(float volumeLevel) {
        GainControl gainConrol = this.m_jmfPlayer.getGainControl();
        if (gainConrol != null) {
            gainConrol.setLevel(volumeLevel);
        }
    }

    @Override
    public void setVolumeLevel(float volumeLevel) {
        if (this.isAtLeastRealized()) {
            this.updateVolumeLevel(volumeLevel);
        } else {
            this.m_pendingVolumeLevel = new Float(volumeLevel);
        }
    }

    private void updateRate(float rate) {
        float actualRate = this.m_jmfPlayer.setRate(rate);
    }

    @Override
    public void setRate(float rate) {
        if (this.isAtLeastRealized()) {
            this.updateRate(rate);
        } else {
            this.m_pendingRate = new Float(rate);
        }
    }

    @Override
    public void realize() {
        try {
            this.m_jmfPlayer.realize();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void prefetch() {
        try {
            this.m_jmfPlayer.prefetch();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void start() {
        try {
            this.m_jmfPlayer.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            if (this.m_jmfPlayer.getState() == 600) {
                this.m_jmfPlayer.stop();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

