/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.media;

import edu.cmu.cs.stage3.io.FileUtilities;
import edu.cmu.cs.stage3.media.jmfmedia.DataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Manager {
    private static boolean s_isJMFAvailable;

    static {
        try {
            Class.forName("javax.media.Manager");
            s_isJMFAvailable = true;
        }
        catch (ClassNotFoundException cnfe) {
            s_isJMFAvailable = false;
        }
    }

    public static edu.cmu.cs.stage3.media.DataSource createDataSource(byte[] data, String extension) {
        if (s_isJMFAvailable) {
            return new DataSource(data, extension);
        }
        return new edu.cmu.cs.stage3.media.nullmedia.DataSource(data, extension);
    }

    public static edu.cmu.cs.stage3.media.DataSource createDataSource(InputStream is, String extension) throws IOException {
        BufferedInputStream bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        int byteCount = bis.available();
        byte[] data = new byte[byteCount];
        bis.read(data);
        return Manager.createDataSource(data, extension);
    }

    public static edu.cmu.cs.stage3.media.DataSource createDataSource(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return Manager.createDataSource(fis, FileUtilities.getExtension(file));
    }
}

