/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Sphere
implements Cloneable {
    protected double m_radius;
    protected Vector3d m_center;

    public Sphere() {
        this(null, Double.NaN);
    }

    public Sphere(Vector3d center, double radius) {
        this.setCenter(center);
        this.setRadius(radius);
    }

    public Sphere(double x, double y, double z, double radius) {
        this.setCenter(new Vector3d(x, y, z));
        this.setRadius(radius);
    }

    public synchronized Object clone() {
        try {
            Sphere sphere = (Sphere)super.clone();
            sphere.setCenter(this.m_center);
            return sphere;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Sphere) {
            Sphere s = (Sphere)o;
            return this.m_center.equals((Tuple3d)s.m_center) && this.m_radius == s.m_radius;
        }
        return false;
    }

    public double getRadius() {
        return this.m_radius;
    }

    public void setRadius(double radius) {
        this.m_radius = radius;
    }

    public Vector3d getCenter() {
        if (this.m_center != null) {
            return new Vector3d(this.m_center);
        }
        return null;
    }

    public void setCenter(Vector3d center) {
        this.m_center = center != null ? new Vector3d(center) : null;
    }

    public void union(Sphere s) {
        if (s != null && s.m_center != null) {
            if (this.m_center != null) {
                Vector3d diagonal = new Vector3d(this.m_center);
                diagonal.sub((Tuple3d)s.m_center);
                diagonal.normalize();
                Vector3d[] points = new Vector3d[]{MathUtilities.add(this.m_center, MathUtilities.multiply(diagonal, this.m_radius)), MathUtilities.subtract(this.m_center, MathUtilities.multiply(diagonal, this.m_radius)), MathUtilities.add(s.m_center, MathUtilities.multiply(diagonal, s.m_radius)), MathUtilities.subtract(s.m_center, MathUtilities.multiply(diagonal, s.m_radius))};
                double maxDistanceSquared = 0.0;
                int maxDistanceI = 0;
                int maxDistanceJ = 1;
                int i = 0;
                while (i < 4) {
                    int j = i + 1;
                    while (j < 4) {
                        double d2 = MathUtilities.subtract(points[i], points[j]).lengthSquared();
                        if (d2 > maxDistanceSquared) {
                            maxDistanceSquared = d2;
                            maxDistanceI = i;
                            maxDistanceJ = j;
                        }
                        ++j;
                    }
                    ++i;
                }
                Vector3d temp = MathUtilities.divide(MathUtilities.add(points[maxDistanceI], points[maxDistanceJ]), 2.0);
                if (!(Double.isNaN(temp.x) || Double.isNaN(temp.y) || Double.isNaN(temp.z))) {
                    this.m_center = temp;
                    this.m_radius = Math.sqrt(maxDistanceSquared) / 2.0;
                }
            } else {
                this.m_center = s.getCenter();
                this.m_radius = s.getRadius();
            }
        }
    }

    public void transform(Matrix4d m) {
        if (this.m_center != null && !Double.isNaN(this.m_radius)) {
            this.m_center.add((Tuple3d)new Vector3(m.m30, m.m31, m.m32));
        }
    }

    public void scale(Matrix3d s) {
        if (s != null) {
            if (this.m_center != null) {
                this.m_center = MathUtilities.multiply(s, this.m_center);
            }
            this.m_radius *= s.getScale();
        }
    }

    public String toString() {
        String s = "edu.cmu.cs.stage3.math.Sphere[radius=" + this.m_radius + ",center=";
        s = this.m_center != null ? String.valueOf(s) + this.m_center + "]" : String.valueOf(s) + "null]";
        return s;
    }
}

