/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.MathUtilities;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Ray
implements Cloneable {
    protected Point3d m_origin = null;
    protected Vector3d m_direction = null;

    public Ray() {
        this(new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0));
    }

    public Ray(Point3d origin, Vector3d direction) {
        this.setOrigin(origin);
        this.setDirection(direction);
    }

    public synchronized Object clone() {
        try {
            Ray ray = (Ray)super.clone();
            ray.setOrigin(new Point3d(this.m_origin));
            ray.setDirection(new Vector3d(this.m_direction));
            return ray;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Ray) {
            Ray ray = (Ray)o;
            return this.m_origin.equals((Tuple3d)ray.m_origin) && this.m_direction.equals((Tuple3d)ray.m_direction);
        }
        return false;
    }

    public Point3d getOrigin() {
        if (this.m_origin != null) {
            return new Point3d(this.m_origin);
        }
        return null;
    }

    public void setOrigin(Point3d origin) {
        this.m_origin = origin != null ? new Point3d(origin) : null;
    }

    public Vector3d getDirection() {
        if (this.m_direction != null) {
            return new Vector3d(this.m_direction);
        }
        return null;
    }

    public void setDirection(Vector3d direction) {
        this.m_direction = direction != null ? new Vector3d(direction) : null;
    }

    public Vector3d getPoint(double t) {
        Vector3d p = new Vector3d(this.m_direction);
        p.scale(t);
        p.add((Tuple3d)this.m_origin);
        return p;
    }

    public void transform(Matrix4d m) {
        Vector4d transformedOrigin = MathUtilities.multiply(this.m_origin.x, this.m_origin.y, this.m_origin.z, 1.0, m);
        this.m_origin = MathUtilities.createPoint3d((Tuple4d)transformedOrigin);
        Vector4d transformedDirection = MathUtilities.multiply(this.m_direction, 0.0, m);
        transformedDirection.w = 1.0;
        this.m_direction = MathUtilities.createVector3d((Tuple4d)transformedDirection);
    }

    public String toString() {
        return "edu.cmu.cs.stage3.math.Ray[origin=" + this.m_origin + ",direction=" + this.m_direction + "]";
    }
}

