/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.AxisAngle;
import edu.cmu.cs.stage3.math.EulerAngles;
import edu.cmu.cs.stage3.math.Interpolable;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;

public class Quaternion
implements Cloneable,
Interpolable {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double w = 1.0;

    public Quaternion() {
    }

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion(double[] v) {
        this(v[0], v[1], v[2], v[3]);
    }

    public Quaternion(Matrix33 m) {
        this.setMatrix33(m);
    }

    public Quaternion(AxisAngle aa) {
        this.setAxisAngle(aa);
    }

    public Quaternion(EulerAngles ea) {
        this.setEulerAngles(ea);
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Quaternion) {
            Quaternion q = (Quaternion)o;
            return this.x == q.x && this.y == q.y && this.z == q.z && this.w == q.w;
        }
        return false;
    }

    public double[] getArray() {
        double[] a = new double[]{this.x, this.y, this.z, this.w};
        return a;
    }

    public void setArray(double[] a) {
        this.x = a[0];
        this.y = a[1];
        this.z = a[2];
        this.w = a[3];
    }

    public boolean equals(Quaternion q) {
        return this.x == q.x && this.y == q.y && this.z == q.z && this.w == q.w;
    }

    public AxisAngle getAxisAngle() {
        return new AxisAngle(this);
    }

    public void setAxisAngle(AxisAngle aa) {
        double halfAngle = aa.getAngle() * 0.5;
        double cosHalfAngle = Math.cos(halfAngle);
        double sinHalfAngle = Math.sin(halfAngle);
        Vector3 normalizedAxis = Vector3.normalizeV(aa.getAxis());
        this.w = cosHalfAngle;
        this.x = sinHalfAngle * aa.m_axis.x;
        this.y = sinHalfAngle * aa.m_axis.y;
        this.z = sinHalfAngle * aa.m_axis.z;
    }

    public EulerAngles getEulerAngles() {
        return new EulerAngles(this);
    }

    public void setEulerAngles(EulerAngles ea) {
        Matrix33 m = new Matrix33();
        m.rotateX(ea.pitch);
        m.rotateY(ea.yaw);
        m.rotateZ(ea.roll);
        this.setMatrix33(m);
    }

    public Matrix33 getMatrix33() {
        Matrix33 m = new Matrix33();
        m.setQuaternion(this);
        return m;
    }

    public void setMatrix33(Matrix33 m) {
        double tr = m.m00 + m.m11 + m.m22;
        if (tr > 0.0) {
            double s = Math.sqrt(tr + 1.0);
            this.w = s * 0.5;
            s = 0.5 / s;
            this.x = (m.m21 - m.m12) * s;
            this.y = (m.m02 - m.m20) * s;
            this.z = (m.m10 - m.m01) * s;
        } else {
            int[] nArray = new int[3];
            nArray[0] = 1;
            nArray[1] = 2;
            int[] nxt = nArray;
            double[][] a = m.getMatrix();
            int i = 0;
            if (a[1][1] > a[0][0]) {
                i = 1;
            }
            if (a[2][2] > a[i][i]) {
                i = 2;
            }
            int j = nxt[i];
            int k = nxt[j];
            double s = Math.sqrt(a[i][i] - (a[j][j] + a[k][k]) + 1.0);
            double[] q = new double[4];
            q[i] = s * 0.5;
            if (s != 0.0) {
                s = 0.5 / s;
            }
            q[3] = (a[k][j] - a[j][k]) * s;
            q[j] = (a[j][i] + a[i][j]) * s;
            q[k] = (a[k][i] + a[i][k]) * s;
            this.setArray(q);
        }
    }

    public void normalize() {
        double lengthSquared = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (lengthSquared != 1.0) {
            double length = Math.sqrt(lengthSquared);
            this.x /= length;
            this.y /= length;
            this.z /= length;
            this.w /= length;
        }
    }

    public static Quaternion multiply(Quaternion a, Quaternion b) {
        double A = (a.w + a.x) * (b.w + b.x);
        double B = (a.z - a.y) * (b.y - b.z);
        double C = (a.x - a.w) * (b.y - b.z);
        double D = (a.y + a.z) * (b.x - b.w);
        double E = (a.x + a.z) * (b.x + b.y);
        double F = (a.x - a.z) * (b.x - b.y);
        double G = (a.w + a.y) * (b.w - b.z);
        double H = (a.w - a.y) * (b.w + b.z);
        Quaternion q = new Quaternion();
        q.w = B + (-E - F + G + H) / 2.0;
        q.x = A - (E + F + G + H) / 2.0;
        q.y = -C + (E - F + G - H) / 2.0;
        q.z = -D + (E - F - G + H) / 2.0;
        return q;
    }

    public static Quaternion interpolate(Quaternion a, Quaternion b, double portion) {
        double scale1;
        double scale0;
        Quaternion b1;
        if (portion <= 0.0) {
            return (Quaternion)a.clone();
        }
        if (portion >= 1.0) {
            return (Quaternion)b.clone();
        }
        double cosom = a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
        if (cosom < 0.0) {
            cosom = -cosom;
            b1 = new Quaternion(-b.x, -b.y, -b.z, -b.w);
        } else {
            b1 = b;
        }
        if (1.0 - cosom > Double.MIN_VALUE) {
            double omega = Math.acos(cosom);
            double sinom = Math.sin(omega);
            scale0 = Math.sin((1.0 - portion) * omega) / sinom;
            scale1 = Math.sin(portion * omega) / sinom;
        } else {
            scale0 = 1.0 - portion;
            scale1 = portion;
        }
        Quaternion q = new Quaternion();
        q.x = scale0 * a.x + scale1 * b1.x;
        q.y = scale0 * a.y + scale1 * b1.y;
        q.z = scale0 * a.z + scale1 * b1.z;
        q.w = scale0 * a.w + scale1 * b1.w;
        return q;
    }

    @Override
    public Interpolable interpolate(Interpolable b, double portion) {
        return Quaternion.interpolate(this, (Quaternion)b, portion);
    }

    public String toString() {
        return "edu.cmu.cs.stage3.math.Quaternion[x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",w=" + this.w + "]";
    }

    public static Quaternion valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.Quaternion[x=", ",y=", ",z=", ",w=", "]"};
        double[] values = new double[markers.length - 1];
        int i = 0;
        while (i < values.length) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
            ++i;
        }
        return new Quaternion(values);
    }
}

