/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Ray;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Plane
implements Cloneable {
    private double m_a;
    private double m_b;
    private double m_c;
    private double m_d;

    public Plane() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Plane(double a, double b, double c, double d) {
        this.m_a = a;
        this.m_b = b;
        this.m_c = c;
        this.m_d = d;
    }

    public Plane(double[] array) {
        this(array[0], array[1], array[2], array[3]);
    }

    public Plane(Vector3d position, Vector3d normal) {
        this(normal.x, normal.y, normal.z, -(normal.x * position.x + normal.y * position.y + normal.z * position.z));
    }

    public Plane(Vector3d v0, Vector3d v1, Vector3d v2) {
        this(v0, MathUtilities.normalizeV(MathUtilities.crossProduct(MathUtilities.normalizeV(MathUtilities.subtract(v2, v1)), MathUtilities.normalizeV(MathUtilities.subtract(v0, v1)))));
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Plane) {
            Plane plane = (Plane)o;
            return this.m_a == plane.m_a && this.m_b == plane.m_b && this.m_c == plane.m_c && this.m_d == plane.m_d;
        }
        return false;
    }

    public double intersect(Ray ray) {
        Point3d p = ray.getOrigin();
        Vector3d d = ray.getDirection();
        double denom = this.m_a * d.x + this.m_b * d.y + this.m_c * d.z;
        if (denom == 0.0) {
            return Double.NaN;
        }
        double numer = this.m_a * p.x + this.m_b * p.y + this.m_c * p.z + this.m_d;
        return -numer / denom;
    }

    public String toString() {
        return "edu.cmu.cs.stage3.math.Plane[a=" + this.m_a + ",b=" + this.m_b + ",c=" + this.m_c + ",d=" + this.m_d + "]";
    }

    public static Plane valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.Plane[a=", ",b=", ",c=", ",d=", "]"};
        double[] values = new double[markers.length - 1];
        int i = 0;
        while (i < values.length) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
            ++i;
        }
        return new Plane(values);
    }
}

