/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.AxisAngle;
import edu.cmu.cs.stage3.math.EulerAngles;
import edu.cmu.cs.stage3.math.Interpolable;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Shear;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class Matrix33
extends Matrix3d
implements Interpolable {
    public static final Matrix33 IDENTITY = new Matrix33();

    public Matrix33() {
        this(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix33(double rc00, double rc01, double rc02, double rc10, double rc11, double rc12, double rc20, double rc21, double rc22) {
        this.m00 = rc00;
        this.m01 = rc01;
        this.m02 = rc02;
        this.m10 = rc10;
        this.m11 = rc11;
        this.m12 = rc12;
        this.m20 = rc20;
        this.m21 = rc21;
        this.m22 = rc22;
    }

    public Matrix33(double[] row0, double[] row1, double[] row2) {
        this(row0[0], row0[1], row0[2], row1[0], row1[1], row1[2], row2[0], row2[1], row2[2]);
    }

    public Matrix33(Vector3d row0, Vector3d row1, Vector3d row2) {
        this(row0.x, row0.y, row0.z, row1.x, row1.y, row1.z, row2.x, row2.y, row2.z);
    }

    public Matrix33(double[] a) {
        this(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]);
    }

    public Matrix33(double[][] m) {
        this(m[0], m[1], m[2]);
    }

    public Matrix33(Matrix3d m) {
        super(m);
    }

    public Matrix33(AxisAngle aa) {
        this.setAxisAngle(aa);
    }

    public Matrix33(Quaternion q) {
        this.setQuaternion(q);
    }

    public Matrix33(EulerAngles ea) {
        this.setEulerAngles(ea);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Matrix33) {
            Matrix33 m = (Matrix33)o;
            return this.m00 == m.m00 && this.m01 == m.m01 && this.m02 == m.m02 && this.m10 == m.m10 && this.m11 == m.m11 && this.m12 == m.m12 && this.m20 == m.m20 && this.m21 == m.m21 && this.m22 == m.m22;
        }
        return false;
    }

    public double getItem(int i, int j) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
                break;
            }
            case 1: {
                switch (j) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
                break;
            }
            case 2: {
                switch (j) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public void setItem(int i, int j, double v) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        this.m00 = v;
                        return;
                    }
                    case 1: {
                        this.m01 = v;
                        return;
                    }
                    case 2: {
                        this.m02 = v;
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (j) {
                    case 0: {
                        this.m10 = v;
                        return;
                    }
                    case 1: {
                        this.m11 = v;
                        return;
                    }
                    case 2: {
                        this.m12 = v;
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (j) {
                    case 0: {
                        this.m20 = v;
                        return;
                    }
                    case 1: {
                        this.m21 = v;
                        return;
                    }
                    case 2: {
                        this.m22 = v;
                        return;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector3 getRow(int i) {
        switch (i) {
            case 0: {
                return new Vector3(this.m00, this.m01, this.m02);
            }
            case 1: {
                return new Vector3(this.m10, this.m11, this.m12);
            }
            case 2: {
                return new Vector3(this.m20, this.m21, this.m22);
            }
        }
        return null;
    }

    public void setRow(int i, Vector3 v) {
        switch (i) {
            case 0: {
                this.m00 = v.x;
                this.m01 = v.y;
                this.m02 = v.z;
                break;
            }
            case 1: {
                this.m10 = v.x;
                this.m11 = v.y;
                this.m12 = v.z;
                break;
            }
            case 2: {
                this.m20 = v.x;
                this.m21 = v.y;
                this.m22 = v.z;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Vector3 getColumn(int i) {
        switch (i) {
            case 0: {
                return new Vector3(this.m00, this.m10, this.m20);
            }
            case 1: {
                return new Vector3(this.m01, this.m11, this.m21);
            }
            case 2: {
                return new Vector3(this.m02, this.m12, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setColumn(int i, Vector3 v) {
        switch (i) {
            case 0: {
                this.m00 = v.x;
                this.m10 = v.y;
                this.m20 = v.z;
                break;
            }
            case 1: {
                this.m01 = v.x;
                this.m11 = v.y;
                this.m21 = v.z;
                break;
            }
            case 2: {
                this.m02 = v.x;
                this.m12 = v.y;
                this.m22 = v.z;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public double[] getArray(boolean rowMajor) {
        if (rowMajor) {
            double[] a = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22};
            return a;
        }
        double[] a = new double[]{this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22};
        return a;
    }

    public void setArray(double[] a, boolean rowMajor) {
        if (rowMajor) {
            this.m00 = a[0];
            this.m01 = a[1];
            this.m02 = a[2];
            this.m10 = a[3];
            this.m11 = a[4];
            this.m12 = a[5];
            this.m20 = a[6];
            this.m21 = a[7];
            this.m22 = a[8];
        } else {
            this.m00 = a[0];
            this.m01 = a[3];
            this.m02 = a[6];
            this.m10 = a[1];
            this.m11 = a[4];
            this.m12 = a[7];
            this.m20 = a[2];
            this.m21 = a[5];
            this.m22 = a[8];
        }
    }

    public double[][] getMatrix() {
        double[][] m = new double[][]{{this.m00, this.m01, this.m02}, {this.m10, this.m11, this.m12}, {this.m20, this.m21, this.m22}};
        return m;
    }

    public void setMatrix(double[][] m) {
        this.m00 = m[0][0];
        this.m01 = m[0][1];
        this.m02 = m[0][2];
        this.m10 = m[1][0];
        this.m11 = m[1][1];
        this.m12 = m[1][2];
        this.m20 = m[2][0];
        this.m21 = m[2][1];
        this.m22 = m[2][2];
    }

    public Quaternion getQuaternion() {
        return new Quaternion(this);
    }

    public void setQuaternion(Quaternion q) {
        double xx = q.x * q.x;
        double xy = q.x * q.y;
        double xz = q.x * q.z;
        double yy = q.y * q.y;
        double yz = q.y * q.z;
        double zz = q.z * q.z;
        double wx = q.w * q.x;
        double wy = q.w * q.y;
        double wz = q.w * q.z;
        this.m00 = 1.0 - 2.0 * (yy + zz);
        this.m01 = 2.0 * (xy - wz);
        this.m02 = 2.0 * (xz + wy);
        this.m10 = 2.0 * (xy + wz);
        this.m11 = 1.0 - 2.0 * (xx + zz);
        this.m12 = 2.0 * (yz - wx);
        this.m20 = 2.0 * (xz - wy);
        this.m21 = 2.0 * (yz + wx);
        this.m22 = 1.0 - 2.0 * (xx + yy);
    }

    public AxisAngle getAxisAngle() {
        return new AxisAngle(this);
    }

    public void setAxisAngle(AxisAngle aa) {
        double theta = aa.getAngle();
        Vector3d axis = aa.getAxis();
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        this.m00 = axis.x * axis.x + cosTheta * (1.0 - axis.x * axis.x);
        this.m01 = axis.x * axis.y * (1.0 - cosTheta) + axis.z * sinTheta;
        this.m02 = axis.z * axis.x * (1.0 - cosTheta) - axis.y * sinTheta;
        this.m10 = axis.x * axis.y * (1.0 - cosTheta) - axis.z * sinTheta;
        this.m11 = axis.y * axis.y + cosTheta * (1.0 - axis.y * axis.y);
        this.m12 = axis.y * axis.z * (1.0 - cosTheta) + axis.x * sinTheta;
        this.m20 = axis.z * axis.x * (1.0 - cosTheta) + axis.y * sinTheta;
        this.m21 = axis.y * axis.z * (1.0 - cosTheta) - axis.x * sinTheta;
        this.m22 = axis.z * axis.z + cosTheta * (1.0 - axis.z * axis.z);
    }

    public EulerAngles getEulerAngles() {
        return new EulerAngles(this);
    }

    public void setEulerAngles(EulerAngles ea) {
        double c1 = Math.cos(ea.pitch);
        double s1 = Math.sin(ea.pitch);
        double c2 = Math.cos(ea.yaw);
        double s2 = Math.sin(ea.yaw);
        double c3 = Math.cos(ea.roll);
        double s3 = Math.sin(ea.roll);
        this.m00 = c2 * c3;
        this.m01 = s2 * s1 * c3 - c1 * s3;
        this.m02 = s2 * c1 * c3 + s1 * s3;
        this.m10 = c2 * s3;
        this.m11 = s2 * s1 * s3 + c1 * c3;
        this.m12 = c2 * s1;
        this.m20 = -s2;
        this.m21 = c2 * s1;
        this.m22 = c2 * c1;
    }

    public Vector3d[] getRows() {
        return new Vector3d[]{this.getRow(0), this.getRow(1), this.getRow(2)};
    }

    public void setRows(Vector3d row0, Vector3d row1, Vector3d row2) {
        this.m00 = row0.x;
        this.m01 = row0.y;
        this.m02 = row0.z;
        this.m10 = row1.x;
        this.m11 = row1.y;
        this.m12 = row1.z;
        this.m20 = row2.x;
        this.m21 = row2.y;
        this.m22 = row2.z;
    }

    public void setForwardUpGuide(Vector3d forward, Vector3d upGuide) {
        Vector3 row2 = Vector3.normalizeV(forward);
        Vector3 normalizedUpGuide = upGuide != null ? Vector3.normalizeV(upGuide) : new Vector3(0.0, 1.0, 0.0);
        Vector3 row0 = Vector3.crossProduct(normalizedUpGuide, row2);
        Vector3 row1 = Vector3.crossProduct(row2, row0);
        this.setRows(row0, row1, row2);
    }

    public void rotateX(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        int i = 0;
        while (i < 3) {
            double tmp = this.getItem(i, 1);
            this.setItem(i, 1, tmp * cosAngle - this.getItem(i, 2) * sinAngle);
            this.setItem(i, 2, tmp * sinAngle + this.getItem(i, 2) * cosAngle);
            ++i;
        }
    }

    public void rotateY(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        int i = 0;
        while (i < 3) {
            double tmp = this.getItem(i, 0);
            this.setItem(i, 0, tmp * cosAngle + this.getItem(i, 2) * sinAngle);
            this.setItem(i, 2, -tmp * sinAngle + this.getItem(i, 2) * cosAngle);
            ++i;
        }
    }

    public void rotateZ(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        int i = 0;
        while (i < 3) {
            double tmp = this.getItem(i, 0);
            this.setItem(i, 0, tmp * cosAngle - this.getItem(i, 1) * sinAngle);
            this.setItem(i, 1, tmp * sinAngle + this.getItem(i, 1) * cosAngle);
            ++i;
        }
    }

    public Vector3 getScaledSpace() {
        Vector3 row0 = this.getRow(0);
        Vector3 row1 = this.getRow(1);
        Vector3 row2 = this.getRow(2);
        Vector3 scale = new Vector3();
        Shear shear = new Shear();
        scale.x = row0.getLength();
        row0.normalize();
        shear.xy = Vector3.dotProduct(row0, row1);
        row1 = Vector3.combine(row1, row0, 1.0, -shear.xy);
        scale.y = row1.getLength();
        row1.normalize();
        shear.xy /= scale.y;
        shear.xz = Vector3.dotProduct(row0, row2);
        row2 = Vector3.combine(row2, row0, 1.0, -shear.xz);
        shear.yz = Vector3.dotProduct(row1, row2);
        row2 = Vector3.combine(row2, row1, 1.0, -shear.yz);
        scale.z = row2.getLength();
        row2.normalize();
        shear.xz /= scale.z;
        shear.yz /= scale.z;
        double determinate = Vector3.dotProduct(row0, Vector3.crossProduct(row1, row2));
        if (determinate < 0.0) {
            row0.negate();
            row1.negate();
            row2.negate();
            scale.multiply(-1.0);
        }
        return scale;
    }

    public static Matrix33 multiply(Matrix33 a, Matrix33 b) {
        Matrix33 m = new Matrix33();
        m.m00 = a.m00 * b.m00 + a.m01 * b.m10 + a.m02 * b.m20;
        m.m01 = a.m00 * b.m01 + a.m01 * b.m11 + a.m02 * b.m21;
        m.m02 = a.m00 * b.m02 + a.m01 * b.m12 + a.m02 * b.m22;
        m.m10 = a.m10 * b.m00 + a.m11 * b.m10 + a.m12 * b.m20;
        m.m11 = a.m10 * b.m01 + a.m11 * b.m11 + a.m12 * b.m21;
        m.m12 = a.m10 * b.m02 + a.m11 * b.m12 + a.m12 * b.m22;
        m.m20 = a.m20 * b.m00 + a.m21 * b.m10 + a.m22 * b.m20;
        m.m21 = a.m20 * b.m01 + a.m21 * b.m11 + a.m22 * b.m21;
        m.m22 = a.m20 * b.m02 + a.m21 * b.m12 + a.m22 * b.m22;
        return m;
    }

    public static Matrix33 interpolate(Matrix33 a, Matrix33 b, double portion) {
        Quaternion q = Quaternion.interpolate(a.getQuaternion(), b.getQuaternion(), portion);
        return new Matrix33(q);
    }

    @Override
    public Interpolable interpolate(Interpolable b, double portion) {
        return Matrix33.interpolate(this, (Matrix33)b, portion);
    }

    public String toString() {
        return "edu.cmu.cs.stage3.math.Matrix33[rc00=" + this.m00 + ",rc01=" + this.m01 + ",rc02=" + this.m02 + ",rc10=" + this.m10 + ",rc11=" + this.m11 + ",rc12=" + this.m12 + ",rc20=" + this.m20 + ",rc21=" + this.m21 + ",rc22=" + this.m22 + "]";
    }

    public static Matrix33 valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.Matrix33[rc00=", ",rc01=", ",rc02=", ",rc10=", ",rc11=", ",rc12=", ",rc20=", ",rc21=", ",rc22=", "]"};
        double[] values = new double[markers.length - 1];
        int i = 0;
        while (i < values.length) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
            ++i;
        }
        return new Matrix33(values);
    }
}

