/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class MathUtilities {
    private static final Matrix4d IDENTITY_MATRIX_4D = new Matrix4d();
    private static final Matrix3d IDENTITY_MATRIX_3D = new Matrix3d();
    private static final Vector3d X_AXIS = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d Y_AXIS = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d Z_AXIS = new Vector3d(0.0, 0.0, 1.0);
    private static final Vector3d NEGATIVE_X_AXIS = new Vector3d(-1.0, 0.0, 0.0);
    private static final Vector3d NEGATIVE_Y_AXIS = new Vector3d(0.0, -1.0, 0.0);
    private static final Vector3d NEGATIVE_Z_AXIS = new Vector3d(0.0, 0.0, -1.0);

    public static Matrix4d getIdentityMatrix4d() {
        IDENTITY_MATRIX_4D.setIdentity();
        return IDENTITY_MATRIX_4D;
    }

    public static Matrix3d getIdentityMatrix3d() {
        IDENTITY_MATRIX_3D.setIdentity();
        return IDENTITY_MATRIX_3D;
    }

    public static Vector3d getXAxis() {
        MathUtilities.X_AXIS.x = 1.0;
        MathUtilities.X_AXIS.z = 0.0;
        MathUtilities.X_AXIS.y = 0.0;
        return X_AXIS;
    }

    public static Vector3d getYAxis() {
        MathUtilities.Y_AXIS.y = 1.0;
        MathUtilities.Y_AXIS.z = 0.0;
        MathUtilities.Y_AXIS.x = 0.0;
        return Y_AXIS;
    }

    public static Vector3d getZAxis() {
        MathUtilities.Z_AXIS.z = 1.0;
        MathUtilities.Z_AXIS.y = 0.0;
        MathUtilities.Z_AXIS.x = 0.0;
        return Z_AXIS;
    }

    public static Vector3d getNegativeXAxis() {
        MathUtilities.NEGATIVE_X_AXIS.x = -1.0;
        MathUtilities.NEGATIVE_X_AXIS.z = 0.0;
        MathUtilities.NEGATIVE_X_AXIS.y = 0.0;
        return NEGATIVE_X_AXIS;
    }

    public static Vector3d getNegativeYAxis() {
        MathUtilities.NEGATIVE_Y_AXIS.y = -1.0;
        MathUtilities.NEGATIVE_Y_AXIS.z = 0.0;
        MathUtilities.NEGATIVE_Y_AXIS.x = 0.0;
        return NEGATIVE_Y_AXIS;
    }

    public static Vector3d getNegativeZAxis() {
        MathUtilities.NEGATIVE_Z_AXIS.z = 1.0;
        MathUtilities.Z_AXIS.y = 0.0;
        MathUtilities.NEGATIVE_Z_AXIS.x = 0.0;
        return NEGATIVE_Z_AXIS;
    }

    public static Matrix4d createIdentityMatrix4d() {
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return m;
    }

    public static Matrix3d createIdentityMatrix3d() {
        Matrix3d m = new Matrix3d();
        m.setIdentity();
        return m;
    }

    public static Vector3d createXAxis() {
        return new Vector3d(1.0, 0.0, 0.0);
    }

    public static Vector3d createYAxis() {
        return new Vector3d(0.0, 1.0, 0.0);
    }

    public static Vector3d createZAxis() {
        return new Vector3d(0.0, 0.0, 1.0);
    }

    public static Vector3d createNegativeXAxis() {
        return new Vector3d(-1.0, 0.0, 0.0);
    }

    public static Vector3d createNegativeYAxis() {
        return new Vector3d(0.0, -1.0, 0.0);
    }

    public static Vector3d createNegativeZAxis() {
        return new Vector3d(0.0, 0.0, -1.0);
    }

    public static Vector3d createVector3d(Tuple4d t) {
        return new Vector3d(t.x / t.w, t.y / t.w, t.z / t.w);
    }

    public static Vector4d createVector4d(Tuple3d t, double tW) {
        return new Vector4d(t.x, t.y, t.z, tW);
    }

    public static Point3d createPoint3d(Tuple4d t) {
        return new Point3d(t.x / t.w, t.y / t.w, t.z / t.w);
    }

    public static Point4d createPoint4d(Tuple3d t, double tW) {
        return new Point4d(t.x, t.y, t.z, tW);
    }

    public static double getItem(Vector3d vector, int i) {
        switch (i) {
            case 0: {
                return vector.x;
            }
            case 1: {
                return vector.y;
            }
            case 2: {
                return vector.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static void setItem(Vector3d vector, int i, double value) {
        switch (i) {
            case 0: {
                vector.x = value;
                return;
            }
            case 1: {
                vector.y = value;
                return;
            }
            case 2: {
                vector.z = value;
                return;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static Vector3d add(Vector3d a, Vector3d b) {
        return new Vector3d(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vector3d subtract(Vector3d a, Vector3d b) {
        return new Vector3d(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vector3d negate(Vector3d v) {
        return new Vector3d(-v.x, -v.y, -v.z);
    }

    public static Vector3d multiply(Vector3d v, double scalar) {
        return new Vector3d(v.x * scalar, v.y * scalar, v.z * scalar);
    }

    public static Vector3d multiply(Vector3d v, Vector3d scalar) {
        return new Vector3d(v.x * scalar.x, v.y * scalar.y, v.z * scalar.z);
    }

    public static Vector3d divide(Vector3d v, double divisor) {
        return MathUtilities.multiply(v, 1.0 / divisor);
    }

    public static Vector3d divide(Vector3d numerator, Vector3d divisor) {
        return new Vector3d(numerator.x / divisor.x, numerator.y / divisor.y, numerator.z / divisor.z);
    }

    public static Vector3d invert(Vector3d v) {
        return new Vector3d(1.0 / v.x, 1.0 / v.y, 1.0 / v.z);
    }

    public static Vector3d normalizeV(Vector3d v) {
        Vector3d nv = new Vector3d(v);
        nv.normalize();
        return nv;
    }

    public static double getLengthSquared(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double getLength(double x, double y, double z) {
        double lengthSquared = MathUtilities.getLengthSquared(x, y, z);
        if (lengthSquared == 1.0) {
            return 1.0;
        }
        return Math.sqrt(lengthSquared);
    }

    public static double getLengthSquared(Vector3d v) {
        return MathUtilities.getLengthSquared(v.x, v.y, v.z);
    }

    public static double getLength(Vector3d v) {
        return MathUtilities.getLength(v.x, v.y, v.z);
    }

    public static double dotProduct(Vector3d a, Vector3d b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static Vector3d crossProduct(Vector3d a, Vector3d b) {
        return new Vector3d(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
    }

    public static Vector3d interpolate(Vector3d a, Vector3d b, double portion) {
        return new Vector3d(a.x + (b.x - a.x) * portion, a.y + (b.y - a.y) * portion, a.z + (b.z - a.z) * portion);
    }

    public static Vector3d projectOnto(Vector3d a, Vector3d b) {
        return MathUtilities.multiply(b, MathUtilities.dotProduct(b, a) / MathUtilities.dotProduct(b, b));
    }

    public static Vector3d multiply(Matrix3d a, Vector3d b) {
        double x = a.m00 * b.x + a.m01 * b.y + a.m02 * b.z;
        double y = a.m10 * b.x + a.m11 * b.y + a.m12 * b.z;
        double z = a.m20 * b.x + a.m21 * b.y + a.m22 * b.z;
        return new Vector3d(x, y, z);
    }

    public static Vector3d multiply(Vector3d a, Matrix4d b) {
        Vector3d ab = new Vector3d();
        ab.x = a.x * b.m00 + a.y * b.m10 + a.z * b.m20;
        ab.y = a.x * b.m01 + a.y * b.m11 + a.z * b.m21;
        ab.z = a.x * b.m02 + a.y * b.m12 + a.z * b.m22;
        return ab;
    }

    public static Vector3d combine(Vector3d a, Vector3d b, double asc1, double bsc1) {
        Vector3d ab = new Vector3d();
        ab.x = asc1 * a.x + bsc1 * b.x;
        ab.y = asc1 * a.y + bsc1 * b.y;
        ab.z = asc1 * a.z + bsc1 * b.z;
        return ab;
    }

    public static double getItem(Vector4d vector, int i) {
        switch (i) {
            case 0: {
                return vector.x;
            }
            case 1: {
                return vector.y;
            }
            case 2: {
                return vector.z;
            }
            case 3: {
                return vector.w;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static void setItem(Vector4d vector, int i, double value) {
        switch (i) {
            case 0: {
                vector.x = value;
                return;
            }
            case 1: {
                vector.y = value;
                return;
            }
            case 2: {
                vector.z = value;
                return;
            }
            case 3: {
                vector.w = value;
                return;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static Vector4d negate(Vector4d v) {
        return new Vector4d(-v.x, -v.y, -v.z, -v.w);
    }

    public static double dotProduct(Vector4d a, Vector4d b) {
        return a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
    }

    public static Vector4d multiply(double aX, double aY, double aZ, double aW, Matrix4d b) {
        Vector4d ab = new Vector4d();
        ab.x = aX * b.m00 + aY * b.m10 + aZ * b.m20 + aW * b.m30;
        ab.y = aX * b.m01 + aY * b.m11 + aZ * b.m21 + aW * b.m31;
        ab.z = aX * b.m02 + aY * b.m12 + aZ * b.m22 + aW * b.m32;
        ab.w = aX * b.m03 + aY * b.m13 + aZ * b.m23 + aW * b.m33;
        return ab;
    }

    public static Vector4d multiply(Vector4d a, Matrix4d b) {
        return MathUtilities.multiply(a.x, a.y, a.z, a.w, b);
    }

    public static Vector4d multiply(Vector3d a, double aW, Matrix4d b) {
        return MathUtilities.multiply(a.x, a.y, a.z, aW, b);
    }

    public static Vector4d multiply(Matrix4d a, double bX, double bY, double bZ, double bW) {
        Vector4d ab = new Vector4d();
        ab.x = bX * a.m00 + bY * a.m01 + bZ * a.m02 + bW * a.m03;
        ab.y = bX * a.m10 + bY * a.m11 + bZ * a.m12 + bW * a.m13;
        ab.z = bX * a.m20 + bY * a.m21 + bZ * a.m22 + bW * a.m23;
        ab.w = bX * a.m30 + bY * a.m31 + bZ * a.m32 + bW * a.m33;
        return ab;
    }

    public static Vector4d multiply(Matrix4d a, Vector4d b) {
        return MathUtilities.multiply(a, b.x, b.y, b.z, b.w);
    }

    public static Vector4d multiply(Matrix4d a, Vector3d b, double bW) {
        return MathUtilities.multiply(a, b.x, b.y, b.z, bW);
    }

    public static Vector3d getRow(Matrix3d m, int i) {
        switch (i) {
            case 0: {
                return new Vector3d(m.m00, m.m01, m.m02);
            }
            case 1: {
                return new Vector3d(m.m10, m.m11, m.m12);
            }
            case 2: {
                return new Vector3d(m.m20, m.m21, m.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static void setRow(Matrix3d m, int i, Vector3d v) {
        switch (i) {
            case 0: {
                m.m00 = v.x;
                m.m01 = v.y;
                m.m02 = v.z;
                break;
            }
            case 1: {
                m.m10 = v.x;
                m.m11 = v.y;
                m.m12 = v.z;
                break;
            }
            case 2: {
                m.m20 = v.x;
                m.m21 = v.y;
                m.m22 = v.z;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public static Vector3d getColumn(Matrix3d m, int i) {
        switch (i) {
            case 0: {
                return new Vector3d(m.m00, m.m10, m.m20);
            }
            case 1: {
                return new Vector3d(m.m01, m.m11, m.m21);
            }
            case 2: {
                return new Vector3d(m.m02, m.m12, m.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static void setColumn(Matrix3d m, int i, Vector3d v) {
        switch (i) {
            case 0: {
                m.m00 = v.x;
                m.m10 = v.y;
                m.m20 = v.z;
                break;
            }
            case 1: {
                m.m01 = v.x;
                m.m11 = v.y;
                m.m21 = v.z;
                break;
            }
            case 2: {
                m.m02 = v.x;
                m.m12 = v.y;
                m.m22 = v.z;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public static Matrix3d multiply(Matrix3d a, Matrix3d b) {
        Matrix3d m = new Matrix3d();
        m.m00 = a.m00 * b.m00 + a.m01 * b.m10 + a.m02 * b.m20;
        m.m01 = a.m00 * b.m01 + a.m01 * b.m11 + a.m02 * b.m21;
        m.m02 = a.m00 * b.m02 + a.m01 * b.m12 + a.m02 * b.m22;
        m.m10 = a.m10 * b.m00 + a.m11 * b.m10 + a.m12 * b.m20;
        m.m11 = a.m10 * b.m01 + a.m11 * b.m11 + a.m12 * b.m21;
        m.m12 = a.m10 * b.m02 + a.m11 * b.m12 + a.m12 * b.m22;
        m.m20 = a.m20 * b.m00 + a.m21 * b.m10 + a.m22 * b.m20;
        m.m21 = a.m20 * b.m01 + a.m21 * b.m11 + a.m22 * b.m21;
        m.m22 = a.m20 * b.m02 + a.m21 * b.m12 + a.m22 * b.m22;
        return m;
    }

    public static Matrix4d multiply(Matrix4d a, Matrix4d b) {
        Matrix4d m = new Matrix4d();
        m.m00 = a.m00 * b.m00 + a.m01 * b.m10 + a.m02 * b.m20 + a.m03 * b.m30;
        m.m01 = a.m00 * b.m01 + a.m01 * b.m11 + a.m02 * b.m21 + a.m03 * b.m31;
        m.m02 = a.m00 * b.m02 + a.m01 * b.m12 + a.m02 * b.m22 + a.m03 * b.m32;
        m.m03 = a.m00 * b.m03 + a.m01 * b.m13 + a.m02 * b.m23 + a.m03 * b.m33;
        m.m10 = a.m10 * b.m00 + a.m11 * b.m10 + a.m12 * b.m20 + a.m13 * b.m30;
        m.m11 = a.m10 * b.m01 + a.m11 * b.m11 + a.m12 * b.m21 + a.m13 * b.m31;
        m.m12 = a.m10 * b.m02 + a.m11 * b.m12 + a.m12 * b.m22 + a.m13 * b.m32;
        m.m13 = a.m10 * b.m03 + a.m11 * b.m13 + a.m12 * b.m23 + a.m13 * b.m33;
        m.m20 = a.m20 * b.m00 + a.m21 * b.m10 + a.m22 * b.m20 + a.m23 * b.m30;
        m.m21 = a.m20 * b.m01 + a.m21 * b.m11 + a.m22 * b.m21 + a.m23 * b.m31;
        m.m22 = a.m20 * b.m02 + a.m21 * b.m12 + a.m22 * b.m22 + a.m23 * b.m32;
        m.m23 = a.m20 * b.m03 + a.m21 * b.m13 + a.m22 * b.m23 + a.m23 * b.m33;
        m.m30 = a.m30 * b.m00 + a.m31 * b.m10 + a.m32 * b.m20 + a.m33 * b.m30;
        m.m31 = a.m30 * b.m01 + a.m31 * b.m11 + a.m32 * b.m21 + a.m33 * b.m31;
        m.m32 = a.m30 * b.m02 + a.m31 * b.m12 + a.m32 * b.m22 + a.m33 * b.m32;
        m.m33 = a.m30 * b.m03 + a.m31 * b.m13 + a.m32 * b.m23 + a.m33 * b.m33;
        return m;
    }

    public static boolean contains(Tuple3d t, double d) {
        if (Double.isNaN(d)) {
            return Double.isNaN(t.x) || Double.isNaN(t.y) || Double.isNaN(t.z);
        }
        return t.x == d || t.y == d || t.z == d;
    }
}

