/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.AxisAngle;
import edu.cmu.cs.stage3.math.Interpolable;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Shear;
import javax.vecmath.Vector3d;

public class EulerAngles
implements Interpolable,
Cloneable {
    public double pitch = 0.0;
    public double yaw = 0.0;
    public double roll = 0.0;

    public EulerAngles() {
    }

    public EulerAngles(double pitch, double yaw, double roll) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.roll = roll;
    }

    public EulerAngles(double[] a) {
        this(a[0], a[1], a[2]);
    }

    public EulerAngles(Matrix33 m) {
        this.setMatrix33(m);
    }

    public EulerAngles(AxisAngle aa) {
        this.setAxisAngle(aa);
    }

    public EulerAngles(Quaternion q) {
        this.setQuaternion(q);
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof EulerAngles) {
            EulerAngles ea = (EulerAngles)o;
            return this.yaw == ea.yaw && this.pitch == ea.pitch && this.roll == ea.roll;
        }
        return false;
    }

    public Matrix33 getMatrix33() {
        return new Matrix33(this);
    }

    public void setMatrix33(Matrix33 m) {
        Vector3d row0 = MathUtilities.getRow(m, 0);
        Vector3d row1 = MathUtilities.getRow(m, 1);
        Vector3d row2 = MathUtilities.getRow(m, 2);
        Vector3d scale = new Vector3d();
        Shear shear = new Shear();
        scale.x = row0.length();
        row0.normalize();
        shear.xy = MathUtilities.dotProduct(row0, row1);
        row1 = MathUtilities.combine(row1, row0, 1.0, -shear.xy);
        scale.y = row1.length();
        row1.normalize();
        shear.xy /= scale.y;
        shear.xz = MathUtilities.dotProduct(row0, row2);
        row2 = MathUtilities.combine(row2, row0, 1.0, -shear.xz);
        shear.yz = MathUtilities.dotProduct(row1, row2);
        row2 = MathUtilities.combine(row2, row1, 1.0, -shear.yz);
        scale.z = row2.length();
        row2.normalize();
        shear.xz /= scale.z;
        shear.yz /= scale.z;
        double determinate = MathUtilities.dotProduct(row0, MathUtilities.crossProduct(row1, row2));
        if (determinate < 0.0) {
            row0.negate();
            row1.negate();
            row2.negate();
            scale.scale(-1.0);
        }
        this.yaw = Math.asin(-row0.z);
        if (Math.cos(this.yaw) != 0.0) {
            this.pitch = Math.atan2(row1.z, row2.z);
            this.roll = Math.atan2(row0.y, row0.x);
        } else {
            this.pitch = Math.atan2(row1.x, row1.y);
            this.roll = 0.0;
        }
    }

    public AxisAngle getAxisAngle() {
        return new AxisAngle(this);
    }

    public void setAxisAngle(AxisAngle aa) {
        this.setMatrix33(aa.getMatrix33());
    }

    public Quaternion getQuaternion() {
        return new Quaternion(this);
    }

    public void setQuaternion(Quaternion q) {
        this.setMatrix33(q.getMatrix33());
    }

    public static EulerAngles interpolate(EulerAngles a, EulerAngles b, double portion) {
        Quaternion q = Quaternion.interpolate(a.getQuaternion(), b.getQuaternion(), portion);
        return new EulerAngles(q);
    }

    @Override
    public Interpolable interpolate(Interpolable b, double portion) {
        return EulerAngles.interpolate(this, (EulerAngles)b, portion);
    }

    public String toString() {
        return "edu.cmu.cs.stage3.math.EulerAngles[pitch=" + this.pitch + ",yaw=" + this.yaw + ",roll=" + this.roll + "]";
    }

    public static EulerAngles revolutionsToRadians(EulerAngles ea) {
        return new EulerAngles(ea.pitch / 0.15915494309189535, ea.yaw / 0.15915494309189535, ea.roll / 0.15915494309189535);
    }

    public static EulerAngles radiansToRevolutions(EulerAngles ea) {
        return new EulerAngles(ea.pitch * 0.15915494309189535, ea.yaw * 0.15915494309189535, ea.roll * 0.15915494309189535);
    }

    public static EulerAngles valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.EulerAngles[pitch=", ",yaw=", ",roll=", "]"};
        double[] values = new double[markers.length - 1];
        int i = 0;
        while (i < values.length) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
            ++i;
        }
        return new EulerAngles(values);
    }
}

