/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.Quadratic;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public abstract class BasisMatrixQuadratic
implements Quadratic {
    private Matrix3d m_h;
    protected Vector3d m_g;

    protected BasisMatrixQuadratic(Matrix3d h, Vector3d g) {
        this.m_h = h;
        this.m_g = g;
    }

    @Override
    public double evaluate(double t) {
        double tt = t * t;
        return (tt * this.m_h.m00 + t * this.m_h.m10 + this.m_h.m20) * this.m_g.x + (tt * this.m_h.m01 + t * this.m_h.m11 + this.m_h.m21) * this.m_g.y + (tt * this.m_h.m02 + t * this.m_h.m12 + this.m_h.m22) * this.m_g.z;
    }

    @Override
    public double evaluateDerivative(double t) {
        double t2 = t * 2.0;
        return (t2 * this.m_h.m00 + this.m_h.m10) * this.m_g.x + (t2 * this.m_h.m01 + this.m_h.m11) * this.m_g.y + (t2 * this.m_h.m02 + this.m_h.m12) * this.m_g.z;
    }
}

