/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.image.codec;

import edu.cmu.cs.stage3.image.codec.BMPCodec;
import edu.cmu.cs.stage3.image.codec.FPXCodec;
import edu.cmu.cs.stage3.image.codec.FileSeekableStream;
import edu.cmu.cs.stage3.image.codec.GIFCodec;
import edu.cmu.cs.stage3.image.codec.ImageDecodeParam;
import edu.cmu.cs.stage3.image.codec.ImageDecoder;
import edu.cmu.cs.stage3.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.image.codec.ImageEncoder;
import edu.cmu.cs.stage3.image.codec.JPEGCodec;
import edu.cmu.cs.stage3.image.codec.JaiI18N;
import edu.cmu.cs.stage3.image.codec.PNGCodec;
import edu.cmu.cs.stage3.image.codec.SeekableStream;
import edu.cmu.cs.stage3.image.codec.TIFFCodec;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ImageCodec {
    private static Hashtable codecs = new Hashtable();
    private static final byte[][] grayIndexCmaps;
    private static final int[] GrayBits8;
    private static final ComponentColorModel colorModelGray8;
    private static final int[] GrayAlphaBits8;
    private static final ComponentColorModel colorModelGrayAlpha8;
    private static final int[] GrayBits16;
    private static final ComponentColorModel colorModelGray16;
    private static final int[] GrayAlphaBits16;
    private static final ComponentColorModel colorModelGrayAlpha16;
    private static final int[] GrayBits32;
    private static final ComponentColorModel colorModelGray32;
    private static final int[] GrayAlphaBits32;
    private static final ComponentColorModel colorModelGrayAlpha32;
    private static final int[] RGBBits8;
    private static final ComponentColorModel colorModelRGB8;
    private static final int[] RGBABits8;
    private static final ComponentColorModel colorModelRGBA8;
    private static final int[] RGBBits16;
    private static final ComponentColorModel colorModelRGB16;
    private static final int[] RGBABits16;
    private static final ComponentColorModel colorModelRGBA16;
    private static final int[] RGBBits32;
    private static final ComponentColorModel colorModelRGB32;
    private static final int[] RGBABits32;
    private static final ComponentColorModel colorModelRGBA32;

    static {
        ImageCodec.registerCodec(new BMPCodec());
        ImageCodec.registerCodec(new GIFCodec());
        ImageCodec.registerCodec(new FPXCodec());
        ImageCodec.registerCodec(new JPEGCodec());
        ImageCodec.registerCodec(new PNGCodec());
        ImageCodec.registerCodec(new TIFFCodec());
        byte[][] byArrayArray = new byte[5][];
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 85;
        byArray2[2] = -86;
        byArray2[3] = -1;
        byArrayArray[2] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[1] = 17;
        byArray3[2] = 34;
        byArray3[3] = 51;
        byArray3[4] = 68;
        byArray3[5] = 85;
        byArray3[6] = 102;
        byArray3[7] = 119;
        byArray3[8] = -120;
        byArray3[9] = -103;
        byArray3[10] = -86;
        byArray3[11] = -69;
        byArray3[12] = -52;
        byArray3[13] = -35;
        byArray3[14] = -18;
        byArray3[15] = -1;
        byArrayArray[4] = byArray3;
        grayIndexCmaps = byArrayArray;
        GrayBits8 = new int[]{8};
        colorModelGray8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits8, false, false, 1, 0);
        GrayAlphaBits8 = new int[]{8, 8};
        colorModelGrayAlpha8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits8, true, false, 3, 0);
        GrayBits16 = new int[]{16};
        colorModelGray16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits16, false, false, 1, 1);
        GrayAlphaBits16 = new int[]{16, 16};
        colorModelGrayAlpha16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits16, true, false, 3, 1);
        GrayBits32 = new int[]{32};
        colorModelGray32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits32, false, false, 1, 3);
        GrayAlphaBits32 = new int[]{32, 32};
        colorModelGrayAlpha32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits32, true, false, 3, 3);
        RGBBits8 = new int[]{8, 8, 8};
        colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits8, false, false, 1, 0);
        RGBABits8 = new int[]{8, 8, 8, 8};
        colorModelRGBA8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits8, true, false, 3, 0);
        RGBBits16 = new int[]{16, 16, 16};
        colorModelRGB16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits16, false, false, 1, 1);
        RGBABits16 = new int[]{16, 16, 16, 16};
        colorModelRGBA16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits16, true, false, 3, 1);
        RGBBits32 = new int[]{32, 32, 32};
        colorModelRGB32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits32, false, false, 1, 3);
        RGBABits32 = new int[]{32, 32, 32, 32};
        colorModelRGBA32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits32, true, false, 3, 3);
    }

    protected ImageCodec() {
    }

    public static ImageCodec getCodec(String name) {
        return (ImageCodec)codecs.get(name.toLowerCase());
    }

    public static void registerCodec(ImageCodec codec) {
        codecs.put(codec.getFormatName().toLowerCase(), codec);
    }

    public static void unregisterCodec(String name) {
        codecs.remove(name.toLowerCase());
    }

    public static Enumeration getCodecs() {
        return codecs.elements();
    }

    public static ImageEncoder createImageEncoder(String name, OutputStream dst, ImageEncodeParam param) {
        ImageCodec codec = ImageCodec.getCodec(name);
        if (codec == null) {
            return null;
        }
        return codec.createImageEncoder(dst, param);
    }

    public static ImageDecoder createImageDecoder(String name, InputStream src, ImageDecodeParam param) {
        ImageCodec codec = ImageCodec.getCodec(name);
        if (codec == null) {
            return null;
        }
        return codec.createImageDecoder(src, param);
    }

    public static ImageDecoder createImageDecoder(String name, File src, ImageDecodeParam param) throws IOException {
        ImageCodec codec = ImageCodec.getCodec(name);
        if (codec == null) {
            return null;
        }
        return codec.createImageDecoder(src, param);
    }

    public static ImageDecoder createImageDecoder(String name, SeekableStream src, ImageDecodeParam param) {
        ImageCodec codec = ImageCodec.getCodec(name);
        if (codec == null) {
            return null;
        }
        return codec.createImageDecoder(src, param);
    }

    private static String[] vectorToStrings(Vector nameVec) {
        int count = nameVec.size();
        String[] names = new String[count];
        int i = 0;
        while (i < count) {
            names[i] = (String)nameVec.elementAt(i);
            ++i;
        }
        return names;
    }

    public static String[] getDecoderNames(SeekableStream src) {
        if (!src.canSeekBackwards() && !src.markSupported()) {
            throw new IllegalArgumentException(JaiI18N.getString("src_must_support_seeking_backwards_or_marking_"));
        }
        Enumeration enum0 = codecs.elements();
        Vector<String> nameVec = new Vector<String>();
        Object opName = null;
        while (enum0.hasMoreElements()) {
            ImageCodec codec = (ImageCodec)enum0.nextElement();
            int bytesNeeded = codec.getNumHeaderBytes();
            if (bytesNeeded == 0 && !src.canSeekBackwards()) continue;
            try {
                if (bytesNeeded > 0) {
                    src.mark(bytesNeeded);
                    byte[] header = new byte[bytesNeeded];
                    src.readFully(header);
                    src.reset();
                    if (!codec.isFormatRecognized(header)) continue;
                    nameVec.add(codec.getFormatName());
                    continue;
                }
                long pointer = src.getFilePointer();
                src.seek(0L);
                if (codec.isFormatRecognized(src)) {
                    nameVec.add(codec.getFormatName());
                }
                src.seek(pointer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ImageCodec.vectorToStrings(nameVec);
    }

    public static String[] getEncoderNames(RenderedImage im, ImageEncodeParam param) {
        Enumeration enum0 = codecs.elements();
        Vector<String> nameVec = new Vector<String>();
        Object opName = null;
        while (enum0.hasMoreElements()) {
            ImageCodec codec = (ImageCodec)enum0.nextElement();
            if (!codec.canEncodeImage(im, param)) continue;
            nameVec.add(codec.getFormatName());
        }
        return ImageCodec.vectorToStrings(nameVec);
    }

    public abstract String getFormatName();

    public int getNumHeaderBytes() {
        return 0;
    }

    public boolean isFormatRecognized(byte[] header) {
        throw new RuntimeException(JaiI18N.getString("Method_unimplemented__should_be_implemented_by_subclass_"));
    }

    public boolean isFormatRecognized(SeekableStream src) throws IOException {
        throw new RuntimeException(JaiI18N.getString("Method_unimplemented__should_be_implemented_by_subclass_"));
    }

    protected abstract Class getEncodeParamClass();

    protected abstract Class getDecodeParamClass();

    protected abstract ImageEncoder createImageEncoder(OutputStream var1, ImageEncodeParam var2);

    public abstract boolean canEncodeImage(RenderedImage var1, ImageEncodeParam var2);

    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        SeekableStream stream = SeekableStream.wrapInputStream(src, true);
        return this.createImageDecoder(stream, param);
    }

    protected ImageDecoder createImageDecoder(File src, ImageDecodeParam param) throws IOException {
        return this.createImageDecoder(new FileSeekableStream(src), param);
    }

    protected abstract ImageDecoder createImageDecoder(SeekableStream var1, ImageDecodeParam var2);

    public static ColorModel createGrayIndexColorModel(SampleModel sm, boolean blackIsZero) {
        byte[] cmap;
        int sampleSize;
        block7: {
            block6: {
                if (sm.getNumBands() != 1) {
                    throw new IllegalArgumentException();
                }
                sampleSize = sm.getSampleSize(0);
                cmap = null;
                if (sampleSize >= 8) break block6;
                cmap = grayIndexCmaps[sampleSize];
                if (blackIsZero) break block7;
                int length = cmap.length;
                byte[] newCmap = new byte[length];
                int i = 0;
                while (i < length) {
                    newCmap[i] = cmap[length - i - 1];
                    ++i;
                }
                cmap = newCmap;
                break block7;
            }
            cmap = new byte[256];
            if (!blackIsZero) {
                int i = 0;
                while (i < 256) {
                    cmap[i] = (byte)i;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < 256) {
                    cmap[i] = (byte)(255 - i);
                    ++i;
                }
            }
        }
        return new IndexColorModel(sampleSize, cmap.length, cmap, cmap, cmap);
    }

    public static ColorModel createComponentColorModel(SampleModel sm) {
        int type = sm.getDataType();
        int bands = sm.getNumBands();
        ComponentColorModel cm = null;
        if (type == 0) {
            switch (bands) {
                case 1: {
                    cm = colorModelGray8;
                    break;
                }
                case 2: {
                    cm = colorModelGrayAlpha8;
                    break;
                }
                case 3: {
                    cm = colorModelRGB8;
                    break;
                }
                case 4: {
                    cm = colorModelRGBA8;
                }
            }
        } else if (type == 1) {
            switch (bands) {
                case 1: {
                    cm = colorModelGray16;
                    break;
                }
                case 2: {
                    cm = colorModelGrayAlpha16;
                    break;
                }
                case 3: {
                    cm = colorModelRGB16;
                    break;
                }
                case 4: {
                    cm = colorModelRGBA16;
                }
            }
        } else if (type == 3) {
            switch (bands) {
                case 1: {
                    cm = colorModelGray32;
                    break;
                }
                case 2: {
                    cm = colorModelGrayAlpha32;
                    break;
                }
                case 3: {
                    cm = colorModelRGB32;
                    break;
                }
                case 4: {
                    cm = colorModelRGBA32;
                }
            }
        }
        return cm;
    }
}

