/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.image.codec;

import edu.cmu.cs.stage3.image.codec.FPXDecodeParam;
import edu.cmu.cs.stage3.image.codec.FPXImageDecoder;
import edu.cmu.cs.stage3.image.codec.ImageCodec;
import edu.cmu.cs.stage3.image.codec.ImageDecodeParam;
import edu.cmu.cs.stage3.image.codec.ImageDecoder;
import edu.cmu.cs.stage3.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.image.codec.ImageEncoder;
import edu.cmu.cs.stage3.image.codec.JaiI18N;
import edu.cmu.cs.stage3.image.codec.SeekableStream;
import java.awt.image.RenderedImage;
import java.io.OutputStream;

public final class FPXCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "fpx";
    }

    @Override
    public Class getEncodeParamClass() {
        return null;
    }

    @Override
    public Class getDecodeParamClass() {
        return FPXDecodeParam.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        return false;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        throw new RuntimeException(JaiI18N.getString("FPX_encoding_not_supported_yet_"));
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new FPXImageDecoder(src, param);
    }

    @Override
    public int getNumHeaderBytes() {
        return 8;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        return header[0] == -48 && header[1] == -49 && header[2] == 17 && header[3] == -32 && header[4] == -95 && header[5] == -79 && header[6] == 26 && header[7] == -31;
    }
}

