/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.image.codec;

import edu.cmu.cs.stage3.image.codec.DataBufferDouble;
import edu.cmu.cs.stage3.image.codec.DataBufferFloat;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;

public class ComponentSampleModelJAI
extends ComponentSampleModel {
    public ComponentSampleModelJAI(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bandOffsets) {
        super(dataType, w, h, pixelStride, scanlineStride, bandOffsets);
    }

    public ComponentSampleModelJAI(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bankIndices, int[] bandOffsets) {
        super(dataType, w, h, pixelStride, scanlineStride, bankIndices, bandOffsets);
    }

    private long getBufferSize() {
        int maxBandOff = this.bandOffsets[0];
        int i = 1;
        while (i < this.bandOffsets.length) {
            maxBandOff = Math.max(maxBandOff, this.bandOffsets[i]);
            ++i;
        }
        long size = 0L;
        if (maxBandOff >= 0) {
            size += (long)(maxBandOff + 1);
        }
        if (this.pixelStride > 0) {
            size += (long)(this.pixelStride * (this.width - 1));
        }
        if (this.scanlineStride > 0) {
            size += (long)(this.scanlineStride * (this.height - 1));
        }
        return size;
    }

    private int[] JAIorderBands(int[] orig, int step) {
        int[] map = new int[orig.length];
        int[] ret = new int[orig.length];
        int i = 0;
        while (i < map.length) {
            map[i] = i;
            ++i;
        }
        i = 0;
        while (i < ret.length) {
            int index = i;
            int j = i + 1;
            while (j < ret.length) {
                if (orig[map[index]] > orig[map[j]]) {
                    index = j;
                }
                ++j;
            }
            ret[map[index]] = i * step;
            map[index] = map[i];
            ++i;
        }
        return ret;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        int i;
        int[] bandOff;
        Object ret = null;
        int minBandOff = this.bandOffsets[0];
        int maxBandOff = this.bandOffsets[0];
        int i2 = 1;
        while (i2 < this.bandOffsets.length) {
            minBandOff = Math.min(minBandOff, this.bandOffsets[i2]);
            maxBandOff = Math.max(maxBandOff, this.bandOffsets[i2]);
            ++i2;
        }
        int bands = this.bandOffsets.length;
        int pStride = Math.abs(this.pixelStride);
        int lStride = Math.abs(this.scanlineStride);
        int bStride = Math.abs(maxBandOff -= minBandOff);
        if (pStride > lStride) {
            if (pStride > bStride) {
                if (lStride > bStride) {
                    bandOff = new int[this.bandOffsets.length];
                    i = 0;
                    while (i < bands) {
                        bandOff[i] = this.bandOffsets[i] - minBandOff;
                        ++i;
                    }
                    lStride = bStride + 1;
                    pStride = lStride * h;
                } else {
                    bandOff = this.JAIorderBands(this.bandOffsets, lStride * h);
                    pStride = bands * lStride * h;
                }
            } else {
                pStride = lStride * h;
                bandOff = this.JAIorderBands(this.bandOffsets, pStride * w);
            }
        } else if (pStride > bStride) {
            bandOff = new int[this.bandOffsets.length];
            i = 0;
            while (i < bands) {
                bandOff[i] = this.bandOffsets[i] - minBandOff;
                ++i;
            }
            pStride = bStride + 1;
            lStride = pStride * w;
        } else if (lStride > bStride) {
            bandOff = this.JAIorderBands(this.bandOffsets, pStride * w);
            lStride = bands * pStride * w;
        } else {
            lStride = pStride * w;
            bandOff = this.JAIorderBands(this.bandOffsets, lStride * h);
        }
        int base = 0;
        if (this.scanlineStride < 0) {
            base += lStride * h;
            lStride *= -1;
        }
        if (this.pixelStride < 0) {
            base += pStride * w;
            pStride *= -1;
        }
        int i3 = 0;
        while (i3 < bands) {
            int n = i3++;
            bandOff[n] = bandOff[n] + base;
        }
        return new ComponentSampleModelJAI(this.dataType, w, h, pStride, lStride, this.bankIndices, bandOff);
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        int[] newBankIndices = new int[bands.length];
        int[] newBandOffsets = new int[bands.length];
        int i = 0;
        while (i < bands.length) {
            int b = bands[i];
            newBankIndices[i] = this.bankIndices[b];
            newBandOffsets[i] = this.bandOffsets[b];
            ++i;
        }
        return new ComponentSampleModelJAI(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, newBankIndices, newBandOffsets);
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int size = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(size, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(size, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(size, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(size, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(size, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(size, this.numBanks);
            }
        }
        return dataBuffer;
    }

    @Override
    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        int type = this.getTransferType();
        int numDataElems = this.getNumDataElements();
        int pixelOffset = y * this.scanlineStride + x * this.pixelStride;
        switch (type) {
            case 0: {
                byte[] bdata = obj == null ? new byte[numDataElems] : (byte[])obj;
                int i = 0;
                while (i < numDataElems) {
                    bdata[i] = (byte)data.getElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                    ++i;
                }
                obj = bdata;
                break;
            }
            case 1: {
                short[] usdata = obj == null ? new short[numDataElems] : (short[])obj;
                int i = 0;
                while (i < numDataElems) {
                    usdata[i] = (short)data.getElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                    ++i;
                }
                obj = usdata;
                break;
            }
            case 3: {
                int[] idata = obj == null ? new int[numDataElems] : (int[])obj;
                int i = 0;
                while (i < numDataElems) {
                    idata[i] = data.getElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                    ++i;
                }
                obj = idata;
                break;
            }
            case 2: {
                short[] sdata = obj == null ? new short[numDataElems] : (short[])obj;
                int i = 0;
                while (i < numDataElems) {
                    sdata[i] = (short)data.getElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                    ++i;
                }
                obj = sdata;
                break;
            }
            case 4: {
                float[] fdata = obj == null ? new float[numDataElems] : (float[])obj;
                int i = 0;
                while (i < numDataElems) {
                    fdata[i] = data.getElemFloat(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                    ++i;
                }
                obj = fdata;
                break;
            }
            case 5: {
                double[] ddata = obj == null ? new double[numDataElems] : (double[])obj;
                int i = 0;
                while (i < numDataElems) {
                    ddata[i] = data.getElemDouble(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                    ++i;
                }
                obj = ddata;
            }
        }
        return obj;
    }

    @Override
    public Object getDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        int type = this.getTransferType();
        int numDataElems = this.getNumDataElements();
        int cnt = 0;
        Object o = null;
        switch (type) {
            case 0: {
                byte[] bdata = obj == null ? new byte[numDataElems * w * h] : (byte[])obj;
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        o = this.getDataElements(j, i, o, data);
                        byte[] btemp = (byte[])o;
                        int k = 0;
                        while (k < numDataElems) {
                            bdata[cnt++] = btemp[k];
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                obj = bdata;
                break;
            }
            case 1: {
                short[] usdata = obj == null ? new short[numDataElems * w * h] : (short[])obj;
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        o = this.getDataElements(j, i, o, data);
                        short[] ustemp = (short[])o;
                        int k = 0;
                        while (k < numDataElems) {
                            usdata[cnt++] = ustemp[k];
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                obj = usdata;
                break;
            }
            case 3: {
                int[] idata = obj == null ? new int[numDataElems * w * h] : (int[])obj;
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        o = this.getDataElements(j, i, o, data);
                        int[] itemp = (int[])o;
                        int k = 0;
                        while (k < numDataElems) {
                            idata[cnt++] = itemp[k];
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                obj = idata;
                break;
            }
            case 2: {
                short[] sdata = obj == null ? new short[numDataElems * w * h] : (short[])obj;
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        o = this.getDataElements(j, i, o, data);
                        short[] stemp = (short[])o;
                        int k = 0;
                        while (k < numDataElems) {
                            sdata[cnt++] = stemp[k];
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                obj = sdata;
                break;
            }
            case 4: {
                float[] fdata = obj == null ? new float[numDataElems * w * h] : (float[])obj;
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        o = this.getDataElements(j, i, o, data);
                        float[] ftemp = (float[])o;
                        int k = 0;
                        while (k < numDataElems) {
                            fdata[cnt++] = ftemp[k];
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                obj = fdata;
                break;
            }
            case 5: {
                double[] ddata = obj == null ? new double[numDataElems * w * h] : (double[])obj;
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        o = this.getDataElements(j, i, o, data);
                        double[] dtemp = (double[])o;
                        int k = 0;
                        while (k < numDataElems) {
                            ddata[cnt++] = dtemp[k];
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                obj = ddata;
            }
        }
        return obj;
    }

    @Override
    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int type = this.getTransferType();
        int numDataElems = this.getNumDataElements();
        int pixelOffset = y * this.scanlineStride + x * this.pixelStride;
        switch (type) {
            case 0: {
                byte[] barray = (byte[])obj;
                int i = 0;
                while (i < numDataElems) {
                    data.setElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i], barray[i] & 0xFF);
                    ++i;
                }
                break;
            }
            case 1: {
                short[] usarray = (short[])obj;
                int i = 0;
                while (i < numDataElems) {
                    data.setElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i], usarray[i] & 0xFFFF);
                    ++i;
                }
                break;
            }
            case 3: {
                int[] iarray = (int[])obj;
                int i = 0;
                while (i < numDataElems) {
                    data.setElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i], iarray[i]);
                    ++i;
                }
                break;
            }
            case 2: {
                short[] sarray = (short[])obj;
                int i = 0;
                while (i < numDataElems) {
                    data.setElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i], sarray[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                float[] farray = (float[])obj;
                int i = 0;
                while (i < numDataElems) {
                    data.setElemFloat(this.bankIndices[i], pixelOffset + this.bandOffsets[i], farray[i]);
                    ++i;
                }
                break;
            }
            case 5: {
                double[] darray = (double[])obj;
                int i = 0;
                while (i < numDataElems) {
                    data.setElemDouble(this.bankIndices[i], pixelOffset + this.bandOffsets[i], darray[i]);
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public void setDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        int cnt = 0;
        Object o = null;
        int type = this.getTransferType();
        int numDataElems = this.getNumDataElements();
        switch (type) {
            case 0: {
                byte[] barray = (byte[])obj;
                byte[] btemp = new byte[numDataElems];
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        int k = 0;
                        while (k < numDataElems) {
                            btemp[k] = barray[cnt++];
                            ++k;
                        }
                        this.setDataElements(j, i, btemp, data);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                short[] usarray = (short[])obj;
                short[] ustemp = new short[numDataElems];
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        int k = 0;
                        while (k < numDataElems) {
                            ustemp[k] = usarray[cnt++];
                            ++k;
                        }
                        this.setDataElements(j, i, ustemp, data);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int[] iArray = (int[])obj;
                int[] itemp = new int[numDataElems];
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        int k = 0;
                        while (k < numDataElems) {
                            itemp[k] = iArray[cnt++];
                            ++k;
                        }
                        this.setDataElements(j, i, itemp, data);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])obj;
                short[] stemp = new short[numDataElems];
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        int k = 0;
                        while (k < numDataElems) {
                            stemp[k] = sArray[cnt++];
                            ++k;
                        }
                        this.setDataElements(j, i, stemp, data);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])obj;
                float[] ftemp = new float[numDataElems];
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        int k = 0;
                        while (k < numDataElems) {
                            ftemp[k] = fArray[cnt++];
                            ++k;
                        }
                        this.setDataElements(j, i, ftemp, data);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])obj;
                double[] dtemp = new double[numDataElems];
                int i = y;
                while (i < y + h) {
                    int j = x;
                    while (j < x + w) {
                        int k = 0;
                        while (k < numDataElems) {
                            dtemp[k] = dArray[cnt++];
                            ++k;
                        }
                        this.setDataElements(j, i, dtemp, data);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        data.setElemFloat(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b], s);
    }

    @Override
    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        float sample = data.getElemFloat(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b]);
        return sample;
    }

    @Override
    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        data.setElemDouble(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b], s);
    }

    @Override
    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        double sample = data.getElemDouble(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b]);
        return sample;
    }

    @Override
    public double[] getPixels(int x, int y, int w, int h, double[] dArray, DataBuffer data) {
        int Offset = 0;
        double[] pixels = dArray != null ? dArray : new double[this.numBands * w * h];
        int i = y;
        while (i < h + y) {
            int j = x;
            while (j < w + x) {
                int k = 0;
                while (k < this.numBands) {
                    pixels[Offset++] = this.getSampleDouble(j, i, k, data);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return pixels;
    }

    public String toString() {
        String ret = "ComponentSampleModelJAI:   dataType=" + this.getDataType() + "  numBands=" + this.getNumBands() + "  width=" + this.getWidth() + "  height=" + this.getHeight() + "  bandOffsets=[ ";
        int i = 0;
        while (i < this.numBands) {
            ret = String.valueOf(ret) + this.getBandOffsets()[i] + " ";
            ++i;
        }
        ret = String.valueOf(ret) + "]";
        return ret;
    }
}

