/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Frame;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Hole;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.KeyEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.LayoutChangeListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.MouseEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.NavigationBar;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ObjectPositionManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Paragraph;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ReadWriteListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ScreenShape;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObject;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObjectPositionListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Note
implements StencilObject,
MouseEventListener,
KeyEventListener,
StencilObjectPositionListener,
ReadWriteListener,
LayoutChangeListener {
    protected Vector shapes = new Vector();
    protected Paragraph paragraph = null;
    protected Vector stencilObjectPositionListeners = new Vector();
    protected ObjectPositionManager positionManager = null;
    protected StencilManager stencilManager = null;
    protected Point clickPos = null;
    protected Point initialPos = null;
    protected StencilObject scrObject = null;
    private RoundRectangle2D.Double bgRect = null;
    private RoundRectangle2D.Double underRect = null;
    private RoundRectangle2D.Double tabRect = null;
    private Line2D.Double line = null;
    private Line2D.Double line2 = null;
    private Line2D.Double line3 = null;
    private Line2D.Double line4 = null;
    private Line2D.Double line5 = null;
    private Polygon triangle = null;
    protected boolean writeEnabled = true;
    protected Point startClick = null;
    protected Point startInitial = null;
    private boolean hasNext = false;
    private RoundRectangle2D.Double bgNext = null;
    private RoundRectangle2D.Double underNext = null;
    private ScreenShape nextShape = null;
    private Font font = new Font("Arial", 1, 16);
    protected boolean isModified = true;
    protected Rectangle rect = null;
    protected Rectangle previousRect = null;
    private boolean prevBlank = false;
    private ScreenShape currentShape = null;
    private boolean startNewLine = false;
    protected boolean isInitialized = false;
    private Point startDragging = null;
    private Point currentDragPosition = null;
    private ScreenShape moveRect = null;
    private int dragInProgress = 0;
    private int fontSize = 20;
    private int dropOffset = 4;
    private int rectWidth = 240;
    private int rectHeight = 190;
    private int noteOpacity = 255;
    private int tabRectOffset = 15;
    private int tabRectWidth = 20;
    private int tabRectHeight = 30;
    private String noteNumber = "";
    private Color defaultColor = new Color(18, 21, 116);
    private Color accentColor = new Color(48, 52, 221);

    public Note(Point clickPos, Point initPos, StencilObject scrObject, ObjectPositionManager positionManager, StencilManager stencilManager, boolean hasNext) {
        this.positionManager = positionManager;
        this.stencilManager = stencilManager;
        this.clickPos = clickPos;
        this.startClick = clickPos;
        this.initialPos = initPos;
        this.startInitial = initPos;
        this.scrObject = scrObject;
        this.hasNext = hasNext;
    }

    public void addText(String text, String color) {
        if (text.length() > 0) {
            char c = text.charAt(0);
            if (Character.isDigit(c)) {
                this.noteNumber = new Character(c).toString();
                text = text.substring(1);
            }
            if (this.paragraph == null) {
                this.paragraph = new Paragraph(this.rectWidth - 20, new Point(this.clickPos.x + 10, this.clickPos.y));
            }
            if (color != null && color.equals("blue")) {
                this.paragraph.addText(text, this.accentColor);
            } else {
                this.paragraph.addText(text, this.defaultColor);
            }
            if (this.isInitialized) {
                this.generateShapes();
                this.setModified();
            }
        }
    }

    public void setText(Vector msgs) {
        this.paragraph.clearText();
        int i = 0;
        while (i < msgs.size()) {
            String text = (String)msgs.elementAt(i);
            if (text.length() > 0) {
                char c = text.charAt(0);
                if (Character.isDigit(c)) {
                    this.noteNumber = new Character(c).toString();
                    text = text.substring(1);
                }
                this.paragraph.addText(text, this.defaultColor);
                if (this.isInitialized) {
                    this.generateShapes();
                    this.setModified();
                }
            }
            ++i;
        }
    }

    protected void drawArrow(Point holePoint, Point wordPoint) {
        double delX = wordPoint.getX() - holePoint.getX();
        double delY = wordPoint.getY() - holePoint.getY();
        double distance = Math.sqrt(delX * delX + delY * delY);
        Point basePt = new Point((int)(holePoint.getX() + 20.0 * (delX /= distance)), (int)(holePoint.getY() + 20.0 * (delY /= distance)));
        Point side1Pt = new Point((int)(basePt.getX() + 10.0 * delY), (int)(basePt.getY() - 10.0 * delX));
        Point side2Pt = new Point((int)(basePt.getX() - 10.0 * delY), (int)(basePt.getY() + 10.0 * delX));
        Point junkPt = new Point((int)(holePoint.getX() + 20.0), (int)holePoint.getY());
        this.triangle = new Polygon();
        this.triangle.addPoint((int)holePoint.getX(), (int)holePoint.getY());
        this.triangle.addPoint((int)side2Pt.getX(), (int)side2Pt.getY());
        this.triangle.addPoint((int)side1Pt.getX(), (int)side1Pt.getY());
    }

    public void updatePosition() {
        if (this.stencilManager.writeEnabled) {
            if (!this.isInitialized && this.scrObject == null) {
                this.initializeNote();
            } else if (!this.isInitialized && this.scrObject != null && this.scrObject.getRectangle() != null) {
                this.initializeNote();
            }
        } else if (this.scrObject == null) {
            this.initializeNote();
        } else if (this.scrObject != null && this.scrObject.getRectangle() != null) {
            this.initializeNote();
        }
        if (this.isInitialized && this.scrObject != null) {
            Point holePoint;
            if (this.scrObject instanceof Hole) {
                this.clickPos = ((Hole)this.scrObject).getNotePoint();
            } else if (this.scrObject instanceof Frame) {
                this.clickPos = ((Frame)this.scrObject).getNotePoint();
            } else if (this.scrObject instanceof NavigationBar) {
                this.clickPos = ((NavigationBar)this.scrObject).getNotePoint();
            }
            if (this.scrObject != null) {
                holePoint = this.getHolesPoint();
                this.clickPos = new Point(holePoint.x + this.initialPos.x, holePoint.y + this.initialPos.y);
            } else {
                this.clickPos = new Point(this.clickPos.x + this.initialPos.x, this.clickPos.y + this.initialPos.y);
            }
            this.underRect.setFrame(this.clickPos.x + this.dropOffset, this.clickPos.y - this.fontSize + this.dropOffset, this.bgRect.width, this.bgRect.height);
            this.bgRect.setFrame(this.clickPos.x, this.clickPos.y - this.fontSize, this.bgRect.width, this.bgRect.height);
            if (this.tabRect != null) {
                this.tabRect.setFrame(this.clickPos.x - this.tabRectOffset, this.clickPos.y, this.tabRectWidth, this.tabRectHeight);
            }
            if (this.hasNext) {
                this.underNext.setFrame(this.bgRect.getX() + this.bgRect.getWidth() - 60.0 + 2.0, this.bgRect.getY() + this.bgRect.getHeight() + 2.0, this.underNext.getWidth(), this.underNext.getHeight());
                this.bgNext.setFrame(this.bgRect.getX() + this.bgRect.getWidth() - 60.0, this.bgRect.getY() + this.bgRect.getHeight(), this.bgNext.getWidth(), this.bgNext.getHeight());
            }
            if (this.paragraph != null) {
                this.paragraph.setTextOrigin(new Point(this.clickPos.x + 10, this.clickPos.y));
            }
            if (this.line != null) {
                holePoint = this.getHolesPoint();
                Point wordPoint = this.getWordsPoint();
                if (holePoint != null && wordPoint != null) {
                    this.line.setLine(holePoint, wordPoint);
                    this.line2.setLine(holePoint.x - 1, holePoint.y, wordPoint.x - 1, wordPoint.y);
                    this.line3.setLine(holePoint.x + 1, holePoint.y, wordPoint.x + 1, wordPoint.y);
                    this.line4.setLine(holePoint.x - 2, holePoint.y, wordPoint.x - 2, wordPoint.y);
                    this.line5.setLine(holePoint.x + 2, holePoint.y, wordPoint.x + 2, wordPoint.y);
                }
            }
        }
        if (this.isInitialized) {
            this.generateShapes();
        }
    }

    public static Point2D.Double translatePositionToVisiblePart(Rectangle2D.Double paramDouble) {
        Rectangle2D.Double localDouble3;
        double d1 = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double d2 = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        Rectangle2D.Double localDouble1 = new Rectangle2D.Double(0.0, 0.0, d1, d2);
        Rectangle2D.Double localDouble2 = new Rectangle2D.Double(0.0, 0.0, d1, d2);
        localDouble2 = new Rectangle2D.Double(localDouble2.getX() - 15.0, localDouble2.getY(), localDouble2.getWidth() + 30.0, localDouble2.getHeight());
        double d3 = paramDouble.getX();
        double d4 = paramDouble.getY();
        if (localDouble2.intersects(paramDouble)) {
            double d5 = Math.abs(paramDouble.getX() - localDouble2.getX());
            double d6 = Math.abs(paramDouble.getX() - (localDouble2.x + localDouble2.width));
            double d7 = Math.abs(paramDouble.getY() + paramDouble.getHeight() - localDouble2.y);
            if (Math.min(d5, d6) < d7) {
                d3 = d5 < d6 ? localDouble2.x - paramDouble.getWidth() : localDouble2.x + localDouble2.width;
            } else {
                d4 = localDouble2.y + localDouble2.height;
            }
        }
        if (!localDouble1.contains(localDouble3 = new Rectangle2D.Double(d3, d4, paramDouble.getWidth(), paramDouble.getHeight()))) {
            if (localDouble3.getX() < 0.0) {
                d3 = 0.0;
            }
            if (localDouble3.getX() + localDouble3.getWidth() > d1) {
                d3 = (double)((int)d1) - localDouble3.getWidth();
            }
            if (localDouble3.getY() + localDouble3.getHeight() > d2) {
                d4 = (double)((int)d2) - localDouble3.getHeight();
            }
        }
        return new Point2D.Double(d3 - paramDouble.getX(), d4 - paramDouble.getY());
    }

    public String getFirstNote() {
        return this.paragraph != null ? (String)this.paragraph.getText().get(0) : "";
    }

    protected Rectangle getBoundingRectangle() {
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        Rectangle area = this.bgRect.getBounds().union(this.underRect.getBounds());
        if (this.tabRect != null) {
            area = area.union(this.tabRect.getBounds());
        }
        if (this.line != null) {
            area = area.union(new Rectangle(this.line.getBounds()));
            if (this.triangle != null) {
                area = area.union(this.triangle.getBounds());
            }
        }
        if (this.moveRect != null) {
            Rectangle movingRect = this.moveRect.getShape().getBounds();
            movingRect.grow(10, 10);
            area = area.union(movingRect);
        }
        return area;
    }

    protected void setModified() {
        if (this.isInitialized) {
            if (this.isModified && this.previousRect != null) {
                this.previousRect = this.previousRect.union(this.rect);
                if (this.tabRect != null) {
                    this.previousRect = this.previousRect.union(this.tabRect.getBounds());
                }
                if (this.hasNext && this.bgNext != null) {
                    this.previousRect = this.previousRect.union(this.bgNext.getBounds());
                }
            } else {
                this.previousRect = this.rect;
                if (this.previousRect != null) {
                    this.previousRect.grow(20, 20);
                }
                if (this.hasNext && this.bgNext != null && this.previousRect != null) {
                    this.previousRect = this.previousRect.union(this.bgNext.getBounds());
                }
                if (this.tabRect != null) {
                    this.previousRect = this.previousRect.union(this.tabRect.getBounds());
                }
            }
            this.rect = this.getBoundingRectangle();
        }
        this.isModified = true;
    }

    public void initializeNote() {
        ScreenShape sShape;
        if (!this.stencilManager.writeEnabled) {
            this.clickPos = this.startClick;
            this.initialPos = this.startInitial;
            this.shapes.removeAllElements();
            if (this.paragraph != null) {
                this.paragraph.setTextOrigin(new Point(this.clickPos.x + 10, this.clickPos.y));
            }
        }
        if (this.scrObject != null) {
            Point holePoint = this.getHolesPoint(this.initialPos);
            this.clickPos = new Point(holePoint.x + this.initialPos.x, holePoint.y + this.initialPos.y);
            this.underRect = new RoundRectangle2D.Double(this.clickPos.x + this.dropOffset, this.clickPos.y - this.fontSize + this.dropOffset, this.rectWidth, this.rectHeight, 10.0, 10.0);
            Color transGray = new Color(75, 75, 75, 100);
            sShape = new ScreenShape(transGray, this.underRect, true, 0);
            this.shapes.addElement(sShape);
            this.bgRect = new RoundRectangle2D.Double(this.clickPos.x, this.clickPos.y - this.fontSize, this.rectWidth, this.rectHeight, 10.0, 10.0);
            sShape = new ScreenShape(new Color(255, 255, 150, this.noteOpacity), this.bgRect, true, 1);
            this.shapes.addElement(sShape);
        } else {
            this.clickPos = new Point(this.clickPos.x + this.initialPos.x, this.clickPos.y + this.initialPos.y);
            this.underRect = new RoundRectangle2D.Double(this.clickPos.x + this.dropOffset, this.clickPos.y - this.fontSize + this.dropOffset, this.rectWidth, this.rectHeight, 10.0, 10.0);
            Color transGray = new Color(75, 75, 75, 100);
            ScreenShape sShape2 = new ScreenShape(transGray, this.underRect, true, 0);
            this.shapes.addElement(sShape2);
            this.bgRect = new RoundRectangle2D.Double(this.clickPos.x, this.clickPos.y - this.fontSize, this.rectWidth, this.rectHeight, 10.0, 10.0);
            sShape2 = new ScreenShape(new Color(255, 255, 150, this.noteOpacity), this.bgRect, true, 1);
            this.shapes.addElement(sShape2);
        }
        if (this.hasNext) {
            this.underNext = new RoundRectangle2D.Double(this.bgRect.getX() + this.bgRect.getWidth() - 60.0 + 2.0, this.bgRect.getY() + this.bgRect.getHeight() + 2.0, 60.0, 20.0, 10.0, 10.0);
            ScreenShape sShape3 = new ScreenShape(new Color(255, 200, 240, 100), this.underNext, true, 2);
            this.shapes.addElement(sShape3);
            this.bgNext = new RoundRectangle2D.Double(this.bgRect.getX() + this.bgRect.getWidth() - 60.0, this.bgRect.getY() + this.bgRect.getHeight(), 60.0, 20.0, 10.0, 10.0);
            sShape3 = new ScreenShape(new Color(255, 180, 210, 220), this.bgNext, true, 3);
            this.shapes.addElement(sShape3);
        }
        if (this.scrObject != null) {
            Point holePt = this.getHolesPoint();
            Point wordsPt = this.getWordsPoint();
            if (holePt != null && wordsPt != null) {
                this.line = new Line2D.Double(holePt, wordsPt);
                this.line2 = new Line2D.Double(holePt.x - 1, holePt.y, wordsPt.x - 1, wordsPt.y);
                this.line3 = new Line2D.Double(holePt.x + 1, holePt.y, wordsPt.x + 1, wordsPt.y);
                this.line4 = new Line2D.Double(holePt.x - 2, holePt.y, wordsPt.x - 2, wordsPt.y);
                this.line5 = new Line2D.Double(holePt.x + 2, holePt.y, wordsPt.x + 2, wordsPt.y);
                sShape = new ScreenShape(Color.red, this.line, false, 2);
                this.shapes.addElement(sShape);
                sShape = new ScreenShape(Color.red, this.line2, false, 3);
                this.shapes.addElement(sShape);
                sShape = new ScreenShape(Color.red, this.line3, false, 4);
                this.shapes.addElement(sShape);
                sShape = new ScreenShape(Color.red, this.line4, false, 5);
                this.shapes.addElement(sShape);
                sShape = new ScreenShape(Color.red, this.line5, false, 6);
                this.shapes.addElement(sShape);
            } else {
                this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
                this.line2 = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
                this.line3 = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
                this.line4 = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
                this.line5 = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
                sShape = new ScreenShape(Color.red, this.line, false, 2);
                this.shapes.addElement(sShape);
                sShape = new ScreenShape(Color.red, this.line2, false, 3);
                this.shapes.addElement(sShape);
                sShape = new ScreenShape(Color.red, this.line3, false, 4);
                this.shapes.addElement(sShape);
                sShape = new ScreenShape(Color.red, this.line4, false, 5);
                this.shapes.addElement(sShape);
                sShape = new ScreenShape(Color.red, this.line5, false, 6);
                this.shapes.addElement(sShape);
            }
        }
        this.isInitialized = true;
        this.setModified();
    }

    protected void generateShapes() {
        Shape caret;
        Shape s;
        int index = 0;
        index = this.scrObject != null ? 7 : 2;
        if (this.hasNext) {
            index += 2;
        }
        Vector newShapes = new Vector();
        int i = 0;
        while (i < index) {
            newShapes.addElement(this.shapes.elementAt(i));
            ++i;
        }
        this.shapes = newShapes;
        if (this.scrObject != null && this.getHolesPoint() != null && this.getWordsPoint() != null) {
            this.drawArrow(this.getHolesPoint(), this.getWordsPoint());
            ScreenShape sShape = new ScreenShape(Color.red, this.triangle, true, index);
            this.shapes.addElement(sShape);
            ++index;
        }
        if (this.noteNumber.length() > 0) {
            this.tabRect = new RoundRectangle2D.Double(this.bgRect.getX() - (double)this.tabRectOffset, this.bgRect.getY(), this.tabRectWidth, this.tabRectHeight, 15.0, 15.0);
            ScreenShape sShape = new ScreenShape(new Color(255, 255, 150, this.noteOpacity), this.tabRect, true, index);
            this.shapes.addElement(sShape);
            ++index;
        }
        if (this.hasNext) {
            TextLayout wordLayout = new TextLayout("next", this.font, new FontRenderContext(null, false, false));
            AffineTransform textAt = new AffineTransform();
            textAt.translate(this.bgRect.getX() + this.bgRect.getWidth() - 50.0, this.bgRect.getY() + this.bgRect.getHeight() + 15.0);
            s = wordLayout.getOutline(textAt);
            this.nextShape = new ScreenShape(new Color(0, 0, 180), s, true, 8);
            this.shapes.addElement(this.nextShape);
            ++index;
        }
        if (this.noteNumber.length() == 0) {
            this.noteNumber = "-1";
        }
        TextLayout tl = new TextLayout(this.noteNumber, new Font("Comic Sans MS", 1, this.fontSize), new FontRenderContext(null, false, false));
        AffineTransform at = new AffineTransform();
        at.translate(this.bgRect.getX() - 10.0, this.bgRect.getY() + 20.0);
        s = tl.getOutline(at);
        ScreenShape sShape = new ScreenShape(Color.blue, s, true, index);
        if (this.noteNumber.equals("-1")) {
            this.noteNumber = "";
        } else {
            this.shapes.addElement(sShape);
            ++index;
        }
        if (this.paragraph != null) {
            Vector wordShapes = this.paragraph.getShapes();
            int i2 = 0;
            while (i2 < wordShapes.size()) {
                ScreenShape wShape = (ScreenShape)wordShapes.elementAt(i2);
                this.shapes.addElement(new ScreenShape(wShape.getColor(), wShape.getShape(), wShape.getIsFilled(), index));
                ++index;
                ++i2;
            }
        }
        if (this.paragraph != null && this.writeEnabled && (caret = this.paragraph.getCaretShape()) != null) {
            this.shapes.addElement(new ScreenShape(Color.red, caret, false, index));
            ++index;
        }
        if (this.moveRect != null) {
            this.shapes.addElement(this.moveRect);
        }
    }

    protected Point getClosestPoint(Rectangle rect, Point center) {
        if (rect == null) {
            return new Point(0, 0);
        }
        if (Math.abs(rect.y - center.y) > Math.abs(rect.y + rect.height - center.y)) {
            return new Point(rect.x + rect.width / 2, rect.y + rect.height + 1);
        }
        return new Point(rect.x + rect.width / 2, rect.y + 1);
    }

    protected Point getHolesPoint(Point offset) {
        if (this.scrObject != null) {
            Rectangle rect = this.scrObject.getRectangle();
            if (rect != null) {
                if (offset.getY() > 0.0) {
                    return new Point(rect.x + rect.width / 2, rect.y + rect.height + 1);
                }
                return new Point(rect.x + rect.width / 2, rect.y + 1);
            }
            return new Point(0, 0);
        }
        return new Point(0, 0);
    }

    protected Point getHolesPoint() {
        return this.getClosestPoint(this.scrObject.getRectangle(), new Point((int)this.bgRect.getCenterX(), (int)this.bgRect.getCenterY()));
    }

    protected Point getWordsPoint() {
        Rectangle holeRect = this.scrObject.getRectangle();
        if (holeRect != null) {
            return this.getClosestPoint(this.bgRect.getBounds(), new Point((int)holeRect.getCenterX(), (int)holeRect.getCenterY()));
        }
        return null;
    }

    @Override
    public Vector getShapes() {
        if (this.scrObject != null && this.scrObject.getRectangle() == null) {
            this.prevBlank = true;
            return null;
        }
        this.prevBlank = false;
        return this.shapes;
    }

    @Override
    public Rectangle getRectangle() {
        return this.rect;
    }

    @Override
    public Rectangle getPreviousRectangle() {
        return this.previousRect;
    }

    @Override
    public boolean isModified() {
        if (this.isModified) {
            this.isModified = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsRectangle(Rectangle testRect) {
        if (this.rect != null) {
            return this.rect.intersects(testRect);
        }
        return false;
    }

    @Override
    public void addStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.addElement(posListener);
    }

    @Override
    public void removeStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.remove(posListener);
    }

    @Override
    public String getComponentID() {
        return null;
    }

    @Override
    public boolean contains(Point point) {
        if (this.bgNext != null) {
            return this.bgRect.contains(point.getX(), point.getY()) || this.bgNext.contains(point.getX(), point.getY());
        }
        if (this.bgRect != null) {
            return this.bgRect.contains(point.getX(), point.getY());
        }
        return false;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        if (this.dragInProgress == 0 && this.bgRect.contains(e.getX(), e.getY())) {
            this.startDragging = e.getPoint();
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(this.clickPos.x - 5, this.clickPos.y - this.fontSize, this.rectWidth, this.rectHeight, 10.0, 10.0);
            this.moveRect = new ScreenShape(new Color(255, 255, 255, 100), rect, true, this.shapes.size());
            this.dragInProgress = 1;
            this.generateShapes();
            this.setModified();
        }
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        if (this.dragInProgress == 1) {
            this.moveRect = null;
            Point p = new Point(e.getPoint().x - this.startDragging.x, e.getPoint().y - this.startDragging.y);
            this.clickPos = new Point(this.clickPos.x + p.x, this.clickPos.y + p.y);
            Point scrObjAttach = null;
            if (this.scrObject instanceof Hole) {
                scrObjAttach = ((Hole)this.scrObject).getNotePoint();
            } else if (this.scrObject instanceof Frame) {
                scrObjAttach = ((Frame)this.scrObject).getNotePoint();
            } else if (this.scrObject instanceof NavigationBar) {
                scrObjAttach = ((NavigationBar)this.scrObject).getNotePoint();
            }
            if (scrObjAttach != null) {
                this.initialPos = new Point(this.clickPos.x - scrObjAttach.x, this.clickPos.y - scrObjAttach.y);
            }
            this.underRect.setFrame(this.clickPos.x - 5 + this.dropOffset, this.clickPos.y - this.fontSize + this.dropOffset, this.bgRect.width, this.bgRect.height);
            this.bgRect.setFrame(this.clickPos.x - 5, this.clickPos.y - this.fontSize, this.bgRect.width, this.bgRect.height);
            if (this.tabRect != null) {
                this.tabRect.setFrame(this.bgRect.getX() - (double)this.tabRectOffset, this.bgRect.getY(), this.tabRectWidth, this.tabRectHeight);
            }
            if (this.hasNext) {
                this.underNext.setFrame(this.bgRect.getX() + this.bgRect.getWidth() - 60.0 + 2.0, this.bgRect.getY() + this.bgRect.getHeight() + 2.0, this.underNext.getWidth(), this.underNext.getHeight());
                this.bgNext.setFrame(this.bgRect.getX() + this.bgRect.getWidth() - 60.0, this.bgRect.getY() + this.bgRect.getHeight(), this.bgNext.getWidth(), this.bgNext.getHeight());
            }
            this.dragInProgress = 0;
            if (this.scrObject != null) {
                Point holePoint = this.getHolesPoint();
                Point wordPoint = this.getWordsPoint();
                this.line.setLine(holePoint, wordPoint);
                this.line2.setLine(holePoint.x - 1, holePoint.y, wordPoint.x - 1, wordPoint.y);
                this.line3.setLine(holePoint.x + 1, holePoint.y, wordPoint.x + 1, wordPoint.y);
                this.line4.setLine(holePoint.x - 2, holePoint.y, wordPoint.x - 2, wordPoint.y);
                this.line5.setLine(holePoint.x + 2, holePoint.y, wordPoint.x + 2, wordPoint.y);
            }
            if (this.paragraph != null) {
                this.paragraph.setTextOrigin(new Point(this.clickPos.x + 10, this.clickPos.y));
            } else {
                this.paragraph = new Paragraph(this.rectWidth - 20, new Point(this.clickPos.x + 10, this.clickPos.y));
            }
            this.generateShapes();
            this.setModified();
        }
        return true;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (this.bgRect.contains(e.getX(), e.getY())) {
            if (this.paragraph != null) {
                this.paragraph.updateCaretPosition(e.getPoint());
            }
            this.generateShapes();
        } else if (this.bgNext.contains(e.getX(), e.getY())) {
            this.stencilManager.showNextStencil();
        }
        return true;
    }

    @Override
    public boolean mouseEntered(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseExited(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        if (this.dragInProgress == 1) {
            Point p = new Point(e.getPoint().x - this.startDragging.x, e.getPoint().y - this.startDragging.y);
            RoundRectangle2D.Double rect = (RoundRectangle2D.Double)this.moveRect.getShape();
            rect.setFrame(this.clickPos.x + p.x, this.clickPos.y - this.fontSize + p.y, rect.width, rect.height);
            this.moveRect.setShape(rect);
            if (this.line != null) {
                Point holePoint = new Point((int)this.line.getP1().getX(), (int)this.line.getP1().getY());
                Point wordPoint = new Point(new Point(this.clickPos.x + p.x + (int)(rect.width / 2.0), this.clickPos.y + p.y - this.fontSize));
                this.line.setLine(this.line.getP1(), new Point(this.clickPos.x + p.x + (int)(rect.width / 2.0), this.clickPos.y + p.y - this.fontSize));
                this.line2.setLine(holePoint.x - 1, holePoint.y, wordPoint.x - 1, wordPoint.y);
                this.line3.setLine(holePoint.x + 1, holePoint.y, wordPoint.x + 1, wordPoint.y);
                this.line4.setLine(holePoint.x - 2, holePoint.y, wordPoint.x - 2, wordPoint.y);
                this.line5.setLine(holePoint.x + 2, holePoint.y, wordPoint.x + 2, wordPoint.y);
                this.drawArrow(holePoint, wordPoint);
                ScreenShape sShape = new ScreenShape(Color.red, this.triangle, true, 6);
                this.shapes.setElementAt(sShape, 6);
            }
            this.setModified();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(KeyEvent e) {
        if (Character.isISOControl(e.getKeyChar())) {
            return false;
        }
        if (this.writeEnabled) {
            if (this.paragraph == null) {
                this.paragraph = new Paragraph(this.rectWidth - 20, new Point(this.clickPos.x + 10, this.clickPos.y));
            }
            this.paragraph.insertChar(e.getKeyChar());
            this.generateShapes();
            this.setModified();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (Character.isISOControl(e.getKeyChar())) {
            if (e.getKeyCode() == 10) {
                if (this.paragraph == null) {
                    this.paragraph = new Paragraph(this.rectWidth - 20, new Point(this.clickPos.x + 10, this.clickPos.y));
                }
                this.paragraph.createNewLine();
                this.generateShapes();
                this.setModified();
                return true;
            }
            if (e.getKeyCode() == 8) {
                if (this.writeEnabled) {
                    if (this.paragraph == null) {
                        this.paragraph = new Paragraph(this.rectWidth - 20, new Point(this.clickPos.x + 10, this.clickPos.y));
                    }
                    this.paragraph.deleteChar();
                    this.generateShapes();
                    this.setModified();
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean keyReleased(KeyEvent e) {
        return false;
    }

    @Override
    public void stencilObjectMoved(Rectangle newPos) {
    }

    public void write(Document document, Element element) {
        Element noteElement = document.createElement("note");
        String id = "null";
        if (this.scrObject != null && (id = this.scrObject.getComponentID()) == null) {
            id = this.scrObject instanceof NavigationBar ? "navbar" : "null";
        }
        Element idNode = document.createElement("id");
        CDATASection idSection = document.createCDATASection(id);
        idNode.appendChild(idSection);
        noteElement.appendChild(idNode);
        Vector msgs = new Vector();
        Vector colors = new Vector();
        if (this.paragraph != null) {
            msgs = this.paragraph.getText();
            colors = this.paragraph.getColors();
            int i = 0;
            while (i < msgs.size()) {
                Element messageNode = document.createElement("message");
                String msg = (String)msgs.elementAt(i);
                if (colors.elementAt(i).equals(this.accentColor)) {
                    messageNode.setAttribute("color", "blue");
                }
                if (this.noteNumber.length() > 0) {
                    msg = String.valueOf(this.noteNumber) + msg;
                }
                CDATASection messageSection = document.createCDATASection(msg);
                messageNode.appendChild(messageSection);
                noteElement.appendChild(messageNode);
                ++i;
            }
        }
        String type = "null";
        if (this.scrObject instanceof Hole) {
            type = "hole";
        } else if (this.scrObject instanceof Frame) {
            type = "frame";
        } else if (this.scrObject instanceof NavigationBar) {
            type = "navBar";
        }
        noteElement.setAttribute("type", type);
        if (type.equals("hole")) {
            boolean autoAdvance = ((Hole)this.scrObject).getAutoAdvance();
            if (autoAdvance) {
                noteElement.setAttribute("autoAdvance", "true");
            } else {
                noteElement.setAttribute("autoAdvance", "false");
            }
            int advanceEvent = ((Hole)this.scrObject).getAdvanceEvent();
            if (advanceEvent == 1) {
                noteElement.setAttribute("advanceEvent", "mousePress");
            } else if (advanceEvent == 0) {
                noteElement.setAttribute("advanceEvent", "mouseClick");
            } else {
                noteElement.setAttribute("advanceEvent", "enterKey");
            }
        }
        if (this.hasNext) {
            noteElement.setAttribute("hasNext", "true");
        } else {
            noteElement.setAttribute("hasNext", "false");
        }
        double x = 0.0;
        double y = 0.0;
        if (this.scrObject != null) {
            Point holePoint = this.getHolesPoint();
            if (this.rect != null) {
                x = (double)this.clickPos.x - holePoint.getX();
                y = (double)this.clickPos.y - holePoint.getY();
            }
        } else {
            x = (double)this.clickPos.x / this.positionManager.getScreenWidth();
            y = (double)this.clickPos.y / this.positionManager.getScreenHeight();
        }
        noteElement.setAttribute("xPos", new Double(x).toString());
        noteElement.setAttribute("yPos", new Double(y).toString());
        element.appendChild(noteElement);
    }

    @Override
    public void setWriteEnabled(boolean enabled) {
        this.writeEnabled = enabled;
        if (this.isInitialized) {
            this.generateShapes();
        }
        this.setModified();
    }

    @Override
    public boolean layoutChanged() {
        if (!this.isInitialized) {
            this.updatePosition();
        }
        if (this.line != null && this.scrObject != null) {
            Point holePoint = this.getHolesPoint();
            Point wordPoint = this.getWordsPoint();
            if (holePoint != null && wordPoint != null) {
                this.line.setLine(new Point(holePoint.x, holePoint.y), new Point(wordPoint.x, wordPoint.y));
                this.line2.setLine(holePoint.x - 1, holePoint.y, wordPoint.x - 1, wordPoint.y);
                this.line3.setLine(holePoint.x + 1, holePoint.y, wordPoint.x + 1, wordPoint.y);
                this.line4.setLine(holePoint.x - 2, holePoint.y, wordPoint.x - 2, wordPoint.y);
                this.line5.setLine(holePoint.x + 2, holePoint.y, wordPoint.x + 2, wordPoint.y);
                this.drawArrow(holePoint, wordPoint);
                ScreenShape sShape = new ScreenShape(Color.red, this.triangle, true, 6);
                this.shapes.setElementAt(sShape, 6);
            }
        }
        this.setModified();
        return true;
    }
}

