/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.client.LayoutChangeListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.MouseEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ObjectPositionManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ScreenShape;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObject;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObjectPositionListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilStackChangeListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;

public class NavigationBar
implements StencilObject,
MouseEventListener,
StencilStackChangeListener,
LayoutChangeListener {
    protected StencilManager stencilManager = null;
    protected ObjectPositionManager positionManager = null;
    protected Vector shapes = new Vector();
    protected boolean isModified = true;
    protected Rectangle previousRect = null;
    private RoundRectangle2D.Double bgBar = null;
    private RoundRectangle2D.Double underBar = null;
    private RoundRectangle2D.Double bgClose = null;
    private RoundRectangle2D.Double underClose = null;
    private RoundRectangle2D.Double bgRestart = null;
    private RoundRectangle2D.Double underRestart = null;
    private RoundRectangle2D.Double bgNext = null;
    private RoundRectangle2D.Double underNext = null;
    private RoundRectangle2D.Double bgPrev = null;
    private RoundRectangle2D.Double underPrev = null;
    private Polygon forwardArrow = null;
    private Polygon backArrow = null;
    private Font font = new Font("Arial", 1, 16);
    private String titleString = null;
    private ScreenShape titleShape = null;
    private ScreenShape xShape = null;
    private ScreenShape nextShape = null;
    private ScreenShape prevShape = null;
    private ScreenShape restartShape = null;
    private boolean isError = false;
    protected Vector stencilObjectPositionListeners = new Vector();

    public NavigationBar(StencilManager stencilManager, ObjectPositionManager positionManager) {
        this.stencilManager = stencilManager;
        this.positionManager = positionManager;
        this.generateShapes();
    }

    public NavigationBar(StencilManager stencilManager, ObjectPositionManager positionManager, boolean isError) {
        this.isError = isError;
        this.stencilManager = stencilManager;
        this.positionManager = positionManager;
        this.generateShapes();
    }

    public void setTitleString(String titleString) {
        this.titleString = titleString;
        this.updateNavBar();
    }

    public String getTitleString() {
        return this.titleString;
    }

    protected void createArrows(Point topCenter, int width) {
        ScreenShape scrShape = null;
        width = 80;
        this.backArrow = new Polygon();
        this.backArrow.addPoint(topCenter.x - 133 + 5, 36);
        this.backArrow.addPoint(topCenter.x - 133 + 15, 26);
        this.backArrow.addPoint(topCenter.x - 133 + 15, 32);
        this.backArrow.addPoint(topCenter.x - 133 + 23, 32);
        this.backArrow.addPoint(topCenter.x - 133 + 23, 40);
        this.backArrow.addPoint(topCenter.x - 133 + 15, 40);
        this.backArrow.addPoint(topCenter.x - 133 + 15, 46);
        scrShape = this.stencilManager.hasPrevious() ? new ScreenShape(Color.blue, this.backArrow, true, 10) : new ScreenShape(Color.lightGray, this.backArrow, true, 10);
        this.shapes.addElement(scrShape);
        this.forwardArrow = new Polygon();
        this.forwardArrow.addPoint(topCenter.x + width / 2 + 25 - 5, 36);
        this.forwardArrow.addPoint(topCenter.x + width / 2 + 25 - 15, 26);
        this.forwardArrow.addPoint(topCenter.x + width / 2 + 25 - 15, 32);
        this.forwardArrow.addPoint(topCenter.x + width / 2 + 25 - 23, 32);
        this.forwardArrow.addPoint(topCenter.x + width / 2 + 25 - 23, 40);
        this.forwardArrow.addPoint(topCenter.x + width / 2 + 25 - 15, 40);
        this.forwardArrow.addPoint(topCenter.x + width / 2 + 25 - 15, 46);
        scrShape = !this.isError && this.stencilManager.hasNext() ? new ScreenShape(Color.blue, this.forwardArrow, true, 11) : new ScreenShape(Color.lightGray, this.forwardArrow, true, 11);
        this.shapes.addElement(scrShape);
    }

    protected int createShape(Point topCenter) {
        this.previousRect = this.getRectangle();
        Shape s = null;
        int width = 0;
        String word = "Page " + (this.stencilManager.getStencilNumber() + 1) + " of " + this.stencilManager.getNumberOfStencils();
        if (this.titleString != null) {
            word = String.valueOf(word) + ": " + this.titleString;
        }
        String close = "Exit Tutorial";
        TextLayout wordLayout = new TextLayout(word, this.font, new FontRenderContext(null, false, false));
        AffineTransform textAt = new AffineTransform();
        width = (int)wordLayout.getBounds().getWidth() / 2;
        textAt.translate(topCenter.x - width, topCenter.y + 18);
        s = wordLayout.getOutline(textAt);
        this.titleShape = new ScreenShape(new Color(0, 0, 180), s, true, 6);
        wordLayout = new TextLayout(close, this.font, new FontRenderContext(null, false, false));
        textAt = new AffineTransform();
        textAt.translate(topCenter.x + width + 45, topCenter.y + 18);
        s = wordLayout.getOutline(textAt);
        this.xShape = new ScreenShape(new Color(0, 0, 180), s, true, 7);
        wordLayout = new TextLayout("next", this.font, new FontRenderContext(null, false, false));
        textAt = new AffineTransform();
        textAt.translate(topCenter.x + 7, topCenter.y + 43);
        s = wordLayout.getOutline(textAt);
        this.nextShape = new ScreenShape(new Color(0, 0, 180), s, true, 8);
        wordLayout = new TextLayout("back", this.font, new FontRenderContext(null, false, false));
        textAt = new AffineTransform();
        textAt.translate(topCenter.x + -110, topCenter.y + 43);
        s = wordLayout.getOutline(textAt);
        this.prevShape = new ScreenShape(new Color(0, 0, 180), s, true, 8);
        wordLayout = new TextLayout("restart", this.font, new FontRenderContext(null, false, false));
        textAt = new AffineTransform();
        textAt.translate((double)topCenter.x - wordLayout.getBounds().getWidth() - 10.0, topCenter.y + 43);
        s = wordLayout.getOutline(textAt);
        this.restartShape = new ScreenShape(new Color(0, 0, 180), s, true, 9);
        this.isModified = true;
        return width * 2;
    }

    protected void generateShapes() {
        this.previousRect = this.getRectangle();
        Point topCenter = new Point((int)this.positionManager.getScreenWidth() / 2, 0);
        int width = this.createShape(topCenter) + 60;
        this.underBar = new RoundRectangle2D.Double(topCenter.x - width / 2 + 2, topCenter.y + 2, width, 25.0, 10.0, 10.0);
        this.underClose = new RoundRectangle2D.Double(topCenter.x + width / 2 + 10 + 2, topCenter.y + 2, 100.0, 25.0, 10.0, 10.0);
        this.underNext = new RoundRectangle2D.Double(topCenter.x + 2, topCenter.y + 2 + 27, 60.0, 20.0, 10.0, 10.0);
        this.underRestart = new RoundRectangle2D.Double(topCenter.x + 3 - 65, topCenter.y + 2 + 27, 60.0, 20.0, 10.0, 10.0);
        this.underPrev = new RoundRectangle2D.Double(topCenter.x + 3 - 130, topCenter.y + 2 + 27, 60.0, 20.0, 10.0, 10.0);
        Color transGray = new Color(255, 200, 240, 100);
        ScreenShape scrShape = new ScreenShape(transGray, this.underBar, true, 0);
        this.shapes.addElement(scrShape);
        scrShape = new ScreenShape(transGray, this.underClose, true, 1);
        this.shapes.addElement(scrShape);
        scrShape = new ScreenShape(transGray, this.underNext, true, 2);
        this.shapes.addElement(scrShape);
        scrShape = new ScreenShape(transGray, this.underRestart, true, 3);
        this.shapes.addElement(scrShape);
        scrShape = new ScreenShape(transGray, this.underPrev, true, 4);
        this.shapes.addElement(scrShape);
        this.bgBar = new RoundRectangle2D.Double(topCenter.x - width / 2, topCenter.y, width, 25.0, 10.0, 10.0);
        this.bgClose = new RoundRectangle2D.Double(topCenter.x + width / 2 + 10, topCenter.y, 100.0, 25.0, 10.0, 10.0);
        this.bgNext = new RoundRectangle2D.Double(topCenter.x, topCenter.y + 27, 60.0, 20.0, 10.0, 10.0);
        this.bgRestart = new RoundRectangle2D.Double(topCenter.x - 65, topCenter.y + 27, 60.0, 20.0, 10.0, 10.0);
        this.bgPrev = new RoundRectangle2D.Double(topCenter.x - 130, topCenter.y + 27, 60.0, 20.0, 10.0, 10.0);
        scrShape = new ScreenShape(new Color(255, 180, 210, 220), this.bgBar, true, 5);
        this.shapes.addElement(scrShape);
        scrShape = new ScreenShape(new Color(255, 180, 210, 220), this.bgClose, true, 6);
        this.shapes.addElement(scrShape);
        scrShape = new ScreenShape(new Color(255, 180, 210, 220), this.bgNext, true, 7);
        this.shapes.addElement(scrShape);
        scrShape = new ScreenShape(new Color(255, 180, 210, 220), this.bgRestart, true, 8);
        this.shapes.addElement(scrShape);
        scrShape = new ScreenShape(new Color(255, 180, 210, 220), this.bgPrev, true, 9);
        this.shapes.addElement(scrShape);
        this.createArrows(topCenter, width - 60);
        if (this.shapes.size() > 12) {
            this.shapes.setElementAt(this.titleShape, 12);
        } else {
            this.shapes.addElement(this.titleShape);
        }
        if (this.shapes.size() > 13) {
            this.shapes.setElementAt(this.xShape, 13);
        } else {
            this.shapes.addElement(this.xShape);
        }
        if (this.shapes.size() > 14) {
            this.shapes.setElementAt(this.nextShape, 14);
        } else {
            this.shapes.addElement(this.nextShape);
        }
        if (this.shapes.size() > 15) {
            this.shapes.setElementAt(this.prevShape, 15);
        } else {
            this.shapes.addElement(this.prevShape);
        }
        if (this.shapes.size() > 16) {
            this.shapes.setElementAt(this.restartShape, 16);
        } else {
            this.shapes.addElement(this.restartShape);
        }
        this.isModified = true;
    }

    @Override
    public Vector getShapes() {
        return this.shapes;
    }

    @Override
    public Rectangle getRectangle() {
        if (this.bgBar != null) {
            return new Rectangle((int)this.bgBar.getBounds().getX(), (int)this.bgBar.getBounds().getY(), (int)this.bgBar.getBounds().getWidth() + (int)this.bgClose.getBounds().getWidth(), (int)this.bgBar.getBounds().getHeight() + (int)this.bgNext.getBounds().getHeight());
        }
        return null;
    }

    @Override
    public Rectangle getPreviousRectangle() {
        return this.previousRect;
    }

    @Override
    public boolean isModified() {
        if (this.isModified) {
            this.isModified = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsRectangle(Rectangle rect) {
        return rect.intersects(this.getRectangle());
    }

    @Override
    public void addStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.addElement(posListener);
    }

    @Override
    public void removeStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.remove(posListener);
    }

    @Override
    public String getComponentID() {
        return null;
    }

    public Point getNotePoint() {
        Rectangle r = this.getRectangle();
        Point p = new Point(0, 0);
        if (r != null) {
            p = new Point((int)r.getX(), (int)r.getY());
        }
        return p;
    }

    @Override
    public boolean contains(Point point) {
        return this.bgBar.contains(point.getX(), point.getY()) || this.bgClose.contains(point.getX(), point.getY()) || this.bgNext.contains(point.getX(), point.getY()) || this.bgRestart.contains(point.getX(), point.getY()) || this.bgPrev.contains(point.getX(), point.getY());
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (this.bgNext.contains(e.getPoint()) && this.stencilManager.hasNext()) {
            this.stencilManager.showNextStencil();
        } else if (this.bgRestart.contains(e.getPoint())) {
            this.stencilManager.reloadStencils();
        } else if (this.bgClose.contains(e.getPoint())) {
            this.stencilManager.showStencils(false);
        } else if (this.bgPrev.contains(e.getPoint()) && this.stencilManager.hasPrevious()) {
            this.stencilManager.showPreviousStencil();
        }
        return true;
    }

    @Override
    public boolean mouseEntered(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseExited(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    protected void updateNavBar() {
        this.shapes = new Vector();
        this.generateShapes();
    }

    @Override
    public void numberOfStencilsChanged(int newNumberOfStencils) {
        this.updateNavBar();
    }

    @Override
    public void currentStencilChanged(int selectedStencil) {
        this.updateNavBar();
    }

    @Override
    public boolean layoutChanged() {
        return true;
    }
}

