/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.client.MouseEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ReadWriteListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ScreenShape;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilFocusListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObject;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObjectPositionListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilPanelMessageListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;

public class Menu
implements StencilObject,
StencilPanelMessageListener,
MouseEventListener,
StencilFocusListener,
ReadWriteListener {
    protected Vector shapes = new Vector();
    protected Vector stencilObjectPositionListeners = new Vector();
    protected StencilManager stencilManager = null;
    protected boolean isShowing = false;
    protected int level = 0;
    protected Point centerPoint;
    protected boolean writeEnabled = true;
    protected boolean isModified = true;
    protected Rectangle previousRect = null;
    protected Rectangle rect = null;
    private Shape upOption = null;
    private Shape downOption = null;
    private Shape rightOption = null;
    private Shape leftOption = null;
    int fontSize = 30;
    Font font = new Font("Arial", 0, this.fontSize);

    public Menu(StencilManager stencilManager) {
        this.stencilManager = stencilManager;
    }

    protected void updateShapes(Point p) {
        this.centerPoint = p;
        this.previousRect = this.getRectangle();
        if (this.level == 1) {
            this.shapes.removeAllElements();
            Point upPosition = new Point(p.x - 40, p.y - 50);
            this.upOption = new RoundRectangle2D.Double(upPosition.x, upPosition.y, 80.0, 30.0, 10.0, 10.0);
            this.shapes.addElement(new ScreenShape(Color.blue, this.upOption, true, 0));
            Shape s = this.createWordShape("new", new Point(upPosition.x + 14, upPosition.y + 25));
            this.shapes.addElement(new ScreenShape(Color.white, s, true, 1));
            Point rightPosition = new Point(p.x - 90, p.y - 15);
            this.rightOption = new RoundRectangle2D.Double(rightPosition.x, rightPosition.y, 80.0, 30.0, 10.0, 10.0);
            this.shapes.addElement(new ScreenShape(Color.blue, this.rightOption, true, 2));
            s = this.createWordShape("load", new Point(rightPosition.x + 10, rightPosition.y + 25));
            this.shapes.addElement(new ScreenShape(Color.white, s, true, 3));
            Point leftPosition = new Point(p.x + 20, p.y - 15);
            this.leftOption = new RoundRectangle2D.Double(leftPosition.x, leftPosition.y, 80.0, 30.0, 10.0, 10.0);
            this.shapes.addElement(new ScreenShape(Color.blue, this.leftOption, true, 4));
            s = this.createWordShape("save", new Point(leftPosition.x + 8, leftPosition.y + 25));
            this.shapes.addElement(new ScreenShape(Color.white, s, true, 5));
            Point downPosition = new Point(p.x - 40, p.y + 20);
            this.downOption = new RoundRectangle2D.Double(downPosition.x, downPosition.y, 80.0, 30.0, 10.0, 10.0);
            this.shapes.addElement(new ScreenShape(Color.blue, this.downOption, true, 6));
            s = this.createWordShape("lock", new Point(downPosition.x + 11, downPosition.y + 25));
            this.shapes.addElement(new ScreenShape(Color.white, s, true, 7));
            this.previousRect = this.rect;
            this.rect = new Rectangle(p.x - 90, p.y - 50, p.x + 90, p.y + 50);
        } else if (this.level == 0) {
            this.shapes.removeAllElements();
            if (this.writeEnabled) {
                Point upPosition = new Point(p.x - 40, p.y - 50);
                this.upOption = new RoundRectangle2D.Double(upPosition.x, upPosition.y, 90.0, 30.0, 10.0, 10.0);
                this.shapes.addElement(new ScreenShape(Color.blue, this.upOption, true, 0));
                Shape s = this.createWordShape("note", new Point(upPosition.x + 15, upPosition.y + 25));
                this.shapes.addElement(new ScreenShape(Color.white, s, true, 1));
                Point rightPosition = new Point(p.x - 90, p.y - 15);
                this.rightOption = new RoundRectangle2D.Double(rightPosition.x, rightPosition.y, 90.0, 30.0, 10.0, 10.0);
                this.shapes.addElement(new ScreenShape(Color.blue, this.rightOption, true, 2));
                s = this.createWordShape("frame", new Point(rightPosition.x + 6, rightPosition.y + 25));
                this.shapes.addElement(new ScreenShape(Color.white, s, true, 3));
                Point leftPosition = new Point(p.x + 20, p.y - 15);
                this.leftOption = new RoundRectangle2D.Double(leftPosition.x, leftPosition.y, 90.0, 30.0, 10.0, 10.0);
                this.shapes.addElement(new ScreenShape(Color.blue, this.leftOption, true, 4));
                s = this.createWordShape("clear", new Point(leftPosition.x + 10, leftPosition.y + 25));
                this.shapes.addElement(new ScreenShape(Color.white, s, true, 5));
                Point downPosition = new Point(p.x - 40, p.y + 20);
                this.downOption = new RoundRectangle2D.Double(downPosition.x, downPosition.y, 90.0, 30.0, 10.0, 10.0);
                this.shapes.addElement(new ScreenShape(Color.blue, this.downOption, true, 6));
                s = this.createWordShape("other", new Point(downPosition.x + 8, downPosition.y + 25));
                this.shapes.addElement(new ScreenShape(Color.white, s, true, 7));
                this.previousRect = this.rect;
                this.rect = new Rectangle(p.x - 90, p.y - 50, p.x + 95, p.y + 50);
            } else {
                Point rightPosition = new Point(p.x - 90, p.y - 15);
                this.rightOption = new RoundRectangle2D.Double(rightPosition.x, rightPosition.y, 65.0, 30.0, 10.0, 10.0);
                this.shapes.addElement(new ScreenShape(Color.blue, this.rightOption, true, 0));
                Shape s = this.createWordShape("load", new Point(rightPosition.x + 5, rightPosition.y + 25));
                this.shapes.addElement(new ScreenShape(Color.white, s, true, 1));
                Point downPosition = new Point(p.x - 40, p.y + 20);
                this.downOption = new RoundRectangle2D.Double(downPosition.x, downPosition.y, 65.0, 30.0, 10.0, 10.0);
                this.shapes.addElement(new ScreenShape(Color.blue, this.downOption, true, 2));
                s = this.createWordShape("lock", new Point(downPosition.x + 5, downPosition.y + 25));
                this.shapes.addElement(new ScreenShape(Color.white, s, true, 3));
                this.previousRect = this.rect;
                this.rect = new Rectangle(p.x - 90, p.y - 15, p.x + 25, p.y + 50);
            }
        }
        this.isModified = true;
    }

    protected Shape createWordShape(String word, Point startPos) {
        TextLayout wordLayout = new TextLayout(word, this.font, new FontRenderContext(null, false, false));
        AffineTransform textAt = new AffineTransform();
        textAt.translate(startPos.x, startPos.y);
        Shape s = wordLayout.getOutline(textAt);
        return s;
    }

    @Override
    public Vector getShapes() {
        if (this.isShowing) {
            return this.shapes;
        }
        return null;
    }

    @Override
    public Rectangle getRectangle() {
        if (this.isShowing) {
            return this.rect;
        }
        return null;
    }

    @Override
    public Rectangle getPreviousRectangle() {
        Rectangle pRect = this.previousRect;
        return pRect;
    }

    @Override
    public boolean isModified() {
        if (this.isModified) {
            this.isModified = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsRectangle(Rectangle rect) {
        Rectangle currentRect = this.getRectangle();
        if (currentRect != null) {
            return rect.intersects(currentRect);
        }
        return false;
    }

    @Override
    public void addStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.addElement(posListener);
    }

    @Override
    public void removeStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.remove(posListener);
    }

    @Override
    public String getComponentID() {
        return null;
    }

    @Override
    public void messageReceived(int messageID, Object data) {
        if (this.writeEnabled) {
            this.isShowing = true;
            this.level = 0;
            this.updateShapes((Point)data);
            this.stencilManager.requestFocus(this);
        }
    }

    @Override
    public boolean contains(Point point) {
        if (this.isShowing) {
            return this.writeEnabled;
        }
        return false;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        this.isShowing = false;
        if (this.writeEnabled) {
            if (this.level == 0) {
                this.previousRect = this.rect;
                if (this.upOption.contains(e.getPoint())) {
                    this.stencilManager.createNewNote(this.centerPoint);
                } else if (this.downOption.contains(e.getPoint())) {
                    this.level = 1;
                    this.isShowing = true;
                    this.updateShapes(e.getPoint());
                } else if (this.rightOption.contains(e.getPoint())) {
                    this.stencilManager.createNewFrame(this.centerPoint);
                } else if (this.leftOption.contains(e.getPoint())) {
                    this.stencilManager.removeAllObjects();
                }
                this.isModified = true;
            } else {
                if (this.upOption.contains(e.getPoint())) {
                    this.stencilManager.insertNewStencil();
                } else if (this.downOption.contains(e.getPoint())) {
                    this.stencilManager.toggleLock();
                } else if (this.rightOption.contains(e.getPoint())) {
                    this.stencilManager.loadStencilsFile();
                } else if (this.leftOption.contains(e.getPoint())) {
                    this.stencilManager.saveStencilsFile();
                }
                this.previousRect = this.rect;
                this.isModified = true;
            }
        } else {
            if (this.downOption.contains(e.getPoint())) {
                this.stencilManager.toggleLock();
            } else if (this.rightOption.contains(e.getPoint())) {
                this.stencilManager.loadStencilsFile();
            }
            this.previousRect = this.rect;
            this.isModified = true;
        }
        return true;
    }

    @Override
    public boolean mouseEntered(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseExited(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    @Override
    public void focusGained() {
        this.isShowing = true;
    }

    @Override
    public void focusLost() {
        this.isShowing = false;
        this.previousRect = this.rect;
        this.isModified = true;
    }

    @Override
    public void setWriteEnabled(boolean enabled) {
        this.writeEnabled = enabled;
    }
}

