/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.caitlin.personbuilder.ColorSelector;
import edu.cmu.cs.stage3.caitlin.personbuilder.ItemChooser;
import edu.cmu.cs.stage3.caitlin.personbuilder.ModelWrapper;
import edu.cmu.cs.stage3.caitlin.personbuilder.XMLDirectoryUtilities;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.w3c.dom.Node;

public class StepPanel
extends JPanel {
    ImageIcon backImage = null;
    ImageIcon nextImage = null;
    Vector choosers = new Vector();

    public StepPanel(Node stepNode, ImageIcon nextImage, ImageIcon backImage, ModelWrapper modelWrapper) {
        this.setBackground(new Color(155, 159, 206));
        this.backImage = backImage;
        this.nextImage = nextImage;
        this.choosers = this.getChoosers(stepNode, modelWrapper);
        this.addChoosers(this.choosers);
    }

    public void resetDefaults() {
        int i = 0;
        while (i < this.choosers.size()) {
            if (this.choosers.elementAt(i) instanceof ItemChooser) {
                ItemChooser chooser = (ItemChooser)this.choosers.elementAt(i);
                chooser.resetDefaults();
            }
            ++i;
        }
    }

    private Vector getChoosers(Node stepNode, ModelWrapper modelWrapper) {
        Vector<JPanel> choosers = new Vector<JPanel>();
        Vector colorNodes = XMLDirectoryUtilities.getSetColorNodes(stepNode);
        int i = 0;
        while (i < colorNodes.size()) {
            ColorSelector colorSelector = new ColorSelector(modelWrapper);
            choosers.addElement(colorSelector);
            ++i;
        }
        Vector chooserNodes = XMLDirectoryUtilities.getDirectories(stepNode);
        double incr = 3.0 / (double)chooserNodes.size();
        int i2 = 0;
        while (i2 < chooserNodes.size()) {
            Node chooserNode = (Node)chooserNodes.elementAt(i2);
            if (chooserNode.getNodeName().equals("directory")) {
                ItemChooser chooser = new ItemChooser(chooserNode, this.nextImage, this.backImage, modelWrapper);
                choosers.addElement(chooser);
            }
            ++i2;
        }
        return choosers;
    }

    private void addChoosers(Vector choosers) {
        this.setLayout(new GridLayout(3, 1));
        int i = 0;
        while (i < choosers.size()) {
            this.add((JPanel)choosers.elementAt(i));
            ++i;
        }
    }
}

