/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.caitlin.personbuilder.AllStepsPanel;
import edu.cmu.cs.stage3.caitlin.personbuilder.ModelWrapper;
import edu.cmu.cs.stage3.caitlin.personbuilder.NamePanel;
import edu.cmu.cs.stage3.caitlin.personbuilder.NavigationPanel;
import edu.cmu.cs.stage3.caitlin.personbuilder.RenderPanel;
import edu.cmu.cs.stage3.caitlin.personbuilder.XMLDirectoryUtilities;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersonBuilder
extends JPanel {
    private AllStepsPanel allStepsPanel = null;
    private NavigationPanel navPanel = null;
    private RenderPanel renderPanel = null;
    private NamePanel namePanel = null;
    private ModelWrapper modelWrapper = null;
    private String builderName = "";

    public static Vector getAllBuilders() {
        Vector<StringObjectPair> builders = new Vector<StringObjectPair>();
        String name = "";
        ImageIcon icon = null;
        Document doc = (Document)XMLDirectoryUtilities.loadFile("images/builders.xml");
        Element root = doc.getDocumentElement();
        NodeList nl = root.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeName().equals("builder")) {
                NamedNodeMap nodeMap = node.getAttributes();
                int j = 0;
                while (j < nodeMap.getLength()) {
                    Node attr = nodeMap.item(j);
                    if (attr.getNodeName().equals("name")) {
                        name = attr.getNodeValue();
                    } else if (attr.getNodeName().equals("icon")) {
                        String iconName = attr.getNodeValue();
                        icon = new ImageIcon(PersonBuilder.class.getResource("images/" + iconName), iconName);
                    }
                    ++j;
                }
                StringObjectPair sop = new StringObjectPair(name, icon);
                builders.addElement(sop);
            }
            ++i;
        }
        return builders;
    }

    public PersonBuilder(String builderName, ProgressObserver progressObserver) throws ProgressCancelException {
        this.builderName = builderName;
        String builderFile = "images/" + builderName + ".xml";
        int progressOffset = 0;
        progressObserver.progressBegin(7);
        try {
            Document doc = (Document)XMLDirectoryUtilities.loadFile(builderFile);
            progressObserver.progressUpdate(progressOffset++, null);
            Element root = doc.getDocumentElement();
            progressObserver.progressUpdate(progressOffset++, null);
            this.modelWrapper = new ModelWrapper(root);
            progressObserver.progressUpdate(progressOffset++, null);
            this.allStepsPanel = new AllStepsPanel(root, this.modelWrapper, progressObserver, progressOffset);
            this.navPanel = new NavigationPanel(root, this.allStepsPanel);
            this.renderPanel = new RenderPanel(this.modelWrapper);
            this.namePanel = new NamePanel();
            this.renderPanel.initialize();
            this.setLayout(new BorderLayout());
            this.add((Component)this.allStepsPanel, "East");
            this.add((Component)this.renderPanel, "Center");
            this.add((Component)this.navPanel, "North");
            this.add((Component)this.namePanel, "South");
        }
        finally {
            progressObserver.progressEnd();
        }
        this.setBackground(new Color(155, 159, 206));
        this.setSize(500, 500);
    }

    public void reset() {
        this.modelWrapper.resetWorld();
        try {
            this.allStepsPanel.resetDefaults();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.navPanel.setFirstStep();
    }

    public Model getModel() {
        Model model = this.modelWrapper.getModel();
        String text = this.namePanel.getCreatedBy();
        if (text.length() == 0) {
            text = Messages.getString("Anonymous");
        }
        model.data.put(Messages.getString("created_by"), text);
        text = this.namePanel.getName();
        if (text.length() == 0) {
            text = DialogManager.showInputDialog(Messages.getString("What_would_you_like_to_name_your_character_"));
        }
        if ((text = text == null ? "" : text.trim()).startsWith("\"") || text.startsWith("'")) {
            text = text.substring(1);
        }
        if (text.endsWith("\"") || text.endsWith("'")) {
            text = text.substring(0, text.length() - 1);
        }
        model.name.set(text);
        return model;
    }
}

