/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.CopyFactory;
import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.UnresolvablePropertyReferencesException;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.criterion.ElementNamedCriterion;
import edu.cmu.cs.stage3.alice.core.light.DirectionalLight;
import edu.cmu.cs.stage3.alice.core.property.DictionaryProperty;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.caitlin.personbuilder.ItemChooser;
import edu.cmu.cs.stage3.caitlin.personbuilder.RotateManipulator;
import edu.cmu.cs.stage3.caitlin.personbuilder.XMLDirectoryUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.util.HowMuch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Node;

public class ModelWrapper {
    protected World miniWorld;
    protected SymmetricPerspectiveCamera camera;
    protected DirectionalLight directionalLight;
    protected OnscreenRenderTarget renderTarget;
    protected MouseListener renderTargetMouseListener;
    protected AuthoringTool authoringTool;
    protected RotateManipulator rtom;
    protected Model person = null;
    protected Model template = null;
    protected CopyFactory personFactory = null;
    protected Image[] textureLayers = new Image[10];
    protected Hashtable partsTable = new Hashtable();
    protected URL url = null;
    protected Vector propertyNameList = new Vector();
    protected Vector propertyValueList = new Vector();
    protected Vector propertyDescList = new Vector();
    protected Vector itemChoosersWithAlts = new Vector();

    public ModelWrapper(Node root) {
        this.worldInit();
        try {
            this.loadInitModel(root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.makeNewPerson();
    }

    public void registerItemChooserWithAlt(ItemChooser itemChooser) {
        this.itemChoosersWithAlts.addElement(itemChooser);
    }

    protected void replaceModel(String modelName, Model model) {
        if (model != null && model.name.getStringValue().equals(modelName) && this.person != null) {
            ElementNamedCriterion nameCriterion = new ElementNamedCriterion(modelName);
            Element[] parts = this.person.search(nameCriterion, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            model.isFirstClass.set(false);
            if (parts.length > 0) {
                Element part = null;
                part = parts[0];
                if (part != null) {
                    Vector3 posToParent = ((Model)part).getPosition((ReferenceFrame)part.getParent());
                    Matrix33 orientToParent = ((Model)part).getOrientationAsAxes((ReferenceFrame)part.getParent());
                    part.replaceWith(model);
                    if (part instanceof Model) {
                        model.vehicle.set(((Model)part).vehicle.get());
                        ((Model)part).vehicle.set(null);
                        if (posToParent != null) {
                            model.setPositionRightNow(posToParent, (ReferenceFrame)model.getParent());
                        }
                        if (orientToParent != null) {
                            model.setOrientationRightNow(orientToParent, (ReferenceFrame)model.getParent());
                        }
                        TextureMap tMap = this.person.diffuseColorMap.getTextureMapValue();
                        this.person.diffuseColorMap.set(tMap, HowMuch.INSTANCE_AND_PARTS);
                    }
                }
            } else {
                System.out.println(String.valueOf(model.name.getStringValue()) + " is not found");
            }
        }
    }

    public void switchToAltModel(String modelName) {
        int i = 0;
        while (i < this.itemChoosersWithAlts.size()) {
            ItemChooser itemChooser = (ItemChooser)this.itemChoosersWithAlts.elementAt(i);
            Model model = itemChooser.getAltModel();
            this.replaceModel(modelName, model);
            ++i;
        }
    }

    public void switchToOrigModel(String modelName) {
        int i = 0;
        while (i < this.itemChoosersWithAlts.size()) {
            ItemChooser itemChooser = (ItemChooser)this.itemChoosersWithAlts.elementAt(i);
            Model model = itemChooser.getOriginalModel();
            this.replaceModel(modelName, model);
            ++i;
        }
    }

    public void resetWorld() {
        this.partsTable = new Hashtable();
        this.textureLayers = new Image[10];
        this.makeNewPerson();
    }

    protected void worldInit() {
        this.miniWorld = new World();
        this.camera = new SymmetricPerspectiveCamera();
        this.directionalLight = new DirectionalLight();
        this.camera.vehicle.set(this.miniWorld);
        this.camera.setPositionRightNow(0.0, 1.5, 6.0);
        this.camera.verticalViewingAngle.set(new Double(0.5235987755982988));
        this.directionalLight.vehicle.set(this.camera);
        this.directionalLight.setOrientationRightNow(this.camera.getOrientationAsQuaternion());
        this.directionalLight.turnRightNow(Direction.FORWARD, 0.15);
        this.directionalLight.turnRightNow(Direction.LEFT, 0.075);
        this.directionalLight.color.set(edu.cmu.cs.stage3.alice.scenegraph.Color.WHITE);
        Color dkBlue = new Color(12, 36, 106);
        this.miniWorld.atmosphereColor.set(new edu.cmu.cs.stage3.alice.scenegraph.Color(dkBlue));
        this.miniWorld.ambientLightColor.set(edu.cmu.cs.stage3.alice.scenegraph.Color.DARK_GRAY);
    }

    protected void makeNewPerson() {
        if (this.personFactory == null) {
            try {
                this.personFactory = this.template.createCopyFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.person = (Model)this.personFactory.manufactureCopy(null);
            this.addModelToWorld(this.person, "none", null);
        }
        catch (UnresolvablePropertyReferencesException upre) {
            throw new ExceptionWrapper(upre, "UnresolvablePropertyReferencesException");
        }
    }

    protected void loadInitModel(Node root) {
        Vector modelURLs = XMLDirectoryUtilities.getModelURLs(root);
        int i = 0;
        while (i < modelURLs.size()) {
            this.url = (URL)modelURLs.elementAt(i);
            try {
                this.template = (Model)Element.load(this.url, null);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (UnresolvablePropertyReferencesException upre) {
                upre.printStackTrace();
            }
            ++i;
        }
    }

    private void initializeModels(Model part, String parentName, Vector3 position) {
        Model partsToAttach = (Model)this.partsTable.get(part.getKey());
        if (partsToAttach != null && partsToAttach.getParent() == null) {
            this.addChildToModel(part, partsToAttach, position);
        }
    }

    private Element[] removeModelFromWorld(Model model) {
        if (model != null) {
            Element[] kids = model.getChildren();
            model.removeFromParent();
            model.vehicle.set(null);
            return kids;
        }
        return null;
    }

    private void removeAllKids(Model parent) {
        if (parent.getChildCount() > 0) {
            Element[] oldKids = parent.getChildren();
            int i = 0;
            while (i < oldKids.length) {
                if (oldKids[i] instanceof Model) {
                    oldKids[i].removeFromParent();
                    Model oldModel = (Model)oldKids[i];
                    oldModel.vehicle.set(null);
                    parent.removeChild(oldModel);
                }
                ++i;
            }
        }
    }

    private void addKidsToModel(Model newParent, Element[] kids) {
        this.removeAllKids(newParent);
        if (newParent != null && kids != null) {
            int i = 0;
            while (i < kids.length) {
                if (kids[i] instanceof Model) {
                    Model kidModel = (Model)kids[i];
                    this.addChildToModel(newParent, kidModel, null);
                }
                ++i;
            }
        }
    }

    private void addChildToModel(Model parent, Model child, Vector3 position) {
        parent.addChild(child);
        parent.parts.add(child);
        child.setParent(parent);
        child.isFirstClass.set(false);
        child.vehicle.set(parent);
        if (position != null) {
            child.setPositionRightNow(position, parent);
        }
    }

    private void addModelToWorld(Model model, String parent, Vector3 position) {
        if (parent.equals("none")) {
            this.person = model;
            this.regenerateTexture();
            this.person.vehicle.set(this.miniWorld);
            this.camera.pointAtRightNow(this.person);
        }
    }

    public void removeModel() {
        if (this.person != null) {
            this.person.vehicle.set(null);
        }
    }

    private void renderInit() {
        this.authoringTool = AuthoringTool.getHack();
        this.renderTarget = this.authoringTool.getRenderTargetFactory().createOnscreenRenderTarget();
        if (this.renderTarget != null) {
            this.renderTarget.addCamera(this.camera.getSceneGraphCamera());
            this.rtom = new RotateManipulator(this.renderTarget);
            this.rtom.setTransformableToRotate(this.person);
        } else {
            System.err.println("PersonBuilder unable to create renderTarget");
        }
    }

    public Component getRenderPanel() {
        this.renderInit();
        return this.renderTarget.getAWTComponent();
    }

    public Model getModel() {
        return this.person;
    }

    protected void regenerateTexture() {
        BufferedImage finalTexture = null;
        Graphics g2 = null;
        int i = 0;
        while (i < this.textureLayers.length) {
            if (this.textureLayers[0] == null) {
                Image im;
                this.textureLayers[0] = im = this.person.diffuseColorMap.getTextureMapValue().image.getImageValue();
            }
            if (this.textureLayers[i] != null) {
                if (finalTexture == null) {
                    finalTexture = new BufferedImage(this.textureLayers[i].getHeight(null), this.textureLayers[i].getWidth(null), 6);
                    g2 = finalTexture.createGraphics();
                }
                g2.drawImage(this.textureLayers[i], 0, 0, null);
            }
            ++i;
        }
        if (finalTexture != null) {
            this.person.diffuseColorMap.getTextureMapValue().image.set(finalTexture);
            this.person.diffuseColorMap.getTextureMapValue().touchImage();
        }
    }

    public void addTexture(Image texture, int level) {
        this.textureLayers[level] = texture;
        this.regenerateTexture();
    }

    public void clearLevel(int level) {
        this.textureLayers[level] = null;
    }

    public void addModel(Model modelToAdd, String parentName, Vector3 position) {
        ElementNamedCriterion nameCriterion;
        Element[] parents;
        if (this.person != null && (parents = this.person.search(nameCriterion = new ElementNamedCriterion(parentName), HowMuch.INSTANCE_AND_ALL_DESCENDANTS)).length > 0) {
            modelToAdd.setParent(parents[0]);
            ((Model)parents[0]).parts.add(modelToAdd);
            modelToAdd.vehicle.set(parents[0]);
            modelToAdd.isFirstClass.set(false);
            modelToAdd.setPositionRightNow(position, (ReferenceFrame)parents[0]);
        }
        TextureMap tMap = this.person.diffuseColorMap.getTextureMapValue();
        modelToAdd.diffuseColorMap.set(tMap, HowMuch.INSTANCE_AND_PARTS);
        this.person.diffuseColorMap.set(tMap, HowMuch.INSTANCE_AND_PARTS);
    }

    public void removeModel(String modelName) {
        ElementNamedCriterion nameCriterion;
        Element[] models;
        if (this.person != null && (models = this.person.search(nameCriterion = new ElementNamedCriterion(modelName), HowMuch.INSTANCE_AND_ALL_DESCENDANTS)).length > 0) {
            models[0].getParent().removeChild(models[0]);
            ((Model)models[0]).vehicle.set(null);
        }
        TextureMap tMap = this.person.diffuseColorMap.getTextureMapValue();
        this.person.diffuseColorMap.set(tMap, HowMuch.INSTANCE_AND_PARTS);
    }

    private void rootModelChanged() {
        this.regenerateTexture();
        int i = 0;
        while (i < this.propertyNameList.size()) {
            String propName = (String)this.propertyNameList.elementAt(i);
            String propValue = (String)this.propertyValueList.elementAt(i);
            String propDesc = (String)this.propertyDescList.elementAt(i);
            this.setPropertyValue(propName, propValue, propDesc);
            ++i;
        }
    }

    public String getModelName() {
        if (this.person != null) {
            return this.person.name.getStringValue();
        }
        return "";
    }

    public void setModel(Model part, String parentName) {
        if (!parentName.equals("none") || this.person != null) {
            if (this.person != null) {
                ElementNamedCriterion nameCriterion = new ElementNamedCriterion(parentName);
                Element[] parents = this.person.search(nameCriterion, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
                if (parents.length > 0) {
                    Element child = parents[0].getChildNamed(part.name.getStringValue());
                    if (child != null) {
                        part.isFirstClass.set(false);
                        Vector3 posToParent = ((Model)child).getPosition((ReferenceFrame)parents[0]);
                        child.replaceWith(part);
                        if (child instanceof Model) {
                            part.vehicle.set(((Model)child).vehicle.get());
                            ((Model)child).vehicle.set(null);
                            if (posToParent != null) {
                                part.setPositionRightNow(posToParent, (ReferenceFrame)part.getParent());
                            }
                        }
                    }
                } else {
                    System.out.println(String.valueOf(part.name.getStringValue()) + " is not found");
                }
            }
            TextureMap tMap = this.person.diffuseColorMap.getTextureMapValue();
            this.person.diffuseColorMap.set(tMap, HowMuch.INSTANCE_AND_PARTS);
        }
    }

    private void setPropertyValue(String propertyName, String propertyValue, String propertyDescription) {
        Property property = this.person.getPropertyNamed(propertyName);
        if (property != null && property instanceof StringProperty) {
            property.set(propertyValue);
        } else if (property != null && property instanceof DictionaryProperty) {
            ((DictionaryProperty)property).put(propertyDescription, propertyValue);
        }
    }

    public void setProperty(String propertyName, String propertyValue, String propertyDesc) {
        int propertyIndex = this.propertyNameList.indexOf(propertyName);
        if (propertyIndex != -1) {
            this.propertyValueList.setElementAt(propertyValue, propertyIndex);
            if (propertyDesc != null) {
                this.propertyDescList.setElementAt(propertyDesc, propertyIndex);
            } else {
                this.propertyDescList.setElementAt("", propertyIndex);
            }
        } else {
            this.propertyNameList.addElement(propertyName);
            this.propertyValueList.addElement(propertyValue);
            if (propertyDesc != null) {
                this.propertyDescList.addElement(propertyDesc);
            } else {
                this.propertyDescList.addElement("");
            }
        }
        this.setPropertyValue(propertyName, propertyValue, propertyDesc);
    }

    public void setColor(Color color) {
        BufferedImage baseColor = new BufferedImage(512, 512, 2);
        Graphics2D g = (Graphics2D)baseColor.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 512, 512);
        this.addTexture(baseColor, 0);
    }
}

