/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.alice.core.CopyFactory;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.UnresolvablePropertyReferencesException;
import edu.cmu.cs.stage3.caitlin.personbuilder.ModelWrapper;
import edu.cmu.cs.stage3.caitlin.personbuilder.PersonBuilder;
import edu.cmu.cs.stage3.caitlin.personbuilder.XMLDirectoryUtilities;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ItemChooser
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel itemPicture = new JLabel();
    JButton backButton = new JButton();
    JButton forwardButton = new JButton();
    ImageIcon nextImage = null;
    ImageIcon backImage = null;
    ModelWrapper modelWrapper = null;
    Vector commandInfos = new Vector();
    int index = 0;

    public ItemChooser(Node itemsNode, ImageIcon nextImage, ImageIcon backImage, ModelWrapper modelWrapper) {
        this.nextImage = nextImage;
        this.backImage = backImage;
        this.modelWrapper = modelWrapper;
        try {
            this.initializeChoices(itemsNode);
            this.jbInit();
            CommandInfo currentInfo = (CommandInfo)this.commandInfos.elementAt(this.index);
            this.itemPicture.setIcon(currentInfo.imageIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetDefaults() {
        this.index = 0;
        CommandInfo currentInfo = (CommandInfo)this.commandInfos.elementAt(this.index);
        this.itemPicture.setIcon(currentInfo.imageIcon);
    }

    private void initializeCommandInfos(Node dirNode, Node choicesNode) {
        NodeList choiceNodeList = choicesNode.getChildNodes();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int altModelCount = 0;
        int i = 0;
        while (i < choiceNodeList.getLength()) {
            String parentString;
            String modelString;
            String altModelName;
            String layerString;
            MediaTracker tracker2;
            String imageFileName;
            Node attr;
            int j;
            NamedNodeMap attrs;
            CommandInfo cmdInfo;
            Node choiceNode = choiceNodeList.item(i);
            if (choiceNode.getNodeName().equals("addTexture")) {
                cmdInfo = new CommandInfo();
                cmdInfo.id = "addTexture";
                attrs = choiceNode.getAttributes();
                j = 0;
                while (j < attrs.getLength()) {
                    attr = attrs.item(j);
                    if (attr.getNodeName().equals("icon")) {
                        imageFileName = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        try {
                            ImageIcon icon;
                            cmdInfo.imageIcon = icon = new ImageIcon(PersonBuilder.class.getResource(imageFileName), imageFileName);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (attr.getNodeName().equals("texture")) {
                        imageFileName = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        Image img = toolkit.createImage(PersonBuilder.class.getResource(imageFileName));
                        try {
                            tracker2 = new MediaTracker(this);
                            tracker2.addImage(img, 0);
                            tracker2.waitForID(0);
                        }
                        catch (InterruptedException tracker2) {
                            // empty catch block
                        }
                        cmdInfo.texture = img;
                    } else if (attr.getNodeName().equals("layer")) {
                        int layer;
                        layerString = attr.getNodeValue();
                        cmdInfo.level = layer = Integer.parseInt(layerString);
                    } else if (attr.getNodeName().equals("useAltModel")) {
                        cmdInfo.altModelName = altModelName = attr.getNodeValue();
                    }
                    ++j;
                }
                this.commandInfos.addElement(cmdInfo);
            } else if (choiceNode.getNodeName().equals("setModel")) {
                cmdInfo = new CommandInfo();
                cmdInfo.id = "setModel";
                attrs = choiceNode.getAttributes();
                j = 0;
                while (j < attrs.getLength()) {
                    attr = attrs.item(j);
                    if (attr.getNodeName().equals("icon")) {
                        imageFileName = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        try {
                            ImageIcon icon;
                            cmdInfo.imageIcon = icon = new ImageIcon(PersonBuilder.class.getResource(imageFileName), imageFileName);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (attr.getNodeName().equals("model")) {
                        modelString = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        Model part = null;
                        try {
                            part = (Model)Element.load(PersonBuilder.class.getResource(modelString), null);
                            part.vehicle.set(null);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        catch (UnresolvablePropertyReferencesException upre) {
                            upre.printStackTrace();
                        }
                        cmdInfo.model = part;
                        cmdInfo.modelFactory = part.createCopyFactory();
                        cmdInfo.modelString = modelString;
                    } else if (attr.getNodeName().equals("parent")) {
                        cmdInfo.parentString = parentString = attr.getNodeValue();
                    } else if (attr.getNodeName().equals("altModel")) {
                        altModelName = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        Model altModel = null;
                        try {
                            altModel = (Model)Element.load(PersonBuilder.class.getResource(altModelName), null);
                            altModel.vehicle.set(null);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        catch (UnresolvablePropertyReferencesException upre) {
                            upre.printStackTrace();
                        }
                        cmdInfo.altModel = altModel;
                        cmdInfo.altModelFactory = altModel.createCopyFactory();
                        ++altModelCount;
                    }
                    ++j;
                }
                this.commandInfos.addElement(cmdInfo);
            } else if (choiceNode.getNodeName().equals("addModelAndTexture")) {
                cmdInfo = new CommandInfo();
                cmdInfo.id = "addModelAndTexture";
                attrs = choiceNode.getAttributes();
                j = 0;
                while (j < attrs.getLength()) {
                    attr = attrs.item(j);
                    if (attr.getNodeName().equals("icon")) {
                        ImageIcon icon;
                        imageFileName = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        cmdInfo.imageIcon = icon = new ImageIcon(PersonBuilder.class.getResource(imageFileName), imageFileName);
                    } else if (attr.getNodeName().equals("model")) {
                        modelString = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        Model part = null;
                        try {
                            part = (Model)Element.load(PersonBuilder.class.getResource(modelString), null);
                            part.vehicle.set(null);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        catch (UnresolvablePropertyReferencesException upre) {
                            upre.printStackTrace();
                        }
                        cmdInfo.model = part;
                        cmdInfo.modelFactory = part.createCopyFactory();
                        cmdInfo.modelString = modelString;
                    } else if (attr.getNodeName().equals("parent")) {
                        cmdInfo.parentString = parentString = attr.getNodeValue();
                    } else if (attr.getNodeName().equals("texture")) {
                        imageFileName = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        Image img = toolkit.createImage(PersonBuilder.class.getResource(imageFileName));
                        try {
                            tracker2 = new MediaTracker(this);
                            tracker2.addImage(img, 0);
                            tracker2.waitForID(0);
                        }
                        catch (InterruptedException tracker3) {
                            // empty catch block
                        }
                        cmdInfo.texture = img;
                    } else if (attr.getNodeName().equals("layer")) {
                        int layer;
                        layerString = attr.getNodeValue();
                        cmdInfo.level = layer = Integer.parseInt(layerString);
                    } else if (attr.getNodeName().equals("useAltModel")) {
                        cmdInfo.altModelName = altModelName = attr.getNodeValue();
                    } else if (attr.getNodeName().equals("x")) {
                        cmdInfo.x = Double.parseDouble(attr.getNodeValue());
                    } else if (attr.getNodeName().equals("y")) {
                        cmdInfo.y = Double.parseDouble(attr.getNodeValue());
                    } else if (attr.getNodeName().equals("z")) {
                        cmdInfo.z = Double.parseDouble(attr.getNodeValue());
                    }
                    ++j;
                }
                this.commandInfos.addElement(cmdInfo);
            } else if (choiceNode.getNodeName().equals("setMultipleModelsAndTexture")) {
                cmdInfo = new CommandInfo();
                cmdInfo.id = "setMultipleModelsAndTexture";
                attrs = choiceNode.getAttributes();
                j = 0;
                while (j < attrs.getLength()) {
                    attr = attrs.item(j);
                    if (attr.getNodeName().equals("icon")) {
                        ImageIcon icon;
                        imageFileName = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        cmdInfo.imageIcon = icon = new ImageIcon(PersonBuilder.class.getResource(imageFileName), imageFileName);
                    } else if (attr.getNodeName().equals("model1")) {
                        modelString = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        Model part = null;
                        try {
                            part = (Model)Element.load(PersonBuilder.class.getResource(modelString), null);
                            part.vehicle.set(null);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        catch (UnresolvablePropertyReferencesException upre) {
                            upre.printStackTrace();
                        }
                        cmdInfo.model = part;
                        cmdInfo.modelFactory = part.createCopyFactory();
                        cmdInfo.modelString = modelString;
                    } else if (attr.getNodeName().equals("parent1")) {
                        cmdInfo.parentString = parentString = attr.getNodeValue();
                    } else if (attr.getNodeName().equals("model2")) {
                        modelString = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        Model part = null;
                        try {
                            part = (Model)Element.load(PersonBuilder.class.getResource(modelString), null);
                            part.vehicle.set(null);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        catch (UnresolvablePropertyReferencesException upre) {
                            upre.printStackTrace();
                        }
                        cmdInfo.altModel = part;
                        cmdInfo.altModelFactory = part.createCopyFactory();
                    } else if (attr.getNodeName().equals("parent2")) {
                        cmdInfo.altParentString = parentString = attr.getNodeValue();
                    } else if (attr.getNodeName().equals("texture")) {
                        imageFileName = String.valueOf(XMLDirectoryUtilities.getPath(dirNode)) + "/" + attr.getNodeValue();
                        Image img = toolkit.createImage(PersonBuilder.class.getResource(imageFileName));
                        try {
                            tracker2 = new MediaTracker(this);
                            tracker2.addImage(img, 0);
                            tracker2.waitForID(0);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        cmdInfo.texture = img;
                    } else if (attr.getNodeName().equals("layer")) {
                        int layer;
                        layerString = attr.getNodeValue();
                        cmdInfo.level = layer = Integer.parseInt(layerString);
                    }
                    ++j;
                }
                this.commandInfos.addElement(cmdInfo);
            }
            ++i;
        }
        if (altModelCount > 0) {
            this.modelWrapper.registerItemChooserWithAlt(this);
        }
    }

    private Model reloadModel(String modelString) {
        Model part = null;
        try {
            part = (Model)Element.load(PersonBuilder.class.getResource(modelString), (Element)new Model());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (UnresolvablePropertyReferencesException upre) {
            upre.printStackTrace();
        }
        return part;
    }

    private void initializeChoices(Node itemsNode) {
        Vector allImages = XMLDirectoryUtilities.getImages(itemsNode);
        Document configDoc = this.loadXMLFile(itemsNode);
        if (allImages != null && allImages.size() > 0 && configDoc != null) {
            NodeList choices = configDoc.getChildNodes();
            int i = 0;
            while (i < choices.getLength()) {
                this.initializeCommandInfos(itemsNode, choices.item(i));
                ++i;
            }
        }
    }

    private Document loadXMLFile(Node itemsNode) {
        Document document = null;
        URL fileURL = null;
        Vector xmlFiles = XMLDirectoryUtilities.getXMLURLs(itemsNode);
        if (xmlFiles.size() == 0) {
            System.out.println(Messages.getString("No_xml_file_found__"));
        } else if (xmlFiles.size() > 1) {
            System.out.println(Messages.getString("Multiple_xml_files_found__"));
        } else {
            fileURL = (URL)xmlFiles.elementAt(0);
        }
        document = (Document)XMLDirectoryUtilities.loadURL(fileURL);
        return document;
    }

    private void currentLosingFocus() {
        if (this.index >= 0 && this.index < this.commandInfos.size()) {
            CommandInfo currentInfo = (CommandInfo)this.commandInfos.elementAt(this.index);
            if (currentInfo.id.equals("addTexture") && currentInfo.altModelName != null) {
                this.modelWrapper.switchToOrigModel(currentInfo.altModelName);
            } else if (currentInfo.id.equals("addTexture")) {
                this.modelWrapper.clearLevel(currentInfo.level);
            } else if (currentInfo.id.equals("addModelAndTexture")) {
                this.modelWrapper.removeModel(currentInfo.model.name.getStringValue());
                this.modelWrapper.clearLevel(currentInfo.level);
                if (currentInfo.altModelName != null) {
                    this.modelWrapper.switchToOrigModel(currentInfo.altModelName);
                }
            }
        }
    }

    private void setIcon() {
        try {
            if (this.index >= 0 && this.index < this.commandInfos.size()) {
                CommandInfo currentInfo = (CommandInfo)this.commandInfos.elementAt(this.index);
                this.itemPicture.setIcon(currentInfo.imageIcon);
                if (currentInfo.id.equals("addTexture")) {
                    this.modelWrapper.addTexture(currentInfo.texture, currentInfo.level);
                    if (currentInfo.altModelName != null) {
                        this.modelWrapper.switchToAltModel(currentInfo.altModelName);
                    }
                } else if (currentInfo.id.equals("setModel")) {
                    Model modelCopy = (Model)currentInfo.modelFactory.manufactureCopy(null);
                    this.modelWrapper.setModel(modelCopy, currentInfo.parentString);
                } else if (currentInfo.id.equals("addModelAndTexture")) {
                    this.modelWrapper.addTexture(currentInfo.texture, currentInfo.level);
                    Model modelCopy = (Model)currentInfo.modelFactory.manufactureCopy(null);
                    Vector3 position = new Vector3(currentInfo.x, currentInfo.y, currentInfo.z);
                    this.modelWrapper.addModel(modelCopy, currentInfo.parentString, position);
                    if (currentInfo.altModelName != null) {
                        this.modelWrapper.switchToAltModel(currentInfo.altModelName);
                    }
                } else if (currentInfo.id.equals("setMultipleModelsAndTexture")) {
                    Model modelCopy = (Model)currentInfo.modelFactory.manufactureCopy(null);
                    this.modelWrapper.setModel(modelCopy, currentInfo.parentString);
                    modelCopy = (Model)currentInfo.altModelFactory.manufactureCopy(null);
                    this.modelWrapper.setModel(modelCopy, currentInfo.altParentString);
                    this.modelWrapper.addTexture(currentInfo.texture, currentInfo.level);
                }
            }
        }
        catch (UnresolvablePropertyReferencesException upre) {
            throw new ExceptionWrapper(upre, "UnresolvablePropertyReferencesException");
        }
    }

    public Model getAltModel() {
        CommandInfo currentInfo = (CommandInfo)this.commandInfos.elementAt(this.index);
        if (currentInfo.altModelFactory != null) {
            try {
                return (Model)currentInfo.altModelFactory.manufactureCopy(null);
            }
            catch (UnresolvablePropertyReferencesException upre) {
                throw new ExceptionWrapper(upre, "UnresolvablePropertyReferencesException");
            }
        }
        return null;
    }

    public Model getOriginalModel() {
        CommandInfo currentInfo = (CommandInfo)this.commandInfos.elementAt(this.index);
        if (currentInfo.modelFactory != null) {
            try {
                return (Model)currentInfo.modelFactory.manufactureCopy(null);
            }
            catch (UnresolvablePropertyReferencesException upre) {
                throw new ExceptionWrapper(upre, "UnresolvablePropertyReferencesException");
            }
        }
        return null;
    }

    private void jbInit() throws Exception {
        this.setBackground(new Color(155, 159, 206));
        this.itemPicture.setMaximumSize(new Dimension(110, 110));
        this.itemPicture.setMinimumSize(new Dimension(110, 110));
        this.itemPicture.setPreferredSize(new Dimension(110, 110));
        this.setLayout(this.borderLayout1);
        this.backButton.setIcon(this.backImage);
        this.backButton.setBackground(new Color(155, 159, 206));
        this.backButton.setBorder(null);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemChooser.this.backButton_actionPerformed(e);
            }
        });
        this.forwardButton.setActionCommand("next");
        this.forwardButton.setIcon(this.nextImage);
        this.forwardButton.setBackground(new Color(155, 159, 206));
        this.forwardButton.setBorder(null);
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemChooser.this.forwardButton_actionPerformed(e);
            }
        });
        this.add((Component)this.itemPicture, "Center");
        this.add((Component)this.backButton, "West");
        this.add((Component)this.forwardButton, "East");
    }

    void backButton_actionPerformed(ActionEvent e) {
        this.currentLosingFocus();
        --this.index;
        if (this.index < 0) {
            this.index += this.commandInfos.size();
        }
        this.setIcon();
    }

    void forwardButton_actionPerformed(ActionEvent e) {
        this.currentLosingFocus();
        ++this.index;
        if (this.index > this.commandInfos.size() - 1) {
            this.index -= this.commandInfos.size();
        }
        this.setIcon();
    }

    protected class CommandInfo {
        public String id = new String();
        public ImageIcon imageIcon = null;
        public String modelString = null;
        public Model model = null;
        public Model altModel = null;
        public CopyFactory modelFactory = null;
        public CopyFactory altModelFactory = null;
        public String altModelName = null;
        public String altParentString = null;
        public Image texture = null;
        public int level = -1;
        public String parentString = new String();
        public double x = 0.0;
        public double y = 0.0;
        public double z = 0.0;

        protected CommandInfo() {
        }
    }
}

