/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.caitlin.personbuilder.ModelWrapper;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorSelector
extends JPanel
implements ActionListener,
ChangeListener {
    protected JButton otherColorsButton = null;
    protected ButtonGroup whichColorChooserGroup = null;
    protected JRadioButton otherColorsRadio = null;
    protected JRadioButton humanColorsRadio = null;
    protected JSlider colorSlider = null;
    protected Color skinColor;
    protected JColorChooser colorChooser;
    protected ModelWrapper modelWrapper = null;

    public ColorSelector(ModelWrapper modelWrapper) {
        this.modelWrapper = modelWrapper;
        this.setBackground(new Color(155, 159, 206));
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.humanColorsRadio = new JRadioButton();
        this.humanColorsRadio.setSelected(true);
        this.humanColorsRadio.setBackground(new Color(155, 159, 206));
        this.otherColorsRadio = new JRadioButton();
        this.otherColorsRadio.setSelected(false);
        this.otherColorsRadio.setBackground(new Color(155, 159, 206));
        this.whichColorChooserGroup = new ButtonGroup();
        this.whichColorChooserGroup.add(this.humanColorsRadio);
        this.whichColorChooserGroup.add(this.otherColorsRadio);
        this.humanColorsRadio.addActionListener(this);
        this.otherColorsRadio.addActionListener(this);
        JPanel humanColorPanel = new JPanel();
        humanColorPanel.setBackground(new Color(155, 159, 206));
        humanColorPanel.setLayout(new FlowLayout());
        this.colorSlider = new JSlider();
        this.skinColor = Color.getHSBColor(0.06963788f, 0.61f, 0.665f);
        this.modelWrapper.setColor(this.skinColor);
        this.colorSlider.setBackground(this.skinColor);
        this.colorSlider.addChangeListener(this);
        humanColorPanel.add(this.humanColorsRadio);
        humanColorPanel.add(this.colorSlider);
        JPanel otherColorPanel = new JPanel();
        otherColorPanel.setBackground(new Color(155, 159, 206));
        otherColorPanel.setLayout(new FlowLayout());
        this.otherColorsButton = new JButton(Messages.getString("Choose_skin_color___"));
        this.otherColorsButton.addActionListener(this);
        this.otherColorsButton.setEnabled(false);
        otherColorPanel.add(this.otherColorsRadio);
        otherColorPanel.add(this.otherColorsButton);
        this.add((Component)humanColorPanel, "North");
        this.add((Component)otherColorPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.otherColorsButton) {
            Color selectedColor;
            if (this.colorChooser == null) {
                this.colorChooser = new JColorChooser();
            }
            if ((selectedColor = DialogManager.showDialog(this.colorChooser, Messages.getString("more_colors___"), this.skinColor)) != null) {
                this.modelWrapper.setColor(selectedColor);
            }
        } else if (ae.getSource() == this.otherColorsRadio) {
            this.colorSlider.setEnabled(false);
            this.otherColorsButton.setEnabled(true);
        } else if (ae.getSource() == this.humanColorsRadio) {
            this.colorSlider.setEnabled(true);
            this.modelWrapper.setColor(this.skinColor);
            this.otherColorsButton.setEnabled(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        int position = this.colorSlider.getValue();
        float s = 0.89f + -0.56f * (float)position / 100.0f;
        float b = 0.33f + 0.67f * (float)position / 100.0f;
        this.skinColor = Color.getHSBColor(0.06963788f, s, b);
        this.colorSlider.setBackground(this.skinColor);
        if (!this.colorSlider.getValueIsAdjusting()) {
            this.modelWrapper.setColor(this.skinColor);
        }
    }
}

