/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.caitlin.personbuilder.ModelWrapper;
import edu.cmu.cs.stage3.caitlin.personbuilder.StepPanel;
import edu.cmu.cs.stage3.caitlin.personbuilder.XMLDirectoryUtilities;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import java.awt.CardLayout;
import java.awt.Component;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.w3c.dom.Node;

public class AllStepsPanel
extends JPanel {
    protected CardLayout cLayout = null;
    protected int selectedPanel = 0;
    protected int numSteps = 0;
    protected ImageIcon nextImage = null;
    protected ImageIcon backImage = null;
    protected Vector stepPanels = new Vector();

    public AllStepsPanel(Node root, ModelWrapper modelWrapper, ProgressObserver progressObserver, int progressOffset) throws ProgressCancelException {
        this.createGuiElements(root, modelWrapper, progressObserver, progressOffset);
        this.setSelected(1);
    }

    private void createGuiElements(Node root, ModelWrapper modelWrapper, ProgressObserver progressObserver, int progressOffset) throws ProgressCancelException {
        Vector imageURLs = XMLDirectoryUtilities.getImageURLs(root);
        int i = 0;
        while (i < imageURLs.size()) {
            URL url = (URL)imageURLs.elementAt(i);
            if (url.toString().indexOf("stepNext.jpg") != -1) {
                this.nextImage = new ImageIcon(url);
            } else if (url.toString().indexOf("stepBack.jpg") != -1) {
                this.backImage = new ImageIcon(url);
            }
            ++i;
        }
        Vector stepNodes = XMLDirectoryUtilities.getDirectories(root);
        if (stepNodes != null) {
            this.cLayout = new CardLayout();
            this.setLayout(this.cLayout);
            this.numSteps = stepNodes.size();
            progressObserver.progressUpdateTotal(progressOffset + stepNodes.size());
            int i2 = 0;
            while (i2 < stepNodes.size()) {
                Node currentStepNode = (Node)stepNodes.elementAt(i2);
                Vector stepImages = XMLDirectoryUtilities.getImages(currentStepNode);
                if (stepImages != null && stepImages.size() > 0) {
                    StepPanel stepPanel = new StepPanel(currentStepNode, this.nextImage, this.backImage, modelWrapper);
                    this.stepPanels.addElement(stepPanel);
                    this.add((Component)stepPanel, "Step " + (i2 + 1) + " Panel");
                }
                progressObserver.progressUpdate(progressOffset++, null);
                ++i2;
            }
        }
    }

    public void resetDefaults() {
        int i = 0;
        while (i < this.stepPanels.size()) {
            StepPanel stepPanel = (StepPanel)this.stepPanels.elementAt(i);
            stepPanel.resetDefaults();
            ++i;
        }
    }

    public int getSelected() {
        return this.selectedPanel;
    }

    public void setSelected(int i) {
        if (i < 1) {
            i = 1;
        }
        if (i > this.numSteps) {
            i = this.numSteps;
        }
        this.selectedPanel = i;
        this.cLayout.show(this, "Step " + i + " Panel");
    }
}

