/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scripting.jython;

import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.alice.scripting.jython.Code;
import edu.cmu.cs.stage3.alice.scripting.jython.Namespace;
import edu.cmu.cs.stage3.alice.scripting.jython.ScriptingFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.__builtin__;

public class Interpreter
implements edu.cmu.cs.stage3.alice.scripting.Interpreter {
    static final Dictionary s_map = new Hashtable();
    private ScriptingFactory m_scriptingFactory;
    private PyModule m_module;
    private Namespace m_dict;
    private World m_world;

    static {
        s_map.put(CompileType.EVAL, "eval");
        s_map.put(CompileType.EXEC_SINGLE, "single");
        s_map.put(CompileType.EXEC_MULTIPLE, "exec");
    }

    public Interpreter(ScriptingFactory scriptingFactory) {
        this.m_scriptingFactory = scriptingFactory;
        this.m_dict = new Namespace();
        this.m_module = new PyModule("main", (PyObject)this.m_dict);
    }

    private void resetNamespace() {
        this.m_dict.clear();
        this.m_dict.setWorld(this.m_world);
    }

    @Override
    public void setWorld(World world) {
        this.m_world = world;
        this.resetNamespace();
    }

    @Override
    public void release() {
        this.m_scriptingFactory.releaseInterpreter(this);
        this.m_scriptingFactory = null;
    }

    @Override
    public void start() {
        this.resetNamespace();
    }

    @Override
    public void stop() {
    }

    @Override
    public edu.cmu.cs.stage3.alice.scripting.Code compile(String script, Object source, CompileType compileType) {
        PyCode pyCode = Py.compile_flags((String)script, (String)source.toString(), (String)((String)s_map.get(compileType)), null);
        return new Code(pyCode, compileType);
    }

    @Override
    public Object eval(edu.cmu.cs.stage3.alice.scripting.Code code) {
        return __builtin__.eval((PyObject)((Code)code).getPyCode(), (PyObject)this.m_dict, (PyObject)this.m_dict);
    }

    @Override
    public void exec(edu.cmu.cs.stage3.alice.scripting.Code code) {
        Py.exec((PyObject)((Code)code).getPyCode(), (PyObject)this.m_dict, (PyObject)this.m_dict);
    }
}

