/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ElementProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTarget;
import edu.cmu.cs.stage3.image.ImageUtilities;
import java.awt.Image;

public abstract class TextureMapProxy
extends ElementProxy {
    protected abstract void onImageChange(int[] var1, int var2, int var3);

    protected abstract void onFormatChange(int var1);

    private void onImageChange(Image image) {
        if (image != null) {
            try {
                int width = ImageUtilities.getWidth(image);
                int height = ImageUtilities.getHeight(image);
                int[] pixels = ImageUtilities.getPixels(image, width, height);
                this.onImageChange(pixels, width, height);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("interrupted waiting for size");
            }
        } else {
            this.onImageChange(null, 0, 0);
        }
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == TextureMap.IMAGE_PROPERTY) {
            this.onImageChange((Image)value);
        } else if (property == TextureMap.FORMAT_PROPERTY) {
            this.onFormatChange((Integer)value);
        } else {
            super.changed(property, value);
        }
    }

    void setRenderTargetWithLatestImage(RenderTarget renderTarget) {
        ((TextureMap)this.getSceneGraphElement()).setRenderTargetWithLatestImage(renderTarget);
    }
}

