/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxyRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ComponentProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ContainerProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.GeometryProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderCanvas;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTargetAdapter;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.VisualProxy;
import javax.vecmath.Vector3d;

public abstract class Renderer
extends AbstractProxyRenderer {
    private int m_nativeInstance = 0;

    static {
        try {
            System.loadLibrary("jawt");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    protected abstract void createNativeInstance();

    protected abstract void releaseNativeInstance();

    protected abstract void pick(ComponentProxy var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, boolean var20, boolean var21, int[] var22, boolean[] var23, int[] var24, double[] var25);

    protected abstract RenderTargetAdapter createRenderTargetAdapter(RenderTarget var1);

    protected abstract RenderCanvas createRenderCanvas(edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget var1);

    @Override
    protected abstract boolean requiresHierarchyAndAbsoluteTransformationListening();

    @Override
    protected abstract boolean requiresBoundListening();

    public Renderer() {
        this.createNativeInstance();
    }

    protected abstract void internalSetIsSoftwareEmulationForced(boolean var1);

    @Override
    public void setIsSoftwareEmulationForced(boolean isSoftwareEmulationForced) {
        super.setIsSoftwareEmulationForced(isSoftwareEmulationForced);
        this.internalSetIsSoftwareEmulationForced(isSoftwareEmulationForced);
    }

    @Override
    public edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo pick(Component sgComponent, Vector3d v, double planeMinX, double planeMinY, double planeMaxX, double planeMaxY, double nearClippingPlaneDistance, double farClippingPlaneDistance, boolean isSubElementRequired, boolean isOnlyFrontMostRequired) {
        this.commitAnyPendingChanges();
        ComponentProxy componentProxy = (ComponentProxy)this.getProxyFor(sgComponent);
        int[] atVisual = new int[1];
        boolean[] atIsFrontFacing = new boolean[]{true};
        int[] atSubElement = new int[]{-1};
        double[] atZ = new double[]{Double.NaN};
        this.pick(componentProxy, v.x, v.y, v.z, planeMinX, planeMinY, planeMaxX, planeMaxY, nearClippingPlaneDistance, farClippingPlaneDistance, isSubElementRequired, isOnlyFrontMostRequired, atVisual, atIsFrontFacing, atSubElement, atZ);
        Visual[] sgVisuals = null;
        Geometry[] sgGeometries = null;
        int[] subElements = null;
        boolean[] isFrontFacings = null;
        VisualProxy visualProxy = VisualProxy.map(atVisual[0]);
        if (visualProxy != null) {
            sgVisuals = new Visual[]{(Visual)visualProxy.getSceneGraphElement()};
            sgGeometries = new Geometry[]{sgVisuals[0].getGeometry()};
            subElements = new int[]{atSubElement[0]};
            isFrontFacings = new boolean[]{atIsFrontFacing[0]};
        }
        return new PickInfo(sgComponent, null, sgVisuals, isFrontFacings, sgGeometries, subElements, atZ);
    }

    @Override
    protected void dispatchAbsoluteTransformationChange(AbsoluteTransformationEvent absoluteTransformationEvent) {
        Component sgComponent = (Component)absoluteTransformationEvent.getSource();
        if (!sgComponent.isReleased()) {
            ComponentProxy componentProxy = (ComponentProxy)this.getProxyFor(sgComponent);
            componentProxy.onAbsoluteTransformationChange();
        }
    }

    @Override
    protected void dispatchBoundChange(BoundEvent boundEvent) {
    }

    @Override
    public void dispatchChildAdd(ChildrenEvent childrenEvent) {
        Container sgContainer = (Container)childrenEvent.getSource();
        Component sgChild = childrenEvent.getChild();
        if (!sgContainer.isReleased() && !sgChild.isReleased()) {
            ContainerProxy containerProxy = (ContainerProxy)this.getProxyFor(sgContainer);
            ComponentProxy childProxy = (ComponentProxy)this.getProxyFor(sgChild);
            containerProxy.onChildAdded(childProxy);
        }
    }

    @Override
    public void dispatchChildRemove(ChildrenEvent childrenEvent) {
        Container sgContainer = (Container)childrenEvent.getSource();
        Component sgChild = childrenEvent.getChild();
        if (!sgContainer.isReleased() && !sgChild.isReleased()) {
            ContainerProxy containerProxy = (ContainerProxy)this.getProxyFor(sgContainer);
            ComponentProxy childProxy = (ComponentProxy)this.getProxyFor(sgChild);
            containerProxy.onChildRemoved(childProxy);
        }
    }

    @Override
    protected void dispatchHierarchyChange(HierarchyEvent hierarchyEvent) {
        Component sgComponent = (Component)hierarchyEvent.getSource();
        if (!sgComponent.isReleased()) {
            ComponentProxy componentProxy = (ComponentProxy)this.getProxyFor(sgComponent);
            componentProxy.onHierarchyChange();
        }
    }

    @Override
    public void commitAnyPendingChanges() {
        super.commitAnyPendingChanges();
        ComponentProxy.updateAbsoluteTransformationChanges();
        GeometryProxy.updateBoundChanges();
    }

    @Override
    protected abstract AbstractProxy createProxyFor(Element var1);

    @Override
    public edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget createOffscreenRenderTarget() {
        return new OffscreenRenderTarget(this);
    }

    @Override
    public OnscreenRenderTarget createOnscreenRenderTarget() {
        return new edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget(this);
    }
}

